/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.util.CryptUtils;
import de.memtext.util.DateUtils;
import de.memtext.util.FileDeleterThread;
import de.memtext.util.FileUtils;
import de.memtext.util.TimeUtils;
import de.memtext.util.TransletUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.SxDBUtils;
import de.superx.common.DBServletException;
import de.superx.common.Maske;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.TransletCache;
import de.superx.servlet.AbstractSuperXServlet;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import de.superx.util.SqlStringUtils;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopConfParser;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFHeader;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jfor.jfor.converter.Converter;
import org.jfor.jfor.converter.IConverterOption;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlTransformer {
    private static int cacheSecs = 300;
    private String stylesheet;
    private String contenttype;
    private HttpServletResponse response;
    private HttpServletRequest request;
    private String mandantenID = SxSQL_Server.DEFAULT_MANDANTEN_ID;
    private String browser;
    private ServletConfig config;
    private String xml;
    private Locale desiredLocale;
    private TimeUtils tutil = new TimeUtils();
    private String maskenname;
    private static final short DECIMALFORMAT = 4;
    private static final short INTEGERFORMAT = 3;
    private String encryptParam;
    private Font font_1;
    private Font font_2;
    private Font font_3;
    private Font font_4;
    private Font font_5;
    private Font font_summe;
    private Maske maske;

    public XmlTransformer(ServletConfig config, HttpServletRequest request, HttpServletResponse response, String mandantenID, String browser) {
        this.response = response;
        this.request = request;
        this.browser = browser;
        this.config = config;
        this.mandantenID = mandantenID;
    }

    private ServletConfig getServletConfig() {
        return this.config;
    }

    public void setMaske(Maske m) {
        this.maske = m;
    }

    public void transform(String maskenname, Collection tmpFiles, String xml, Locale desiredLocale, String stylesheet, String desiredContenttype, String encryptParam) throws DBServletException, FactoryConfigurationError, IOException, ParserConfigurationException, TransformerException {
        this.xml = xml;
        this.stylesheet = stylesheet;
        this.contenttype = desiredContenttype;
        this.desiredLocale = desiredLocale;
        this.maskenname = maskenname;
        this.encryptParam = encryptParam;
        this.tutil.start();
        String methode = "html";
        if (stylesheet != null && stylesheet.indexOf("fo_rtf") > -1) {
            desiredContenttype = "application/rtf";
        }
        if (desiredContenttype != null) {
            if (((String)desiredContenttype).equals("")) {
                desiredContenttype = "text/html; charset=" + SqlStringUtils.getEncoding();
                methode = "html";
            }
        } else {
            desiredContenttype = "text/html; charset=" + SqlStringUtils.getEncoding();
        }
        if (((String)(desiredContenttype = ((String)desiredContenttype).toLowerCase())).startsWith("text/xml") || ((String)desiredContenttype).startsWith("application/jrxml")) {
            this.response.setContentType("text/xml; charset=" + SqlStringUtils.getEncoding());
            methode = "xml";
        } else if (((String)desiredContenttype).startsWith("application/pdf")) {
            this.response.setContentType("application/pdf");
            methode = "xml";
        } else if (((String)desiredContenttype).startsWith("text/plain")) {
            this.response.setContentType("text/plain; charset=" + SqlStringUtils.getEncoding());
            methode = "text";
        } else if (((String)desiredContenttype).startsWith("application/msword") || ((String)desiredContenttype).startsWith("application/rtf")) {
            Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.DEBUG, (Object)"Transformiere nach rtf gew\u00e4hlt ");
            this.response.setContentType("application/rtf");
            methode = "xml";
        } else if (((String)desiredContenttype).startsWith("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
            Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.DEBUG, (Object)"Transformiere nach xls gew\u00e4hlt ");
            this.response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            methode = "xml";
        } else if (((String)desiredContenttype).startsWith("native_")) {
            methode = "xml";
        } else if (((String)desiredContenttype).contains("xhtml")) {
            this.response.setContentType((String)desiredContenttype);
            methode = "xhtml";
        } else {
            this.response.setContentType((String)desiredContenttype);
            methode = "html";
        }
        Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.INFO, (Object)("Transformation nach " + methode + " beginnt "));
        if (stylesheet == null || stylesheet.equals("")) {
            stylesheet = SuperXManager.defaultTableHtmlXsl;
        }
        Object transletFile = !stylesheet.contains(File.separator) ? "file:///" + this.getServletConfig().getServletContext().getRealPath("/xml/" + stylesheet) : stylesheet;
        Logger.getLogger((String)("superx_" + this.getMandantenID() + "_xml")).log((Priority)Level.INFO, (Object)(" Translet f\u00fcr Ergebnisvorbereitung:" + (String)transletFile));
        Transformer transformer = TransletCache.getTransformer(this.getMandantenID(), (String)transletFile);
        transformer.setOutputProperty("encoding", SqlStringUtils.getEncoding());
        transformer.setOutputProperty("method", methode);
        xml = SxPools.get(this.getMandantenID()).localize(xml, desiredLocale);
        if ((((String)desiredContenttype).equals("application/vnd.ms-excel") || ((String)desiredContenttype).equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) && this.maske != null && this.maske.isNewExcelExport()) {
            xml = XmlTransformer.stripXml(xml);
        }
        SuperXManager.setLastXml(xml);
        StringReader returnTextStringReader = new StringReader(xml);
        Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.INFO, (Object)("Erzeuge Contenttype: " + (String)desiredContenttype));
        if (((String)desiredContenttype).equals("text/xml") || ((String)desiredContenttype).equals("application/jrxml")) {
            this.createXml(transformer, returnTextStringReader);
        } else if (((String)desiredContenttype).equals("application/pdf")) {
            this.createPdf(transformer, returnTextStringReader);
        } else if (((String)desiredContenttype).equals("application/rtf")) {
            this.createRtf(transformer, returnTextStringReader);
        } else if (((String)desiredContenttype).equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
            this.createXls(transformer, returnTextStringReader, null);
        } else if (((String)desiredContenttype).startsWith("native")) {
            this.createNative(returnTextStringReader);
        } else {
            this.createNormalOutput(transformer, returnTextStringReader, (String)desiredContenttype);
        }
        FileDeleterThread fd = new FileDeleterThread(tmpFiles, cacheSecs);
        fd.start();
    }

    public static String stripXml(String xml) {
        return xml.replaceAll("<row(?s).*</row>", "");
    }

    public void createPdfStandalone(File fopxconf, String xml, String transletFile, String outfileFilename) throws IOException, TransformerException, ConfigurationException, SAXException, DBServletException {
        File f = new File(transletFile);
        if (fopxconf == null) {
            fopxconf = new File("fop.xconf");
        }
        if (!fopxconf.exists()) {
            throw new IOException(fopxconf.getAbsolutePath() + " nicht gefunden - ggfs. Pfad als Param -fopxconf: \u00fcbergeben");
        }
        FopConfParser parser = new FopConfParser(fopxconf);
        FopFactoryBuilder builder = parser.getFopFactoryBuilder();
        builder.setStrictFOValidation(false);
        builder.setBaseURI(f.toURI());
        FopFactory fopFactory = builder.build();
        FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
        FileOutputStream fs = new FileOutputStream(outfileFilename);
        Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)fs);
        StringReader returnTextStringReader = new StringReader(xml);
        StreamSource src = new StreamSource(returnTextStringReader);
        SAXResult res = new SAXResult(fop.getDefaultHandler());
        Templates t = TransletUtils.createTemplate(transletFile);
        TransletUtils.initFactory("net.sf.saxon.TransformerFactoryImpl", "org.apache.xalan.xsltc.trax.TransformerFactoryImpl");
        Transformer transformer = t.newTransformer();
        transformer.setOutputProperty("encoding", SqlStringUtils.getEncoding());
        transformer.setOutputProperty("method", "xml");
        transformer.transform(src, res);
        fs.close();
    }

    public void createExcelStandalone(String xml, String transletFile, String outfileFilename) throws DBServletException, FactoryConfigurationError, IOException, ParserConfigurationException, TransformerException {
        String methode = "xml";
        Transformer transformer = TransletCache.getTransformer(this.getMandantenID(), transletFile);
        transformer.setOutputProperty("encoding", SqlStringUtils.getEncoding());
        transformer.setOutputProperty("method", methode);
        StringReader returnTextStringReader = new StringReader(xml);
        this.createXls(transformer, returnTextStringReader, outfileFilename);
    }

    public void setMandantenID(String mandantenId) {
        this.mandantenID = mandantenId;
    }

    private String getMandantenID() {
        return this.mandantenID;
    }

    public String getBrowser() {
        return this.browser;
    }

    public void setBrowser(String browser) {
        this.browser = browser;
    }

    private void createNormalOutput(Transformer transformer, StringReader returnTextStringReader, String desiredContenttype) throws IOException, TransformerException {
        Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.INFO, (Object)"Normal xml Transformation, not fop or rtf");
        StringWriter erg = new StringWriter();
        transformer.transform(new StreamSource(returnTextStringReader), new StreamResult(erg));
        String result = erg.toString().replaceAll("_HISINONE_", SuperXManager.his1_refapp);
        result = SxPools.get(this.mandantenID).customHTMLHeaderFooter(result);
        Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.DEBUG, (Object)(" transformation zu HTML Dauer:" + this.tutil.getSinceStart()));
        if (this.encryptParam != null && this.encryptParam.equals("true")) {
            result = CryptUtils.simpleEncryptString2(result);
        }
        this.tutil.start();
        if (desiredContenttype.equals("text/plain")) {
            this.sendBackTXT(result);
        } else {
            this.sendBackHTML(AbstractSuperXServlet.insertCsrfToken(this.request, result));
        }
        Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.DEBUG, (Object)(" schicken der Ergebnisseite an Client " + this.tutil.getSinceStart()));
    }

    @Deprecated
    protected void sendBackHTML(String txt) throws IOException {
        Object out = null;
        TimeUtils t = new TimeUtils();
        t.start();
        String encoding = this.request.getHeader("Accept-Encoding");
        if (!SuperXManager.isResponseCompressionWanted) {
            encoding = "none";
        }
        byte[] myBytes = txt.getBytes(SqlStringUtils.getEncoding());
        if (encoding != null && encoding.indexOf("gzip") != -1) {
            this.response.setHeader("Content-Encoding", "gzip");
            out = new GZIPOutputStream((OutputStream)this.response.getOutputStream());
        } else if (encoding != null && encoding.indexOf("compress") != -1) {
            this.response.setHeader("Content-Encoding", "compress");
            out = new ZipOutputStream((OutputStream)this.response.getOutputStream());
        } else {
            this.response.setContentLength(myBytes.length);
            out = this.response.getOutputStream();
        }
        this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        ((OutputStream)out).write(myBytes);
        ((OutputStream)out).close();
    }

    protected void sendBackTXT(String txt) throws IOException {
        Object out = null;
        TimeUtils t = new TimeUtils();
        t.start();
        String encoding = this.request.getHeader("Accept-Encoding");
        if (!SuperXManager.isResponseCompressionWanted) {
            encoding = "none";
        }
        byte[] myBytes = txt.getBytes(SqlStringUtils.getEncoding());
        if (encoding != null && encoding.indexOf("gzip") != -1) {
            this.response.setHeader("Content-Encoding", "gzip");
            out = new GZIPOutputStream((OutputStream)this.response.getOutputStream());
        } else if (encoding != null && encoding.indexOf("compress") != -1) {
            this.response.setHeader("Content-Encoding", "compress");
            out = new ZipOutputStream((OutputStream)this.response.getOutputStream());
        } else {
            this.response.setContentLength(myBytes.length);
            out = this.response.getOutputStream();
        }
        this.response.setContentType("text/plain; charset=" + SqlStringUtils.getEncoding());
        ((OutputStream)out).write(myBytes);
        ((OutputStream)out).close();
    }

    private void createRtf(Transformer transformer, StringReader returnTextStringReader) throws FactoryConfigurationError, TransformerException, IOException, DBServletException, ParserConfigurationException {
        DocumentBuilderFactory dfactory = XMLUtils.createSecureDocumentBuilderFactory();
        DocumentBuilder builder = dfactory.newDocumentBuilder();
        Document mydomres = builder.newDocument();
        PrintWriter output = this.response.getWriter();
        this.response.reset();
        this.response.setContentType("application/rtf");
        this.response.setHeader("Content-disposition", "attachment; filename=" + this.maskenname.replace(' ', '_') + ".rtf");
        this.response.setHeader("Cache-Control", "expires=0");
        transformer.transform(new StreamSource(returnTextStringReader), new DOMResult(mydomres));
        try {
            new Converter(mydomres, (Writer)output, (IConverterOption)Converter.createConverterOption());
        }
        catch (Exception e) {
            throw new DBServletException("Converter " + e);
        }
        output.flush();
    }

    private void createXls(Transformer transformer, StringReader returnTextStringReader, String filename) throws FactoryConfigurationError, IOException, ParserConfigurationException, TransformerException {
        SXSSFWorkbook wb;
        Logger.getLogger((String)("superx_" + this.getMandantenID() + "_xml")).log((Priority)Level.INFO, (Object)"Transformiere nach xls ");
        DocumentBuilderFactory dfactory = XMLUtils.createSecureDocumentBuilderFactory();
        DocumentBuilder builder = dfactory.newDocumentBuilder();
        Document mydomres = builder.newDocument();
        transformer.transform(new StreamSource(returnTextStringReader), new DOMResult(mydomres));
        Logger.getLogger((String)("superx_" + this.getMandantenID() + "_xml")).log((Priority)Level.INFO, (Object)"Transformiere nach xml-xls ");
        Node workbook = XMLUtils.getFirstNode(mydomres, "xls_workbook");
        if (workbook == null) {
            return;
        }
        if (SxPools.hasPool(this.mandantenID) && SxPools.get(this.mandantenID).getExcelVorlage() != null && (!XMLUtils.hasAttrib(workbook, "vorlage") || XMLUtils.getAttribValue(workbook, "vorlage").equals(""))) {
            XMLUtils.setAttribValue(workbook, "vorlage", SxPools.get(this.mandantenID).getExcelVorlage());
        }
        String vorlage = null;
        if (XMLUtils.hasAttrib(workbook, "vorlage")) {
            vorlage = XMLUtils.getAttribValue(workbook, "vorlage");
        }
        if (vorlage == null || vorlage.equals("")) {
            wb = new SXSSFWorkbook(100);
        } else {
            FileInputStream fis = new FileInputStream(vorlage);
            wb = new XSSFWorkbook((InputStream)fis);
            fis.close();
        }
        this.font_1 = wb.createFont();
        this.font_1.setBold(true);
        this.font_2 = wb.createFont();
        this.font_2.setBold(true);
        this.font_3 = wb.createFont();
        this.font_3.setBold(true);
        this.font_4 = wb.createFont();
        this.font_4.setBold(true);
        this.font_4.setItalic(true);
        this.font_5 = wb.createFont();
        this.font_5.setBold(true);
        this.font_summe = wb.createFont();
        this.font_summe.setBold(true);
        NodeList stylelist = mydomres.getElementsByTagName("xls_cellstyle");
        Node pageformat = null;
        try {
            pageformat = XMLUtils.getChildNode(workbook, "xls_PageFormat");
        }
        catch (Exception exception) {
            // empty catch block
        }
        XlsStyles xs = new XlsStyles(stylelist, (Workbook)wb);
        Hashtable styles = xs.getHashtable();
        int counter = 0;
        Iterator<Node> it = XMLUtils.getChildNodeIterator(workbook);
        while (it.hasNext()) {
            Node n = it.next();
            if (n.getLocalName() != "xls_sheet") continue;
            this.createXls_Sheet(vorlage != null && !vorlage.equals(""), styles, n, pageformat, (Workbook)wb, ++counter, vorlage == null);
        }
        String removeAdditionalSheets = null;
        if (XMLUtils.hasAttrib(workbook, "removeAdditionalSheets")) {
            removeAdditionalSheets = XMLUtils.getAttribValue(workbook, "removeAdditionalSheets");
        }
        if (removeAdditionalSheets != null && removeAdditionalSheets.equals("true")) {
            int sheetCount = wb.getNumberOfSheets();
            for (int i = counter; i < sheetCount; ++i) {
                Sheet asheet = wb.getSheetAt(counter);
                wb.setSheetName(counter, "del" + i);
                for (int i2 = 0; i2 <= asheet.getLastRowNum(); ++i2) {
                    if (asheet.getRow(i2) == null) continue;
                    asheet.removeRow(asheet.getRow(i2));
                }
                wb.removeSheetAt(counter);
            }
        }
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            wb.getSheetAt(i).setSelected(i == 0);
        }
        wb.setActiveSheet(0);
        if (filename != null) {
            FileOutputStream fileOut = new FileOutputStream(filename);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        } else {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            this.response.reset();
            this.response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            this.response.setHeader("Content-disposition", "attachment; filename=" + FileUtils.removeProblemChars(this.maskenname) + ".xlsx");
            this.response.setHeader("Cache-Control", "expires=0");
            ServletOutputStream sos = this.response.getOutputStream();
            outStream.writeTo((OutputStream)sos);
            sos.flush();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private short getColorIndex(String attrib) {
        short result = -999;
        try {
            return Short.parseShort(attrib);
        }
        catch (NumberFormatException ex) {
            Object key;
            Map t = HSSFColor.getIndexHash();
            Set s = t.keySet();
            Iterator it = s.iterator();
            do {
                if (!it.hasNext()) return result;
            } while (t.get(key = it.next()) == null || ((HSSFColor)t.get(key)).toString().indexOf(attrib) <= -1);
            HSSFColor c = (HSSFColor)t.get(key);
            return c.getIndex();
        }
    }

    private void createXml(Transformer transformer, StringReader returnTextStringReader) throws IOException, TransformerException {
        ServletOutputStream out = null;
        Logger.getLogger((String)("superx_" + this.getMandantenID() + "_xml")).log((Priority)Level.INFO, (Object)"Transformiere nach XML ");
        out = this.response.getOutputStream();
        this.response.setContentType("text/xml; charset=" + SqlStringUtils.getEncoding());
        this.response.setHeader("Content-Encoding", SqlStringUtils.getEncoding());
        StringWriter erg = new StringWriter();
        transformer.transform(new StreamSource(returnTextStringReader), new StreamResult(erg));
        String result = erg.toString();
        byte[] myBytes = result.getBytes(SqlStringUtils.getEncoding());
        this.response.setContentLength(myBytes.length);
        out.write(myBytes);
        out.close();
    }

    private void createPdf(Transformer transformer, StringReader returnTextStringReader) throws IOException, TransformerException {
        Logger.getLogger((String)("superx_" + this.getMandantenID() + "_xml")).log((Priority)Level.INFO, (Object)"Transformiere nach pdf ");
        this.response.setContentType("application/pdf");
        this.response.setHeader("Content-disposition", "attachment; filename=" + FileUtils.removeProblemChars(this.maskenname) + ".pdf");
        this.response.setHeader("Cache-Control", "expires=0");
        try {
            String cfgFolder = SuperXManager.getWEB_INFPfad() + File.separator + "fop.xconf";
            File xconf = new File(cfgFolder);
            FopConfParser parser = new FopConfParser(xconf);
            FopFactoryBuilder builder = parser.getFopFactoryBuilder();
            FopFactory fopFactory = builder.build();
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)this.response.getOutputStream());
            StreamSource src = new StreamSource(returnTextStringReader);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform(src, res);
        }
        catch (Exception ex) {
            Logger.getLogger((String)("superx_" + this.getMandantenID() + "_xml")).log((Priority)Level.ERROR, (Object)"Transformer-Fehler\n ", (Throwable)ex);
        }
    }

    protected void createXlsPageFormat(Node pageformat, Sheet sheet) {
        PrintSetup ps = sheet.getPrintSetup();
        if (pageformat != null) {
            Object s = null;
            Object mynode = "";
            Iterator<Node> it = XMLUtils.getChildNodeIterator(pageformat);
            while (it.hasNext()) {
                String nodeval;
                Node n = it.next();
                String nodename = n.getLocalName();
                try {
                    nodeval = XMLUtils.getTheValue(n);
                }
                catch (Exception e) {
                    nodeval = "";
                }
                String nodefont = null;
                String nodefontStyle = null;
                String nodefontSize = null;
                try {
                    nodefont = XMLUtils.getAttribValue(n, "font");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    nodefontStyle = XMLUtils.getAttribValue(n, "fontStyle");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    nodefontSize = XMLUtils.getAttribValue(n, "fontSize");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                mynode = "";
                if (nodefont != null && nodefontStyle != null) {
                    mynode = (String)mynode + HSSFHeader.font((String)nodefont, (String)nodefontStyle);
                }
                if (((String)(mynode = (String)mynode + nodeval)).indexOf("$PAGE") > 0) {
                    mynode = SxDBUtils.replaceString((String)mynode, "$PAGE", HSSFHeader.page());
                }
                if (((String)mynode).indexOf("$NUMPAGES") > 0) {
                    mynode = SxDBUtils.replaceString((String)mynode, "$NUMPAGES", HSSFHeader.numPages());
                }
                Logger.getLogger((String)("superx_" + this.getMandantenID() + "_xml")).log((Priority)Level.INFO, (Object)("node: " + nodename + " val: " + nodeval));
                if (nodename.equalsIgnoreCase("xls_top-margin")) {
                    sheet.setMargin((short)2, Double.parseDouble(nodeval) / 2.54);
                }
                if (nodename.equalsIgnoreCase("xls_bottom-margin")) {
                    sheet.setMargin((short)3, Double.parseDouble(nodeval) / 2.54);
                }
                if (nodename.equalsIgnoreCase("xls_left-margin")) {
                    sheet.setMargin((short)0, Double.parseDouble(nodeval) / 2.54);
                }
                if (nodename.equalsIgnoreCase("xls_right-margin")) {
                    sheet.setMargin((short)1, Double.parseDouble(nodeval) / 2.54);
                }
                this.createXlsHeaderFooter(sheet, nodename, (String)mynode);
                if (nodename.equalsIgnoreCase("xls_Autobreaks")) {
                    sheet.setAutobreaks(true);
                }
                if (nodename.equalsIgnoreCase("xls_Landscape")) {
                    ps.setLandscape(true);
                }
                if (nodename.equalsIgnoreCase("xls_FitHeight")) {
                    ps.setFitHeight(Short.parseShort(nodeval));
                }
                if (nodename.equalsIgnoreCase("xls_FitWidth")) {
                    ps.setFitWidth(Short.parseShort(nodeval));
                    Logger.getLogger((String)("superx_" + this.getMandantenID() + "_xml")).log((Priority)Level.INFO, (Object)("xls_FitWidth: " + nodeval));
                }
                if (!nodename.equalsIgnoreCase("xls_PaperSize")) continue;
                if (nodeval.equalsIgnoreCase("letter")) {
                    ps.setPaperSize((short)1);
                    continue;
                }
                ps.setPaperSize((short)9);
            }
        }
    }

    private void createXlsHeaderFooter(Sheet sheet, String nodename, String mynode) {
        Header header = sheet.getHeader();
        Footer footer = sheet.getFooter();
        if (nodename.equalsIgnoreCase("xls_header-left")) {
            header.setLeft(mynode);
        }
        if (nodename.equalsIgnoreCase("xls_header-center")) {
            header.setCenter(mynode);
        }
        if (nodename.equalsIgnoreCase("xls_header-right")) {
            header.setRight(mynode);
        }
        if (nodename.equalsIgnoreCase("xls_footer-left")) {
            footer.setLeft(mynode);
        }
        if (nodename.equalsIgnoreCase("xls_footer-center")) {
            footer.setCenter(mynode);
        }
        if (nodename.equalsIgnoreCase("xls_footer-right")) {
            footer.setRight(mynode);
        }
    }

    protected void createXls_Sheet(boolean hasVorlagendatei, Hashtable styles, Node sheetnode, Node pageformat, Workbook wb, int counter, boolean isNewSheetWanted) {
        Sheet sheet;
        if (sheetnode == null || pageformat == null) {
            return;
        }
        String s = XMLUtils.getAttribValue(sheetnode, "name");
        if (s == null) {
            s = "Ergebnis";
        }
        if (isNewSheetWanted || counter > wb.getNumberOfSheets()) {
            sheet = wb.createSheet(this.createExcelSheetname(s) + counter);
        } else if (XMLUtils.hasAttrib(sheetnode, "exactmatch") && XMLUtils.getAttribValue(sheetnode, "exactmatch").equals("true")) {
            sheet = wb.getSheet(s);
        } else {
            sheet = wb.getSheetAt(counter - 1);
            wb.setSheetName(counter - 1, this.createExcelSheetname(s) + counter);
        }
        Logger.getLogger((String)("superx_" + this.getMandantenID() + "_xml")).log((Priority)Level.INFO, (Object)("Erzeuge Excel Sheet " + counter));
        Logger.getLogger((String)("superx_" + this.getMandantenID() + "_xml")).log((Priority)Level.INFO, (Object)("Erzeuge PageFormat f\u00fcr Excel Sheet " + counter));
        if (this.maske != null && this.maske.isNewExcelExport()) {
            String msg = "Maske " + this.maske.getName() + " neuer RAM excelexport";
            Logger.getLogger((String)("superx_" + this.getMandantenID() + "_xml")).log((Priority)Level.INFO, (Object)msg);
            Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.INFO, (Object)msg);
        }
        if (!hasVorlagendatei) {
            this.createXlsPageFormat(pageformat, sheet);
        }
        if (XMLUtils.hasAttrib(sheetnode, "repeatrowstart")) {
            this.installRepeatRows(counter - 1, sheetnode, wb);
        }
        Logger.getLogger((String)("superx_" + this.getMandantenID() + "_xml")).log((Priority)Level.INFO, (Object)("Erzeuge Rows f\u00fcr Excel Sheet " + counter));
        this.createXls_fillSheet(styles, sheetnode, wb, counter, sheet);
    }

    private void createXls_fillFromRAM(Hashtable styles, Workbook wb, int counter, Sheet sheet, int rownum) {
        SuperX_el el = this.maske.getResult_el();
        SxResultSet rs = el.getResultSet();
        Row row = null;
        for (SxResultRow sxrow : rs) {
            XSSFCellStyle style = null;
            if (el.getColumnNames()[0].equals("ebene")) {
                style = (XSSFCellStyle)styles.get("intdecimal" + (Integer.valueOf(sxrow.get(0).toString()) + 3));
            }
            row = sheet.createRow(rownum);
            int columnnum = 0;
            if (this.maske.getColset() != null && !this.maske.getColset().trim().equals("") && !this.maske.getColset().equals("restore")) {
                StringTokenizer st = new StringTokenizer(this.maske.getColset(), "|");
                while (st.hasMoreTokens()) {
                    String colname = st.nextToken();
                    int trueColumn = el.getTrueColumnNumber(colname);
                    if (colname.startsWith("hidden") || colname.startsWith("next")) continue;
                    Object o = sxrow.get(trueColumn);
                    this.createXLS_fillFromRAMCell(styles, row, style, columnnum, o, el.getColumnTypes()[trueColumn]);
                    ++columnnum;
                }
            } else {
                int anzahlUebersprungen = 0;
                for (Object o : sxrow) {
                    if (el.getColumnNames()[columnnum].startsWith("hidden") || el.getColumnNames()[columnnum].startsWith("next")) {
                        ++anzahlUebersprungen;
                        ++columnnum;
                        continue;
                    }
                    this.createXLS_fillFromRAMCell(styles, row, style, columnnum - anzahlUebersprungen, o, el.getColumnTypes()[columnnum]);
                    ++columnnum;
                }
            }
            ++rownum;
        }
    }

    private void createXLS_fillFromRAMCell(Hashtable styles, Row row, XSSFCellStyle style, int columnnum, Object o, int columnType) {
        Cell cell = row.createCell(columnnum);
        XSSFCellStyle tmpStyle = null;
        if (style == null && (columnType == 3 || columnType == 4)) {
            if (columnType == 3) {
                tmpStyle = (XSSFCellStyle)styles.get("simple_decimal");
            }
            if (columnType == 4) {
                tmpStyle = (XSSFCellStyle)styles.get("simple_integer");
            }
            cell.setCellStyle((CellStyle)tmpStyle);
        }
        if (style != null) {
            cell.setCellStyle((CellStyle)style);
        }
        if (o != null && !o.toString().trim().equals("") && !o.toString().trim().equals(" ")) {
            if (columnType == 3 || columnType == 4) {
                double d1 = Double.parseDouble(o.toString());
                cell.setCellType(CellType.NUMERIC);
                cell.setCellValue(d1);
            } else if (columnType == 6) {
                cell.setCellValue(DateUtils.format((Date)o));
            } else {
                cell.setCellValue(o.toString());
            }
        } else {
            cell.setCellType(CellType.BLANK);
        }
        if (tmpStyle != null) {
            cell.setCellStyle((CellStyle)tmpStyle);
        }
        if (style != null) {
            cell.setCellStyle((CellStyle)style);
        }
    }

    private void createXls_fillSheet(Hashtable styles, Node sheetnode, Workbook wb, int counter, Sheet sheet) {
        Row row = null;
        String row_level = "";
        int rownum = 0;
        Iterator<Node> it = XMLUtils.getChildNodeIterator(sheetnode);
        while (it.hasNext()) {
            String s;
            Node rownode = it.next();
            row_level = "";
            if (XMLUtils.hasAttrib(rownode, "jumpover") && XMLUtils.getAttribValue(rownode, "jumpover").equals("true")) {
                ++rownum;
                continue;
            }
            if (XMLUtils.hasAttrib(rownode, "ebene")) {
                row_level = XMLUtils.getAttribValue(rownode, "ebene");
            }
            if (XMLUtils.hasAttrib(rownode, "issumme")) {
                row_level = "summe";
            }
            row = sheet.createRow(rownum);
            try {
                s = XMLUtils.getAttribValue(rownode, "height");
                if (s != null) {
                    row.setHeight(Short.parseShort(s));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                s = XMLUtils.getAttribValue(rownode, "repeating");
                if (s != null) {
                    if (s.equalsIgnoreCase("true")) {
                        sheet.setRepeatingRows(new CellRangeAddress(rownum, rownum, -1, -1));
                    } else {
                        sheet.setRepeatingRows(new CellRangeAddress(rownum, rownum + Integer.parseInt(s) - 1, -1, -1));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            short columnnum = 0;
            Iterator<Node> cellit = XMLUtils.getChildNodeIterator(rownode);
            while (cellit.hasNext()) {
                Node cellnode = cellit.next();
                if (XMLUtils.hasAttrib(cellnode, "jumpover") && XMLUtils.getAttribValue(cellnode, "jumpover").equals("true")) {
                    columnnum = (short)(columnnum + 1);
                    continue;
                }
                this.createXlsCell(wb, sheet, styles, row, rownum, row_level, cellnode, columnnum);
                columnnum = (short)(columnnum + 1);
            }
            ++rownum;
        }
        if (this.maske != null && this.maske.isNewExcelExport()) {
            this.createXls_fillFromRAM(styles, wb, counter, sheet, rownum);
        }
    }

    private void createXlsCell(Workbook wb, Sheet sheet, Hashtable styles, Row row, int rownum, String row_level, Node cellnode, short columnnum) {
        String s;
        String value = null;
        Object laenge = null;
        Cell cell = null;
        try {
            value = XMLUtils.getChildNodeValues(cellnode).trim();
        }
        catch (Exception e) {
            value = "";
        }
        cell = row.createCell((int)columnnum);
        try {
            if (row_level != null && !row_level.equals("")) {
                CellStyle style;
                String datatype = "general";
                if (XMLUtils.hasAttrib(cellnode, "datatype") && (XMLUtils.getAttribValue(cellnode, "datatype").equals("decimal") || XMLUtils.getAttribValue(cellnode, "datatype").equals("integer"))) {
                    datatype = XMLUtils.getAttribValue(cellnode, "datatype");
                }
                if ((style = (CellStyle)styles.get("int" + datatype + row_level)) == null) {
                    throw new RuntimeException("Excel kann nicht erzeugt werden DETAILS:Kein Style f\u00fcr Ebene +" + row_level + " datatype:" + datatype + " gefunden");
                }
                cell.setCellStyle(style);
            } else {
                s = XMLUtils.getAttribValue(cellnode, "style");
                if (s != null) {
                    cell.setCellStyle((CellStyle)styles.get(s));
                }
            }
        }
        catch (Exception datatype) {
            // empty catch block
        }
        if (XMLUtils.hasAttrib(cellnode, "numeric") || cell.getCellStyle() != null && cell.getCellStyle().getDataFormat() != 0) {
            cell.setCellValue("");
            if (value != null && !value.trim().equals("") && !value.equals(" ")) {
                try {
                    double d1 = Double.parseDouble(value);
                    cell.setCellType(CellType.NUMERIC);
                    cell.setCellValue(d1);
                }
                catch (NumberFormatException e) {
                    cell.setCellType(CellType.BLANK);
                    cell.setCellValue("");
                }
            } else {
                cell.setCellType(CellType.BLANK);
            }
        } else if (value == null || value.trim().equals("")) {
            cell.setCellType(CellType.BLANK);
        } else {
            this.setStringValue(value, cell);
        }
        try {
            s = XMLUtils.getAttribValue(cellnode, "width");
            if (s != null) {
                if (Integer.parseInt(s) < 32000) {
                    sheet.setColumnWidth((int)columnnum, (int)Short.parseShort(s));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s = XMLUtils.getAttribValue(cellnode, "colspan");
            if (s != null) {
                sheet.addMergedRegion(new CellRangeAddress(rownum, rownum, (int)columnnum, (int)((short)(columnnum + Integer.parseInt(s) - 1))));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            s = XMLUtils.getAttribValue(cellnode, "rowspan");
            if (s != null) {
                sheet.addMergedRegion(new CellRangeAddress(rownum, rownum + Integer.parseInt(s) - 1, (int)columnnum, (int)columnnum));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setStringValue(String value, Cell cell) {
        try {
            cell.setCellType(CellType.STRING);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        cell.setCellValue(value.trim());
    }

    private void installRepeatRows(int sheetpos, Node sheetnode, Workbook wb) {
        String repeatrowstart = XMLUtils.getAttribValue(sheetnode, "repeatrowstart");
        if (!XMLUtils.hasAttrib(sheetnode, "repeatrowend")) {
            throw new IllegalArgumentException("Excel kann nicht erzeugt werden DETAILS: sheet must have both attribs: repeatrowstart and repeatrowend");
        }
        String repeatrowend = XMLUtils.getAttribValue(sheetnode, "repeatrowend");
        int startrow = Integer.parseInt(repeatrowstart);
        int endrow = Integer.parseInt(repeatrowend);
        Sheet localsheet = wb.getSheetAt(sheetpos);
        localsheet.setRepeatingRows(new CellRangeAddress(startrow - 1, endrow - 1, -1, -1));
    }

    String createExcelSheetname(String s) {
        s = SxDBUtils.replaceString((String)s, "/", "|");
        s = SxDBUtils.replaceString((String)s, "\\", "");
        s = SxDBUtils.replaceString((String)s, "?", "");
        s = SxDBUtils.replaceString((String)s, "*", "");
        s = SxDBUtils.replaceString((String)s, "[", "");
        if (((String)(s = SxDBUtils.replaceString((String)s, "]", ""))).length() > 28) {
            s = ((String)s).substring(0, 26) + "..";
        }
        return s;
    }

    private void createNative(StringReader returnTextStringReader) throws FactoryConfigurationError, IOException, ParserConfigurationException, TransformerException, DBServletException {
        Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.INFO, (Object)("Native Transformation startet " + this.contenttype));
        DocumentBuilderFactory dfactory = XMLUtils.createSecureDocumentBuilderFactory();
        DocumentBuilder builder = dfactory.newDocumentBuilder();
        InputSource is = new InputSource(returnTextStringReader);
        Document mydomres = builder.newDocument();
        try {
            mydomres = builder.parse(is);
        }
        catch (SAXException e1) {
            Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.ERROR, (Object)("XML-Strom nicht valide: " + e1.toString()));
        }
        Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.INFO, (Object)"Lese native Datei");
        Node colnode = XMLUtils.getFirstNode(mydomres, "col");
        Node filenode = XMLUtils.getChildNode(colnode, "wert");
        String filename = XMLUtils.getChildNodeValues(filenode);
        String pfad = this.getServletConfig().getServletContext().getRealPath("/WEB-INF/downloads/" + filename);
        ByteArrayOutputStream myStream = new ByteArrayOutputStream();
        try {
            int len;
            FileInputStream filestream = new FileInputStream(pfad);
            byte[] buf = new byte[4096];
            while ((len = filestream.read(buf)) > 0) {
                myStream.write(buf, 0, len);
            }
            Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.INFO, (Object)("Datei " + filename + " erfolgreich gelesen "));
            this.response.setContentType(this.contenttype.substring(this.contenttype.indexOf("native_") + 7));
            this.response.setContentLength(myStream.size());
            this.response.setHeader("Content-disposition", "inline; filename=" + filename);
            ServletOutputStream os = this.response.getOutputStream();
            myStream.writeTo((OutputStream)os);
            os.flush();
            myStream.reset();
        }
        catch (IOException e) {
            Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.INFO, (Object)("Native Datei " + pfad + " kann nicht gelesen werden: " + e.toString()));
            e.printStackTrace();
            throw new DBServletException("Download-Datei " + pfad + " kann nicht gelesen werden." + e.getMessage());
        }
    }

    private class XlsStyles {
        private Hashtable styles = new Hashtable();

        XlsStyles(NodeList stylenodes, Workbook wb) {
            this.initInternalStyles(wb);
            this.initExternalStyles(stylenodes, wb);
        }

        public Hashtable getHashtable() {
            return this.styles;
        }

        private void initInternalStyles(Workbook wb) {
            this.initInternal(wb, "general");
            this.initInternal(wb, "decimal");
            this.initInternal(wb, "integer");
        }

        private void initInternal(Workbook wb, String datatype) {
            CellStyle style = wb.createCellStyle();
            style.setAlignment(HorizontalAlignment.RIGHT);
            style.setDataFormat((short)4);
            this.styles.put("simple_decimal", style);
            style = wb.createCellStyle();
            style.setAlignment(HorizontalAlignment.RIGHT);
            style.setDataFormat((short)3);
            this.styles.put("simple_integer", style);
            style = wb.createCellStyle();
            style.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
            style.setBorderLeft(BorderStyle.MEDIUM);
            style.setBorderRight(BorderStyle.MEDIUM);
            style.setBorderTop(BorderStyle.MEDIUM);
            style.setBorderBottom(BorderStyle.MEDIUM);
            style.setFont(XmlTransformer.this.font_1);
            this.adapt(style, datatype);
            this.styles.put("int" + datatype + "1", style);
            style = wb.createCellStyle();
            style.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
            style.setBorderLeft(BorderStyle.MEDIUM_DASHED);
            style.setBorderRight(BorderStyle.MEDIUM_DASHED);
            style.setBorderTop(BorderStyle.MEDIUM_DASHED);
            style.setBorderBottom(BorderStyle.MEDIUM_DASHED);
            style.setFont(XmlTransformer.this.font_2);
            this.styles.put("int" + datatype + "2", style);
            style = wb.createCellStyle();
            style.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
            style.setBorderLeft(BorderStyle.HAIR);
            style.setBorderRight(BorderStyle.HAIR);
            style.setBorderTop(BorderStyle.HAIR);
            style.setBorderBottom(BorderStyle.HAIR);
            this.styles.put("int" + datatype + "3", style);
            style = wb.createCellStyle();
            style.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
            style.setBorderLeft(BorderStyle.HAIR);
            style.setBorderRight(BorderStyle.HAIR);
            style.setBorderTop(BorderStyle.HAIR);
            style.setBorderBottom(BorderStyle.HAIR);
            style.setFont(XmlTransformer.this.font_4);
            this.styles.put("int" + datatype + "4", style);
            style = wb.createCellStyle();
            style.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
            style.setBorderLeft(BorderStyle.HAIR);
            style.setBorderRight(BorderStyle.HAIR);
            style.setBorderTop(BorderStyle.HAIR);
            style.setBorderBottom(BorderStyle.HAIR);
            style.setFont(XmlTransformer.this.font_5);
            this.styles.put("int" + datatype + "5", style);
            style = wb.createCellStyle();
            style.setFillBackgroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
            style.setBorderLeft(BorderStyle.MEDIUM);
            style.setBorderRight(BorderStyle.MEDIUM);
            style.setBorderTop(BorderStyle.MEDIUM);
            style.setBorderBottom(BorderStyle.MEDIUM);
            this.styles.put("int" + datatype + "summe", style);
            XSSFCellStyle cs1 = (XSSFCellStyle)wb.createCellStyle();
            cs1.setFillForegroundColor(new XSSFColor(new Color(100, 100, 40)));
            cs1.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            cs1.setFont(XmlTransformer.this.font_2);
            cs1.setBorderLeft(BorderStyle.MEDIUM_DASHED);
            cs1.setBorderRight(BorderStyle.MEDIUM_DASHED);
            cs1.setBorderTop(BorderStyle.MEDIUM_DASHED);
            cs1.setBorderBottom(BorderStyle.MEDIUM_DASHED);
            this.styles.put("teststyle", cs1);
        }

        private void adapt(CellStyle style, String datatype) {
            if (datatype.equals("decimal")) {
                style.setAlignment(HorizontalAlignment.RIGHT);
                style.setDataFormat((short)4);
            }
            if (datatype.equals("integer")) {
                style.setAlignment(HorizontalAlignment.RIGHT);
                style.setDataFormat((short)3);
            }
        }

        private void initExternalStyles(NodeList stylenodes, Workbook wb) {
            CellStyle cellStyle = wb.createCellStyle();
            cellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"d-mmm-yy"));
            this.styles.put("body_date", cellStyle);
            String s = null;
            String stylename = null;
            if (stylenodes != null) {
                int anz_tags = stylenodes.getLength();
                for (int i = 0; i < anz_tags; ++i) {
                    Node stylenode = stylenodes.item(i);
                    CellStyle cs = wb.createCellStyle();
                    DataFormat format = wb.createDataFormat();
                    stylename = XMLUtils.getAttribValue(stylenode, "name");
                    try {
                        Node fontnode = XMLUtils.getChildNode(stylenode, "xls_font");
                        Font f = wb.createFont();
                        cs.setFont(f);
                        try {
                            s = XMLUtils.getAttribValue(fontnode, "name");
                            if (s != null) {
                                f.setFontName(s);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            s = XMLUtils.getAttribValue(fontnode, "height");
                            if (s != null) {
                                f.setFontHeight(Short.parseShort(s));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            s = XMLUtils.getAttribValue(fontnode, "color");
                            if (s != null) {
                                f.setColor(XmlTransformer.this.getColorIndex(s));
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (XMLUtils.getAttribValue(fontnode, "bold") != null) {
                                f.setBold(true);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (XMLUtils.getAttribValue(fontnode, "underline") != null) {
                                f.setUnderline((byte)1);
                            }
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception fontnode) {
                        // empty catch block
                    }
                    Iterator<Node> it = XMLUtils.getChildNodeIterator(stylenode);
                    while (it.hasNext()) {
                        Node n = it.next();
                        if (n.getLocalName() == "xls_border") {
                            try {
                                s = XMLUtils.getAttribValue(n, "type").toUpperCase();
                                BorderStyle type = BorderStyle.NONE;
                                if (s != null) {
                                    if (s.equals("DASH_DOT")) {
                                        type = BorderStyle.DASH_DOT;
                                    }
                                    if (s.equals("DASH_DOT_DOT")) {
                                        type = BorderStyle.DASH_DOT_DOT;
                                    }
                                    if (s.equals("DASHED")) {
                                        type = BorderStyle.DASHED;
                                    }
                                    if (s.equals("DOTTED")) {
                                        type = BorderStyle.DOTTED;
                                    }
                                    if (s.equals("DOUBLE")) {
                                        type = BorderStyle.DOUBLE;
                                    }
                                    if (s.equals("HAIR")) {
                                        type = BorderStyle.HAIR;
                                    }
                                    if (s.equals("MEDIUM")) {
                                        type = BorderStyle.MEDIUM;
                                    }
                                    if (s.equals("MEDIUM_DASH_DOT")) {
                                        type = BorderStyle.MEDIUM_DASH_DOT;
                                    }
                                    if (s.equals("MEDIUM_DASHED")) {
                                        type = BorderStyle.MEDIUM_DASHED;
                                    }
                                    if (s.equals("NONE")) {
                                        type = BorderStyle.NONE;
                                    }
                                    if (s.equals("SLANTED_DASH_DOT")) {
                                        type = BorderStyle.SLANTED_DASH_DOT;
                                    }
                                    if (s.equals("THICK")) {
                                        type = BorderStyle.THICK;
                                    }
                                    if (s.equals("THIN")) {
                                        type = BorderStyle.THIN;
                                    }
                                }
                                if ((s = XMLUtils.getAttribValue(n, "location").toUpperCase()) != null) {
                                    if (s.equals("BOTTOM")) {
                                        cs.setBorderBottom(type);
                                    }
                                    if (s.equals("TOP")) {
                                        cs.setBorderTop(type);
                                    }
                                    if (s.equals("LEFT")) {
                                        cs.setBorderLeft(type);
                                    }
                                    if (s.equals("RIGHT")) {
                                        cs.setBorderRight(type);
                                    }
                                }
                            }
                            catch (Exception type) {
                                // empty catch block
                            }
                        }
                        if (n.getLocalName() == "xls_fill") {
                            try {
                                short c = XmlTransformer.this.getColorIndex(XMLUtils.getAttribValue(n, "color"));
                                if (c != -999) {
                                    cs.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                                    cs.setFillForegroundColor(c);
                                }
                            }
                            catch (Exception c) {
                                // empty catch block
                            }
                        }
                        if (n.getLocalName() == "xls_align") {
                            try {
                                s = XMLUtils.getAttribValue(n, "align").toUpperCase();
                                if (s != null) {
                                    if (s.equals("ALIGN_CENTER")) {
                                        cs.setAlignment(HorizontalAlignment.CENTER);
                                    }
                                    if (s.equals("ALIGN_CENTER_SELECTION")) {
                                        cs.setAlignment(HorizontalAlignment.CENTER_SELECTION);
                                    }
                                    if (s.equals("ALIGN_FILL")) {
                                        cs.setAlignment(HorizontalAlignment.FILL);
                                    }
                                    if (s.equals("ALIGN_GENERAL")) {
                                        cs.setAlignment(HorizontalAlignment.GENERAL);
                                    }
                                    if (s.equals("ALIGN_JUSTIFY")) {
                                        cs.setAlignment(HorizontalAlignment.JUSTIFY);
                                    }
                                    if (s.equals("ALIGN_LEFT")) {
                                        cs.setAlignment(HorizontalAlignment.LEFT);
                                    }
                                    if (s.equals("ALIGN_RIGHT")) {
                                        cs.setAlignment(HorizontalAlignment.RIGHT);
                                    }
                                }
                            }
                            catch (Exception c) {
                                // empty catch block
                            }
                            try {
                                s = XMLUtils.getAttribValue(n, "valign").toUpperCase();
                                if (s != null) {
                                    if (s.equals("VERTICAL_BOTTOM")) {
                                        cs.setVerticalAlignment(VerticalAlignment.BOTTOM);
                                    }
                                    if (s.equals("VERTICAL_CENTER")) {
                                        cs.setVerticalAlignment(VerticalAlignment.CENTER);
                                    }
                                    if (s.equals("VERTICAL_JUSTIFY")) {
                                        cs.setVerticalAlignment(VerticalAlignment.JUSTIFY);
                                    }
                                    if (s.equals("VERTICAL_TOP")) {
                                        cs.setVerticalAlignment(VerticalAlignment.TOP);
                                    }
                                }
                            }
                            catch (Exception c) {
                                // empty catch block
                            }
                        }
                        if (n.getLocalName().equals("wrapText")) {
                            cs.setWrapText(true);
                        }
                        if (!n.getLocalName().equals("xls_format")) continue;
                        String formatattrib = XMLUtils.getAttribValue(n, "format");
                        try {
                            cs.setDataFormat(Short.parseShort(formatattrib));
                        }
                        catch (NumberFormatException e) {
                            cs.setDataFormat(format.getFormat(formatattrib));
                        }
                    }
                    this.styles.put(stylename, cs);
                }
            }
        }
    }
}

