/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.DBAccess;
import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.CryptUtils;
import de.memtext.util.DateUtils;
import de.memtext.util.EqualsUtil;
import de.memtext.util.ServletHelper;
import de.superx.common.AbstractSicht;
import de.superx.common.DBServletException;
import de.superx.common.OrgUnit;
import de.superx.common.Sichten;
import de.superx.common.SxFinRechte;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxUser;
import de.superx.servlet.ImplicitOrgEinheitFillerI;
import de.superx.servlet.JavaRecursiveImplicitOrgEinheitFiller;
import de.superx.servlet.LdapPasswordChecker;
import de.superx.servlet.PostgresImplicitOrgEinheitFiller;
import de.superx.servlet.RequestParameter;
import de.superx.servlet.ServletBasics;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SessionAttribute;
import de.superx.servlet.SichtServlet;
import de.superx.servlet.SichtartRechteDefinition;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import de.superx.servlet.TokenChecker;
import de.superx.servlet.UserAndRightsStreamliner;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.h2.util.StringUtils;
import org.saiku.web.service.SessionService;
import org.springframework.context.ApplicationContext;

public class UserInitializer {
    private static Logger logger = Logger.getLogger(UserInitializer.class);
    private static final String SELECT_ORGUNIT = "select key_apnr as apnr,uniquename,lid,name,gueltig_seit,gueltig_bis from organigramm where lid in ";
    public static final String MAXIMALE_LOGIN_VERSUCHE_UEBERSCHRITTEN = " Maximale Login-Versuche \u00fcberschritten";
    private SxUser user = new SxUser();
    private boolean isPasswordChangeDemanded = false;
    protected HttpServletRequest request;
    private String mandantenID = SxSQL_Server.DEFAULT_MANDANTEN_ID;
    private String oldsha;
    private boolean implicit_orgunit_rights_table_exists = false;

    public UserInitializer(HttpServletRequest request) throws IOException {
        this.request = request;
    }

    public UserInitializer(String mandantenID, String userName, Integer userid, Object adminUser) throws SQLException, DBServletException, TransformerException {
        this.mandantenID = mandantenID;
        this.user = new SxUser(userName, userid, mandantenID);
        if (adminUser.toString().contentEquals("1")) {
            this.user.setAdmin(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(TokenChecker tokenChecker, ApplicationContext springApplicationContext) throws NichtAngemeldetException, IllegalArgumentException, SecurityException, TransformerConfigurationException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, TransformerException, KeyParentEqualException, SQLException, DBServletException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (tokenChecker != null) {
            this.streamLineTokenRightsAndFillRightsMap(tokenChecker, attributes);
        }
        this.mandantenID = ServletHelper.getParameter(this.request, RequestParameter.MandantenID);
        if (this.mandantenID == null) {
            this.mandantenID = SxSQL_Server.DEFAULT_MANDANTEN_ID;
        }
        this.user.setMandantenID(this.mandantenID);
        try (Connection con = SxPools.getConnection(this.mandantenID);){
            this.authenticate(con);
            UserInitializer userInitializer = this;
            synchronized (userInitializer) {
                if (SxPools.get((String)this.mandantenID).userpool.containsItemWithId(this.user.getId().toString())) {
                    this.user = (SxUser)SxPools.get((String)this.mandantenID).userpool.getById(this.user.getId().toString());
                } else {
                    try {
                        this.initUser(con, attributes);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new IllegalArgumentException(e.toString());
                    }
                }
                this.initHttpSession();
                attributes.putAll(this.initAttributes(tokenChecker, this.user.isAdmin()));
                this.updateUserAndSessionAttrib(this.user, attributes);
                if (springApplicationContext != null) {
                    SessionService sessionService = (SessionService)springApplicationContext.getBean("sessionService");
                    sessionService.logout(this.request);
                    sessionService.authenticate(this.request, this.user.getName(), null);
                }
            }
        }
    }

    private void initHttpSession() {
        HttpSession session = this.request.getSession(true);
        session.setAttribute("UserID", (Object)this.user.getId().toString());
        session.setAttribute("sessiontype", (Object)"superx");
        session.setAttribute("MandantenID", (Object)this.mandantenID);
        session.setAttribute("User-A", (Object)this.request.getHeader("User-Agent"));
        String desiredLocale = ServletHelper.getParameter(this.request, RequestParameter.locale);
        if (desiredLocale != null) {
            session.setAttribute("locale", (Object)desiredLocale);
        }
        session.setAttribute("username", (Object)this.user.getName());
        session.setAttribute("user", (Object)this.user);
        session.setAttribute("sessiontype", (Object)"superx");
        session.setAttribute("UserIsAdmin", (Object)(this.user.isAdmin() ? "true" : "false"));
        session.setAttribute("UserMaskRights", (Object)this.user.getMaskRights());
        session.setAttribute("UserGroups", (Object)this.user.getGroups());
        session.setAttribute("UserSachgebiete", (Object)this.user.getSachgebiete());
        session.setAttribute("UserGroupnames", (Object)this.user.getGroupnames());
        if (this.isPasswordChangeDemanded()) {
            session.setAttribute("passwordchange", (Object)"true");
        }
    }

    private void initPWGueltigkeit_Oldshas(Connection con) throws SQLException {
        try (Statement st = con.createStatement();){
            try (ResultSet rs = st.executeQuery("select passwd_sha from userinfo where tid=" + this.user.getUserIdAsInt());){
                while (rs.next()) {
                    this.user.setCurrentSha(rs.getString(1));
                }
            }
            rs = st.executeQuery("select pw_gueltig_bis,old_sha1,old_sha2,old_sha3,old_sha4,old_sha5,old_sha6,old_sha7 from user_pw where userinfo_id=" + this.user.getUserIdAsInt());
            try {
                while (rs.next()) {
                    Date gueltig_bis = rs.getDate(1);
                    java.util.Date today = new java.util.Date();
                    if (gueltig_bis != null && !DateUtils.isDateInFuture(gueltig_bis)) {
                        this.isPasswordChangeDemanded = true;
                    }
                    this.user.setOldSha(0, rs.getString(2));
                    this.user.setOldSha(1, rs.getString(3));
                    this.user.setOldSha(2, rs.getString(4));
                    this.user.setOldSha(3, rs.getString(5));
                    this.user.setOldSha(4, rs.getString(6));
                    this.user.setOldSha(5, rs.getString(7));
                    this.user.setOldSha(6, rs.getString(8));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
    }

    private void initImplicitOrgUnitRights(Connection con) throws SQLException {
        if (DBAccess.hasTable(con, "implicit_orgunit_rights")) {
            this.implicit_orgunit_rights_table_exists = true;
        }
        if (this.implicit_orgunit_rights_table_exists) {
            logger.info((Object)("Leere implicit_orgunit_rights f\u00fcr User " + this.user.getName() + " (" + this.user.getUserIdAsInt() + ")"));
            PreparedStatement pst_delete = con.prepareStatement("delete from implicit_orgunit_rights where userinfo_id=?");
            pst_delete.setInt(1, this.user.getUserIdAsInt());
            pst_delete.execute();
            pst_delete.close();
        }
        logger.info((Object)("BI-Trage implizite erlaubte Orgeinheiten ein f\u00fcr User " + this.user.getName() + " (" + this.user.getUserIdAsInt() + ")"));
        if (this.user.hasAllOrgUnitRights()) {
            this.allowAllOrgUnitsImplicitly(con);
        } else {
            ImplicitOrgEinheitFillerI iof = null;
            if (SxPools.get(this.mandantenID).getSqlDialect().contentEquals("Postgres")) {
                logger.info((Object)"Using PostgresImplicitOrgEinheitFiller");
                iof = new PostgresImplicitOrgEinheitFiller(this.implicit_orgunit_rights_table_exists, this.user);
            } else {
                logger.info((Object)"Using JavaRecursiveImplicitOrgEinheitFiller");
                iof = new JavaRecursiveImplicitOrgEinheitFiller(this.implicit_orgunit_rights_table_exists, this.user);
            }
            for (OrgUnit ou : this.user.getAllowedOrgUnits()) {
                iof.insertImplicitOrgUnitRights(con, ou);
            }
        }
    }

    private void allowAllOrgUnitsImplicitly(Connection con) throws SQLException {
        if (this.implicit_orgunit_rights_table_exists) {
            logger.info((Object)("Trage alle Einheiten komplett ein in implicit_orgunit_rights f\u00fcr UserId " + this.user.getName() + " (" + this.user.getUserIdAsInt() + ")"));
            try (PreparedStatement pst = con.prepareStatement("insert into implicit_orgunit_rights (userinfo_id,apnr,uniquename,lid)\nselect ?::integer,key_apnr,nvl(uniquename,key_apnr)::varchar(255),lid from organigramm union\nselect ?::integer,mapped_id,uniquename,lid from orgunit_mapping union\nselect ?::integer,uniquename,uniquename,lid from orgunit_mapping");){
                pst.setInt(1, this.user.getUserIdAsInt());
                pst.setInt(2, this.user.getUserIdAsInt());
                pst.setInt(3, this.user.getUserIdAsInt());
                pst.execute();
            }
        }
        try (Statement stm = con.createStatement();
             ResultSet rs = stm.executeQuery("select key_apnr,nvl(uniquename,key_apnr) as uniquename,lid,name,gueltig_seit,gueltig_bis from organigramm");){
            while (rs.next()) {
                OrgUnit ou = new OrgUnit(rs.getString("key_apnr"), rs.getString("uniquename"), rs.getString("lid"), rs.getString("name"), rs.getDate("gueltig_seit"), rs.getDate("gueltig_bis"));
                this.user.addImplicitlyAllowedOrgUnit(ou);
            }
        }
    }

    private void authenticate(Connection con) throws DBServletException, NichtAngemeldetException, SQLException {
        logger.debug((Object)("Session authentication for user=" + this.user.getName()));
        String token = ServletHelper.getParameter(this.request, RequestParameter.token);
        if (!SuperXManager.isHis1) {
            this.superxStandaloneAuthenfication(con);
        } else if (token != null) {
            TokenChecker tokenChecker = new TokenChecker(token);
            tokenChecker.testAll();
            this.user.setName(tokenChecker.getKennung());
            this.user.setHisInOneOrgUnitLidOfRole(tokenChecker.getOrgunitLid());
            this.checkIfUserExistsInDatabaseAndUpdateDetails(con, false);
        } else {
            this.his1GuestAuthentication(con);
        }
        this.erfolgreicheAnmeldungVerarbeiten(con);
    }

    private void superxStandaloneAuthenfication(Connection con) throws NichtAngemeldetException, SQLException {
        this.user.setName(ServletHelper.getParameter(this.request, RequestParameter.kennung));
        if (StringUtils.isNullOrEmpty((String)this.user.getName())) {
            throw new NichtAngemeldetException(" Keine Anmeldung m\u00f6glich, da im request keine Kennung angegeben.");
        }
        this.checkIfUserExistsInDatabaseAndUpdateDetails(con, true);
        String passwort = ServletHelper.getParameter(this.request, RequestParameter.passwort);
        if (passwort == null || passwort.length() == 0) {
            passwort = "notsecret";
        }
        boolean isPasswordOK = false;
        if (SuperXManager.isStandaloneLdapActive()) {
            if ("superx".equals(ServletHelper.getParameter(this.request, RequestParameter.login))) {
                logger.debug((Object)("LDAP aktiv aber Passwortkontrolle f\u00fcr " + this.user.getName() + " aus SuperX-Datenbank wegen Parameter login=superx"));
                isPasswordOK = this.isPasswordInSuperXDatabaseOK(passwort);
            } else {
                isPasswordOK = new LdapPasswordChecker().isLdapPasswordOK(false, this.mandantenID, this.user.getName(), passwort);
            }
        } else {
            isPasswordOK = this.request.getRemoteUser() != null ? true : this.isPasswordInSuperXDatabaseOK(passwort);
        }
        if (!isPasswordOK) {
            this.passwortFehlerVerarbeiten(con);
            throw new NichtAngemeldetException(" Falsches Passwort f\u00fcr User " + this.user.getName());
        }
    }

    private void his1GuestAuthentication(Connection con) throws NichtAngemeldetException, SQLException {
        this.user.setName(ServletBasics.getParameter(this.request, RequestParameter.kennung));
        if (StringUtils.isNullOrEmpty((String)this.user.getName())) {
            throw new NichtAngemeldetException(" Keine Anmeldung m\u00f6glich, da im request keine Kennung angegeben.");
        }
        if (!UserInitializer.isGuestUser(con, this.user.getName())) {
            throw new NichtAngemeldetException("Kein Gastzugang f\u00fcr " + this.user.getName());
        }
        this.checkIfUserExistsInDatabaseAndUpdateDetails(con, false);
    }

    public void initUser(Connection con, Map<String, Object> hisInOneAttributMap) throws IllegalArgumentException, SecurityException, TransformerConfigurationException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, TransformerException, KeyParentEqualException, SQLException, DBServletException, NichtAngemeldetException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        this.user.getSelectionBuffer().setActive(SuperXManager.isSessionFieldDefaultsWanted(this.mandantenID));
        this.user.setDBVersion(SxPools.get(this.mandantenID).getDatabaseMajorVersion(), SxPools.get(this.mandantenID).getDatabaseMinorVersion());
        if (hisInOneAttributMap != null) {
            this.addH1TokenOrgUnitRights(con, hisInOneAttributMap);
        }
        this.addSuperXOrBIDirectOrgUnitRights(con);
        this.initImplicitOrgUnitRights(con);
        this.initMaskenUndSachgebietsRechte(con);
        this.initGroups(con);
        this.initSichten();
        this.initFinRechte();
        if (SxPools.get(this.mandantenID).hasKontierungsrechte()) {
            this.user.initKontierungsrechte();
        }
        this.user.initThemenbaum();
        this.user.updateFreemarkerBasicMap();
        this.initPWGueltigkeit_Oldshas(con);
        this.initMaskenEditRechte();
    }

    private void addH1TokenOrgUnitRights(Connection con, Map<String, Object> hisInOneAttributMap) throws SQLException {
        Map allowedOrgUnitLids;
        Map rightsMap = (Map)hisInOneAttributMap.get("rightsMap");
        if (rightsMap != null && (allowedOrgUnitLids = (Map)rightsMap.get("allowedOrgUnits")) != null) {
            if (allowedOrgUnitLids.size() == 0) {
                throw new RuntimeException("Keine g\u00fcltige Organisationseinheit f\u00fcr Nutzer gefunden. Bitte Hauptladeroutine Kostenrechnung ausf\u00fchren!");
            }
            String sqlLidInString = UserInitializer.buildInString(allowedOrgUnitLids.keySet());
            try (Statement stm = con.createStatement();
                 ResultSet rs = stm.executeQuery(SELECT_ORGUNIT + sqlLidInString);){
                while (rs.next()) {
                    OrgUnit ou = new OrgUnit(rs.getString("apnr"), rs.getString("uniquename"), rs.getString("lid"), rs.getString("name"), rs.getDate("gueltig_seit"), rs.getDate("gueltig_bis"));
                    this.user.addStandardOrgUnitRight(ou);
                }
            }
        }
    }

    private static String buildInString(Collection<String> items) {
        Object result = "(";
        int count = items.size();
        int i = 0;
        for (String item : items) {
            result = (String)result + "'" + item + "'";
            if (++i >= count) continue;
            result = (String)result + ",";
        }
        return (String)result + ")";
    }

    private void addSuperXOrBIDirectOrgUnitRights(Connection con) throws SQLException, DBServletException {
        try (Statement stm = con.createStatement();
             ResultSet rs = stm.executeQuery("select trim(ch110_institut) as apnr,O.uniquename,O.name,O.lid,O.gueltig_seit,O.gueltig_bis from user_institution U left outer join organigramm O on (ch110_institut=key_apnr) where userid=" + this.user.getId() + " and ch110_institut is not null and (external_entry is null or external_entry!=1) and (U.gueltig_seit is null or U.gueltig_seit<=today()) and (U.gueltig_bis is null or U.gueltig_bis>=today()) ");){
            while (rs.next()) {
                OrgUnit ou = new OrgUnit(rs.getString("apnr"), rs.getString("uniquename"), rs.getString("lid"), rs.getString("name"), rs.getDate("gueltig_seit"), rs.getDate("gueltig_bis"));
                this.user.addStandardOrgUnitRight(ou);
            }
        }
    }

    private void initFinRechte() throws SQLException, DBServletException {
        SxResultSet rs = null;
        int finRightVariant = SxPools.get(this.mandantenID).getFinRightVariant();
        if (finRightVariant != 0 && !this.user.isAdmin()) {
            if (finRightVariant == 1) {
                rs = ServletUtils.execute("Einlesen von einfachtenFin-Rechten f\u00fcr Benutzer " + this.user.getId(), SxFinRechte.getReadingSqlUserKamSimple(this.user), this.user.getMandantenID());
            }
            if (finRightVariant == 2) {
                rs = ServletUtils.execute("Einlesen von erweiterten Fin-Rechten f\u00fcr Benutzer " + this.user.getId(), SxFinRechte.getReadingSqlUserKam(this.user), this.user.getMandantenID());
            }
            if (finRightVariant == 3) {
                rs = ServletUtils.execute("Einlesen von erweiterten Fin-Rechten inkl. ins3 f\u00fcr Benutzer " + this.user.getId(), SxFinRechte.getReadingSqlUserKamIns3(this.user, SxPools.get(this.mandantenID).hasFinUserKamRestrictionFields()), this.user.getMandantenID());
            }
            SxResultSet rs2 = ServletUtils.executeALL_el(null, null, "Einlesen von Fin-Rechten proj_to_inst  f\u00fcr Benutzer " + this.user.getId(), SxFinRechte.getReadingSqlProjToInst(SxPools.get(this.mandantenID).getDatabaseAbbr(), this.user), this.user.getMandantenID(), true).getResultSet();
            this.user.initFinRechte(rs, finRightVariant, rs2, SxPools.get(this.mandantenID).is0FINJoker(), SxPools.get(this.mandantenID).getRepository());
        }
    }

    private void initSichten() throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        boolean hasSichtartRechteDefinitionen;
        boolean bl = hasSichtartRechteDefinitionen = SxPools.get(this.user.getMandantenID()).getSichtartRechteDefinitionen().size() > 0;
        if (hasSichtartRechteDefinitionen) {
            this.readAdditionalSichtenRights1();
        }
        SxResultSet rs = ServletUtils.execute("Einlesen von Sichten f\u00fcr Benutzer " + this.user.getId(), Sichten.getReadingSql(this.user), this.user.getMandantenID());
        this.user.getSichten().init(this.user.getMandantenID(), rs, SichtServlet.class);
        if (hasSichtartRechteDefinitionen) {
            this.readAdditionalSichtenRights2();
        }
        rs = ServletUtils.execute("Einlesen von Sichtrechten f\u00fcr Benutzer " + this.user.getId(), "select distinct tid,type from sichten S where " + Sichten.getErlaubteSichtenSql(this.user), this.user.getMandantenID());
        this.user.getSichten().setAllowedSichten(rs, this.user.isAdmin());
    }

    private void readAdditionalSichtenRights1() throws SQLException, DBServletException {
        for (SichtartRechteDefinition sd : SxPools.get(this.user.getMandantenID()).getSichtartRechteDefinitionen()) {
            SxResultSet rs = ServletUtils.execute("Einlesen von Sichtart " + sd.getName() + " Rechten f\u00fcr Benutzer " + this.user.getId(), sd.getSql((Integer)this.user.getId()), this.user.getMandantenID());
            this.user.getSichten().addSichtartRechte(sd.getName(), sd.isFallback_user_inst(), rs);
        }
    }

    private void readAdditionalSichtenRights2() throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        for (SichtartRechteDefinition sd : SxPools.get(this.user.getMandantenID()).getSichtartRechteDefinitionen()) {
            if (!sd.hasAdditionalKeysSQL()) continue;
            boolean isSQLOK = true;
            String sql = sd.getAdditionalKeysSQL();
            sql = sql.replaceAll("<<UserID>>", this.user.getId().toString());
            for (String sichtart : this.user.getSichten().getSichtenArten()) {
                if (sql.indexOf("<<" + sichtart + ">>") <= -1) continue;
                String sichtartkeys = this.user.getSichten().getSichtartKeys(sichtart);
                if (sichtartkeys.equals("")) {
                    isSQLOK = false;
                }
                sql = sql.replaceAll("<<" + sichtart + ">>", sichtartkeys);
            }
            if (!isSQLOK) continue;
            SxResultSet rs2 = ServletUtils.execute("Einlesen erg\u00e4nzenden Rechten von Sichtart " + sd.getName() + " Rechten f\u00fcr Benutzer " + this.user.getId(), sql, this.user.getMandantenID());
            this.user.getSichten().addSichtartRechte(sd.getName(), sd.isFallback_user_inst(), rs2);
        }
    }

    private void initGroups(Connection con) throws SQLException {
        try (Statement stm = con.createStatement();
             ResultSet rs = stm.executeQuery("select tid::varchar(10) as groupid,name from groupinfo G, user_group_bez U where G.tid=U.groupinfo_id and userinfo_id=" + this.user.getUserIdAsInt());){
            while (rs.next()) {
                this.user.addGruppe(rs.getString("groupid"), rs.getString("name"));
            }
        }
    }

    private void initMaskenUndSachgebietsRechte(Connection con) throws SQLException, DBServletException {
        String queryMaskenRechte = "--alle Abfragen f\u00fcr die die Gruppe \u00fcber Sachgebiete berechtigt \nselect distinct M.tid,M.name \n\t\t  from  maskeninfo M, sachgeb_maske_bez S, group_sachgeb_bez G, user_group_bez U \n\t\t where M.tid = S.maskeninfo_id \n\t\t and S.sachgebiete_id = G.sachgebiete_id \n\t\t   and G.groupinfo_id = U.groupinfo_id \n\t\t   and U.userinfo_id = " + this.user.getId() + " \n\t\t union  \n\t\t --alle Abfragen f\u00fcr die die Gruppe berechtigt (Einzelrechte) \n\tselect distinct M.tid,M.name \n\t\t  from  maskeninfo M, group_masken_bez G, user_group_bez U \n\t\t where  M.tid = G.maskeninfo_id \n\t\t   and G.groupinfo_id = U.groupinfo_id \n\t\t   and U.userinfo_id = " + this.user.getId() + " \n\t\t union  \n--alle Abfragen aus Sachgebieten f\u00fcr die der Nutzer Rechte hat \n\tselect distinct M.tid,M.name \n\t\tfrom  maskeninfo M  \n\t\twhere  \n \t\t (M.tid in (select maskeninfo_id from sachgeb_maske_bez S where S.sachgebiete_id in  \n\t\t (select sachgebiete_id from user_sachgeb_bez U where U.userinfo_id=" + this.user.getId() + " )))  \n\t\tunion  \n--alle Abfragen f\u00fcr die Einzelrechte in user_masken_bez angegeben \n\tselect distinct M.tid,M.name \n\t\tfrom  maskeninfo M, user_masken_bez B  \n\t\twhere \n\t\t B.userinfo_id = " + this.user.getId() + " \n\t\t \t and (M.tid = B.maskeninfo_id \n\t\t or B.maskeninfo_id = 0)";
        SxResultSet rs = ServletUtils.execute("Erlaubte Masken f\u00fcr User " + this.user.getName() + " (" + this.user.getId() + ")", queryMaskenRechte, this.user.getMandantenID());
        ArrayList<Integer> erlaubteMasken = new ArrayList<Integer>();
        for (SxResultRow row : rs) {
            erlaubteMasken.add((Integer)row.get(0));
        }
        this.user.initErlaubteMasken(erlaubteMasken);
        rs = ServletUtils.execute("Erlaubte Sachgebiete f\u00fcr User " + this.user.getName() + " (" + this.user.getId() + ")", "select sachgebiete_id from user_sachgeb_bez where userinfo_id=" + this.user.getId() + " \nunion \nselect sachgebiete_id from group_sachgeb_bez where groupinfo_id in ( \nselect groupinfo_id from user_group_bez where userinfo_id=" + this.user.getId() + ")", this.user.getMandantenID());
        this.user.setSachgebiete(rs);
        try {
            rs = ServletUtils.execute("Einlesen von versteckten Feldern f\u00fcr Benutzer " + this.user.getId(), "select field_id from group_field_pref where pref='hidden' and groupinfo_id in (select groupinfo_id from user_group_bez where userinfo_id=" + this.user.getId() + ")", this.user.getMandantenID());
            this.user.setHiddenFields(rs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initMaskenEditRechte() throws SQLException, DBServletException {
        String sql = " SELECT (SELECT count(*) from user_group_bez U,group_sachgeb_bez B, sachgebiete S where S.tid=B.sachgebiete_id and U.groupinfo_id=B.groupinfo_id and U.userinfo_id=" + this.user.getId() + " and (S.name like 'Bearbeitung%' or S.name like 'Administration%') ) + (SELECT count(*) from user_sachgeb_bez B, sachgebiete S where S.tid=B.sachgebiete_id and B.userinfo_id=" + this.user.getId() + " and (S.name like 'Bearbeitung%' or S.name like 'Administration%') )";
        SxResultSet rs = ServletUtils.execute("Bearbeitungsrechte auf Masken", sql, this.user.getMandantenID());
        this.user.setMaskenEditRights(rs);
    }

    @Deprecated
    private static void initUserField1Cache(SxUser user) throws SQLException, DBServletException {
        SxResultSet rs = ServletUtils.execute("potentielle zu cachende User-Field1-quellen lesen", "select distinct relation from felderinfo where  and art=1 and tid!=23541", user.getMandantenID());
        TreeSet<String> sqls = new TreeSet<String>();
        String haushaltsjahr = DateUtils.getYear(new Date(new java.util.Date().getTime()));
        Hashtable<String, String> formular = new Hashtable<String, String>();
        formular.put("Haushaltsjahr", haushaltsjahr);
        for (SxResultRow row : rs) {
            String sql = (String)row.get(0);
            if (sql.trim().indexOf("<<SQL>>") == -1) continue;
            sql = SqlStringUtils.generateSQL("PG", formular, sql);
            try {
                HashMap map = new HashMap();
                map.putAll(user.getBasicMap());
                sql = SxPools.get(user.getMandantenID()).getTemplateProcessor().process(map, null, "user Field1 Cache", sql, null, SxPools.get(user.getMandantenID()).getRepository(), SxPools.get(user.getMandantenID()).getSqlDialect());
                if ((sql = AbstractSicht.getStrippedSQL(sql)).indexOf("<<") != -1) continue;
                sqls.add(sql);
            }
            catch (Exception e) {
                logger.info((Object)("Problem bei Caching des User-Feld-SQLs " + sql + " " + e));
            }
        }
    }

    private void checkIfUserExistsInDatabaseAndUpdateDetails(Connection con, boolean isStandardLogin) throws SQLException, NichtAngemeldetException {
        boolean wasUserFound = false;
        boolean isUserinfoMitGueltigkeit = this.checkUserinfoMitGueltigkeit(con);
        Object select = "select tid, passwd_sha, administration, kennwort,akt_versuch,max_versuch from userinfo where benutzer = ? ";
        if (isUserinfoMitGueltigkeit) {
            select = (String)select + "and ( (gueltig_von is null or gueltig_von<=today()) and (gueltig_bis is null or gueltig_bis>=today()) )";
        }
        try (PreparedStatement pst = con.prepareStatement((String)select);){
            pst.setString(1, this.user.getName());
            try (ResultSet rs = pst.executeQuery();){
                while (rs.next()) {
                    wasUserFound = true;
                    this.checkAndUpdateUserDetails(isStandardLogin, rs);
                }
            }
        }
        if (!wasUserFound) {
            this.fehlerhafteAnmeldungProtokollieren(con);
            throw new NichtAngemeldetException(" Kombination von " + this.user.getName() + " und Passwort ung\u00fcltig");
        }
    }

    private boolean checkUserinfoMitGueltigkeit(Connection dbConnection) throws SQLException {
        boolean result = false;
        Statement stm = dbConnection.createStatement();
        DatabaseMetaData md = dbConnection.getMetaData();
        ResultSet rs = md.getColumns(null, null, "userinfo", null);
        while (rs.next()) {
            if (!rs.getString(4).equals("gueltig_von")) continue;
            result = true;
        }
        rs.close();
        return result;
    }

    private static boolean isGuestUser(Connection con, String kennung) throws SQLException {
        boolean result = false;
        try (PreparedStatement pst = con.prepareStatement("select name from userinfo where benutzer = ?");){
            pst.setString(1, kennung);
            try (ResultSet rs = pst.executeQuery();){
                if (rs.next()) {
                    String name = rs.getString("name");
                    result = name != null && name.trim().equals("Gastkennung");
                }
            }
        }
        return result;
    }

    private void passwortFehlerVerarbeiten(Connection con) throws SQLException {
        try (Statement stm = con.createStatement();){
            stm.executeUpdate("update userinfo set akt_versuch=akt_versuch+1   where tid=" + this.user.getUserIdAsInt());
            stm.execute("insert into protokoll (proto_fkt_id, userinfo_id, ip_adresse, client_name, zeitpunkt) values (2," + this.user.getUserIdAsInt() + ",'" + this.request.getRemoteAddr() + "','" + this.request.getRemoteHost() + "'," + this.now_command() + ");");
        }
    }

    private void erfolgreicheAnmeldungVerarbeiten(Connection con) throws SQLException {
        try (Statement stm = con.createStatement();){
            if (this.user.getId() != null) {
                stm.executeUpdate("update userinfo set akt_versuch=0   where tid = " + this.user.getUserIdAsInt());
            }
            this.updateLastLogin(stm);
            if (SxPools.get(this.mandantenID).isErweitertesProtokollWanted()) {
                stm.execute("insert into protokoll (proto_fkt_id, userinfo_id, ip_adresse, client_name, zeitpunkt) values (1," + this.user.getUserIdAsInt() + ",'" + this.request.getRemoteAddr() + "','" + this.request.getRemoteHost() + "'," + this.now_command() + ");");
            }
        }
    }

    private String now_command() {
        if (SxPools.get(this.mandantenID).getSqlDialect().equals("Postgres")) {
            return "now()";
        }
        return "current";
    }

    private void fehlerhafteAnmeldungProtokollieren(Connection con) throws SQLException {
        try (Statement stm = con.createStatement();){
            stm.execute("insert into protokoll (proto_fkt_id, userinfo_id, ip_adresse, client_name, zeitpunkt) values (2, -1,'" + this.request.getRemoteAddr() + "','" + this.request.getRemoteHost() + "'," + this.now_command() + ");");
        }
    }

    private void checkAndUpdateUserDetails(boolean isStandardLogin, ResultSet rs) throws SQLException, NichtAngemeldetException {
        String password_sha;
        Short adminUser;
        Integer userid = (Integer)rs.getObject(1);
        this.user.setId(userid);
        String kennwortSpalte = rs.getString(4);
        if (kennwortSpalte != null) {
            kennwortSpalte = kennwortSpalte.trim().toLowerCase();
        }
        if (isStandardLogin && kennwortSpalte != null && (kennwortSpalte.equals("\u00e4ndern") || kennwortSpalte.equals("aendern"))) {
            this.isPasswordChangeDemanded = true;
        }
        if ((adminUser = Short.valueOf(rs.getShort(3))) == 1) {
            this.user.setAdmin(true);
        }
        if ((password_sha = rs.getString(2)) == null) {
            throw new NichtAngemeldetException("Kein Passwort in DB gefunden");
        }
        password_sha = password_sha.trim();
        this.user.setCurrentSha(password_sha);
        this.oldsha = password_sha;
        int akt_versuch = rs.getInt(5);
        int max_versuch = rs.getInt(6);
        if (akt_versuch > max_versuch || max_versuch == 0) {
            throw new NichtAngemeldetException(MAXIMALE_LOGIN_VERSUCHE_UEBERSCHRITTEN);
        }
    }

    private boolean isPasswordInSuperXDatabaseOK(String enteredPassword) {
        return EqualsUtil.areEqual(this.user.getCurrentSha(), CryptUtils.encodeSHA(enteredPassword)) || EqualsUtil.areEqual(this.user.getCurrentSha(), CryptUtils.encodeSHA(enteredPassword + CryptUtils.geheimnis1));
    }

    private void updateLastLogin(Statement stm) throws SQLException {
        int userInDB = 0;
        try (ResultSet rs = stm.executeQuery("select count(*) from user_pw where userinfo_id=" + this.user.getUserIdAsInt());){
            while (rs.next()) {
                userInDB = rs.getInt(1);
            }
        }
        if (userInDB == 0) {
            stm.executeUpdate("insert into user_pw (userinfo_id,last_login) values (" + this.user.getUserIdAsInt() + ",now());");
        } else {
            stm.executeUpdate("update user_pw set last_login=now() where userinfo_id=" + this.user.getUserIdAsInt());
        }
    }

    public String getUsername() {
        return this.user.getName();
    }

    public SxUser getUser() {
        return this.user;
    }

    public boolean isPasswordChangeDemanded() {
        String attrib = "false";
        if (this.request.getSession() != null && (attrib = (String)this.request.getSession().getAttribute("passwordchange")) == null) {
            attrib = "false";
        }
        return this.isPasswordChangeDemanded || attrib.equals("true");
    }

    public void setPasswordChangeDemanded(boolean isPasswordChangeDemanded) {
        this.isPasswordChangeDemanded = isPasswordChangeDemanded;
    }

    public static String getPwChangeHtml(String message) {
        return SuperXManager.htmlPageHead("Erfolg") + "<form action=\"/superx/servlet/SuperXmlPwChanger\" method=post>" + message + "<br>Bisheriges Passwort<br><input type=password name=\"altes_passwort\" maxlength=40 size=20><br><br>Neues Passwort<br><input type=password name=\"passwort\" maxlength=40 size=20><br>Erneut eingeben<br><input type=password name=\"passwort2\" maxlength=40 size=20><br><br><input type=submit value=\"Abschicken\"></form></body></html>";
    }

    public String getOldsha() {
        return this.oldsha;
    }

    @Deprecated
    void initSessionOld(TokenChecker tokenChecker, ApplicationContext springApplicationContext) throws NichtAngemeldetException, TransformerConfigurationException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, TransformerException, KeyParentEqualException, SQLException, DBServletException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (tokenChecker != null) {
            this.streamLineTokenRightsAndFillRightsMap(tokenChecker, attributes);
        }
        attributes.putAll(this.initAttributes(tokenChecker, this.user.isAdmin()));
        this.updateUserAndSessionAttrib(this.user, attributes);
        if (springApplicationContext != null) {
            SessionService sessionService = (SessionService)springApplicationContext.getBean("sessionService");
            sessionService.logout(this.request);
            sessionService.authenticate(this.request, this.user.getName(), null);
        }
    }

    private void streamLineTokenRightsAndFillRightsMap(TokenChecker tokenChecker, Map<String, Object> attributes) throws SQLException, NichtAngemeldetException, DBServletException {
        Map<String, Map<String, String>> rightsMap = UserAndRightsStreamliner.streamline(this.mandantenID, tokenChecker);
        attributes.put("rightsMap", rightsMap);
    }

    private Map<String, Object> initAttributes(TokenChecker tokenChecker, boolean isAdmin) throws SQLException, DBServletException, NichtAngemeldetException, TransformerConfigurationException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, TransformerException, KeyParentEqualException {
        Map<String, Object> attributes = null;
        attributes = tokenChecker != null ? this.getAttributesFromToken(tokenChecker) : this.getSxStandaloneAttributes(isAdmin);
        return attributes;
    }

    private void updateUserAndSessionAttrib(SxUser user, Map<String, Object> attributes) {
        user.setRights((Map)attributes.get("rightsMap"), (String)attributes.get("role"));
        user.setHisInOneOrgUnitLidOfRole((Integer)attributes.get("orgUnit"));
        user.setRoleId((Integer)attributes.get("roleId"));
        if (this.request.getSession() != null) {
            this.request.getSession().setAttribute(SessionAttribute.isSuperXStandalone.toString(), (Object)(SuperXManager.isHis1() ? "false" : "true"));
            this.request.getSession().setAttribute(SessionAttribute.rights.toString(), (Object)((String)attributes.get(SessionAttribute.rightsString.toString())));
            this.request.getSession().setAttribute(SessionAttribute.orgUnit.toString(), (Object)((Integer)attributes.get(SessionAttribute.orgUnit.toString())));
        }
    }

    private Map<String, Object> getSxStandaloneAttributes(boolean isAdmin) throws NichtAngemeldetException, TransformerConfigurationException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, TransformerException, KeyParentEqualException, SQLException, DBServletException {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("orgUnit", Integer.getInteger("-1"));
        HashMap<String, Object> sx_rightsMap = new HashMap<String, Object>();
        if (isAdmin) {
            sx_rightsMap.put("RIGHT_CS_BIA_STANDARDREPORTS_ADMIN", null);
            sx_rightsMap.put("RIGHT_CS_BIA_OLAP_CREATE_TABLES", null);
            attributes.put("rightsString", "RIGHT_CS_BIA_OLAP_CREATE_TABLES,RIGHT_CS_BIA_STANDARDREPORTS_ADMIN");
            attributes.put("role", "ROLE_BI_ADMIN");
        } else if (this.user.getName().startsWith("gast")) {
            sx_rightsMap.put("RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS", null);
            attributes.put("rightsString", "RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS");
            attributes.put("role", "ROLE_BI_SPECIALIST");
        } else {
            sx_rightsMap.put("RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS", null);
            sx_rightsMap.put("RIGHT_CS_BIA_OLAP_CREATE_TABLES", null);
            attributes.put("rightsString", "RIGHT_CS_BIA_OLAP_CREATE_TABLES,RIGHT_CS_BIA_STANDARDREPORTS_VIEW_REPORTS");
            attributes.put("role", "ROLE_BI_SPECIALIST");
        }
        attributes.put("rightsMap", sx_rightsMap);
        return attributes;
    }

    private Map<String, Object> getAttributesFromToken(TokenChecker tokenChecker) throws NichtAngemeldetException, TransformerConfigurationException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, TransformerException, KeyParentEqualException, SQLException, DBServletException {
        logger.debug((Object)("Request.token: " + tokenChecker.getTokenString()));
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("role", tokenChecker.getRole());
        attributes.put("orgUnit", tokenChecker.getOrgunitLid());
        attributes.put("rightsString", tokenChecker.getRights());
        attributes.put("roleId", tokenChecker.getExternRoleID());
        return attributes;
    }
}

