/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.baseobjects.NamedIdObjectWithParent;
import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.tree.TreeBuilder;
import de.superx.common.DBServletException;
import de.superx.common.Menu;
import de.superx.common.MenuItemNode;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.TransletCache;
import de.superx.rest.model.MenuItem;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Themenbaum
implements Serializable {
    private static final long serialVersionUID = 2L;
    private Integer userid = -1;
    private String login_name = "dummy";
    private boolean isAdmin = false;
    private StringBuffer menuXml = new StringBuffer();
    private String menuHtml = "";
    private String mandantenID = SxSQL_Server.DEFAULT_MANDANTEN_ID;
    private Menu menu = new Menu();

    public synchronized void init(Integer userid, String login_name, boolean isAdmin, String mandantenID) throws SQLException, DBServletException, TransformerException, NichtAngemeldetException {
        this.userid = userid;
        this.login_name = login_name;
        this.mandantenID = mandantenID;
        this.isAdmin = isAdmin;
        if (SxPools.get(mandantenID).getRepository().containsKey("K_aufklappbarer Themenbaum") && SxPools.get(mandantenID).getRepository().get("K_aufklappbarer Themenbaum").toString().equals("1")) {
            this.menu.setAufklappbarerThemenbaum(true);
        }
        try {
            this.menuXml = this.getMenuXmlAndInitMenu();
        }
        catch (KeyParentEqualException e) {
            throw new SQLException("Themenbaum defekt. DETAILS: Ein Eintrag hat key=parent " + e.getMessage());
        }
        catch (NoMainEntryException e) {
            throw new SQLException("Im Themenbaum kein Hauptknoten gefunden DETAILS:mit parent null" + e);
        }
    }

    private void transform() throws TransformerException, TransformerConfigurationException, DBServletException {
        Transformer transformer = TransletCache.getTransformer(this.mandantenID, "file:///" + ServletUtils.getPath() + "/menue_html.xsl");
        StringWriter erg = new StringWriter();
        transformer.transform(new StreamSource(new StringReader(this.menuXml.toString())), new StreamResult(erg));
        this.menuHtml = erg.toString();
    }

    private StringBuffer getMenuXmlAndInitMenu() throws SQLException, DBServletException, KeyParentEqualException, NoMainEntryException, NichtAngemeldetException {
        StringBuffer result = new StringBuffer();
        result.append("<menue hisinone_active=\"" + (SuperXManager.isHis1() ? "true" : "false") + "\"\nhisinone_refapp=\"" + SuperXManager.his1_refapp + "\"\ncan_write_user_kettle=\"" + (SuperXManager.canWriteUserHomeDir || SuperXManager.canWriteUserKettleDir) + "\" showNavigation=\"true\" aufklappbarer_themenbaum=\"" + (this.menu.isAufklappbarerThemenbaum() ? "true" : "false") + "\">");
        String welcomedPerson = this.login_name;
        if (this.login_name == null || this.login_name.trim().equals("")) {
            welcomedPerson = this.userid.toString();
        }
        result.append("<nachricht>" + welcomedPerson + "</nachricht>");
        Object query = SxPools.get(this.mandantenID).getSqlDialect().equals("Postgres") ? "select sp_user_themen(" + this.userid.toString() + ",today(),1);select distinct tid,name,maskeninfo_id,parent,erlaeuterung,sort,css_class from tmp_themenbaum order by sort,name; drop table tmp_themenbaum;" : (SxPools.get(this.mandantenID).getSqlDialect().equals("Informix") ? "execute procedure sp_user_themen(" + this.userid.toString() + ",today,1);select distinct tid,name,maskeninfo_id,parent,erlaeuterung,sort,css_class from tmp_themenbaum order by sort,name; drop table tmp_themenbaum;" : "select tid, name, maskeninfo_id, parent, gueltig_seit, gueltig_bis,sort,css_class from themenbaum order by sort,name;");
        SuperX_el erg_el = ServletUtils.executeALL_el(null, null, "Themenbaum auslesen", (String)query, this.mandantenID, true);
        int countEntries = erg_el.getResultSet().size();
        Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.DEBUG, (Object)("Abfrage: " + (String)query));
        result.append("<userid>" + this.userid.toString() + "</userid>");
        result.append("<mandantenid>" + this.mandantenID + "</mandantenid>");
        result.append("<eintraege>\n");
        int zeile = 0;
        HashMap map = new HashMap();
        for (SxResultRow row : erg_el.getResultSet()) {
            String isMaske = "false";
            if (row.get(2) != null) {
                isMaske = "true";
            }
            result.append("<eintrag isMaske=\"" + isMaske + "\">\n<zeile>" + (zeile + 1) + "</zeile>\n<!--id = tid in themenbaumtabelle -->\n<id>" + row.get(0) + "</id>\n<!--tid = tid in maskeninfo-tabelle -->\n<tid>" + row.get(2) + "</tid>\n<titel><![CDATA[" + row.get(1) + "]]></titel>\n<parent>" + row.get(3) + "</parent>\n<sort>" + row.get(5) + "</sort>\n<css_class>" + row.get(6) + "</css_class>\n</eintrag>\n");
            MenuItemNode n = new MenuItemNode(new NamedIdObjectWithParent(row.get(0), (String)row.get(1), row.get(3)));
            n.setMaskenID((Integer)row.get(2));
            n.setErlaeuterung((String)row.get(4));
            if (row.get(5) != null) {
                n.setSortnr(Integer.valueOf(row.get(5).toString()));
            }
            n.setCssClass((String)row.get(6));
            TreeBuilder.add(map, n);
        }
        this.menu.clear();
        if (countEntries > 0) {
            this.menu.update(map);
        }
        result.append("</eintraege>\n");
        result.append("</menue>");
        Logger.getLogger((String)("superx_" + this.mandantenID + "_xml")).log((Priority)Level.DEBUG, (Object)("Themenbaum XML " + result));
        return result;
    }

    public String getSubmenuXml(String tid, String navigationElement) {
        if (tid == null) {
            throw new IllegalArgumentException("Keine Tid angegeben");
        }
        return this.menu.getSubmenuXml(tid, navigationElement, this.userid, this.login_name, this.isAdmin);
    }

    public String getMenupath(Integer themenbaumParent, String tid) {
        if (tid == null) {
            throw new IllegalArgumentException("Keine Tid angegeben");
        }
        return this.menu.getMenupathForMask(themenbaumParent, tid);
    }

    public String toHtml(Locale locale) {
        Logger.getLogger((String)("superx_" + this.mandantenID + "_xml")).log((Priority)Level.DEBUG, (Object)"Versuche Themenbaum HTML Transformation");
        try {
            this.transform();
        }
        catch (TransformerException e) {
            Logger.getLogger((String)("superx_" + this.mandantenID + "_xml")).log((Priority)Level.ERROR, (Object)("Themenbaum HTML Transformation fehlgeschlagen:  " + e.toString()));
        }
        catch (DBServletException e) {
            Logger.getLogger((String)("superx_" + this.mandantenID + "_xml")).log((Priority)Level.ERROR, (Object)("Themenbaum HTML Auslesen fehlgeschlagen:  " + e.toString()));
        }
        Logger.getLogger((String)("superx_" + this.mandantenID + "_xml")).log((Priority)Level.DEBUG, (Object)"Themenbaum HTML Transformation erfolgreich");
        String result = SxPools.get(this.mandantenID).localize(this.menuHtml, locale).replaceAll("_HISINONE_", SuperXManager.his1_refapp);
        Logger.getLogger((String)("superx_" + this.mandantenID + "_xml")).log((Priority)Level.DEBUG, (Object)("Themenbaum HTML  _HISINONE_ ersetzt durch " + SuperXManager.his1_refapp + "\n" + result));
        return result;
    }

    public String toXml(Locale locale) {
        String myXml = this.menuXml.toString();
        String result = SxPools.get(this.mandantenID).localize(myXml, locale);
        return result;
    }

    public List<MenuItem> getMenuEntries(int tid) {
        return this.menu.getMenuEntries(tid);
    }
}

