/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import com.google.common.base.Splitter;
import de.memtext.util.XMLUtils;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.servlet.SuperXManager;
import de.superx.util.SqlStringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SxSQL_Server {
    private static final char SQL_STRING_DELIM = '\'';
    private static final char SQL_STMT_SEP = ';';
    private static final String SQL_STMT_SEP_SUBST = "@@SEMICOLON@@";
    public static String DEFAULT_MANDANTEN_ID = "default";
    private String mandantenID = DEFAULT_MANDANTEN_ID;
    private int updateCount = -1;
    private int numberOfColumns = -1;
    private ResultSetMetaData metaData;

    public SxSQL_Server(String mandantenID) {
        this.mandantenID = mandantenID;
    }

    private static String removeSemicolonExpansionSequence(String fromThis) {
        String result = fromThis;
        while (result.contains(SQL_STMT_SEP_SUBST)) {
            result = result.replace(SQL_STMT_SEP_SUBST, "");
        }
        return result;
    }

    public synchronized void executeQuery(String query, Connection connection, SuperX_el gesamt) throws SQLException {
        SxResultSet rows = new SxResultSet();
        Statement statement = connection.createStatement();
        statement.setMaxRows(SuperXManager.maxRows);
        Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.INFO, (Object)("Abfrage ausf\u00fchren:" + query));
        try {
            int column;
            ResultSet resultSet = statement.executeQuery(query);
            this.metaData = resultSet.getMetaData();
            this.numberOfColumns = this.metaData.getColumnCount();
            String[] columnNames = new String[this.numberOfColumns];
            String[] columnLabel = new String[this.numberOfColumns];
            int[] columnDisplaySize = new int[this.numberOfColumns];
            int[] columnType = new int[this.numberOfColumns];
            int[] scales = new int[this.numberOfColumns];
            boolean[] isWritable = new boolean[this.numberOfColumns];
            for (column = 0; column < this.numberOfColumns; ++column) {
                columnNames[column] = this.metaData.getColumnName(column + 1);
            }
            for (column = 0; column < this.numberOfColumns; ++column) {
                columnLabel[column] = this.metaData.getColumnLabel(column + 1);
            }
            for (column = 0; column < this.numberOfColumns; ++column) {
                columnDisplaySize[column] = this.metaData.getColumnDisplaySize(column + 1);
            }
            for (column = 0; column < this.numberOfColumns; ++column) {
                columnType[column] = this.adaptColumType(this.metaData.getColumnType(column + 1));
            }
            for (column = 0; column < this.numberOfColumns; ++column) {
                scales[column] = this.metaData.getScale(column + 1);
            }
            for (column = 0; column < this.numberOfColumns; ++column) {
                isWritable[column] = this.metaData.isWritable(column + 1);
            }
            int naturalOrderNo = 1;
            while (resultSet.next()) {
                SxResultRow newRow = SxResultRow.createInstance(this.metaData, this.numberOfColumns, ++naturalOrderNo, resultSet, columnNames, this.mandantenID);
                rows.add(newRow);
            }
            gesamt.setColumnCount(this.numberOfColumns);
            gesamt.setAndAdaptColumnNames(columnNames);
            gesamt.setColumnLabels(columnLabel);
            gesamt.setColumnDisplaySizes(columnDisplaySize);
            gesamt.setColumnTypes(columnType);
            gesamt.setScales(scales);
            gesamt.setisWritable(isWritable);
            gesamt.setRows(rows);
            if (resultSet != null) {
                resultSet.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException e) {
            Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.INFO, (Object)e.toString());
            gesamt.setError_String(e.toString());
        }
        catch (Exception e) {
            Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.INFO, (Object)("Allgemeiner Fehler beim DB-Zugriff:" + e.toString()));
            gesamt.setError_String(e.toString());
        }
    }

    private synchronized void executePst(PreparedStatement pst, String args) throws NumberFormatException, SQLException {
        int i = args.indexOf("<pstexec>");
        int i2 = args.indexOf("</pstexec>");
        if (i == -1 || i2 == -1) {
            throw new IllegalArgumentException("<pstexec> nicht XML konform definiert");
        }
        Document doc = null;
        try {
            doc = XMLUtils.buildDocumentFromString2(args, false);
        }
        catch (Exception e) {
            System.err.println(args);
            throw new SQLException("Xml-Parsingproblem " + e);
        }
        if (doc != null) {
            NodeList list = doc.getElementsByTagName("arg");
            for (i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                String no = XMLUtils.getAttribValue(n, "no");
                String datatype = "string";
                if (XMLUtils.hasAttrib(n, "type")) {
                    datatype = XMLUtils.getAttribValue(n, "type");
                }
                String val = XMLUtils.getTheValue(n);
                pst.setString(Integer.parseInt(no), val);
            }
            int rows = pst.executeUpdate();
            System.out.println(rows + " r");
        }
    }

    public synchronized void executeALL(String query, Connection connection, SuperX_el gesamt) throws SQLException {
        gesamt.setAktuelleNachricht("");
        gesamt.setError_String("");
        if (SuperXManager.isDevelopmentMode || query.indexOf("--Abfrage") <= -1) {
            String queryReplaced = SxSQL_Server.removeSemicolonExpansionSequence(query);
            queryReplaced = SqlStringUtils.replaceInAll(queryReplaced, '\'', ';', SQL_STMT_SEP_SUBST);
            Iterator st = Splitter.on((char)';').split((CharSequence)queryReplaced).iterator();
            int n = 0;
            while (st.hasNext()) {
                ++n;
                String sqlstmt = ((String)st.next()).trim();
                if (sqlstmt.length() < 5) continue;
                sqlstmt = sqlstmt.replace(SQL_STMT_SEP_SUBST, ";");
                sqlstmt = SqlStringUtils.unescapeString(sqlstmt);
                this.execute(sqlstmt, connection, gesamt);
                String errorstring = gesamt.getError_String();
                if (errorstring.equals("")) continue;
                String msg = errorstring + " bei sql-statement Nr " + n + " " + sqlstmt;
                throw new SQLException(msg);
            }
        } else {
            int pos = query.lastIndexOf("select");
            if (query.lastIndexOf("Select") > pos) {
                pos = query.lastIndexOf("Select");
            }
            if (query.lastIndexOf("SELECT") > pos) {
                pos = query.lastIndexOf("SELECT");
            }
            String hauptteil = query.substring(0, pos);
            String rest = query.substring(pos);
            Statement stm = connection.createStatement();
            hauptteil = SxSQL_Server.removeSemicolonExpansionSequence(hauptteil);
            hauptteil = SqlStringUtils.replaceInAll(hauptteil, '\'', ';', SQL_STMT_SEP_SUBST);
            Iterator st = Splitter.on((char)';').split((CharSequence)hauptteil).iterator();
            int totallength = 0;
            while (st.hasNext()) {
                String sqlstmt = ((String)st.next()).trim();
                sqlstmt = sqlstmt.replace(SQL_STMT_SEP_SUBST, ";");
                totallength += sqlstmt.length();
                if (sqlstmt.length() > 5) {
                    stm.addBatch(sqlstmt);
                }
                if (totallength <= 30000) continue;
                stm.executeBatch();
                stm.clearBatch();
            }
            stm.executeBatch();
            stm.close();
            Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.INFO, (Object)"Hauptteil ausgef\u00fchrt");
            this.execute(rest, connection, gesamt);
        }
    }

    public synchronized void execute(String query, Connection connection, SuperX_el gesamt) throws SQLException {
        SxResultSet rows = new SxResultSet();
        Statement statement = connection.createStatement();
        DatabaseMetaData dbmd = connection.getMetaData();
        statement.setMaxRows(SuperXManager.maxRows);
        String queryReplaced = SqlStringUtils.replaceInAll(query, '\'', ';', SQL_STMT_SEP_SUBST);
        Iterator st = Splitter.on((char)';').split((CharSequence)queryReplaced).iterator();
        int n = 0;
        boolean hasRuntimeMessage = false;
        while (st.hasNext()) {
            ++n;
            String sqlstmt = ((String)st.next()).trim();
            if ((sqlstmt = sqlstmt.replace(SQL_STMT_SEP_SUBST, ";")).length() < 5) continue;
            Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.ALL, (Object)("sql-Abfrage ausf\u00fchren:" + sqlstmt));
            try {
                if (statement.execute(sqlstmt)) {
                    int column;
                    ResultSet resultSet = statement.getResultSet();
                    this.metaData = resultSet.getMetaData();
                    this.numberOfColumns = this.metaData.getColumnCount();
                    String[] columnNames = new String[this.numberOfColumns];
                    String[] columnLabel = new String[this.numberOfColumns];
                    int[] columnDisplaySize = new int[this.numberOfColumns];
                    int[] columnType = new int[this.numberOfColumns];
                    int[] Scale = new int[this.numberOfColumns];
                    boolean[] isWritable = new boolean[this.numberOfColumns];
                    for (column = 0; column < this.numberOfColumns; ++column) {
                        columnNames[column] = this.metaData.getColumnName(column + 1);
                        if (!columnNames[column].equalsIgnoreCase("_runtimeMessage")) continue;
                        hasRuntimeMessage = true;
                    }
                    for (column = 0; column < this.numberOfColumns; ++column) {
                        columnLabel[column] = this.metaData.getColumnLabel(column + 1);
                    }
                    for (column = 0; column < this.numberOfColumns; ++column) {
                        columnDisplaySize[column] = this.metaData.getColumnDisplaySize(column + 1);
                    }
                    for (column = 0; column < this.numberOfColumns; ++column) {
                        columnType[column] = this.adaptColumType(this.metaData.getColumnType(column + 1));
                    }
                    for (column = 0; column < this.numberOfColumns; ++column) {
                        Scale[column] = this.metaData.getScale(column + 1);
                    }
                    for (column = 0; column < this.numberOfColumns; ++column) {
                        isWritable[column] = this.metaData.isWritable(column + 1);
                    }
                    int naturalOrderNo = 1;
                    while (resultSet.next()) {
                        if (hasRuntimeMessage) {
                            gesamt.setRuntimeMessage(resultSet.getString(1));
                            continue;
                        }
                        SxResultRow newRow = this.addRow(naturalOrderNo++, resultSet, columnNames);
                        rows.add(newRow);
                    }
                    gesamt.setColumnCount(this.numberOfColumns);
                    if (dbmd.getDatabaseProductName().equals("H2")) {
                        gesamt.setAndAdaptColumnNames(columnLabel);
                    } else {
                        gesamt.setAndAdaptColumnNames(columnNames);
                    }
                    gesamt.setColumnLabels(columnLabel);
                    gesamt.setColumnDisplaySizes(columnDisplaySize);
                    gesamt.setColumnTypes(columnType);
                    gesamt.setScales(Scale);
                    gesamt.setisWritable(isWritable);
                    gesamt.setRows(rows);
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    this.updateCount = -1;
                } else {
                    this.updateCount = statement.getUpdateCount();
                }
            }
            catch (SQLException e) {
                Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.INFO, (Object)e.toString());
                gesamt.setError_String(e.toString());
            }
            catch (Exception e) {
                Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.INFO, (Object)("Allgemeiner Fehler beim DB-Zugriff:" + e.toString()));
                gesamt.setError_String(e.toString());
            }
            gesamt.setUpdateCount(this.updateCount);
        }
        if (statement != null) {
            statement.close();
        }
    }

    private SxResultRow addRow(int naturalOrderNo, ResultSet resultSet, String[] columnNames) throws SQLException {
        SxResultRow newRow = SxResultRow.createInstance(this.metaData, this.numberOfColumns, naturalOrderNo, resultSet, columnNames, this.mandantenID);
        return newRow;
    }

    public void cancel() throws Exception {
        try {
            System.err.println("SxSQL: Cancel statement");
        }
        catch (Exception e) {
            System.err.println("SxSQL: Error canceling statement: " + e);
        }
        throw new UnsupportedOperationException("");
    }

    public void cancel(String url, String user, String passwd) throws Exception {
        try {
            System.err.println("SxSQL: Cancel statement");
        }
        catch (Exception e) {
            System.err.println("SxSQL: Error canceling statement: " + e);
        }
        throw new UnsupportedOperationException("cancel");
    }

    public int adaptColumType(int rsColType) {
        return switch (rsColType) {
            case -6, -5, 4, 5 -> 4;
            case 16 -> -7;
            case 2, 3, 6, 7, 8 -> 3;
            case 91 -> 6;
            case 93 -> 8;
            case 92 -> 9;
            default -> 1;
        };
    }
}

