/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import com.zaxxer.hikari.HikariDataSource;
import de.memtext.baseobjects.NamedObjectI;
import de.memtext.baseobjects.coll.IdObjectCollection;
import de.memtext.baseobjects.coll.NamedIdObjectSet;
import de.memtext.baseobjects.coll.NamedObjectList;
import de.memtext.baseobjects.coll.NamedObjectSet;
import de.memtext.rights.NewPasswordChecker;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.DSAHandler;
import de.memtext.util.DateUtils;
import de.memtext.util.LogUtils;
import de.superx.common.AbstractSicht;
import de.superx.common.DBServletException;
import de.superx.common.Field;
import de.superx.common.FieldContainer;
import de.superx.common.GraphicFormat;
import de.superx.common.MacroFieldSelection;
import de.superx.common.Maske;
import de.superx.common.OrgUnitMapping;
import de.superx.common.RepositoryItemCollection;
import de.superx.common.SichtException;
import de.superx.common.SxKontierungsrechte;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxUser;
import de.superx.common.TemplateProcessor;
import de.superx.common.TranslationContainer;
import de.superx.conf.InitStatus;
import de.superx.servlet.ExternalPool;
import de.superx.servlet.FieldElementCache;
import de.superx.servlet.ServletTemplateProcessor;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SichtartRechteDefinition;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SuperXmlAnmeldung;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import de.superx.spring.batch.His1DataSources;
import de.superx.spring.config.BatchConfig;
import de.superx.util.PropsReader;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SxPool
extends GenericObjectPool
implements NamedObjectI {
    private String name;
    private int finRightVariant = 0;
    private NamedObjectList sichtartRechteDefinitionen = new NamedObjectList();
    private boolean isErweitertesProtokollWanted = false;
    private int passwortG\u00fcltigkeit = 0;
    private Properties props = new Properties();
    private FieldElementCache fieldElementCache = new FieldElementCache();
    private IdObjectCollection graphicformats = new IdObjectCollection();
    private IdObjectCollection translations = new IdObjectCollection();
    private Collection makroFieldSelections = new LinkedList();
    public NamedIdObjectSet userpool = new NamedIdObjectSet();
    private NamedIdObjectSet maskenpool = new NamedIdObjectSet();
    private ServletTemplateProcessor templateProcessor;
    private HashMap repositoryMap = new HashMap();
    private String privateKeyEncoded = null;
    private String publicKeyEncoded = null;
    private boolean isRestrictedConnection = false;
    private DSAHandler dsaHandler;
    private NewPasswordChecker newPasswordChecker;
    private boolean hasImplicitOrgUnitRightsTable = false;
    private boolean is0FINJoker = true;
    private boolean hasKontierungsrechte = false;
    private String excelVorlage;
    private boolean hasCustomPdfFile = false;
    private NamedObjectSet externalPools = new NamedObjectSet();
    private boolean hasFinUserKamRestrictionFields = false;
    private Map<String, OrgUnitMapping> orgUnitMappings = new HashMap<String, OrgUnitMapping>();
    private static Logger logger = LoggerFactory.getLogger(SxPool.class);
    private DataSource eduetlDataSource;
    private String databaseAbbrevation;

    public boolean hasFinUserKamRestrictionFields() {
        return this.hasFinUserKamRestrictionFields;
    }

    SxPool(String name, Properties dbProperties) throws SQLException, IOException, DBServletException {
        this.setName(name);
        this.initProperties(dbProperties);
        this.initLogging(true, Level.ERROR);
        this.templateProcessor = new ServletTemplateProcessor(name);
        if (SxSQL_Server.DEFAULT_MANDANTEN_ID.equals(name) || "test".equals(name)) {
            this.initHikariPool();
        } else {
            this.configureDbcp();
        }
        this.initDbcpPoolingDriver();
        try {
            this.setDatabaseAbbreviation();
            this.initFromDB();
        }
        catch (SQLException e) {
            Object msg = "Fehler beim Aufbau des ConnectionPools ";
            if (!this.getName().equals(SxSQL_Server.DEFAULT_MANDANTEN_ID)) {
                msg = (String)msg + " f\u00fcr Mandant: " + this.getName();
            }
            msg = (String)msg + "\nKonnte keine Connection aus dem Pool holen.DETAILS:\n" + e;
            e.printStackTrace();
            throw new SQLException((String)msg);
        }
        if (this.privateKeyEncoded != null) {
            this.initDSAHandler();
        }
    }

    SxPool(String name, DataSource dataSource) throws SecurityException, IOException, SQLException, DBServletException {
        this.setName(name);
        this.initLogging(true, Level.DEBUG);
        this.templateProcessor = new ServletTemplateProcessor(name);
        this.eduetlDataSource = dataSource;
        try {
            this.setDatabaseAbbreviation();
            this.initFromDB();
        }
        catch (SQLException e) {
            Object msg = "Fehler beim Aufbau des ConnectionPools ";
            if (!this.getName().equals(SxSQL_Server.DEFAULT_MANDANTEN_ID)) {
                msg = (String)msg + " f\u00fcr Mandant: " + this.getName();
            }
            msg = (String)msg + "\nKonnte keine Connection aus dem Pool holen.DETAILS:\n" + e;
            e.printStackTrace();
            throw new SQLException((String)msg);
        }
        if (this.privateKeyEncoded != null) {
            this.initDSAHandler();
        }
    }

    public String getConnectionUrl() {
        if (this.props == null) {
            throw new IllegalStateException("Noch keine Properties eingelesen!");
        }
        return this.props.getProperty("connectionURL");
    }

    private void setKernMaskHtmlXsl(Statement st) throws SQLException {
        int count = 0;
        ResultSet rs = st.executeQuery("select count(*) from konstanten where beschreibung='KernMaskHtmlXsl' ");
        while (rs.next()) {
            count = rs.getInt(1);
        }
        rs.close();
        if (count == 0) {
            rs = st.executeQuery("select max(tid) from konstanten");
            int newtid = 999;
            while (rs.next()) {
                newtid = rs.getInt(1);
            }
            rs.close();
            st.executeUpdate("insert into konstanten (tid,beschreibung,apnr) values (" + ++newtid + ", 'KernMaskHtmlXsl',0)");
        }
        int tablehtml = 1;
        if (!SuperXManager.defaultMaskXsl.equals("maske_html.xsl")) {
            tablehtml = 2;
        }
        st.executeUpdate("update konstanten set apnr=" + tablehtml + " where beschreibung='KernMaskHtmlXsl' ");
    }

    private Optional<Throwable> initHeaderFooterDB() {
        try (Connection con = this.getConnection();
             Statement stmt = con.createStatement();){
            ResultSet rs = stmt.executeQuery("select id from sx_repository where art='HEADER_FOOTER'");
            HashMap<String, String> ids = new HashMap<String, String>();
            while (rs.next()) {
                String id = rs.getString(1);
                ids.put(id.trim(), "found");
            }
            rs.close();
            rs = stmt.executeQuery("select max(tid) from sx_repository ");
            int tid = 0;
            while (rs.next()) {
                tid = rs.getInt(1) + 1;
            }
            try (PreparedStatement pst = this.getDatabaseAbbr().equals("PG") ? con.prepareStatement("insert into sx_repository(tid,id,caption,sachgebiete_id,art,aktiv,gueltig_seit,gueltig_bis)\tvalues (?,?,?,0,'HEADER_FOOTER',1,DATE '1900-01-01',DATE '3000-01-01')") : con.prepareStatement("insert into sx_repository(tid,id,caption,sachgebiete_id,art,aktiv,gueltig_seit,gueltig_bis)\tvalues (?,?,?,0,'HEADER_FOOTER',1,DATE '1900-01-01',DATE '3000-01-01')");){
                if (!ids.containsKey("HTML_HEADER")) {
                    pst.setInt(1, tid++);
                    pst.setString(2, "HTML_HEADER");
                    pst.setString(3, "HTML Kopfzeile");
                    pst.execute();
                }
                if (!ids.containsKey("HTML_FOOTER")) {
                    pst.setInt(1, tid++);
                    pst.setString(2, "HTML_FOOTER");
                    pst.setString(3, "HTML Fu\u00dfzeile");
                    pst.execute();
                }
                if (!ids.containsKey("CUSTOM_PDF")) {
                    pst.setInt(1, tid++);
                    pst.setString(2, "CUSTOM_PDF");
                    pst.setString(3, "individuelle PDF Anpassung");
                    pst.execute();
                }
            }
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    private void initFromDB() throws SQLException {
        try (Connection con = this.getConnection();
             Statement st = con.createStatement();){
            this.setKernMaskHtmlXsl(st);
            ResultSet rs = st.executeQuery("select content from sx_repository where id='privatekey'");
            while (rs.next()) {
                this.privateKeyEncoded = rs.getString(1);
            }
            rs = st.executeQuery("select content from sx_repository where id='publickey'");
            while (rs.next()) {
                this.publicKeyEncoded = rs.getString(1);
            }
            rs = st.executeQuery("select apnr from konstanten where beschreibung='Passwortg\u00fcltigkeit (Tage)'");
            while (rs.next()) {
                this.passwortG\u00fcltigkeit = rs.getInt(1);
            }
            rs = st.executeQuery("select apnr from konstanten where beschreibung='Passwort Gro\u00df- u. Kleinb.'");
            int gro\u00dfklein = 0;
            while (rs.next()) {
                gro\u00dfklein = rs.getInt(1);
            }
            int ziffern\u00f6tig = 0;
            rs = st.executeQuery("select apnr from konstanten where beschreibung='Passwort erfordert Ziffer'");
            while (rs.next()) {
                ziffern\u00f6tig = rs.getInt(1);
            }
            rs = st.executeQuery("select apnr from konstanten where beschreibung='Passwortl\u00e4nge (Minimum)'");
            int minL\u00e4nge = 0;
            while (rs.next()) {
                minL\u00e4nge = rs.getInt(1);
            }
            this.newPasswordChecker = new NewPasswordChecker(minL\u00e4nge, gro\u00dfklein, ziffern\u00f6tig);
            rs = st.executeQuery("select apnr from konstanten where beschreibung='Erweitertes Protokoll'");
            int loginP = 0;
            while (rs.next()) {
                loginP = rs.getInt(1);
            }
            this.isErweitertesProtokollWanted = loginP == 1;
        }
    }

    public int getPasswortG\u00fcltigkeit() {
        return this.passwortG\u00fcltigkeit;
    }

    public boolean isErweitertesProtokollWanted() {
        return this.isErweitertesProtokollWanted;
    }

    public void initLogging(boolean append, Level defaultLevel) throws SecurityException, IOException {
        String loggerSqlName = String.format("superx_%s", this.getName());
        String loggerXmlName = String.format("superx_%s_xml", this.getName());
        String fileNameSql = String.format("%s/superx_%s.log", SxPool.getLogDir(), this.name);
        String fileNameXml = String.format("%s/superx_%s_xml.log", SxPool.getLogDir(), this.name);
        LogUtils.initRawFile(loggerSqlName, fileNameSql, 20000, 1, append, true);
        LogUtils.initRawFile(loggerXmlName, fileNameXml, 20000, 1, append, true);
        this.setLoggingLevel(loggerSqlName, "logLevelSQL", defaultLevel);
        this.setLoggingLevel(loggerXmlName, "logLevelXML", defaultLevel);
    }

    private void setLoggingLevel(String loggerName, String propertyName, Level defaultLevel) {
        Level dbPropsLevel = null;
        try {
            if (this.props.getProperty(propertyName) != null) {
                dbPropsLevel = Level.toLevel((String)this.props.getProperty(propertyName));
            }
        }
        catch (IllegalArgumentException e) {
            String msg = "Ung\u00fcltiger Level f\u00fcr Logger " + loggerName;
            if (!this.getName().equals(SxSQL_Server.DEFAULT_MANDANTEN_ID)) {
                msg = msg + "(Mandant :" + this.getName() + ") ";
            }
            msg = msg + " :" + this.props.getProperty(propertyName);
            logger.info(msg);
        }
        org.apache.log4j.Logger aLogger = org.apache.log4j.Logger.getLogger((String)loggerName);
        aLogger.setLevel(dbPropsLevel != null ? dbPropsLevel : defaultLevel);
        aLogger.setAdditivity(false);
        logger.info("\nLoglevel " + logger + ": " + org.apache.log4j.Logger.getLogger((String)loggerName).getLevel());
    }

    public static String getLogDir() {
        Object targetDir = SuperXManager.getWEB_INFPfad() + File.separator + "logs";
        File f = new File((String)targetDir);
        if (!f.exists()) {
            f.mkdir();
        }
        if (System.getProperty("SX_LOG_TO_TMP") != null && System.getProperty("SX_LOG_TO_TMP").equalsIgnoreCase("true")) {
            targetDir = System.getProperty("java.io.tmpdir");
        }
        return targetDir;
    }

    private void readPropertiesAndUrl() throws Exception {
        this.props = PropsReader.prepareProps(new File(this.getDbPropertyFilePath()));
    }

    private String getDbPropertyFilePath() {
        Object propname = "db_" + this.getName() + ".properties";
        if (this.getName().equals(SxSQL_Server.DEFAULT_MANDANTEN_ID)) {
            propname = "db.properties";
        }
        return SuperXManager.getWEB_INFPfad() + File.separator + (String)propname;
    }

    private void checkRestrictedConnection() throws Exception {
        if (this.props.getProperty("restrictedConnectionName") != null && !this.props.getProperty("restrictedConnectionName").trim().equals("") && this.props.getProperty("restrictedConnectionPassword") != null && !this.props.getProperty("restrictedConnectionPassword").trim().equals("")) {
            this.props.put("user", this.props.getProperty("restrictedConnectionName"));
            this.props.put("password", PropsReader.check(this.props.getProperty("restrictedConnectionPassword")));
            this.isRestrictedConnection = true;
        } else {
            String user = this.props.getProperty("connectionName");
            String passw = this.props.getProperty("connectionPassword");
            if (user != null) {
                this.props.put("user", user);
            } else {
                logger.warn("No property connectionName!");
            }
            if (passw != null) {
                this.props.put("password", PropsReader.check(passw));
            } else {
                logger.warn("No property connectionPassword!");
            }
        }
    }

    public String getSqlDialect() {
        if ("PG".equals(this.databaseAbbrevation)) {
            return "Postgres";
        }
        return "Informix";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void close() throws SQLException {
        if (this.eduetlDataSource == null) {
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
            driver.closePool(this.getName());
        }
        this.closeLoggers();
    }

    private void closeLogger(String loggername) {
        Enumeration appenders = org.apache.log4j.Logger.getLogger((String)loggername).getAllAppenders();
        Iterator it = appenders.asIterator();
        while (it.hasNext()) {
            ((Appender)it.next()).close();
        }
    }

    private void closeLoggers() {
        String loggerSqlName = String.format("superx_%s", this.getName());
        String loggerXmlName = String.format("superx_%s_xml", this.getName());
        this.closeLogger(loggerSqlName);
        this.closeLogger(loggerXmlName);
    }

    public Connection getConnection() throws SQLException {
        if (this.eduetlDataSource != null) {
            Connection con = this.eduetlDataSource.getConnection();
            return con;
        }
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:" + this.getName());
    }

    public DataSource getDataSource() {
        return this.eduetlDataSource;
    }

    public Object borrowObject() throws Exception {
        Object obj = super.borrowObject();
        return obj;
    }

    public void returnObject(Object obj) throws Exception {
        super.returnObject(obj);
    }

    public boolean hasMaske(Integer tid) {
        return this.maskenpool.containsItemWithId(tid);
    }

    public Maske getMaskenclone(Integer tid) throws CloneNotSupportedException {
        return (Maske)((Maske)this.maskenpool.getById(tid)).clone();
    }

    private Optional<Throwable> initTranslations() {
        try {
            this.translations = new IdObjectCollection();
            SxResultSet rs = ServletUtils.execute("Einlesen von \u00dcbersetzungen", "select id,locale,contents_short,contents_long from sx_captions where id is not null", this.getName());
            for (SxResultRow row : rs) {
                Object id = row.get(0);
                String loc = (String)row.get(1);
                String contentsShort = SqlStringUtils.getValueAsString(row.get(2));
                String contentsLong = SqlStringUtils.getValueAsString(row.get(3));
                if (!this.translations.containsItemWithId(id)) {
                    this.translations.add(new TranslationContainer(this.getName(), id, loc, contentsShort, contentsLong));
                    continue;
                }
                TranslationContainer tc = (TranslationContainer)this.translations.getById(id);
                tc.addLocalizedItem(loc, contentsShort, contentsLong);
            }
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public synchronized Optional<Throwable> initRepository() {
        try {
            this.repositoryMap = this.readRepository();
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public HashMap readRepository() throws SQLException, DBServletException {
        HashMap result = new HashMap();
        SxResultSet rs = ServletUtils.execute("Einlesen von Sx_repository Eintr\u00e4gen", "select trim(both from id) as id,caption,content,gueltig_seit,gueltig_bis,comment,sort1,sort2,sort3 from sx_repository where aktiv=1", this.getName());
        TemplateProcessor.repositoryToMap(rs, result);
        rs = ServletUtils.execute("Einlesen von hochschulinfo f\u00fcr repository", "select name,adresse,hs_nr,kapitel from hochschulinfo", this.getName());
        for (SxResultRow zeile : rs) {
            result.put("K_Name", zeile.get(0));
            result.put("K_Adresse", zeile.get(1));
            result.put("K_hs_nr", zeile.get(2));
            result.put("K_Kapitel", zeile.get(3));
        }
        rs = ServletUtils.execute("Einlesen von konstanten f\u00fcr repository", "select trim(beschreibung),apnr from konstanten", this.getName());
        for (SxResultRow row : rs) {
            String beschreibung = (String)row.get(0);
            result.put("K_" + beschreibung, row.get(1));
        }
        return result;
    }

    public String localize(StringBuffer text, Locale l) {
        return this.localize(text.toString(), l);
    }

    public String localize(String text, Locale l) {
        String result = text;
        for (TranslationContainer tc : this.translations) {
            StringBuffer longVersion = new StringBuffer().append("@@@").append(tc.getId()).append("@@@");
            StringBuffer shortVersion = new StringBuffer().append("@@").append(tc.getId()).append("@@");
            result = StringUtils.replace((String)result, (String)longVersion.toString(), (String)tc.getContentsLong(l));
            result = StringUtils.replace((String)result, (String)shortVersion.toString(), (String)tc.getContentsShort(l));
        }
        result = result.replaceAll("@@@doku_\\d*_mask@@@", "");
        return result.replaceAll("_HISINONE_", SuperXManager.his1_refapp);
    }

    public String getTranslationShort(String id, Locale l) {
        String result = "";
        if (this.translations.containsItemWithId(id)) {
            TranslationContainer tc = (TranslationContainer)this.translations.getById(id);
            result = tc.getContentsShort(l);
        }
        return result;
    }

    private Optional<Throwable> initGraphicsFormats() {
        try {
            SxResultSet rs = ServletUtils.execute("Einlesen von Grafikformaten", "select id,charttype,caption,width,height,captionx,captiony,linex,liney,showvalues,moreattribs from graphicformat", this.getName());
            this.graphicformats.clear();
            for (SxResultRow row : rs) {
                this.graphicformats.add(new GraphicFormat(row));
            }
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    private Optional<Throwable> initMacroFieldSelections() {
        try {
            SxResultSet makroFieldRs = ServletUtils.execute("Einlesen von speziellen Auswahlwerten f\u00fcr makros aus macro_feld_wert", "select macro,sortnr,feldname,value,feldsicht from macro_feld_wert where active=1", this.getName());
            this.makroFieldSelections.clear();
            for (SxResultRow aRow : makroFieldRs) {
                MacroFieldSelection m = new MacroFieldSelection(aRow);
                if (m.getWert() != null && m.getWert().startsWith("<<SQL>>")) {
                    SxResultSet result = ServletUtils.execute("Wert f\u00fcr hinterlegten makro_feld_wert " + m.getMakroid() + ", sortnr " + m.getSortnr() + " holen", m.getWert().substring(7), this.getName());
                    if (result.size() == 0) {
                        throw new IllegalArgumentException("Kein Makro_feld_wert f\u00fcr makro " + m.getMakroid() + " sortnr " + m.getSortnr() + " per " + m.getWert() + " gefunden.");
                    }
                    SxResultRow row = (SxResultRow)result.first();
                    Object o = row.get(0);
                    if (o == null) {
                        throw new IllegalArgumentException("Makro_feld_wert f\u00fcr makro " + m.getMakroid() + " sortnr " + m.getSortnr() + " darf nicht null sein.");
                    }
                    m.setWert(o.toString());
                }
                this.makroFieldSelections.add(m);
            }
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public boolean hasMakroFieldSelection(Object makroid, Integer sortNr) {
        boolean result = false;
        for (MacroFieldSelection makroFieldSelection : this.makroFieldSelections) {
            if (!makroFieldSelection.getMakroid().toString().equals(makroid.toString()) || !makroFieldSelection.getSortnr().equals(sortNr)) continue;
            result = true;
            break;
        }
        return result;
    }

    public void applyMacroFieldSelectionTo(Object makroid, Maske maske, Hashtable formular, HashMap map, FieldContainer fc, SxUser user) {
        for (MacroFieldSelection makroFieldSelection : this.makroFieldSelections) {
            Field f;
            if (!makroFieldSelection.getMakroid().toString().equals(makroid.toString()) || !makroFieldSelection.getSortnr().equals(maske.getSortNr())) continue;
            SuperXManager.logActivity(Level.DEBUG, "Setze speziellen Auswahlwert           ein f\u00fcr Makro " + makroid + " Submaske: " + maske.getName() + "          sortnr=" + makroFieldSelection.getSortnr() + "          Feld:" + makroFieldSelection.getFeldername() + "          Wert:" + makroFieldSelection.getWert() + "     Sicht:" + makroFieldSelection.getFeldsicht());
            try {
                if (makroFieldSelection.getFeldsicht() != null && !makroFieldSelection.getFeldsicht().equals("")) {
                    f = maske.getField(makroFieldSelection.getFeldername());
                    SxResultSet rs = ServletUtils.execute("Suchen der Sicht mit name_intern=" + makroFieldSelection.getFeldsicht(), "select tid from sichten where name_intern='" + makroFieldSelection.getFeldsicht() + "'", this.getName());
                    Integer sichttid = -1;
                    for (SxResultRow row : rs) {
                        sichttid = (Integer)row.get(0);
                    }
                    if (sichttid == null || sichttid == -1) {
                        throw new IllegalArgumentException("F\u00fcr Makro " + makroid + " Feld:" + makroFieldSelection.getFeldername() + " Sortnr:" + makroFieldSelection.getSortnr() + " wurde eine Sicht mit name_intern=" + makroFieldSelection.getFeldsicht() + " angegeben, die nicht gefunden wurde");
                    }
                    f.setSicht(formular, map, fc, sichttid, user);
                    f.setMacroMaskenSichtSet(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("F\u00fcr Makro " + makroid + " Feld:" + makroFieldSelection.getFeldername() + " Sortnr:" + makroFieldSelection.getSortnr() + " konnte eine Sicht mit name_intern=" + makroFieldSelection.getFeldsicht() + " nicht gesetzt werden");
            }
            try {
                if (makroFieldSelection.getWert() == null || makroFieldSelection.getWert().equals("")) continue;
                f = maske.getField(makroFieldSelection.getFeldername());
                f.initIfNeeded(formular, map, fc, user);
                maske.setSpecialFieldSelection(makroFieldSelection.getFeldername(), makroFieldSelection.getWert());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Konnte f\u00fcr Maske " + maske.getName() + " (" + maske.getId() + ") den gew\u00fcnschten Wert :\"" + makroFieldSelection.getWert() + "\" f\u00fcr das Feld " + makroFieldSelection.getFeldername() + " nicht eintragen.\n" + e);
            }
        }
    }

    public void init() {
        try {
            SuperXmlAnmeldung.waitForPoolInit = true;
            InitStatus.setStatus(InitStatus.SubSystem.OrgunitMapping, this.initOrgUnitMapping());
            InitStatus.setStatus(InitStatus.SubSystem.SichtartRechteDefinition, this.initSichtartRechteDefinition());
            InitStatus.setStatus(InitStatus.SubSystem.FinRights, this.initFinRights());
            InitStatus.setStatus(InitStatus.SubSystem.FMTemplates, this.initFMTemplates());
            InitStatus.setStatus(InitStatus.SubSystem.Repository, this.initRepository());
            InitStatus.setStatus(InitStatus.SubSystem.Translations, this.initTranslations());
            InitStatus.setStatus(InitStatus.SubSystem.HeaderFooterDB, this.initHeaderFooterDB());
            InitStatus.setStatus(InitStatus.SubSystem.MacroFieldSelections, this.initMacroFieldSelections());
            InitStatus.setStatus(InitStatus.SubSystem.GraphicsFormats, this.initGraphicsFormats());
            InitStatus.setStatus(InitStatus.SubSystem.FieldElementCache, this.initFieldElementCache());
            InitStatus.setStatus(InitStatus.SubSystem.ExcelTemplate, this.initExcelTemplate());
            InitStatus.setStatus(InitStatus.SubSystem.ExternalPools, this.initExternalPools());
            InitStatus.setStatus(InitStatus.SubSystem.HasKontierungsRechte, this.initHasKontierungsrechte());
            InitStatus.setStatus(InitStatus.SubSystem.HasImplicitOrgunitsRightTable, this.inithasImplicitOrgUnitRightsTable());
            InitStatus.setStatus(InitStatus.SubSystem.JasperReports, this.initJasper());
        }
        finally {
            SuperXmlAnmeldung.waitForPoolInit = false;
        }
    }

    private Optional<Throwable> initJasper() {
        boolean useJaxen = true;
        try (Connection dbConnection = SxPools.getConnection(this.getName());
             Statement stm = dbConnection.createStatement();
             ResultSet rs = stm.executeQuery("select count(*) from konstanten where beschreibung='KERN_JASPER_USE_JAXEN' and apnr=0");){
            while (rs.next()) {
                if (rs.getInt(1) == 0) continue;
                useJaxen = false;
            }
            org.apache.log4j.Logger.getLogger((String)("superx_" + this.getName())).log((Priority)Level.DEBUG, (Object)("Inited " + this.orgUnitMappings.size() + " OrgUnitMappings for LiveMapping"));
        }
        catch (Exception e) {
            org.apache.log4j.Logger.getLogger((String)("superx_" + this.getName())).log((Priority)Level.ERROR, (Object)e.toString());
            return Optional.of(e);
        }
        org.apache.log4j.Logger.getLogger((String)("superx_" + this.getName())).info((Object)("JASPER Jaxen Nutzung steht auf " + useJaxen));
        if (useJaxen) {
            DefaultJasperReportsContext context = DefaultJasperReportsContext.getInstance();
            JRPropertiesUtil.getInstance((JasperReportsContext)context).setProperty("net.sf.jasperreports.xpath.executer.factory", "net.sf.jasperreports.engine.util.xml.JaxenXPathExecuterFactory");
        }
        return Optional.empty();
    }

    private Optional<Throwable> inithasImplicitOrgUnitRightsTable() {
        try (Connection dbConnection = SxPools.getConnection(this.getName());){
            DatabaseMetaData md = dbConnection.getMetaData();
            String[] types = new String[]{"TABLE"};
            try (ResultSet rs = md.getTables(null, null, "implicit_orgunit_rights", types);){
                if (rs.next()) {
                    this.hasImplicitOrgUnitRightsTable = true;
                }
            }
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public boolean hasImplicitOrgUnitRightsTable() {
        return this.hasImplicitOrgUnitRightsTable;
    }

    private Optional<Throwable> initOrgUnitMapping() {
        try (Connection dbConnection = SxPools.getConnection(this.getName());
             Statement stm = dbConnection.createStatement();
             ResultSet rs = stm.executeQuery("select apnr,mapped_id,uniquename from orgunit_mapping");){
            this.orgUnitMappings.clear();
            while (rs.next()) {
                String id = rs.getString("apnr");
                OrgUnitMapping oum = this.orgUnitMappings.get(id);
                if (oum == null) {
                    oum = new OrgUnitMapping(id);
                    this.orgUnitMappings.put(id, oum);
                }
                oum.setUniquename(rs.getString("uniquename"));
                oum.addMappedId(rs.getString("mapped_id"));
            }
            org.apache.log4j.Logger.getLogger((String)("superx_" + this.getName())).log((Priority)Level.DEBUG, (Object)("Inited " + this.orgUnitMappings.size() + " OrgUnitMappings for LiveMapping"));
        }
        catch (Exception e) {
            org.apache.log4j.Logger.getLogger((String)("superx_" + this.getName())).log((Priority)Level.ERROR, (Object)e.toString());
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public Map<String, OrgUnitMapping> getOrgUnitMappings() {
        return this.orgUnitMappings;
    }

    private void updateHisInOneConfig() throws SQLException {
        int hisinone_active = SuperXManager.his1_refapp.equals("") ? 0 : 1;
        Connection con = this.getConnection();
        Statement st = con.createStatement();
        this.updateHisIneOrganigrammQuelle(st, hisinone_active);
        st.close();
        con.close();
    }

    private void updateHisInOneActive(Statement st, int hisinone_active) throws SQLException {
        this.getKonstantenAPNR(st, "HisInOne_aktiv", true);
        st.executeUpdate("update konstanten set apnr=" + hisinone_active + ",read_only=1 where beschreibung='HisInOne_aktiv'");
    }

    private void updateHisIneOrganigrammQuelle(Statement st, int hisinone_active) throws SQLException {
        int quelle_mbs;
        this.getKonstantenAPNR(st, "Organigrammquelle", true);
        int quelle_cob = this.getKonstantenAPNR(st, "Organigramm_aus_COB", false);
        if (quelle_cob == 1) {
            st.executeUpdate("udpate konstanten set apnr=10,read_only=0 where beschreibung='Organigrammquelle'");
        }
        if ((quelle_mbs = this.getKonstantenAPNR(st, "Organigramm_aus_MBS", false)) == 1) {
            st.executeUpdate("update konstanten set apnr=3,read_only=0 where beschreibung='Organigrammquelle'");
        }
        st.executeUpdate("delete from konstanten where beschreibung='Organigramm_aus_COB'");
        st.executeUpdate("delete from konstanten where beschreibung='Organigramm_aus_MBS'");
    }

    private int getKonstantenAPNR(Statement st, String konstante, boolean createIfNotFound) throws SQLException {
        ResultSet rs;
        if (createIfNotFound) {
            rs = st.executeQuery("select count(*) from konstanten where beschreibung='" + konstante + "'");
            int konstante_gefunden = 0;
            while (rs.next()) {
                konstante_gefunden = rs.getInt(1);
            }
            rs.close();
            if (konstante_gefunden == 0) {
                rs = st.executeQuery("select max(tid) from konstanten");
                int maxtid = 0;
                while (rs.next()) {
                    maxtid = rs.getInt(1);
                }
                rs.close();
                st.executeUpdate("insert into konstanten (tid,beschreibung,apnr) values (" + ++maxtid + ",'" + konstante + "',-1)");
                if (this.getDatabaseAbbr().equals("PG")) {
                    st.executeQuery("select sp_update_sequence('konstanten')");
                }
            }
        }
        int apnr = -1;
        rs = st.executeQuery("select apnr from konstanten where beschreibung='" + konstante + "'");
        while (rs.next()) {
            apnr = rs.getInt(1);
        }
        return apnr;
    }

    public boolean hasKontierungsrechte() {
        return this.hasKontierungsrechte;
    }

    private Optional<Throwable> initHasKontierungsrechte() {
        try (Connection dbConnection = SxPools.getConnection(this.getName());){
            this.hasKontierungsrechte = false;
            boolean isErweitert = false;
            DatabaseMetaData md = dbConnection.getMetaData();
            try (ResultSet rs = md.getColumns(null, null, "gxstage_user_rights", null);){
                while (rs.next()) {
                    this.hasKontierungsrechte = true;
                    if (!rs.getString("COLUMN_NAME").equalsIgnoreCase("status")) continue;
                    isErweitert = true;
                }
                if (this.hasKontierungsrechte) {
                    org.apache.log4j.Logger.getLogger((String)("superx_" + this.getName())).info((Object)("Spezielle SAP-Finanzkontierungsrechte (gxstage_user_rights) " + (isErweitert ? " inkl. Status" : "ohne Status") + "gefunden"));
                    SxKontierungsrechte.initReadingSQL(isErweitert);
                } else {
                    org.apache.log4j.Logger.getLogger((String)("superx_" + this.getName())).info((Object)"Keine Spezielle SAP-Finanzkontierungsrechte (gxstage_user_rights) gefunden");
                }
            }
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    private Optional<Throwable> initExcelTemplate() {
        try {
            File customPdfFile;
            File f;
            String pfad = SuperXManager.getWEB_INFPfad() + File.separator + ".." + File.separator + this.getName() + File.separator + "custom";
            File excelVorlageFile = new File(pfad + File.separator + "vorlage.xlsx");
            if (excelVorlageFile.exists()) {
                this.excelVorlage = excelVorlageFile.getAbsolutePath();
            }
            if (!(f = new File(pfad)).exists()) {
                f.mkdirs();
            }
            if ((customPdfFile = new File(pfad + File.separator + "custom_pdf.xsl")).exists()) {
                customPdfFile.delete();
            }
            if (this.repositoryMap.get("CUSTOM_PDF") != null && !((RepositoryItemCollection)this.repositoryMap.get("CUSTOM_PDF")).getContent().equals("")) {
                FileUtils.writeStringToFile((File)customPdfFile, (String)((RepositoryItemCollection)this.repositoryMap.get("CUSTOM_PDF")).getContent());
            }
            this.hasCustomPdfFile = customPdfFile.exists();
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public boolean hasCustomPDFFile() {
        return this.hasCustomPdfFile;
    }

    private Optional<Throwable> initFieldElementCache() {
        block21: {
            try {
                SxResultSet rs;
                this.fieldElementCache.init();
                if (SuperXManager.isSichtenCachingWanted) {
                    logger.info("  Caching von Sichten mit statischem SQL (Mandant:" + this.getName() + ")...");
                    rs = null;
                    try {
                        rs = ServletUtils.execute("potentielle zu cachende Sichtenquellen lesen", "select name_intern,art,quelle,cacheapplet,cachexml from sichten where tid>10 and type!=20 and aktiv=1 and (length(quelle) > 7 and substring(quelle from 7 for (length(quelle)-7)) not like '%<<%')  and quelle not like '%${%' and quelle not like '%--freemarker%' and quelle not like '%<@%'", this.getName());
                    }
                    catch (Exception e) {
                        logger.error("Error beim Einlesen potentielle zu cachende Sichtenquellen " + e);
                    }
                    if (rs != null) {
                        for (SxResultRow row : rs) {
                            if (!this.fieldElementCache.isSichtCachingWanted((String)row.get(2))) continue;
                            try {
                                Object sqlQuery = (String)row.get(2);
                                if (row.get(3) != null) {
                                    sqlQuery = (String)sqlQuery + " " + row.get(3);
                                }
                                if (row.get(4) != null) {
                                    sqlQuery = (String)sqlQuery + " " + row.get(4);
                                }
                                org.apache.log4j.Logger.getLogger((String)("superx_" + this.getName())).log((Priority)Level.DEBUG, (Object)(" Cache Sicht:  " + row.get(0)));
                                SxResultSet items = ServletUtils.executeALL_el(null, null, "Elemente f\u00fcr zu cachende Sicht " + row.get(0), this.fieldElementCache.generateSQL((String)sqlQuery, this.getSqlDialect()), this.getName(), false).getResultSet();
                                boolean isOrganigramm = false;
                                if (row.get(1).toString().equals("Organigramm-Sicht")) {
                                    isOrganigramm = true;
                                }
                                this.fieldElementCache.addSicht(this.getName(), (String)row.get(0), items, isOrganigramm);
                            }
                            catch (Exception e) {
                                org.apache.log4j.Logger.getLogger((String)("superx_" + this.getName())).log((Priority)Level.INFO, (Object)("Problem bei Caching der Sicht " + row.get(0) + " " + e));
                            }
                        }
                    }
                    logger.info("OK");
                } else {
                    logger.info("Caching von Sichten mit statischem SQL deaktiviert");
                }
                if (SuperXManager.field1Cache == null || SuperXManager.field1Cache.equals("")) {
                    logger.info("  kein Feldart 1-caching aktiviert");
                    break block21;
                }
                logger.info("  Feldart 1-caching (" + SuperXManager.field1Cache + ")...");
                rs = null;
                try {
                    rs = ServletUtils.execute("potentielle zu cachende Felderquellen lesen", "select relation from felderinfo where " + SuperXManager.field1Cache + " and art=1 and substring(relation from 7 for (length(relation)-7)) not like '%<<%' and relation not like '%${%' and relation not like '%--freemarker%' and relation not like '%<@%' and relation not like '%#dbid:%' and tid!=23541", this.getName());
                }
                catch (Exception e) {
                    logger.error("Error beim Einlesen potentielle zu cachende Felderquellen ", (Throwable)e);
                }
                if (rs != null) {
                    TreeSet<String> sqls = new TreeSet<String>();
                    String haushaltsjahr = DateUtils.getYear(new java.sql.Date(new Date().getTime()));
                    Hashtable<String, String> formular = new Hashtable<String, String>();
                    formular.put("Haushaltsjahr", haushaltsjahr);
                    for (SxResultRow row : rs) {
                        String sql = (String)row.get(0);
                        if (sql.trim().indexOf("<<SQL>>") == -1) continue;
                        sql = SqlStringUtils.generateSQL("PG", formular, sql);
                        if ((sql = AbstractSicht.getStrippedSQL(sql)).indexOf("<<") != -1) continue;
                        sqls.add(sql);
                    }
                    for (String sql : sqls) {
                        org.apache.log4j.Logger.getLogger((String)("superx_" + this.getName())).log((Priority)Level.DEBUG, (Object)(" Cache Feld-SQL:  " + sql));
                        try {
                            rs = ServletUtils.executeALL_el(null, null, "Felder-SQL cachen", sql, this.getName(), false).getResultSet();
                            this.fieldElementCache.add(sql, rs);
                        }
                        catch (Exception e) {
                            org.apache.log4j.Logger.getLogger((String)("superx_" + this.getName())).log((Priority)Level.INFO, (Object)("Problem bei Caching des Feld-SQLs " + sql + " " + e));
                        }
                    }
                }
                logger.info("OK");
            }
            catch (Exception e) {
                return Optional.of(e);
            }
        }
        return Optional.empty();
    }

    private Optional<Throwable> initSichtartRechteDefinition() {
        this.sichtartRechteDefinitionen.clear();
        try (Connection con = this.getConnection();){
            if (SqlStringUtils.tableExists(con, "sichtart_rechttabelle", this.getName())) {
                SxResultSet rs = ServletUtils.execute("Einlesen von sichtartRechttable (ab 4.5)", "select art,tabelle,feldname,additionalkeyssql,fallback_user_inst from sichtart_rechttabelle", this.getName());
                for (SxResultRow row : rs) {
                    String sichtart = (String)row.get(0);
                    String tabelle = (String)row.get(1);
                    String feldname = (String)row.get(2);
                    Object additionalKeys = (String)row.get(3);
                    boolean fallback_user_inst = false;
                    if (row.get(4) != null && row.get(4).toString().equals("1")) {
                        fallback_user_inst = true;
                    }
                    SichtartRechteDefinition sd = new SichtartRechteDefinition();
                    sd.setName(sichtart);
                    sd.setTabelle(tabelle);
                    sd.setFeld(feldname);
                    sd.setFallback_user_inst(fallback_user_inst);
                    if (additionalKeys != null && ((String)additionalKeys).startsWith("sp_")) {
                        additionalKeys = this.getDatabaseAbbr().equals("PG") ? "select " + (String)additionalKeys : "execute procedure " + (String)additionalKeys;
                    }
                    sd.setAdditionalKeys((String)additionalKeys);
                    this.sichtartRechteDefinitionen.add(sd);
                }
            }
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public NamedObjectList getSichtartRechteDefinitionen() {
        return this.sichtartRechteDefinitionen;
    }

    private Optional<Throwable> initExternalPools() {
        try {
            String sql = "SELECT id, \n       driver, \n       url, \n       username, \n       passwort, \n       minidle, \n       maxidle, \n       maxactive, \n       testsql \nFROM dbconnections";
            this.closeExternalPools();
            this.externalPools.clear();
            try (Connection dbConnection = SxPools.getConnection(this.getName());
                 Statement stm = dbConnection.createStatement();
                 ResultSet rs = stm.executeQuery(sql);){
                while (rs.next()) {
                    String externalid = rs.getString(1);
                    String driver = rs.getString(2);
                    String url = rs.getString(3);
                    String username = rs.getString(4);
                    String password = rs.getString(5);
                    int minidle = rs.getInt(6);
                    int maxidle = rs.getInt(7);
                    int maxactive = rs.getInt(8);
                    String testsql = rs.getString(9);
                    ExternalPool pool = new ExternalPool(this.name, this.name + "-" + externalid, driver, url, username, password, minidle, maxidle, maxactive, testsql);
                    this.externalPools.add(pool);
                }
            }
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    private void closeExternalPools() throws SQLException {
        Iterator it = this.externalPools.iterator();
        if (it.hasNext()) {
            PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
            while (it.hasNext()) {
                ExternalPool pool = (ExternalPool)it.next();
                if (!pool.isOK()) continue;
                driver.closePool(pool.getName());
            }
        }
    }

    private Optional<Throwable> initFinRights() {
        this.finRightVariant = 0;
        try (Connection dbConnection = SxPools.getConnection(this.getName());
             Statement stm = dbConnection.createStatement();){
            boolean isFinFound = false;
            DatabaseMetaData md = dbConnection.getMetaData();
            String[] types = new String[]{"TABLE"};
            try (ResultSet rs = md.getTables(null, null, "fin_user_kam", types);){
                if (rs.next()) {
                    isFinFound = true;
                    this.finRightVariant = 1;
                } else {
                    logger.info("Kein Fin-Modul gefunden (fin_user_kam)");
                }
            }
            if (isFinFound) {
                rs = md.getColumns(null, null, "fin_user_kam", null);
                try {
                    while (rs.next()) {
                        if (rs.getString(4).equals("kapitel")) {
                            this.finRightVariant = 2;
                            logger.info("erweiterte FIN_user_kam gefunden - OK");
                        }
                        if (!rs.getString(4).equals("restrict_konten")) continue;
                        this.hasFinUserKamRestrictionFields = true;
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
                int k3count = 1;
                if (this.finRightVariant == 2 && k3count > 0) {
                    this.finRightVariant = 3;
                    logger.info("erweiterte FIN_user_kam inkl. ins2/3 gefunden - OK");
                }
            }
            SxResultSet rs2 = ServletUtils.execute("", "select apnr from konstanten where beschreibung='FIN_RECHTE_0_JOKER'", this.getName());
            for (SxResultRow r : rs2) {
                logger.info(r.get(0) + " " + r.get(0).toString().equals("0"));
                if (r.get(0) == null || !r.get(0).toString().equals("0")) continue;
                this.is0FINJoker = false;
            }
            logger.info(DateUtils.getNowString() + " finrights fertig");
        }
        catch (Exception e) {
            org.apache.log4j.Logger.getLogger((String)("superx_" + this.getName())).log((Priority)Level.ERROR, (Object)e.toString());
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public boolean is0FINJoker() {
        return this.is0FINJoker;
    }

    public int getFinRightVariant() {
        return this.finRightVariant;
    }

    private void initMask(Integer tid) throws TransformerConfigurationException, TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, IOException, SQLException, DBServletException, NoMainEntryException {
        System.out.println("adding " + tid + " to Maskenpool");
        this.maskenpool.add(new Maske(this.getName(), null, tid, TranslationContainer.defaultLocale));
    }

    private Optional<Throwable> initFMTemplates() {
        try {
            SxResultSet rawFmTemplates = ServletUtils.execute("Hole allg. FreeMarker Templates aus der DB", "select trim(id),content from fm_templates", this.getName());
            this.templateProcessor.setTemplates(rawFmTemplates);
        }
        catch (Exception e) {
            return Optional.of(e);
        }
        return Optional.empty();
    }

    public GraphicFormat getGraphicFormat(String graphicFormat) {
        GraphicFormat result = null;
        Optional<Throwable> error = this.initGraphicsFormats();
        if (error.isPresent()) {
            logger.error(error.get().getMessage(), error.get());
        }
        try {
            Integer graphicFormatNr = Integer.valueOf(graphicFormat);
            result = (GraphicFormat)this.graphicformats.getById(graphicFormatNr);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Kein GraphicFormat mit id " + graphicFormat + " in der Datenbank gefunden.");
        }
        return result;
    }

    public GraphicFormat getGraphicFormat2(String graphicFormat) {
        GraphicFormat result = null;
        Optional<Throwable> error = this.initGraphicsFormats();
        if (error.isPresent()) {
            logger.error(error.get().getMessage(), error.get());
        }
        try {
            result = (GraphicFormat)this.graphicformats.getById(graphicFormat);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Kein GraphicFormat mit id " + graphicFormat + " in der Datenbank gefunden.");
        }
        return result;
    }

    public ServletTemplateProcessor getTemplateProcessor() {
        return this.templateProcessor;
    }

    public static void main(String[] args) {
    }

    public String getDatabaseAbbr() {
        return this.databaseAbbrevation;
    }

    public HashMap getRepository() {
        return this.repositoryMap;
    }

    public void clearLogFiles() throws IOException {
        this.closeLoggers();
        this.initLogging(false, Level.ERROR);
    }

    private void initDSAHandler() throws DBServletException {
        if (this.privateKeyEncoded == null) {
            throw new IllegalStateException("privatekey war null - sx_repository auf Eintrag \u00fcberpr\u00fcfen");
        }
        if (this.publicKeyEncoded == null) {
            throw new IllegalStateException("publickey war null -  sx_repository auf Eintrag pr\u00fcfen");
        }
        try {
            this.dsaHandler = new DSAHandler(this.privateKeyEncoded, this.publicKeyEncoded);
        }
        catch (Exception e) {
            throw new DBServletException(e.toString());
        }
    }

    public boolean hasDSAHandler() {
        return this.dsaHandler != null;
    }

    public boolean verifiy(String data, String signature) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureException {
        if (this.dsaHandler == null) {
            throw new IllegalStateException("DSAHandler ist null, public und private key definition pr\u00fcfen");
        }
        return this.dsaHandler.verify(data, signature);
    }

    public String getPrivateKey() {
        return this.privateKeyEncoded;
    }

    public boolean isRestrictedConnection() {
        return this.isRestrictedConnection;
    }

    public NewPasswordChecker getNewPWChecker() {
        return this.newPasswordChecker;
    }

    public FieldElementCache getFieldElementCache() {
        return this.fieldElementCache;
    }

    public String getFinRightVariantName() {
        String result = "einfach";
        if (this.finRightVariant == 2) {
            result = "erweitert ohne ins2/ins3";
        }
        if (this.finRightVariant == 3) {
            result = "erweitert inkl. ins2/3";
        }
        return result;
    }

    public String customHTMLHeaderFooter(String result) {
        if (this.repositoryMap.get("HTML_HEADER") != null && !((RepositoryItemCollection)this.repositoryMap.get("HTML_HEADER")).getContent().equals("")) {
            Pattern customheadertablePattern = Pattern.compile("<table .* id=\"customheader\".*?</table>", 32);
            Matcher action = customheadertablePattern.matcher(result);
            String newstuff = ((RepositoryItemCollection)this.repositoryMap.get("HTML_HEADER")).getContent();
            result = action.replaceAll(newstuff);
        }
        if (this.repositoryMap.get("HTML_FOOTER") != null && !((RepositoryItemCollection)this.repositoryMap.get("HTML_FOOTER")).getContent().equals("")) {
            result = StringUtils.replace((String)result, (String)"<!--customfooter-->", (String)((RepositoryItemCollection)this.repositoryMap.get("HTML_FOOTER")).getContent());
        }
        return result;
    }

    public String getExcelVorlage() {
        return this.excelVorlage;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        int version = 0;
        try (Connection con = this.getConnection();){
            version = con.getMetaData().getDatabaseMinorVersion();
        }
        return version;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        int version = 0;
        try (Connection con = this.getConnection();){
            version = con.getMetaData().getDatabaseMajorVersion();
        }
        return version;
    }

    public boolean hasExternalPool(String epName) {
        return this.externalPools.containsItemWithName(epName);
    }

    public ExternalPool getExternalPool(String epName) {
        return (ExternalPool)this.externalPools.getByName(epName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String checkImports(String input) throws SQLException {
        String result = null;
        if (input == null) return result;
        StringBuffer work = new StringBuffer(input);
        boolean importsFounds = input.indexOf("<sximport>") > -1;
        if (!importsFounds) return work.toString();
        try (Connection dbConnection = SxPools.getConnection(this.getName());
             Statement stm = dbConnection.createStatement();){
            while (work.indexOf("<sximport") > -1) {
                int posstart = work.indexOf("<sximport>");
                int posende = work.indexOf("</sximport>", posstart);
                if (posende == -1) {
                    throw new IllegalArgumentException("Tag sximport nicht ordentlich beendet");
                }
                String importInstruction = work.substring(posstart + 10, posende);
                ResultSet rs = stm.executeQuery(importInstruction);
                try {
                    boolean validReplaceText = false;
                    while (rs.next()) {
                        validReplaceText = true;
                        de.memtext.util.StringUtils.replace(work, "<sximport>" + importInstruction + "</sximport>", SqlStringUtils.getValueAsString(rs.getObject(1)));
                    }
                    rs.close();
                    if (validReplaceText) continue;
                    break;
                }
                finally {
                    if (rs == null) continue;
                    rs.close();
                }
            }
            stm.close();
            dbConnection.close();
            return work.toString();
        }
    }

    private void initProperties(Properties dbProperties) throws DBServletException, SQLException {
        try {
            if (dbProperties == null || dbProperties.isEmpty()) {
                if (new File(this.getDbPropertyFilePath()).exists()) {
                    this.readPropertiesAndUrl();
                    logger.info(" (" + this.props.getProperty("connectionURL") + ") ..");
                } else {
                    logger.warn("No dbproperties found and no explicit properties set - setting emtpy properties!");
                    this.props = new Properties();
                }
            } else {
                logger.info("Setting explicit properties");
                this.props = dbProperties;
            }
            this.checkRestrictedConnection();
        }
        catch (Exception e) {
            logger.error("Konnte db.properties nicht verarbeiten ", (Throwable)e);
            throw new DBServletException("Konnte properties / Passwort nicht lesen. " + e.getMessage());
        }
    }

    private void configureDbcp() throws DBServletException {
        try {
            Class.forName(this.props.getProperty("driverName"));
        }
        catch (ClassNotFoundException e1) {
            throw new DBServletException("Treiber " + this.props.getProperty("driverName") + " nicht gefunden. Ggfs. nach tomcat/common/lib kopieren.");
        }
        this.setTestOnBorrow(true);
        String devMode = this.props.getProperty("developmentMode");
        SuperXManager.isDevelopmentMode = devMode == null || devMode.equals("true");
        this.setMinIdle(NumberUtils.toInt((String)this.props.getProperty("minIdle"), (int)5));
        this.setMaxIdle(NumberUtils.toInt((String)this.props.getProperty("maxIdle"), (int)-1));
        this.setMaxActive(NumberUtils.toInt((String)this.props.getProperty("maxActive"), (int)-1));
        this.setMaxWait(NumberUtils.toLong((String)this.props.getProperty("maxWait"), (long)-1L));
        this.setTimeBetweenEvictionRunsMillis(NumberUtils.toInt((String)this.props.getProperty("timeBetweenEvictionRunsMillis"), (int)-1));
        DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(this.props.getProperty("connectionURL"), this.props);
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, (ObjectPool)this, null, "select count(*) from xdummy;", false, true);
        this.setFactory((PoolableObjectFactory)poolableConnectionFactory);
    }

    private void initHikariPool() {
        His1DataSources dataSources = SuperXManager.getBean("dataSources", His1DataSources.class);
        if (dataSources == null) {
            logger.warn("No Spring bean dataSources available. Will init Hikari pool standalone!");
            BatchConfig batchConfig = new BatchConfig();
            dataSources = batchConfig.dataSources();
        }
        this.eduetlDataSource = dataSources.get("eduetl");
    }

    private void initDbcpPoolingDriver() throws DBServletException, SQLException {
        try {
            Class.forName("org.apache.commons.dbcp.PoolingDriver");
        }
        catch (ClassNotFoundException e2) {
            throw new DBServletException("ConnectionPool Klasse org.apache.commons.dbcp.PoolingDriver nicht gefunden.\ncommons-dbcp nach tomcat/common/lib stellen.");
        }
        PoolingDriver driver = (PoolingDriver)DriverManager.getDriver("jdbc:apache:commons:dbcp:");
        driver.registerPool(this.getName(), (ObjectPool)this);
    }

    private void setDatabaseAbbreviation() throws SQLException {
        try (Connection con = this.getConnection();){
            String product = con.getMetaData().getDatabaseProductName();
            this.databaseAbbrevation = product.toLowerCase().contains("postgres") || product.toLowerCase().contains("h2") ? "PG" : "IDS";
        }
    }

    public void evictConnection(Connection con) {
        if (!SxSQL_Server.DEFAULT_MANDANTEN_ID.equals(this.name)) {
            return;
        }
        HikariDataSource hikariDs = (HikariDataSource)this.eduetlDataSource;
        hikariDs.evictConnection(con);
    }
}

