/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.util.CryptUtils;
import de.memtext.util.EqualsUtil;
import de.memtext.util.ServletHelper;
import de.superx.common.DBServletException;
import de.superx.common.SxUser;
import de.superx.servlet.RequestParameter;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SessionAttribute;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import de.superx.servlet.UserInitializer;
import de.superx.util.SqlStringUtils;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public class SuperXmlPwChanger
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletUtils.setPath(this.getServletConfig().getServletContext().getRealPath("/xml"));
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletUtils.setPath(this.getServletConfig().getServletContext().getRealPath("/xml"));
        PwChanger pw = new PwChanger(request, response);
        pw.run(true);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        PrintWriter output = response.getWriter();
        if (session == null || session.getAttribute(SessionAttribute.user.toString()) == null) {
            output.write(SuperXManager.htmlPageHead("Erfolg") + "<h1>Passwort\u00e4nderung f\u00fcr angemeldete Benutzer</h1></body></html>");
        } else {
            response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            output.write(UserInitializer.getPwChangeHtml(""));
        }
        output.flush();
        output.close();
    }

    public String getServletInfo() {
        return "<i>SuperXmlPwChanger</i>";
    }

    private class PwChanger
    extends SuperXServletHelper {
        private String passwort;
        private Connection con;
        private SxUser user;

        public PwChanger(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
        }

        @Override
        protected void perform() throws KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException, DBServletException, TransformerException {
            boolean isShowLoginWantend = EqualsUtil.areEqual(ServletHelper.getParameter(this.request, RequestParameter.showlogin), "true");
            String add = "";
            if (isShowLoginWantend) {
                add = "<input type=\"hidden\" name=\"showlogin\" value=\"true\">";
            }
            String altesPasswort = ServletHelper.getParameter(this.request, RequestParameter.altes_passwort);
            this.passwort = ServletHelper.getParameter(this.request, RequestParameter.passwort);
            String passwort2 = ServletHelper.getParameter(this.request, RequestParameter.passwort2);
            HttpSession ses = this.request.getSession();
            this.user = (SxUser)ses.getAttribute(SessionAttribute.user.toString());
            String currentSha = this.user.getCurrentSha();
            if (altesPasswort == null || altesPasswort.equals("") || this.passwort == null || this.passwort.equals("")) {
                this.sendBackHtml(UserInitializer.getPwChangeHtml(add + "<font color=red>Bitte Passwort eingeben</font>"));
            } else {
                this.con = SxPools.get(this.getMandantenID()).getConnection();
                try {
                    boolean isAltesPasswortOk = this.checkOldPw(altesPasswort);
                    if (isAltesPasswortOk) {
                        if (!EqualsUtil.areEqual(this.passwort, passwort2)) {
                            this.sendBackHtml(UserInitializer.getPwChangeHtml(add + "<font color=red>Die eingegeben Passw&ouml;rter stimmten nicht &uuml;berein</font>"));
                        } else if (this.user.isPWUsedBefore(this.passwort) || CryptUtils.encodeSHA(this.passwort).equals(currentSha) || CryptUtils.encodeSHA(this.passwort + CryptUtils.geheimnis1).equals(currentSha)) {
                            this.sendBackHtml(UserInitializer.getPwChangeHtml(add + "<font color=red>Sie m&uuml;ssen ein neues Passwort eingeben (kein bereits fr&uuml;her benutztes)</font>"));
                        } else {
                            String faults = SxPools.get(this.getMandantenID()).getNewPWChecker().checkForFaults(this.user.getName(), this.passwort);
                            if (faults != null) {
                                this.sendBackHtml(UserInitializer.getPwChangeHtml(add + "<font color=red>" + faults + "</font>"));
                            } else {
                                this.user.rememberOldSHA(currentSha);
                                this.dbUpdate();
                                this.request.getSession().setAttribute("passwordchange", (Object)"false");
                                StringBuffer returnPage = new StringBuffer(SuperXManager.htmlPageHead("Erfolg") + "<h3>Passwort&auml;nderung erfolgreich</h3>");
                                if (isShowLoginWantend) {
                                    returnPage.append("<p>Sie k&ouml;nnen Sich jetzt " + this.getStartPageLink("neu anmelden"));
                                    SuperXServletHelper.removeCookie(this.request, this.response);
                                    this.request.getSession().invalidate();
                                } else {
                                    returnPage.append("<p>" + this.getStartPageLink("Zur Startseite") + "</p>");
                                }
                                returnPage.append("</body></html>");
                                this.sendBackHtml(returnPage.toString());
                            }
                        }
                    }
                    this.con.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (this.con != null) {
                        SxPools.invalidate(this.getMandantenID(), this.con);
                    }
                    Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.ERROR, (Object)("SQL-Fehler: " + e.toString()));
                    throw new DBServletException(e.getMessage());
                }
            }
        }

        private String getStartPageLink(String linktext) {
            return "<a href=\"/superx/index.jsp?MandantenID=" + this.getMandantenID() + "\">" + linktext + "</a>";
        }

        private boolean checkOldPw(String altesPasswort) throws SQLException, IOException {
            boolean isOk = false;
            String msg = null;
            try (PreparedStatement pst = this.con.prepareStatement("select passwd_sha, akt_versuch,max_versuch from userinfo where tid = ?");){
                pst.setInt(1, Integer.valueOf(this.user.getId().toString()));
                try (ResultSet rs = pst.executeQuery();){
                    while (rs.next()) {
                        int max_versuch;
                        int akt_versuch;
                        String oldsha = rs.getString(1);
                        if (oldsha != null) {
                            oldsha = oldsha.trim();
                        }
                        if ((akt_versuch = rs.getInt(2)) >= (max_versuch = rs.getInt(3))) {
                            msg = " Maximale Login-Versuche \u00fcberschritten";
                            continue;
                        }
                        if (CryptUtils.encodeSHA(altesPasswort).equals(oldsha) || CryptUtils.encodeSHA(altesPasswort + CryptUtils.geheimnis1).equals(oldsha)) {
                            isOk = true;
                            continue;
                        }
                        try (Statement stm = this.con.createStatement();){
                            stm.executeUpdate("update userinfo set akt_versuch=akt_versuch+1   where tid=" + this.user.getUserIdAsInt());
                        }
                        msg = "Bisheriges Passwort falsch";
                    }
                }
            }
            if (msg != null) {
                this.sendBackHtml(UserInitializer.getPwChangeHtml("<font color=red>" + msg + "</font>"));
            }
            return isOk;
        }

        private void dbUpdate() throws Exception {
            String newSha;
            Statement stm = this.con.createStatement();
            int rowcount = stm.executeUpdate("update userinfo set passwd_sha='" + (newSha = CryptUtils.encodeSHA(this.passwort + CryptUtils.geheimnis1)) + "',kennwort='' where tid=" + this.user.getId() + ";");
            if (rowcount != 1) {
                throw new DBServletException("Passwort\u00e4nderung fehlgeschlagen, statt einem Eintrag wurden " + rowcount + " ge\u00e4ndert.");
            }
            stm.execute(this.user.getUser_PW_Command(SxPools.get(this.getMandantenID()).getPasswortG\u00fcltigkeit()));
            stm.close();
            this.user.setCurrentSha(newSha);
        }
    }
}

