/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.ServletHelper;
import de.superx.common.DBServletException;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.SichtException;
import de.superx.common.SxUser;
import de.superx.common.TransletCache;
import de.superx.common.UngueltigeEingabeException;
import de.superx.servlet.AbstractSuperXServlet;
import de.superx.servlet.RequestParameter;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Locale;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SuperXmlMenu
extends AbstractSuperXServlet {
    private static final long serialVersionUID = 1L;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SuperXmlMenu.setEncoding(request);
        if (this.hasProperSession(request)) {
            SubmenuCreator sub = new SubmenuCreator(request, response);
            sub.run(true);
        } else {
            this.infoNeuAnmelden(response);
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public String getServletInfo() {
        return "SuperXmlMenu 4.0";
    }

    private class SubmenuCreator
    extends SuperXServletHelper {
        private Hashtable formular;

        SubmenuCreator(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.formular = new Hashtable();
        }

        @Override
        protected void perform() throws NichtAngemeldetException, TransformerException, ParseException, NumberFormatException, TransformerConfigurationException, TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, IOException, SQLException, DBServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
            SxUser user = (SxUser)this.request.getSession().getAttribute("user");
            if (user == null) {
                throw new IllegalStateException("Kein user in der Session gefunden - bitte Browser neu starten!");
            }
            Locale desiredLocale = this.getDesiredLocale();
            String tid = ServletHelper.getParameter(this.request, RequestParameter.tid);
            String contenttype = ServletHelper.getParameter(this.request, RequestParameter.contenttype);
            if (contenttype == null) {
                contenttype = "text/html";
            }
            boolean showNavigation = SuperXmlMenu.this.getShowNavigation(this.request);
            String navigationElement = "";
            if (showNavigation) {
                navigationElement = user.getThemenbaum().toXml(desiredLocale);
            }
            String returnText = user.getThemenbaum().getSubmenuXml(tid, navigationElement);
            Logger.getLogger((String)("superx_" + this.getMandantenID() + "_xml")).log((Priority)Level.DEBUG, (Object)("Menu-xml: " + returnText));
            if (contenttype.equalsIgnoreCase("text/xml")) {
                this.response.setContentType("text/xml; charset=" + SqlStringUtils.getEncoding());
            } else {
                this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
                returnText = this.transform(returnText);
            }
            returnText = SxPools.get(this.getMandantenID()).localize(returnText, desiredLocale).replaceAll("_HISINONE_", SuperXManager.his1_refapp);
            this.sendBackHtml(returnText);
        }

        private String transform(String returnText) throws DBServletException, TransformerException {
            Transformer transformer = TransletCache.getTransformer(this.getMandantenID(), "file:///" + ServletUtils.getPath() + "/submenu_html.xsl");
            StringWriter erg = new StringWriter();
            transformer.transform(new StreamSource(new StringReader(returnText.toString())), new StreamResult(erg));
            return erg.toString();
        }
    }
}

