/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.util.ServletHelper;
import de.memtext.util.StringUtils;
import de.memtext.util.TimeUtils;
import de.superx.common.DBServletException;
import de.superx.common.Field;
import de.superx.common.FieldXmlEncoder;
import de.superx.common.InvalidDataTypeException;
import de.superx.common.InvalidKeyException;
import de.superx.common.Maske;
import de.superx.common.SichtException;
import de.superx.common.SxUser;
import de.superx.common.UngueltigeEingabeException;
import de.superx.servlet.AbstractSuperXServlet;
import de.superx.servlet.MaskenContainer;
import de.superx.servlet.RequestParameter;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SessionAttribute;
import de.superx.servlet.SichtChanger;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import de.superx.util.SqlStringUtils;
import freemarker.template.TemplateException;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.dom4j.DocumentException;
import org.xml.sax.SAXException;

public class SuperXmlMaske
extends AbstractSuperXServlet {
    private static final long serialVersionUID = 1L;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String mxr = config.getInitParameter(RequestParameter.maxRowsOrganigramm.toString());
        SqlStringUtils.maxRowsOrganigramm = mxr == null || mxr.equals("") ? "4000" : mxr;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SuperXmlMaske.setEncoding(request);
        this.checkCacheClearing(request);
        if (!this.hasProperSession(request)) {
            this.infoNeuAnmelden(response);
        } else {
            if (SichtChanger.isSichtChangeWanted(request)) {
                SichtChanger s = new SichtChanger(request, response, false);
                s.run(true);
            }
            if (this.isJSONRequest(request)) {
                JSONResponder jr = new JSONResponder(request, response);
                jr.run(true);
            } else if (this.isAjaxRequest(request)) {
                AjaxResponder ar = new AjaxResponder(request, response);
                ar.run(true);
            } else {
                MaskCreator maskCreator = new MaskCreator(request, response);
                maskCreator.run(true);
            }
        }
    }

    @Deprecated
    private boolean isAjaxRequest(HttpServletRequest request) {
        boolean result = false;
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String aName = (String)en.nextElement();
            if (!aName.startsWith("getXML_")) continue;
            result = true;
        }
        return result;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJSONRequest(request)) {
            // empty if block
        }
        this.doPost(request, response);
    }

    public String getServletInfo() {
        return "<i>SuperXDBServlet, v.1.2</i>";
    }

    private class JSONResponder
    extends SuperXServletHelper {
        private Maske maske;
        private SxUser user;

        public JSONResponder(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.user = (SxUser)request.getSession().getAttribute(SessionAttribute.user.toString());
            this.setAjaxResponder(true);
        }

        @Override
        protected void perform() throws SQLException, DBServletException, TransformerException, KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CloneNotSupportedException, TemplateException, InvalidKeyException, SichtException, IOException, ServletException, NoMainEntryException, InvalidDataTypeException {
            if (this.user == null) {
                throw new IllegalStateException("Kein user in der Session gefunden - bitte Browser neu starten!");
            }
            this.userid = this.request.getSession().getAttribute(SessionAttribute.UserID.toString()).toString();
            String tidString = SuperXmlMaske.this.getTid(this.request);
            StringBuffer json = new StringBuffer("");
            MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
            this.maske = mc.getMaske(tidString);
            if (this.maske == null) {
                throw new IllegalStateException("Es wurde versucht, per AJAX Feld-XML nachzuladen, ohne, dass die Maske geladen wurde");
            }
            try {
                Enumeration en = this.request.getParameterNames();
                while (en.hasMoreElements()) {
                    String aName = (String)en.nextElement();
                    if (!aName.startsWith("getJSON_")) continue;
                    Field f = this.maske.getField(aName.substring(8));
                    String param = JSONResponder.getParameterString((ServletRequest)this.request, aName);
                    if (f.getArt() != Field.Art.id_12_Sicht && !f.isOldOrganigrammArt() && f.isDynamic() && param != null && param.equals("xxxxxx-xxxxxx@")) {
                        f.setInited(false);
                        this.maske.setFieldDefaults(this.user, this.request, false);
                    }
                    if (f.getArt() == Field.Art.id_12_Sicht && f.getSichtgruppe().hasDynamicSicht() && param.equals("xxxxxx-xxxxxx@")) {
                        this.maske.setFieldDefaults(this.user, this.request, false);
                        this.maske.updateDynamicSichten(f, this.user);
                    }
                    json.append(f.getJSON(param));
                }
            }
            catch (UngueltigeEingabeException e) {
                json.setLength(0);
                json.append("({error:\"" + StringUtils.jsonAdapt(e.getMessage(), true) + "\"})");
            }
            String result = SxPools.get(this.getMandantenID()).localize(json, this.getDesiredLocale());
            Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.DEBUG, (Object)("/*" + result + "*/"));
            this.sendBack("/*" + result + "*/", "text/json-comment-filtered");
        }

        public void sendNotAuthorized() throws IOException {
            this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            PrintWriter p = this.response.getWriter();
            String msg = ServletUtils.getJSONErrorText(this.userid, this.getDesiredLocale());
            System.out.println(msg);
            p.print(msg);
            p.close();
        }
    }

    @Deprecated
    private class AjaxResponder
    extends SuperXServletHelper {
        private static final String PARAM_GET_XML_ = "getXML_";
        private Maske maske;
        private SxUser user;
        private StringBuffer xml;

        public AjaxResponder(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.xml = new StringBuffer("<?xml version=\"1.0\"  encoding=\"" + SqlStringUtils.getEncoding() + "\" ?>\n<felder>");
            this.user = (SxUser)request.getSession().getAttribute(SessionAttribute.user.toString());
            if (this.user == null) {
                throw new IllegalStateException("Kein user in der Session gefunden - bitte Browser neu starten!");
            }
        }

        @Override
        protected void perform() throws SQLException, DBServletException, TransformerException, KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, CloneNotSupportedException, TemplateException, InvalidKeyException, SichtException, IOException, ServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
            String tidString = SuperXmlMaske.this.getTid(this.request);
            this.request.setCharacterEncoding("UTF-8");
            MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
            this.maske = mc.getMaske(tidString);
            if (this.maske == null) {
                throw new IllegalStateException("Es wurde versucht, per AJAX Feld-XML nachzuladen, ohne dass die Maske geladen wurde");
            }
            this.maske.setFieldDefaults(this.user, this.request, false);
            Enumeration en = this.request.getParameterNames();
            while (en.hasMoreElements()) {
                String aName = (String)en.nextElement();
                if (!aName.startsWith(PARAM_GET_XML_)) continue;
                this.appendXml(aName.substring(7));
            }
            this.xml.append("\n</felder>");
            this.response.setContentType("text/xml; charset=" + SqlStringUtils.getEncoding());
            this.sendBack(this.xml.toString());
        }

        private void appendXml(String fieldname) {
            Field f = this.maske.getField(fieldname);
            String param = AjaxResponder.getParameterString((ServletRequest)this.request, PARAM_GET_XML_ + fieldname);
            this.xml.append(FieldXmlEncoder.toXml(f, param));
        }
    }

    private class MaskCreator
    extends SuperXServletHelper {
        private Hashtable formular;
        private Maske maske;

        MaskCreator(HttpServletRequest request, HttpServletResponse response) throws IOException {
            super(request, response);
            this.formular = new Hashtable();
        }

        @Override
        protected void perform() throws NichtAngemeldetException, TransformerException, ParseException, NumberFormatException, TransformerConfigurationException, TemplateException, KeyParentEqualException, CloneNotSupportedException, SichtException, IOException, SQLException, DBServletException, UngueltigeEingabeException, NoMainEntryException, InvalidDataTypeException {
            String tpStr;
            this.userid = this.request.getSession().getAttribute(SessionAttribute.UserID.toString()).toString();
            SxUser user = (SxUser)this.request.getSession().getAttribute(SessionAttribute.user.toString());
            if (user == null) {
                throw new IllegalStateException("Kein user in der Session gefunden - bitte Browser neu starten!");
            }
            Locale desiredLocale = this.getDesiredLocale();
            this.formular.put(SessionAttribute.UserID.toString(), this.userid);
            this.formular.put(SessionAttribute.locale.toString(), desiredLocale.getLanguage());
            boolean showNavigation = SuperXmlMaske.this.getShowNavigation(this.request);
            TimeUtils t = new TimeUtils();
            t.start();
            String contenttype = null;
            contenttype = ServletHelper.getParameter(this.request, RequestParameter.contenttype);
            if (contenttype == null) {
                contenttype = "text/html";
            }
            String tidStr = SuperXmlMaske.this.getTid(this.request);
            user.checkAuthentificationForMask(tidStr);
            MaskenContainer mc = MaskenContainer.getFromRequest(this.request);
            String cm = ServletHelper.getParameter(this.request, RequestParameter.cachingcontrol);
            if (cm != null && cm.equalsIgnoreCase("clearsessiondefaults")) {
                user.getSelectionBuffer().clear();
            }
            if (cm != null && cm.toLowerCase().equals("reusemask")) {
                this.maske = mc.getMaske(tidStr);
            }
            if (this.maske == null) {
                if (SxPools.get(this.getMandantenID()).hasMaske(Integer.valueOf(tidStr))) {
                    this.maske = SxPools.get(this.getMandantenID()).getMaskenclone(Integer.valueOf(tidStr));
                    Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.DEBUG, (Object)"   using mask clone");
                } else {
                    this.maske = new Maske(this.getMandantenID(), user, Integer.valueOf(tidStr), desiredLocale);
                }
            }
            if ((tpStr = ServletHelper.getParameter(this.request, RequestParameter.themenbaumparent)) != null) {
                this.maske.setThemenbaumParent(Integer.valueOf(tpStr));
            } else {
                this.maske.setThemenbaumParent(null);
            }
            this.maske.removeTempFieldItems();
            this.maske.setLocale(desiredLocale);
            this.maske.setFieldDefaults(user, this.request, false);
            Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.DEBUG, (Object)("   Maskenvorbereitung Dauer:" + t.getSinceStart()));
            t.start();
            mc.addMaske(this.maske);
            String returnText = "";
            if (contenttype.equalsIgnoreCase("text/xml")) {
                returnText = this.maske.getMaskXml(user, showNavigation);
                this.response.setContentType("text/xml; charset=" + SqlStringUtils.getEncoding());
            } else {
                returnText = this.maske.getMaskHtml(user, showNavigation);
                this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
            }
            returnText = SxPools.get(this.getMandantenID()).localize(returnText, desiredLocale);
            Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.DEBUG, (Object)(" HTML f\u00fcr Maske Dauer insgesamt: " + t.getSinceStart()));
            t.start();
            this.setExpires(600);
            this.sendBackHtml(AbstractSuperXServlet.insertCsrfToken(this.request, returnText));
            Logger.getLogger((String)("superx_" + this.getMandantenID())).log((Priority)Level.DEBUG, (Object)(" schicken der Maske an Client " + t.getSinceStart()));
        }
    }
}

