/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.superx.common.OrgUnit;
import de.superx.common.SxUser;
import de.superx.servlet.ImplicitOrgEinheitFillerI;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class PostgresImplicitOrgEinheitFiller
implements ImplicitOrgEinheitFillerI {
    private boolean implicit_orgunit_rights_table_exists = false;
    private SxUser user;

    PostgresImplicitOrgEinheitFiller(boolean implicit_orgunit_rights_table_exists, SxUser user) {
        this.implicit_orgunit_rights_table_exists = implicit_orgunit_rights_table_exists;
        this.user = user;
    }

    @Override
    public void insertImplicitOrgUnitRights(Connection con, OrgUnit ou) throws SQLException {
        try (Statement stm = con.createStatement();){
            stm.executeUpdate("drop table if exists tmp_hier");
        }
        String sql = "WITH RECURSIVE subordinates AS ( \n\tSELECT \n\t\tkey_apnr, \n\t\tnvl(uniquename,key_apnr) as uniquename, name,\n\t\tlid, \n\t\tparent_lid ,gueltig_seit,gueltig_bis \n \n\tFROM \n organigramm \n\tWHERE \n\t\t(key_apnr = ? or uniquename=?) \n\tUNION \n\t\tSELECT \n\t\t\tO.key_apnr, \n\t\tnvl(O.uniquename,O.key_apnr) as uniquename,O.name, \n\t\tO.lid, \n\t\tO.parent_lid,O.gueltig_seit,O.gueltig_bis \n\t\tFROM \n\t\t\torganigramm O \n\t\tINNER JOIN subordinates s ON s.lid = O.parent_lid \n) SELECT * into tmp_hier FROM subordinates";
        try (PreparedStatement pst_create_temp_table = con.prepareStatement(sql);){
            pst_create_temp_table.setString(1, ou.getApnr());
            pst_create_temp_table.setString(2, ou.getUniquename());
            pst_create_temp_table.execute();
        }
        try (Statement stm = con.createStatement();
             ResultSet rs = stm.executeQuery("select * from tmp_hier");){
            while (rs.next()) {
                this.user.addImplicitlyAllowedOrgUnit(new OrgUnit(rs.getString("key_apnr"), rs.getString("uniquename"), rs.getString("lid"), rs.getString("name"), rs.getDate("gueltig_seit"), rs.getDate("gueltig_bis")));
            }
        }
        if (this.implicit_orgunit_rights_table_exists) {
            String insert = "insert into implicit_orgunit_rights (userinfo_id,apnr,uniquename,lid) \nselect distinct ?,O.key_apnr,nvl(O.uniquename,O.key_apnr),O.lid from organigramm O, tmp_hier T \nwhere T.key_apnr=O.key_apnr \nunion \nselect distinct ?,mapped_id,M.uniquename,M.lid from orgunit_mapping M, tmp_hier T \nwhere T.key_apnr=M.apnr \n union \nselect distinct ?,M.uniquename,M.uniquename,M.lid from orgunit_mapping M, tmp_hier T \nwhere T.key_apnr=M.apnr;";
            try (PreparedStatement pst_insert = con.prepareStatement(insert);){
                pst_insert.setInt(1, this.user.getUserIdAsInt());
                pst_insert.setInt(2, this.user.getUserIdAsInt());
                pst_insert.setInt(3, this.user.getUserIdAsInt());
                pst_insert.execute();
            }
        }
        stm = con.createStatement();
        try {
            stm.executeUpdate("drop table if exists tmp_hier");
        }
        finally {
            if (stm != null) {
                stm.close();
            }
        }
    }
}

