/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.baseobjects.coll.NamedIdObjectSet;
import de.memtext.db.NichtAngemeldetException;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.util.EqualsUtil;
import de.memtext.util.StringUtils;
import de.superx.common.DBServletException;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxUser;
import de.superx.servlet.Hinweis;
import de.superx.servlet.PreparedXmlProcessor;
import de.superx.servlet.RequestParameter;
import de.superx.servlet.ServletBasics;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SessionAttribute;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SuperXServletHelper;
import de.superx.servlet.SxPools;
import de.superx.servlet.TokenChecker;
import de.superx.servlet.UserInitializer;
import de.superx.util.SqlStringUtils;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.Hashtable;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.xml.sax.SAXException;

public class MenuCreator
extends SuperXServletHelper {
    private static Logger logger = LoggerFactory.getLogger(UserInitializer.class);
    private final String hinweisSql = "SELECT id \nFROM user_dialog \nWHERE (valid_from IS NULL OR valid_from <= TODAY ()) \nAND   (valid_till IS NULL OR valid_till >= TODAY ()) \nAND   (id IN (SELECT hinweise_id FROM user_hinweis WHERE userinfo_id = <<USERID>>) OR id IN (SELECT hinweise_id \n                                                                                      FROM group_hinweis \n                                                                                      WHERE groupinfo_id IN (SELECT groupinfo_id FROM user_group_bez WHERE  userinfo_id = <<USERID>>)))and id not in (select user_dialog_id from user_dialog_accept where userinfo_id=<<USERID>>)";
    private Hashtable<String, NamedIdObjectSet> hinweisCollections;
    private boolean hasProperSession = false;
    private ServletConfig servletConfig;
    private ServletContext servletContext;

    public MenuCreator(HttpServletRequest request, HttpServletResponse response, ServletConfig servletConfig, ServletContext servletContext, Hashtable<String, NamedIdObjectSet> hinweisCollections, boolean hasProperSession) throws IOException {
        super(request, response);
        this.hinweisCollections = hinweisCollections;
        this.hasProperSession = hasProperSession;
        this.servletConfig = servletConfig;
        this.servletContext = servletContext;
    }

    @Override
    protected void perform() throws KeyParentEqualException, NichtAngemeldetException, IOException, ParseException, ParserConfigurationException, FactoryConfigurationError, SAXException, DocumentException, IllegalArgumentException, SecurityException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SQLException, DBServletException, TransformerException, IOException, ServletException {
        if (MenuCreator.getParameter(this.request, RequestParameter.alt_redirect_url) != null) {
            throw new IllegalArgumentException("Funktion alt_redirect_url wird nicht mehr unterst\u00fctzt");
        }
        logger.debug("Running MenuCreator.perform()");
        HttpSession session = this.request.getSession(false);
        logger.debug("Request.session: " + session);
        String kennungImRequest = MenuCreator.getParameter(this.request, RequestParameter.kennung);
        logger.debug("Request.kennung: " + kennungImRequest);
        String token = MenuCreator.getParameter(this.request, RequestParameter.token);
        UserInitializer userInit = new UserInitializer(this.request);
        TokenChecker tokenChecker = null;
        if (token != null && !token.isEmpty()) {
            if (!SuperXManager.isHis1()) {
                throw new IllegalStateException("Fehlerhafte Serverkonfiguration. Es wurde ein Token \u00fcbergeben, aber in der superx/WEB-INF/web.xml ist superxStandalone aktiviert");
            }
            tokenChecker = new TokenChecker(token);
            tokenChecker.testAll();
        }
        String requType = this.request.getHeader("x-requested-with");
        String accept = this.request.getHeader("Accept");
        boolean wantsJson = StringUtils.notNullAndStartsWith(accept, "application/json") || "XMLHttpRequest".equals(requType);
        SxUser user = null;
        try {
            if (!this.hasProperSession) {
                userInit.perform(tokenChecker, (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE));
                user = userInit.getUser();
            } else {
                user = (SxUser)session.getAttribute(SessionAttribute.user.toString());
                if (kennungImRequest != null && !kennungImRequest.equals(user.getName())) {
                    throw new NichtAngemeldetException();
                }
                if (tokenChecker != null && this.hasKennungOrRightsInTokenChanged(kennungImRequest, tokenChecker, session, user)) {
                    userInit.perform(tokenChecker, (ApplicationContext)this.servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE));
                    user = userInit.getUser();
                }
            }
            this.sendResponse(userInit, wantsJson, user);
        }
        catch (NichtAngemeldetException e) {
            e.printStackTrace();
            this.displayErrorMessage(kennungImRequest, userInit, wantsJson);
        }
    }

    private void sendResponse(UserInitializer ui, boolean wantsJson, SxUser user) throws SQLException, IOException, DBServletException, ServletException, FactoryConfigurationError, ParserConfigurationException, TransformerException {
        boolean showMainPageAfterHinweisAccepted = false;
        if (this.wasHinweisAccepted()) {
            this.saveHinweisAccepted(user);
            showMainPageAfterHinweisAccepted = true;
        }
        if (ui.isPasswordChangeDemanded()) {
            this.displayPasswordChangeDialog();
        } else if (this.isDisplayHinweisWanted(user)) {
            this.displayHinweis(user);
        } else if (this.isUserSpecificStartWanted(user)) {
            this.displayUserSpecificStartPage(user);
        } else {
            String redirect = this.identifyRedirect(showMainPageAfterHinweisAccepted);
            if (redirect != null) {
                this.response.sendRedirect(redirect);
            } else if (wantsJson) {
                this.sendSSO_OK();
            } else {
                this.displayStandardMenu(user);
            }
        }
    }

    private void sendSSO_OK() throws IOException {
        this.sendBack("{ \"result\": \"SSO OK\" }", "application/json");
    }

    private boolean hasKennungOrRightsInTokenChanged(String kennungImRequest, TokenChecker tokenChecker, HttpSession session, SxUser user) throws NichtAngemeldetException {
        boolean hasChangeOccured = false;
        if (kennungImRequest != null && !EqualsUtil.areEqual(kennungImRequest, user.getName())) {
            hasChangeOccured = true;
        }
        if (tokenChecker != null) {
            if (!EqualsUtil.areEqual(tokenChecker.getRights(), session.getAttribute(SessionAttribute.rights.toString()))) {
                hasChangeOccured = true;
            }
            if (!EqualsUtil.areEqual(tokenChecker.getOrgunitLid(), session.getAttribute(SessionAttribute.orgUnit.toString()))) {
                hasChangeOccured = true;
            }
        }
        return hasChangeOccured;
    }

    private void displayErrorMessage(String kennung, UserInitializer ui, boolean wantsJson) throws IOException {
        if (kennung == null || kennung.equals("")) {
            kennung = ui.getUsername();
        }
        Object meldung = "Anmeldung fehlgeschlagen: ";
        meldung = SuperXManager.isHis1() ? (String)meldung + "Beim Single Sign-on ist ein Fehler aufgetreten." : (String)meldung + "Kombination von Benutzernamen und Passwort nicht bekannt.";
        SuperXServletHelper.removeCookie(this.request, this.response);
        HttpSession currSession = this.request.getSession(false);
        if (currSession != null) {
            currSession.invalidate();
        }
        String txt = SuperXManager.htmlPageHead("Problem") + "\n<p class=\"errmsg\">" + (String)meldung + "</p>";
        if (!SuperXManager.his1_refapp.isEmpty()) {
            txt = txt + "<p><a href=\"/" + SuperXManager.his1_refapp + "\">Zur\u00fcck</a>";
        }
        txt = txt + "</body></html>";
        if (wantsJson) {
            this.sendBack("{ \"result\": \"SSO failure\" }", "application/json");
        } else {
            try (PrintWriter output = this.response.getWriter();){
                this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
                output.write(txt);
            }
        }
    }

    private void displayStandardMenu(SxUser user) throws IOException {
        String contenttype = MenuCreator.getParameter(this.request, RequestParameter.contenttype);
        if (contenttype == null) {
            contenttype = "text/html";
        }
        Object returnTxt = "";
        if (contenttype.equalsIgnoreCase("text/xml")) {
            logger.debug("Themenbaum nach XML");
            returnTxt = "<?xml version=\"1.0\" encoding=\"" + SqlStringUtils.getEncoding() + "\" ?>" + user.getThemenbaum().toXml(this.getDesiredLocale());
            this.response.setContentType("text/xml; charset=" + SqlStringUtils.getEncoding());
        } else {
            logger.debug("Themenbaum nach HTML");
            returnTxt = user.getThemenbaum().toHtml(this.getDesiredLocale());
            this.response.setContentType("text/html; charset=" + SqlStringUtils.getEncoding());
        }
        this.sendBack((String)returnTxt);
    }

    private String identifyRedirect(boolean showMainPageAfterHinweisAccepted) {
        String paramApplet = MenuCreator.getParameter(this.request, RequestParameter.start_applet);
        if (paramApplet != null) {
            throw new IllegalArgumentException("Param start_applet wird nicht mehr unterst\u00fctzt");
        }
        String redirect = MenuCreator.getParameter(this.request, RequestParameter.redirect);
        if (redirect != null && redirect.isEmpty()) {
            redirect = null;
        }
        if (EqualsUtil.areEqual(redirect, "../servlet/SuperXmlAnmeldung")) {
            redirect = null;
        }
        if (redirect != null && !redirect.isEmpty() && !redirect.startsWith("/superx/")) {
            System.out.println("BI unerlaubter redirect param " + redirect);
            throw new IllegalArgumentException("Nicht erlaubter redirect param");
        }
        String paramMainPage = MenuCreator.getParameter(this.request, RequestParameter.show_main_page);
        if (EqualsUtil.areEqualIgnoringCase(paramMainPage, "true") || showMainPageAfterHinweisAccepted) {
            redirect = "/superx/";
        }
        return redirect;
    }

    private void displayPasswordChangeDialog() throws IOException {
        this.sendBackHtml(UserInitializer.getPwChangeHtml("<input type=\"hidden\" name=\"showlogin\" value=\"true\"><font color=red>Sie m&uuml;ssen Ihr Passwort &auml;ndern</font>"));
    }

    private boolean isDisplayHinweisWanted(SxUser user) throws SQLException, DBServletException {
        boolean displayHinweis = false;
        SxResultSet res = ServletUtils.execute("m\u00f6gliche Hinweise f\u00fcr User " + user + "suchen", StringUtils.replace("SELECT id \nFROM user_dialog \nWHERE (valid_from IS NULL OR valid_from <= TODAY ()) \nAND   (valid_till IS NULL OR valid_till >= TODAY ()) \nAND   (id IN (SELECT hinweise_id FROM user_hinweis WHERE userinfo_id = <<USERID>>) OR id IN (SELECT hinweise_id \n                                                                                      FROM group_hinweis \n                                                                                      WHERE groupinfo_id IN (SELECT groupinfo_id FROM user_group_bez WHERE  userinfo_id = <<USERID>>)))and id not in (select user_dialog_id from user_dialog_accept where userinfo_id=<<USERID>>)", "<<USERID>>", user.getId().toString()), this.getMandantenID());
        if (res.size() > 0) {
            displayHinweis = true;
        }
        return displayHinweis;
    }

    private boolean wasHinweisAccepted() {
        return this.request.getSession().getAttribute(SessionAttribute.current_hinweis.toString()) != null && EqualsUtil.areEqual(ServletBasics.getParameter(this.request, RequestParameter.accepted), "on");
    }

    private void saveHinweisAccepted(SxUser user) throws SQLException {
        int rows;
        Integer currentHinweisId = (Integer)this.request.getSession().getAttribute(SessionAttribute.current_hinweis.toString());
        Connection con = SxPools.getConnection(this.getMandantenID());
        Statement stm = con.createStatement();
        String now = "now()";
        if (!SxPools.get(this.getMandantenID()).getSqlDialect().equals("Postgres")) {
            now = "current";
        }
        if ((rows = stm.executeUpdate("insert into user_dialog_accept (userinfo_id,user_dialog_id,timestamp,ip_address,client_name)values (" + user.getId() + "," + currentHinweisId + "," + now + ",'" + this.request.getRemoteAddr() + "','" + this.request.getRemoteHost() + "')")) != 1) {
            throw new RuntimeException("Speichern der Hinweis-Akzeptanz fehlgeschlagen");
        }
        this.request.getSession().setAttribute(SessionAttribute.current_hinweis.toString(), null);
        stm.close();
        con.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayHinweis(SxUser user) throws SQLException {
        Connection con = null;
        Statement stm = null;
        try {
            con = SxPools.getConnection(this.getMandantenID());
            stm = con.createStatement();
            SxResultSet res = ServletUtils.execute(" Hinweise f\u00fcr User " + user + "suchen", StringUtils.replace("SELECT id \nFROM user_dialog \nWHERE (valid_from IS NULL OR valid_from <= TODAY ()) \nAND   (valid_till IS NULL OR valid_till >= TODAY ()) \nAND   (id IN (SELECT hinweise_id FROM user_hinweis WHERE userinfo_id = <<USERID>>) OR id IN (SELECT hinweise_id \n                                                                                      FROM group_hinweis \n                                                                                      WHERE groupinfo_id IN (SELECT groupinfo_id FROM user_group_bez WHERE  userinfo_id = <<USERID>>)))and id not in (select user_dialog_id from user_dialog_accept where userinfo_id=<<USERID>>)", "<<USERID>>", user.getId().toString()), this.getMandantenID());
            if (res.size() > 0) {
                SxResultRow row = (SxResultRow)res.first();
                Integer hinweistid = (Integer)row.get(0);
                NamedIdObjectSet hinweisCollection = this.hinweisCollections.get(this.getMandantenID());
                if (hinweisCollection == null) {
                    hinweisCollection = new NamedIdObjectSet();
                    ResultSet rs = stm.executeQuery("select id,identifier,headline,url,confirm,confirm_prompt from user_dialog WHERE (valid_from IS NULL OR valid_from <= TODAY ()) \nAND   (valid_till IS NULL OR valid_till >= TODAY ()) ");
                    while (rs.next()) {
                        Hinweis hinweis = new Hinweis(rs.getInt("id"), rs.getString("identifier"));
                        hinweis.setUeberschrift(rs.getString("headline"));
                        hinweis.setUrl(rs.getString("url"));
                        hinweis.setBestaetigen(rs.getInt("confirm") == 1);
                        String satz = rs.getString("confirm_prompt");
                        if (satz != null) {
                            hinweis.setBestaetigungsSatz(satz);
                        }
                        hinweisCollection.add(hinweis);
                    }
                    this.hinweisCollections.put(this.getMandantenID(), hinweisCollection);
                }
                Hinweis hinw = (Hinweis)hinweisCollection.getById(hinweistid);
                StringBuffer hinweishtml = new StringBuffer("<html>\n<head><titel>" + hinw.getName() + "</titel>\n<script language=\"Javascript\">var oldcols=parent.document.all('superxframes').cols;function maxLeftFrame(){parent.document.all('superxframes').cols='100%,*'} ; function resize(){parent.document.all('superxframes').cols=oldcols;}</script>\n</head>\n<body onload=\"maxLeftFrame()\">\n");
                hinweishtml.append(hinw.getUeberschrift() + "<br>");
                hinweishtml.append("<IFRAME SRC=\"" + hinw.getUrl() + "\" TITLE=\"" + hinw.getName() + "\" width=\"90%\" height=\"60%\">");
                hinweishtml.append("<a href=\"" + hinw.getUrl() + "\">" + hinw.getName() + "</a>");
                hinweishtml.append("\n</IFRAME><br>\n");
                hinweishtml.append("<form method=\"post\" action=\"/superx/servlet/SuperXmlAnmeldung\" onsubmit=\"resize()\">\n");
                this.request.getSession().setAttribute(SessionAttribute.current_hinweis.toString(), hinw.getId());
                if (hinw.isBestaetigen()) {
                    hinweishtml.append("<p align=\"center\"><input type=\"checkbox\" name=\"accepted\">" + hinw.getBestaetigungsSatz() + "</p>\n");
                } else {
                    hinweishtml.append("<input type=\"hidden\" name=\"accepted\" value=\"on\">\n<p align=\"center\">" + hinw.getBestaetigungsSatz() + "</p>\n");
                }
                hinweishtml.append("\n<p align=\"center\"><input type=\"submit\" value=\"OK\"></p>\n");
                hinweishtml.append("</form></body></html>");
                this.sendBackHtml(hinweishtml.toString());
            }
        }
        catch (Exception e) {
            System.out.println("Fehler beim Lesen von Hinweisen");
            e.printStackTrace();
        }
        finally {
            if (stm != null) {
                stm.close();
            }
            if (con != null) {
                con.close();
            }
        }
    }

    private boolean isUserSpecificStartWanted(SxUser user) throws SQLException, DBServletException {
        SxResultSet res;
        boolean result = false;
        result = EqualsUtil.areEqual(ServletBasics.getParameter(this.request, RequestParameter.user_specific), "true") ? true : (res = ServletUtils.execute("m\u00f6glich Startpage f\u00fcr User " + (Integer)user.getId() + "suchen", "select startmask,starturl,notolderthan,alturl,stylesheet,encrypted from user_startpage where userid=" + (Integer)user.getId() + " and active=1", this.getMandantenID())).size() > 0;
        return result;
    }

    private void displayUserSpecificStartPage(SxUser user) throws ServletException, FactoryConfigurationError, IOException, ParserConfigurationException, TransformerException, SQLException, DBServletException {
        String requestedServlet;
        SxResultSet res = ServletUtils.execute("m\u00f6glich Startpage f\u00fcr User " + user + "suchen", "select startmask,starturl,notolderthan,alturl,stylesheet,encrypted from user_startpage where userid=" + user.getId() + " and active=1", this.getMandantenID());
        boolean i = true;
        if (res.size() > 0) {
            logger.info("Userspezifischer Start f\u00fcr User " + user.getId());
            SxResultRow row = (SxResultRow)res.first();
            Integer startmask = (Integer)row.get(0);
            String starturl = (String)row.get(1);
            Integer notolderthan = (Integer)row.get(2);
            String alturl = (String)row.get(3);
            String stylesheet = (String)row.get(4);
            Object encrypted = row.get(5);
            if (starturl != null && starturl.endsWith(".xml")) {
                PreparedXmlProcessor px = new PreparedXmlProcessor(this.servletConfig, this.request, this.response, this.getMandantenID(), this.getBrowser());
                if (px.isFileOk(starturl, notolderthan)) {
                    boolean success = px.process(starturl, stylesheet, ServletBasics.getParameter(this.request, RequestParameter.contenttype), encrypted);
                    if (!success) {
                        logger.info("File " + starturl + " enthielt keine XML-Daten oder XML-Transformationsfehler, versuche startmaske direkt aufzurufen");
                        this.gotoStartUrl(user, startmask, null, stylesheet);
                    }
                } else {
                    logger.info("File " + starturl + " nicht gefunden oder zu alt, versuche Startmaske aufzurufen");
                    this.gotoStartUrl(user, startmask, null, stylesheet);
                }
            } else {
                this.gotoStartUrl(user, startmask, starturl, stylesheet);
            }
        }
        if ((requestedServlet = ServletBasics.getParameter(this.request, RequestParameter.requestedServlet)) != null) {
            throw new IllegalArgumentException("Funktion requestedServlet steht nicht mehr zur Verf\u00fcgung");
        }
    }

    private void gotoStartUrl(SxUser user, Integer startmask, String starturl, String stylesheet) throws SQLException, DBServletException, ServletException, IOException {
        if (starturl == null || ((String)starturl).trim().equals("")) {
            if (startmask == null) {
                throw new IllegalArgumentException("Versuche eine userspezifische Startmaske aufzurufen, aber startmask war null");
            }
            StringBuffer url = new StringBuffer("/servlet/SuperXmlTabelle?navi=true&tid=" + startmask);
            SxResultSet res = ServletUtils.execute("Startfields f\u00fcr User " + user + "suchen", "select fieldname,value from user_startfields where userid=" + user.getId() + "and active=1", this.getMandantenID());
            for (SxResultRow row : res) {
                url.append("&" + row.get(0) + "=" + row.get(1));
            }
            starturl = url.toString();
        }
        if (stylesheet != null) {
            starturl = (String)starturl + "&stylesheet=" + stylesheet;
        }
        logger.info("going to starturl:" + (String)starturl);
        this.servletContext.getRequestDispatcher((String)starturl).forward((ServletRequest)this.request, (ServletResponse)this.response);
    }
}

