/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.superx.common.Maske;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;

public class MaskenContainer
extends ArrayList<Object> {
    private String lastMaskentid;
    private static final long serialVersionUID = 1L;

    public MaskenContainer() {
        super(5);
    }

    public void addMaske(Maske m) {
        for (Maske maske : this) {
            if (!m.getId().equals(maske.getId())) continue;
            this.remove(maske);
            break;
        }
        if (!this.contains(m)) {
            while (this.size() > 3) {
                this.remove(0);
            }
            this.add(m);
        }
    }

    public void removeMaske(String tidString) {
        for (Maske maske : this) {
            if (!tidString.equals(maske.getId().toString())) continue;
            this.remove(maske);
            break;
        }
    }

    @Override
    public String toString() {
        StringBuffer r = new StringBuffer("Maskencontainer (");
        for (Maske m : this) {
            r.append(m.getId() + " ");
        }
        r.append(")");
        return r.toString();
    }

    public static MaskenContainer getFromRequest(HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (session == null) {
            throw new IllegalArgumentException("Keine Session gefunden bitte neu anmelden");
        }
        MaskenContainer mc = (MaskenContainer)session.getAttribute("maskencontainer");
        if (mc == null) {
            mc = new MaskenContainer();
            session.setAttribute("maskencontainer", (Object)mc);
        }
        return mc;
    }

    public Maske getLastMaske() {
        Maske result = null;
        if (this.lastMaskentid != null) {
            result = this.getMaske(this.lastMaskentid);
        }
        return result;
    }

    public Maske getMaske(String tidString) {
        this.lastMaskentid = tidString;
        Maske result = null;
        for (Maske m : this) {
            if (!m.getId().toString().equals(tidString)) continue;
            result = m;
        }
        return result;
    }
}

