/*
 * Decompiled with CFR 0.152.
 */
package de.superx.servlet;

import de.memtext.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LdapPasswordChecker {
    private static Properties props = new Properties();
    private static String[] attributeFilter = new String[1];
    private static boolean hasLdapServiceUserDN = false;
    private static boolean wasSetupTestOK = false;
    private static boolean isStandaloneTest = false;
    private DirContext serviceCtxForLockout = null;

    public static void main(String[] args) {
        isStandaloneTest = true;
        if (args.length != 3) {
            System.out.println("LdapPasswordChecker path_to_config_file username password");
            System.exit(1);
        }
        try {
            LdapPasswordChecker.setup(new File(args[0]));
            LdapPasswordChecker lpc = new LdapPasswordChecker();
            lpc.isLdapPasswordOK(false, "default", args[1], args[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setup(File superxStandaloneLdapConfigFile) throws IOException {
        FileInputStream is = new FileInputStream(superxStandaloneLdapConfigFile);
        props.load(is);
        ((InputStream)is).close();
        LdapPasswordChecker.checkProperty(superxStandaloneLdapConfigFile, "LdapUrl");
        LdapPasswordChecker.checkProperty(superxStandaloneLdapConfigFile, "LdapBase");
        LdapPasswordChecker.checkProperty(superxStandaloneLdapConfigFile, "LdapIdentifyingAttribute");
        if (!StringUtils.isNullOrEmpty(props.getProperty("LdapServiceUserDN"))) {
            hasLdapServiceUserDN = true;
            System.out.println(" LDAP Passwortkontrolle ServiceUser " + props.getProperty("LdapServiceUserDN") + " aktiviert");
        }
        LdapPasswordChecker.attributeFilter[0] = props.getProperty("LdapIdentifyingAttribute");
        boolean isJustSetupTest = true;
        String mandantenIDNichtRelevant = "default";
        String beliebigerTestUser = "superx";
        String testpassword = "not_relevant_just_testing_connection";
        if (isStandaloneTest) {
            System.out.println("Starte Verbindungstest");
        }
        new LdapPasswordChecker().isLdapPasswordOK(isJustSetupTest, mandantenIDNichtRelevant, beliebigerTestUser, testpassword);
        if (isStandaloneTest) {
            System.out.println(" Verbindungstest OK");
            System.out.println("");
        }
        wasSetupTestOK = true;
    }

    private static void checkProperty(File superxStandaloneLdapConfigFile, String name) throws IllegalStateException {
        if (StringUtils.isNullOrEmpty(props.getProperty(name))) {
            throw new IllegalStateException(" Property \"" + name + "\" ist in Datei " + superxStandaloneLdapConfigFile + " nicht konfiguiert");
        }
    }

    public boolean isUserLocked(String benutzer) throws Exception {
        NamingEnumeration<SearchResult> searchResults;
        if (props.size() == 0) {
            throw new IllegalStateException("LDAP Passwordchecker nicht konfiguiert, setup Methode muss vorher aufgerufen werden");
        }
        boolean result = false;
        if (this.serviceCtxForLockout == null) {
            this.serviceCtxForLockout = this.initContext();
        }
        if ((searchResults = this.searchForUserLockedStatus(this.serviceCtxForLockout, benutzer)).hasMoreElements()) {
            result = true;
        }
        return result;
    }

    public void closeServiceCtxForLockout() throws NamingException {
        this.serviceCtxForLockout.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLdapPasswordOK(boolean isJustSetupTest, String mandantenID, String username, String password) {
        Date start = new Date();
        if (props.size() == 0) {
            throw new IllegalStateException("LDAP Passwordchecker nicht konfiguiert, setup Methode muss vorher aufgerufen werden");
        }
        if (!isJustSetupTest && !wasSetupTestOK) {
            throw new IllegalStateException("LDAP Setup f\u00fcr gesamten Server war nicht erfolgreich");
        }
        InitialDirContext serviceCtx = null;
        try {
            serviceCtx = this.initContext();
            if (isStandaloneTest) {
                System.out.println("Reine Kontrolle, ob User " + username + " existiert");
            }
            NamingEnumeration<SearchResult> searchResults = this.searchForUser(serviceCtx, username);
            if (!isJustSetupTest) {
                this.tryAuthentification(searchResults, username, password);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().indexOf("Invalid Credentials") > -1) {
                Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.INFO, (Object)(" Authentifizierung via LDAP f\u00fcr User " + username + " fehlgeschlagen :" + e.toString()));
            }
            if (e.getLocalizedMessage() != null && e.getLocalizedMessage().indexOf("Kein LDAP Eintrag f\u00fcr User") > -1) {
                Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.INFO, (Object)(" Kein LDAP User " + username + " gefunden :" + e.toString()));
            } else {
                e.printStackTrace();
            }
        }
        finally {
            if (serviceCtx != null) {
                try {
                    serviceCtx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    private NamingEnumeration<SearchResult> searchForUserLockedStatus(DirContext serviceCtx, String username) throws NamingException {
        SearchControls sc = new SearchControls();
        sc.setReturningAttributes(attributeFilter);
        sc.setSearchScope(2);
        if (StringUtils.isNullOrEmpty(props.getProperty("LdapLockoutFilter"))) {
            throw new NamingException("LdapLockoutFilter ist nicht definiert");
        }
        String searchFilter = StringUtils.replace(props.getProperty("LdapLockoutFilter"), "${0}", username);
        return serviceCtx.search(props.getProperty("LdapBase"), searchFilter, sc);
    }

    private NamingEnumeration<SearchResult> searchForUser(DirContext serviceCtx, String username) throws NamingException {
        SearchControls sc = new SearchControls();
        sc.setReturningAttributes(attributeFilter);
        sc.setSearchScope(2);
        Object searchFilter = "";
        searchFilter = props.getProperty("LdapSearchFilter") != null ? StringUtils.replace(props.getProperty("LdapSearchFilter"), "${0}", username) : "(" + props.getProperty("LdapIdentifyingAttribute") + "=" + username + ")";
        return serviceCtx.search(props.getProperty("LdapBase"), (String)searchFilter, sc);
    }

    private void tryAuthentification(NamingEnumeration<SearchResult> searchResults, String username, String password) throws NamingException {
        if (isStandaloneTest) {
            System.out.println("Versuche Authentifizierung");
        }
        if (searchResults.hasMore()) {
            SearchResult result = searchResults.next();
            String distinguishedName = result.getNameInNamespace();
            if (isStandaloneTest) {
                System.out.println(" User " + username + " gefunden - distingushedName(DN/nameInNamespace):" + distinguishedName);
                System.out.println(" versuche Authentifizierung f\u00fcr " + distinguishedName + " mit eingegebenen Passwort");
            }
            Properties authEnv = new Properties();
            authEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            authEnv.put("java.naming.provider.url", props.getProperty("LdapUrl"));
            authEnv.put("java.naming.security.authentication", "simple");
            authEnv.put("java.naming.security.principal", distinguishedName);
            authEnv.put("java.naming.security.credentials", password);
            new InitialDirContext(authEnv);
            if (isStandaloneTest) {
                System.out.println("Authentifizierung erfolgreich");
            }
        } else {
            throw new IllegalStateException(" Kein g\u00fcltiger LDAP Eintrag f\u00fcr User " + username + " gefunden");
        }
    }

    private InitialDirContext initContext() throws NamingException {
        Properties serviceEnv = new Properties();
        serviceEnv.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        serviceEnv.put("java.naming.provider.url", props.getProperty("LdapUrl"));
        serviceEnv.put("java.naming.security.authentication", "simple");
        if (hasLdapServiceUserDN) {
            serviceEnv.put("java.naming.security.principal", props.getProperty("LdapServiceUserDN"));
            serviceEnv.put("java.naming.security.credentials", props.getProperty("LdapServiceUserPassword"));
        }
        return new InitialDirContext(serviceEnv);
    }
}

