/*
 * Decompiled with CFR 0.152.
 */
package de.superx.saiku.schema;

import com.google.common.base.Splitter;
import de.superx.servlet.SxSQL_Server;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import javax.sql.DataSource;
import mondrian.olap.Util;
import mondrian.spi.impl.FilterDynamicSchemaProcessor;
import org.apache.log4j.Logger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DriverManagerDataSource;

public class SuperxDynamicSchemaProcessor
extends FilterDynamicSchemaProcessor {
    public static Logger logger = Logger.getLogger(SuperxDynamicSchemaProcessor.class);
    public static final String CUSTOM_FILE_NAME = "custom.xml";
    private JdbcTemplate jt;

    public SuperxDynamicSchemaProcessor() {
        DriverManagerDataSource ds = new DriverManagerDataSource("jdbc:apache:commons:dbcp:" + SxSQL_Server.DEFAULT_MANDANTEN_ID);
        this.jt = new JdbcTemplate((DataSource)ds);
    }

    public SuperxDynamicSchemaProcessor(DataSource ds) {
        this.jt = new JdbcTemplate(ds);
    }

    protected String filter(String schemaUrl, Util.PropertyList connectInfo, InputStream stream) throws Exception {
        logger.info((Object)("Processing Mondrian schema from " + schemaUrl));
        return super.filter(schemaUrl, connectInfo, stream);
    }

    public String processSchema(String schemaUrl, Util.PropertyList connectInfo) throws Exception {
        Object dbModified = null;
        Object dbSchema = null;
        String originalDbSchema = "";
        Object dbCustomization = null;
        String fileCustomization = "";
        String filePath = "/" + schemaUrl.substring(4);
        URL fileUrl = ((Object)((Object)this)).getClass().getResource(filePath);
        File file = new File(fileUrl.getFile());
        return super.processSchema(schemaUrl, connectInfo);
    }

    public String customize(String customization, String schema) {
        if (customization == null || customization.isEmpty()) {
            return schema;
        }
        Document schemaDoc = null;
        Document customDoc = null;
        Document customizedSchemaDoc = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            schemaDoc = builder.build((Reader)new StringReader(schema));
            customDoc = builder.build((Reader)new StringReader(customization));
            List custDimensions = customDoc.getRootElement().getChildren("dimension");
            LinkedHashMap<String, DimensionCustomization> customDimensions = new LinkedHashMap<String, DimensionCustomization>();
            for (Element custDimension : custDimensions) {
                customDimensions.put(custDimension.getAttributeValue("name"), new DimensionCustomization(custDimension));
            }
            Element physicalSchema = schemaDoc.getRootElement().getChild("PhysicalSchema");
            List dimensions = schemaDoc.getRootElement().getChildren("Dimension");
            XPathFactory xpfac = XPathFactory.instance();
            for (Element dimension : dimensions) {
                String tableName = dimension.getAttributeValue("table");
                String caption = dimension.getAttributeValue("caption");
                if (!customDimensions.containsKey(caption)) continue;
                XPathExpression xpQuery = xpfac.compile("//Query[@alias='" + tableName + "']", Filters.element());
                Element table = (Element)xpQuery.evaluateFirst((Object)physicalSchema);
                DimensionCustomization dc = (DimensionCustomization)customDimensions.get(caption);
                dc.setDimension(dimension);
                dc.setTable(table);
            }
            customizedSchemaDoc = this.customizeSchema(customDimensions.values());
            List<String> sqlStatements = this.generateCustomizeSql(customDimensions.values());
            this.execSql(sqlStatements);
        }
        catch (Exception e) {
            logger.error((Object)"Couldn't customize Mondrian schema. Using original schema. Please check custom.xml");
            logger.error((Object)"Error was: ", (Throwable)e);
            return schema;
        }
        XMLOutputter xmlOutputter = new XMLOutputter();
        xmlOutputter.setFormat(Format.getPrettyFormat());
        return xmlOutputter.outputString(customizedSchemaDoc);
    }

    List<String> generateCustomizeSql(Collection<DimensionCustomization> customizations) {
        ArrayList<String> sql = new ArrayList<String>();
        for (DimensionCustomization customization : customizations) {
            String dropSql = "DROP TABLE IF EXISTS " + customization.getTableName();
            String createSql = "CREATE TABLE " + customization.getTableName() + " AS (SELECT apnr,druck,sortorder FROM dim_bp_apnr WHERE dimension_bp_id = (select D.tid from dimension_bp D where D.apnr='" + customization.getDimensionName() + "') AND apnr!=0) ORDER BY 1";
            String updateSortorderSql = "UPDATE " + customization.getTableName() + " SET sortorder = 99998 WHERE sortorder IS NULL";
            sql.add(dropSql);
            sql.add(createSql);
            sql.add(updateSortorderSql);
            for (Element level : customization.getLevels()) {
                String levelLongNameAlpha = SuperxDynamicSchemaProcessor.stringToLowerAlpha(level.getAttributeValue("name"));
                String addColumnSql = "ALTER TABLE " + customization.getTableName() + " ADD COLUMN " + levelLongNameAlpha + " VARCHAR(255)";
                sql.add(addColumnSql);
                String addSortColumnSql = "ALTER TABLE " + customization.getTableName() + " ADD COLUMN " + levelLongNameAlpha + "_sort INTEGER";
                sql.add(addSortColumnSql);
                sql.addAll(this.getLevelMappings(level, customization.getDimensionName(), levelLongNameAlpha, customization.getTableName()));
            }
        }
        return sql;
    }

    Document customizeSchema(Collection<DimensionCustomization> customizations) {
        for (DimensionCustomization customization : customizations) {
            Element dimension = customization.getDimension();
            Element attributes = dimension.getChild("Attributes");
            Element table = customization.getTable();
            if (table.getName().equals("Query")) {
                table.setName("Table");
                table.setAttribute(new Attribute("name", customization.getTableName()));
                table.removeContent();
            }
            Element hierarchies = new Element("Hierarchies");
            dimension.addContent((Content)hierarchies);
            for (Element level : customization.getLevels()) {
                String levelLongName = level.getAttributeValue("name");
                String levelLongNameAlpha = SuperxDynamicSchemaProcessor.stringToLowerAlpha(levelLongName);
                Element attribute = new Element("Attribute");
                attribute.setAttributes(Arrays.asList(new Attribute("name", levelLongName), new Attribute("caption", levelLongName), new Attribute("keyColumn", levelLongNameAlpha), new Attribute("orderByColumn", levelLongNameAlpha + "_sort")));
                attributes.addContent(0, (Content)attribute);
                XMLOutputter xmlOutputter = new XMLOutputter();
                xmlOutputter.setFormat(Format.getPrettyFormat());
                logger.debug((Object)("Adding new Attributes " + xmlOutputter.outputString(attributes)));
            }
        }
        return customizations.iterator().next().getSchemaDocument();
    }

    List<String> getLevelMappings(Element levelElement, String dimensionName, String levelLongNameAlpha, String tableName) {
        ArrayList<String> sql = new ArrayList<String>();
        List members = levelElement.getChildren("member");
        int sort = 0;
        for (Element member : members) {
            String memberName = member.getAttributeValue("name");
            logger.warn((Object)("Getting mapping for member " + memberName));
            Iterable mapping = Splitter.on((String)",").trimResults().omitEmptyStrings().split((CharSequence)member.getTextTrim());
            Object m = "";
            for (String apnr : mapping) {
                if (apnr.startsWith("\"") && apnr.endsWith("\"")) {
                    apnr = this.getApnrForSourceId(dimensionName, apnr.replaceAll("\"", ""));
                }
                m = (String)m + apnr + ",";
            }
            m = ((String)m).substring(0, ((String)m).length() - 1);
            String updateSql = "UPDATE " + tableName + " SET " + levelLongNameAlpha + "='" + memberName + "' WHERE apnr IN (" + (String)m + ")";
            sql.add(updateSql);
            String updateSortSql = "UPDATE " + tableName + " SET " + levelLongNameAlpha + "_sort=" + sort + " WHERE " + levelLongNameAlpha + " = '" + memberName + "'";
            sql.add(updateSortSql);
            ++sort;
        }
        String emptyMemberName = levelElement.getAttributeValue("emptyMember");
        if (emptyMemberName != null && !emptyMemberName.isEmpty()) {
            String updateSql = "UPDATE " + tableName + " SET " + levelLongNameAlpha + "='" + emptyMemberName + "' WHERE " + levelLongNameAlpha + " is null";
            sql.add(updateSql);
        }
        return sql;
    }

    private void execSql(List<String> sqlStatements) {
        for (String sql : sqlStatements) {
            logger.warn((Object)("EXEC: " + sql));
            this.jt.execute(sql);
        }
    }

    String getApnrForSourceId(String bluep, String sourceId) {
        String query = "SELECT apnr FROM trans_dim_bp_apnr WHERE sourcesystem_id='" + sourceId + "' AND dimension_bp_id=(select D.tid from dimension_bp D where D.apnr='" + bluep + "')";
        logger.debug((Object)query);
        String apnr = (String)this.jt.queryForObject(query, String.class);
        return apnr == null || apnr.isEmpty() ? sourceId : apnr;
    }

    public void setDataSource(DataSource ds) {
        this.jt = new JdbcTemplate(ds);
    }

    public static String stringToLowerAlpha(String s) {
        return s.toLowerCase().replaceAll("[^a-z]", "");
    }

    public static class DimensionCustomization {
        private Element dimension;
        private Element custDimension;
        private Element table;
        private String dimensionName;
        private String dimensionCaption;
        private String tableName;
        private List<Element> levels;

        public DimensionCustomization(Element dimension, Element custDimension) {
            this(custDimension);
            this.setDimension(dimension);
        }

        public DimensionCustomization(Element custDimension) {
            this.custDimension = custDimension;
            this.levels = custDimension.getChildren("level");
        }

        public void setDimension(Element dimension) {
            this.dimension = dimension;
            this.dimensionName = dimension.getAttributeValue("name");
            this.dimensionCaption = dimension.getAttributeValue("caption");
            this.tableName = "dim_" + this.dimensionName;
        }

        public Element getDimension() {
            return this.dimension;
        }

        public Element getCustomDimension() {
            return this.custDimension;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public String getDimensionCaption() {
            return this.dimensionCaption;
        }

        public String getTableName() {
            return this.tableName;
        }

        public List<Element> getLevels() {
            return this.levels;
        }

        public Document getSchemaDocument() {
            return this.dimension.getDocument();
        }

        public Element getTable() {
            return this.table;
        }

        public void setTable(Element table) {
            this.table = table;
        }
    }
}

