/*
 * Decompiled with CFR 0.152.
 */
package de.superx.saiku;

import com.google.common.base.Joiner;
import de.superx.common.SxUser;
import de.superx.saiku.SuperxSaikuSessionService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import mondrian.olap.Access;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.DelegatingRole;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.olap.SchemaReader;
import mondrian.olap4j.SaikuMondrianHelper;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapMember;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.saiku.datasources.connection.AbstractConnectionManager;
import org.saiku.datasources.connection.ISaikuConnection;
import org.saiku.datasources.connection.SaikuConnectionFactory;
import org.saiku.datasources.datasource.SaikuDatasource;
import org.saiku.olap.util.exception.SaikuOlapException;
import org.saiku.service.ISessionService;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class SuperxSaikuConnectionManager
extends AbstractConnectionManager {
    protected static Logger logger = Logger.getLogger(SuperxSaikuConnectionManager.class);
    public static final String SECURITY_TYPE_SUPERX = "superx";
    private static final long serialVersionUID = -5912836681963684201L;
    private Map<String, ISaikuConnection> connections = new HashMap<String, ISaikuConnection>();
    private List<String> errorConnections = new ArrayList<String>();
    private ISessionService sessionService;
    private DataSource dataSource;
    private boolean isShowFaecherForFachbereichUnbekannt;

    public void setSessionService(ISessionService ss) {
        this.sessionService = ss;
        ((SuperxSaikuSessionService)ss).setConnectionManager(this);
    }

    public void init() throws SaikuOlapException {
        logger.debug((Object)"INIT START");
        this.connections = this.getAllConnections();
        logger.debug((Object)"INIT FINISHED");
    }

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    protected ISaikuConnection getInternalConnection(String name, SaikuDatasource datasource) {
        logger.debug((Object)("Get internal connection " + name));
        ISaikuConnection con = null;
        if (this.isDatasourceSecurity(datasource, "passthrough") && this.sessionService != null) {
            datasource = this.handlePassThrough(datasource);
        }
        String newName = name;
        if (this.isDatasourceSecurityEnabled(datasource) && this.sessionService != null && (newName = this.getUserConnectionName(name)) == null) {
            logger.warn((Object)("Connection not authenticated: " + name));
            return null;
        }
        if (!this.connections.containsKey(newName)) {
            logger.debug((Object)("New name: " + newName));
            con = SuperxSaikuConnectionManager.connect(datasource);
            if (con != null) {
                if (!this.isDatasourceSecurity(datasource, "passthrough")) {
                    con = this.applySecurity(con, datasource);
                }
                this.connections.put(newName, con);
            } else if (!this.errorConnections.contains(newName)) {
                this.errorConnections.add(newName);
            }
        } else {
            con = this.connections.get(newName);
        }
        return con;
    }

    private String getUserConnectionName(String name) {
        String userConnectionName = null;
        Map session = this.sessionService.getAllSessionObjects();
        String username = (String)session.get("username");
        String useruuid = (String)session.get("useruuid");
        if (username != null && useruuid != null) {
            userConnectionName = name + "-" + username + "-" + useruuid;
        }
        return userConnectionName;
    }

    protected ISaikuConnection refreshInternalConnection(String name, SaikuDatasource datasource) {
        try {
            ISaikuConnection con;
            String newName = name;
            if (this.getUserConnectionName(name) != null) {
                newName = this.getUserConnectionName(name);
            }
            if ((con = this.connections.remove(newName)) != null) {
                con.clearCache();
            }
            con = null;
            return this.getInternalConnection(name, datasource);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void removeConnection(String name) {
        try {
            String newName = name;
            if (this.getUserConnectionName(name) != null) {
                newName = this.getUserConnectionName(name);
            }
            for (String key : this.connections.keySet()) {
                if (!key.equals(newName)) continue;
                ISaikuConnection con = this.connections.remove(key);
                if (con != null) {
                    con.clearCache();
                }
                con = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private SaikuDatasource handlePassThrough(SaikuDatasource datasource) {
        Map session = this.sessionService.getAllSessionObjects();
        String username = (String)session.get("username");
        if (username != null) {
            String password = (String)session.get("password");
            datasource.getProperties().setProperty("username", username);
            if (password != null) {
                datasource.getProperties().setProperty("password", password);
            }
            return datasource;
        }
        return null;
    }

    private ISaikuConnection applySecurity(ISaikuConnection con, SaikuDatasource datasource) {
        if (con == null) {
            throw new IllegalArgumentException("Cannot apply Security to NULL connection object");
        }
        if (this.isDatasourceSecurity(datasource, "one2one")) {
            List<String> springRoles = SuperxSaikuConnectionManager.getSpringRoles();
            List<String> conRoles = SuperxSaikuConnectionManager.getConnectionRoles(con);
            Object roleName = null;
            for (String sprRole : springRoles) {
                if (!conRoles.contains(sprRole)) continue;
                if (roleName == null) {
                    roleName = sprRole;
                    continue;
                }
                roleName = (String)roleName + "," + sprRole;
            }
            if (SuperxSaikuConnectionManager.setRole(con, roleName, datasource)) {
                return con;
            }
        } else if (this.isDatasourceSecurity(datasource, "lookup")) {
            Map<String, List<String>> mapping = SuperxSaikuConnectionManager.getRoleMapping(datasource);
            List<String> springRoles = SuperxSaikuConnectionManager.getSpringRoles();
            Object roleName = null;
            for (String sprRole : springRoles) {
                if (!mapping.containsKey(sprRole)) continue;
                List<String> roles = mapping.get(sprRole);
                for (String role : roles) {
                    if (roleName == null) {
                        roleName = role;
                        continue;
                    }
                    roleName = (String)roleName + "," + role;
                }
            }
            if (SuperxSaikuConnectionManager.setRole(con, roleName, datasource)) {
                return con;
            }
        } else if (this.isDatasourceSecurity(datasource, SECURITY_TYPE_SUPERX)) {
            logger.info((Object)"Security type superx");
            if (con.getDatasourceType().equals("OLAP") && con.getConnection() instanceof OlapConnection) {
                if (!this.isAdmin()) {
                    this.applySuperxSecurityWithDelegatingRoleOn(con);
                }
                return con;
            }
            return null;
        }
        return con;
    }

    private static boolean setRole(ISaikuConnection con, String roleName, SaikuDatasource datasource) {
        if (con.getConnection() instanceof OlapConnection) {
            OlapConnection c = (OlapConnection)con.getConnection();
            if (c == null) {
                return false;
            }
            System.out.println("Setting role to datasource:" + datasource.getName() + " role:" + roleName);
            try {
                if (StringUtils.isNotBlank((String)roleName) && SaikuMondrianHelper.isMondrianConnection((OlapConnection)c) && roleName.split(",").length > 1) {
                    SaikuMondrianHelper.setRoles((OlapConnection)c, (String[])roleName.split(","));
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    private static List<String> getSpringRoles() {
        ArrayList<String> roles = new ArrayList<String>();
        if (SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null) {
            Collection auths = SecurityContextHolder.getContext().getAuthentication().getAuthorities();
            for (GrantedAuthority a : auths) {
                roles.add(a.getAuthority());
            }
        }
        return roles;
    }

    private static List<String> getConnectionRoles(ISaikuConnection con) {
        if (con.getDatasourceType().equals("OLAP") && con.getConnection() instanceof OlapConnection) {
            OlapConnection c = (OlapConnection)con.getConnection();
            try {
                return c.getAvailableRoleNames();
            }
            catch (OlapException e) {
                e.printStackTrace();
            }
        }
        return new ArrayList<String>();
    }

    private static Map<String, List<String>> getRoleMapping(SaikuDatasource datasource) {
        String mappings;
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        if (datasource.getProperties().containsKey("security.mapping") && (mappings = datasource.getProperties().getProperty("security.mapping")) != null) {
            String[] maps;
            for (String map : maps = mappings.split(";")) {
                String[] m = map.split("=");
                if (m.length != 2) continue;
                if (!result.containsKey(m[0])) {
                    result.put(m[0], new ArrayList());
                }
                ((List)result.get(m[0])).add(m[1]);
            }
        }
        return result;
    }

    private static ISaikuConnection connect(SaikuDatasource datasource) {
        try {
            ISaikuConnection con = SaikuConnectionFactory.getConnection((SaikuDatasource)datasource);
            if (con.initialized()) {
                return con;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Collection<String> getAllowedFacttables(Integer userinfo_id) {
        if (userinfo_id == null) {
            return new ArrayList<String>(0);
        }
        final HashMap facttableTopicarea = new HashMap();
        JdbcTemplate eduetlJdbcTemplate = new JdbcTemplate(this.dataSource);
        eduetlJdbcTemplate.query("select name, sachgebiete_id::int from fact_table", new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                facttableTopicarea.put(rs.getString(1).trim(), rs.getInt(2));
            }
        });
        List userFacttable = eduetlJdbcTemplate.query("select name from fact_table where sachgebiete_id::integer in (select sachgebiete_id from user_sachgeb_bez where userinfo_id = ?) or sachgebiete_id::integer in (select GS.sachgebiete_id from group_sachgeb_bez GS, user_group_bez UG where UG.groupinfo_id=GS.groupinfo_id and UG.userinfo_id = ?)", new Object[]{userinfo_id, userinfo_id}, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(1).trim();
            }
        });
        return userFacttable.size() > 0 ? userFacttable : facttableTopicarea.keySet();
    }

    @Deprecated
    private Map<String, String> getAllowedOrgunits(Integer userinfo_id) {
        final HashMap<String, String> allowedOrgunits = new HashMap<String, String>();
        if (userinfo_id != null) {
            JdbcTemplate eduetlJdbcTemplate = new JdbcTemplate(this.dataSource);
            eduetlJdbcTemplate.query("select distinct io.apnr,io.uniquename,io.lid,o.name from implicit_orgunit_rights io left join organigramm o on io.apnr = o.key_apnr where io.userinfo_id=?", new Object[]{userinfo_id}, new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    String key_apnr = rs.getString("apnr");
                    String name = rs.getString("name");
                    if (key_apnr != null && name != null) {
                        allowedOrgunits.put(key_apnr.trim(), name.trim());
                    }
                }
            });
        }
        return allowedOrgunits;
    }

    private Set<String> getAllowedSubjectOfStudies(Set<String> orgunits) {
        final HashSet<String> allowedSubjectsOfStudy = new HashSet<String>();
        JdbcTemplate eduetlJdbcTemplate = new JdbcTemplate(this.dataSource);
        String query = "select trim(stg) from dim_studiengang where fb=?" + (this.isShowFaecherForFachbereichUnbekannt ? " or fb_str='Unbekannt'" : "");
        for (String orgunit : orgunits) {
            eduetlJdbcTemplate.query(query, new Object[]{orgunit}, new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    allowedSubjectsOfStudy.add(rs.getString(1).trim());
                }
            });
        }
        logger.info((Object)("****> get allowed subject of studies: " + Joiner.on((String)", ").join(allowedSubjectsOfStudy)));
        return allowedSubjectsOfStudy;
    }

    private Set<String> getAllowedCourseOfStudies(Collection<String> orgunits) {
        final HashSet<String> courseOfStudyText = new HashSet<String>();
        JdbcTemplate eduetlJdbcTemplate = new JdbcTemplate(this.dataSource);
        for (String orgunit : orgunits) {
            eduetlJdbcTemplate.query("select text from dim_studiengang where fb =?", new Object[]{orgunit}, new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    if (rs.getObject(1) != null) {
                        courseOfStudyText.add(rs.getString(1).trim());
                    }
                }
            });
        }
        if (this.isShowFaecherForFachbereichUnbekannt) {
            eduetlJdbcTemplate.query("select text from dim_studiengang where fb is null or fb_str = 'Unbekannt'", new Object[0], new RowCallbackHandler(){

                public void processRow(ResultSet rs) throws SQLException {
                    if (rs.getObject(1) != null) {
                        courseOfStudyText.add(rs.getString(1).trim());
                    }
                }
            });
        }
        courseOfStudyText.add("Alle");
        logger.info((Object)("****> get allowed course of studies: " + Joiner.on((String)", ").join(courseOfStudyText)));
        return courseOfStudyText;
    }

    private void applySuperxSecurityWithDelegatingRoleOn(ISaikuConnection con) {
        Dimension[] sharedDimensions;
        OlapConnection c = (OlapConnection)con.getConnection();
        Connection mondrianConnection = null;
        try {
            if (!SaikuMondrianHelper.isMondrianConnection((OlapConnection)c)) {
                throw new IllegalArgumentException("Connection has to wrap RolapConnection");
            }
            mondrianConnection = (Connection)c.unwrap(RolapConnection.class);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        RoleImpl role = ((RoleImpl)mondrianConnection.getRole()).makeMutableClone();
        List<Cube> cubes = Arrays.asList(mondrianConnection.getSchema().getCubes());
        Map session = this.sessionService.getAllSessionObjects();
        Integer userinfo_id = (Integer)session.get("userinfo_id");
        Collection<String> facttables = this.getAllowedFacttables(userinfo_id);
        SxUser user = null;
        Object userObject = SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        if (userObject instanceof SxUser) {
            user = (SxUser)userObject;
            if (!user.getHis1Rights().contains("RIGHT_CS_BIA_OLAP_CREATE_TABLES")) {
                throw new RuntimeException("Benutzer hat kein Recht Saiku zu verwenden!");
            }
        } else {
            throw new RuntimeException("Keine korrekte Authentifizierung - UserObjekt (SxUser) fehlt");
        }
        Set<String> allowedOrgUnits = user.getAllAllowedOrgUnitsForSaiku();
        System.out.println(user + " " + allowedOrgUnits + "mondrian connection:" + mondrianConnection);
        for (Cube cube : cubes) {
            if (facttables.contains(cube.getName())) {
                role.grant(cube, Access.ALL);
                continue;
            }
            if (cube.getName().startsWith("$")) continue;
            role.grant(cube, Access.NONE);
        }
        JdbcTemplate eduetlJdbcTemplate = new JdbcTemplate(this.dataSource);
        boolean dim_studiengang_exists = (Integer)eduetlJdbcTemplate.queryForObject("select count(*) from sx_tables where name='dim_studiengang'", Integer.class) > 0;
        boolean showFaecherForFachbereichUnbekannt = (Integer)eduetlJdbcTemplate.queryForObject("select apnr from konstanten where beschreibung='OLAP Fachbereichzuordnung unbekannt'", Integer.class) > 0;
        this.isShowFaecherForFachbereichUnbekannt = showFaecherForFachbereichUnbekannt || user.hasAllOrgUnitRights();
        HashSet<String> courseOfStudy = new HashSet();
        HashSet<String> subjectOfStudy = new HashSet();
        if (dim_studiengang_exists) {
            courseOfStudy = this.getAllowedCourseOfStudies(allowedOrgUnits);
            subjectOfStudy = this.getAllowedSubjectOfStudies(allowedOrgUnits);
        } else {
            logger.warn((Object)"Table dim_studiengang doesn't exist - cannot find allowed course of studys! Is sos installed?");
        }
        Role.RollupPolicy rollupPolicy = (Role.RollupPolicy)eduetlJdbcTemplate.query("select apnr from konstanten where beschreibung='OLAP Partielles Rollup'", (ResultSetExtractor)new ResultSetExtractor<Role.RollupPolicy>(){

            public Role.RollupPolicy extractData(ResultSet rs) throws SQLException, DataAccessException {
                int apnr;
                Role.RollupPolicy result = Role.RollupPolicy.FULL;
                if (rs.next() && (apnr = rs.getInt(1)) != 0) {
                    result = Role.RollupPolicy.PARTIAL;
                }
                return result;
            }
        });
        logger.debug((Object)("Rollup Policy: " + rollupPolicy.name()));
        HashMap<String, Set<Member>> hierarchies = new HashMap<String, Set<Member>>();
        SchemaReader reader = mondrianConnection.getSchemaReader().withLocus();
        block10: for (Dimension dimension : sharedDimensions = reader.getSchema().getSharedDimensions()) {
            Hierarchy hierarchy = dimension.getHierarchy();
            String hierarchyName = hierarchy.getName();
            switch (OlapDimension.getOlapDimensionForLevelName(hierarchyName)) {
                case fachbereich: {
                    hierarchies.put(hierarchyName, this.getAllowedMembers(reader, hierarchy, allowedOrgUnits));
                    continue block10;
                }
                case studiengang: {
                    hierarchies.put(hierarchyName, this.getAllowedMembers(reader, hierarchy, courseOfStudy));
                    continue block10;
                }
                case institut: {
                    hierarchies.put(hierarchyName, this.getAllowedMembers(reader, hierarchy, allowedOrgUnits));
                    continue block10;
                }
                case kostenstelle: {
                    hierarchies.put(hierarchyName, this.getAllowedMembers(reader, hierarchy, allowedOrgUnits));
                    continue block10;
                }
                case studienfach: {
                    hierarchies.put(hierarchyName, this.getAllowedMembers(reader, hierarchy, subjectOfStudy));
                }
            }
        }
        role.makeImmutable();
        SuperxRole delegatingRole = new SuperxRole((Role)role, hierarchies, rollupPolicy);
        logger.info((Object)"Set superx role");
        mondrianConnection.setRole((Role)delegatingRole);
    }

    private Set<Member> getAllowedMembers(SchemaReader reader, Hierarchy hierarchy, Set<String> allowedMemberIds) {
        HashSet<Member> allowedMembers = new HashSet<Member>();
        List levels = reader.getHierarchyLevels(hierarchy);
        for (Level level : levels) {
            String levelName = level.getName();
            if (!levelName.equals(hierarchy.getName())) continue;
            List members = reader.getLevelMembers(level, false);
            for (Member member : members) {
                if (member.isAll()) continue;
                String name = member.getName();
                boolean isAllowedMember = false;
                if (name.toLowerCase().contains("nicht zugeordnet") || name.toLowerCase().contains("leer") || name.toLowerCase().contains("unbekannt")) {
                    isAllowedMember = true;
                } else if (levelName.equals(OlapDimension.fachbereich.levelName) || levelName.equals(OlapDimension.institut.levelName) || levelName.equals(OlapDimension.kostenstelle.levelName)) {
                    id = (Integer)((RolapMember)member).getKey();
                    String uniqueName = this.getUniqueNameFor(OlapDimension.getBluepForLevelName(levelName), id);
                    isAllowedMember = uniqueName == null || allowedMemberIds.contains(uniqueName);
                } else {
                    String stg;
                    isAllowedMember = levelName.equals(OlapDimension.studienfach.levelName) ? allowedMemberIds.contains(stg = this.getStgFor(id = (Integer)((RolapMember)member).getKey())) || stg == null : allowedMemberIds.contains(name);
                }
                if (!isAllowedMember) continue;
                allowedMembers.add(member);
                for (Member parent = member.getParentMember(); parent != null; parent = parent.getParentMember()) {
                    allowedMembers.add(parent);
                }
            }
        }
        return allowedMembers;
    }

    private String getUniqueNameFor(String bluep, Integer id) {
        JdbcTemplate eduetlJdbcTemplate = new JdbcTemplate(this.dataSource);
        return (String)eduetlJdbcTemplate.queryForObject("select trim(uniquename) from dim_bp_apnr where dimension_bp_id=(select tid from dimension_bp where apnr=?) and apnr=?", new Object[]{bluep, id}, String.class);
    }

    private String getStgFor(Integer id) {
        JdbcTemplate eduetlJdbcTemplate = new JdbcTemplate(this.dataSource);
        return (String)eduetlJdbcTemplate.queryForObject("select trim(stg) from dim_stg where apnr=?", new Object[]{id}, String.class);
    }

    private boolean isAdmin() {
        Map sessObjs = this.sessionService.getAllSessionObjects();
        assert (sessObjs != null);
        Set rights = (Set)sessObjs.get("rights");
        assert (rights != null);
        return rights.contains("RIGHT_CS_BIA_STANDARDREPORTS_ADMIN");
    }

    public static enum OlapDimension {
        fachbereich("[bluep_fb].[Fachbereich]", "Fachbereich", "bluep_fb"),
        studiengang("[bluep_studiengang].[Studiengang]", "Studiengang", "bluep_studiengang"),
        lehreinheit("[bluep_lehr].[Lehreinheit (intern)]", "Lehreinheit (intern)", "bluep_lehr"),
        institut("[bluep_ch110_institut].[Institution]", "Institution", "bluep_ch110_institut"),
        kostenstelle("[bluep_kostenstelle].[Kostenstelle]", "Kostenstelle", "bluep_kostenstelle"),
        studienfach("[bluep_stg].[Fach]", "Studienfach", "bluep_stg"),
        undefined("", "", "");

        public final String nameSegment;
        public final String levelName;
        public final String bluep;

        private OlapDimension(String nameSegment, String levelName, String bluep) {
            this.nameSegment = nameSegment;
            this.levelName = levelName;
            this.bluep = bluep;
        }

        public static String getBluepForLevelName(String levelName) {
            String bluep = null;
            for (OlapDimension olapDimension : OlapDimension.values()) {
                if (!olapDimension.levelName.equals(levelName)) continue;
                bluep = olapDimension.bluep;
                break;
            }
            return bluep;
        }

        public static OlapDimension getOlapDimensionForLevelName(String levelName) {
            for (OlapDimension olapDimension : OlapDimension.values()) {
                if (!olapDimension.levelName.equals(levelName)) continue;
                return olapDimension;
            }
            return undefined;
        }
    }

    class SuperxRole
    extends DelegatingRole {
        private Map<String, Set<Member>> hierarchies;
        private Role.RollupPolicy rollupPolicy;
        private Map<Hierarchy, Role.HierarchyAccess> grantedHierarchies;

        public SuperxRole(Role role, Map<String, Set<Member>> hierarchies, Role.RollupPolicy rollupPolicy) {
            super(role);
            this.grantedHierarchies = new HashMap<Hierarchy, Role.HierarchyAccess>();
            this.hierarchies = hierarchies;
            this.rollupPolicy = rollupPolicy;
        }

        public Access getAccess(Hierarchy hierarchy) {
            String name = hierarchy.getName();
            if (this.hierarchies.keySet().contains(name)) {
                return Access.CUSTOM;
            }
            return this.role.getAccess(hierarchy);
        }

        public Role.HierarchyAccess getAccessDetails(Hierarchy hierarchy) {
            Role.HierarchyAccess hierAccess = this.getHierarchyAccess(hierarchy);
            if (hierAccess == null) {
                hierAccess = this.role.getAccessDetails(hierarchy);
            }
            return hierAccess;
        }

        public Access getAccess(Member member) {
            Hierarchy hierarchy = member.getHierarchy();
            Role.HierarchyAccess hierAccess = this.getHierarchyAccess(hierarchy);
            if (hierAccess != null) {
                return hierAccess.getAccess(member);
            }
            return this.role.getAccess(member);
        }

        private Role.HierarchyAccess getHierarchyAccess(Hierarchy hierarchy) {
            String name = hierarchy.getName();
            if (this.hierarchies.keySet().contains(name)) {
                if (!this.grantedHierarchies.containsKey(hierarchy)) {
                    this.grantedHierarchies.put(hierarchy, new SuperxHierarchyAccess(hierarchy, this.hierarchies.get(name)));
                }
                return this.grantedHierarchies.get(hierarchy);
            }
            return null;
        }

        private boolean checkLevelIsOkWithRestrictions(SuperxHierarchyAccess hierarchyAccess, Level level) {
            if (level.getDepth() < hierarchyAccess.topLevel.getDepth()) {
                return false;
            }
            return level.getDepth() <= hierarchyAccess.bottomLevel.getDepth();
        }

        public class SuperxHierarchyAccess
        implements Role.HierarchyAccess {
            private Set<Member> allowedMembers;
            private Level topLevel;
            private Level bottomLevel;

            public SuperxHierarchyAccess(Hierarchy hierarchy, Set<Member> allowedMembers) {
                Level[] levels = hierarchy.getLevels();
                this.topLevel = levels[0];
                this.bottomLevel = levels[levels.length - 1];
                this.allowedMembers = allowedMembers;
            }

            public Access getAccess(Member member) {
                Level level = member.getLevel();
                String memberName = member.getName();
                if (level == this.bottomLevel) {
                    if (this.allowedMembers.contains(member) || memberName.equals("Alle")) {
                        return Access.ALL;
                    }
                } else if (this.allowedMembers.contains(member)) {
                    if (member.isAll() || memberName.equals("Alle")) {
                        return Access.CUSTOM;
                    }
                    return Access.ALL;
                }
                return Access.NONE;
            }

            public int getBottomLevelDepth() {
                return this.bottomLevel.getDepth();
            }

            public Role.RollupPolicy getRollupPolicy() {
                return SuperxRole.this.rollupPolicy;
            }

            public int getTopLevelDepth() {
                return this.topLevel.getDepth();
            }

            public boolean hasInaccessibleDescendants(Member arg0) {
                return false;
            }
        }
    }
}

