/*
 * Decompiled with CFR 0.152.
 */
package de.superx.saiku;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SuperxAuthenticationProvider
implements AuthenticationProvider {
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();
    public static Logger logger = Logger.getLogger(SuperxAuthenticationProvider.class);
    @Autowired
    SecurityContextRepository securityContextRepository;

    public boolean supports(Class<? extends Object> authentication) {
        return PreAuthenticatedAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (authentication.getPrincipal() == null) {
            throw new BadCredentialsException("No pre-authenticated principal found in request.");
        }
        if (authentication.getCredentials() == null) {
            throw new BadCredentialsException("No pre-authenticated credentials found in request.");
        }
        UserDetails ud = (UserDetails)authentication.getPrincipal();
        this.userDetailsChecker.check(ud);
        PreAuthenticatedAuthenticationToken result = new PreAuthenticatedAuthenticationToken((Object)ud, authentication.getCredentials(), ud.getAuthorities());
        result.setDetails(authentication.getPrincipal());
        logger.debug((Object)("AUTH: " + result));
        SecurityContext securityContext = SecurityContextHolder.createEmptyContext();
        securityContext.setAuthentication((Authentication)result);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
        ServletRequestAttributes attrs = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attrs.getRequest();
        HttpServletResponse response = attrs.getResponse();
        this.securityContextRepository.saveContext(securityContext, request, response);
        return result;
    }

    public void setSecurityContextRepository(SecurityContextRepository securityContextRepository) {
        this.securityContextRepository = securityContextRepository;
    }
}

