/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest.model.job;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.superx.spring.batch.job.JobUtils;
import de.superx.spring.batch.util.StepCounter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.item.ExecutionContext;

public class StepExecutionStatus {
    private String name;
    private Date startTime;
    private Date endTime;
    private long duration;
    private int inputRows;
    private int outputRows;
    private int stepsInternal = 0;
    private ExitStatus exitStatus;
    boolean isJob = false;
    private List<StepExecutionStatus> children;

    public StepExecutionStatus(StepExecution stepExecution, JobExplorer jobExplorer, StepCounter stepCounter) {
        JobExecution jobExecution;
        ExecutionContext context = stepExecution.getExecutionContext();
        this.name = stepExecution.getStepName();
        this.startTime = JobUtils.convertLocalDateToDate(stepExecution.getStartTime());
        this.endTime = JobUtils.convertLocalDateToDate(stepExecution.getEndTime());
        this.inputRows = (int)stepExecution.getReadCount();
        this.outputRows = (int)stepExecution.getWriteCount();
        if (this.endTime != null) {
            this.duration = this.endTime.getTime() - this.startTime.getTime();
        }
        if ((jobExecution = StepExecutionStatus.getJobExecution(stepExecution, jobExplorer)) != null) {
            this.isJob = true;
            this.exitStatus = new ExitStatus(jobExecution.getExitStatus().getExitCode());
            this.children = this.getChildren(jobExecution, jobExplorer, stepCounter);
        } else {
            this.exitStatus = stepExecution.getExitStatus();
            if (context.containsKey("stepsInternal")) {
                this.stepsInternal = context.getInt("stepsInternal");
                stepCounter.increment(1);
            } else {
                stepCounter.increment(1);
            }
            this.exitStatus = stepExecution.getExitStatus();
        }
    }

    @JsonCreator
    public StepExecutionStatus(@JsonProperty(value="exitCode") String name, @JsonProperty(value="startTime") Date startTime, @JsonProperty(value="endTime") Date endTime, @JsonProperty(value="duration") long duration, @JsonProperty(value="inputRows") int inputRows, @JsonProperty(value="outputRows") int outputRows, @JsonProperty(value="stepsInternal") int stepsInternal, @JsonProperty(value="exitStatus") ExitStatus exitStatus, @JsonProperty(value="isJob") boolean isJob, @JsonProperty(value="children") List<StepExecutionStatus> children) {
        this.name = name;
        this.startTime = startTime;
        this.endTime = endTime;
        this.duration = duration;
        this.inputRows = inputRows;
        this.outputRows = outputRows;
        this.stepsInternal = stepsInternal;
        this.exitStatus = exitStatus;
        this.isJob = isJob;
        this.children = children;
    }

    public String getName() {
        return this.name;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public int getInputRows() {
        return this.inputRows;
    }

    public int getOutputRows() {
        return this.outputRows;
    }

    public int getStepsInternal() {
        return this.stepsInternal;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public List<StepExecutionStatus> getChildren() {
        return this.children;
    }

    private static JobExecution getJobExecution(StepExecution jobStepExecution, JobExplorer jobExplorer) {
        String stepName = jobStepExecution.getStepName();
        List jobInstances = jobExplorer.findJobInstancesByJobName(stepName, 0, 1);
        if (jobInstances.size() > 0) {
            JobInstance jobInstance = (JobInstance)jobInstances.get(0);
            JobExecution result = (JobExecution)jobExplorer.getJobExecutions(jobInstance).get(0);
            return result;
        }
        return null;
    }

    private List<StepExecutionStatus> getChildren(JobExecution jobExecution, JobExplorer jobExplorer, StepCounter stepCounter) {
        ArrayList<StepExecutionStatus> result = new ArrayList<StepExecutionStatus>();
        Collection stepExecutions = jobExecution.getStepExecutions();
        stepExecutions.forEach(stepExecution -> {
            StepExecutionStatus se = new StepExecutionStatus((StepExecution)stepExecution, jobExplorer, stepCounter);
            if (se.exitStatus.getExitCode().equals("FAILED")) {
                this.exitStatus = ExitStatus.FAILED;
            }
            result.add(se);
        });
        return result;
    }
}

