/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest.model.job;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.superx.rest.model.job.StepExecutionStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;

public class JobExecutionStatus {
    public Long jobExecutionId;
    public String name;
    public Long totalStepsCount;
    public Long executedStepsCount = 0L;
    public Long duration;
    public Date startTime;
    public Date endTime;
    public BatchStatus status;
    public ExitStatus exitStatus;
    private List<StepExecutionStatus> stepExecutions;
    public String log;

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof JobExecutionStatus) {
            JobExecutionStatus s = (JobExecutionStatus)obj;
            boolean id = this.jobExecutionId.equals(s.jobExecutionId);
            boolean totalCount = this.totalStepsCount.equals(s.totalStepsCount);
            boolean start = true;
            boolean end = true;
            boolean count = this.executedStepsCount.equals(s.executedStepsCount);
            boolean estatus = this.exitStatus.equals((Object)s.exitStatus);
            result = id && count && totalCount && start && end & estatus;
        }
        return result;
    }

    public JobExecutionStatus() {
    }

    @JsonCreator
    public JobExecutionStatus(@JsonProperty(value="jobExecutionId") Long jobExecutionId, @JsonProperty(value="name") String name, @JsonProperty(value="totalStepsCount") Long totalStepsCount, @JsonProperty(value="executedStepsCount") Long executedStepsCount, @JsonProperty(value="duration") Long duration, @JsonProperty(value="startTime") Date startTime, @JsonProperty(value="endTime") Date endTime, @JsonProperty(value="status") BatchStatus status, @JsonProperty(value="exitStatus") ExitStatus exitStatus, @JsonProperty(value="stepExecutions") List<StepExecutionStatus> stepExecutions, @JsonProperty(value="log") String log) {
        this.jobExecutionId = jobExecutionId;
        this.name = name;
        this.totalStepsCount = totalStepsCount;
        this.executedStepsCount = executedStepsCount;
        this.duration = duration;
        this.startTime = startTime;
        this.endTime = endTime;
        this.status = status;
        this.exitStatus = exitStatus;
        this.stepExecutions = stepExecutions;
        this.log = log;
    }

    public void setStepExecutions(List<StepExecutionStatus> status) {
        this.stepExecutions = status;
        for (StepExecutionStatus s : status) {
            if (!s.getExitStatus().getExitCode().equals("FAILED") || !this.exitStatus.getExitCode().equals("COMPLETED")) continue;
            this.exitStatus = ExitStatus.FAILED;
        }
    }

    public List<StepExecutionStatus> getStepExecutions() {
        return this.stepExecutions;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public static List<StepExecutionStatus> getFailedStepExecutionStatus(List<StepExecutionStatus> stepExecutionStatus) {
        ArrayList<StepExecutionStatus> result = new ArrayList<StepExecutionStatus>();
        for (StepExecutionStatus status : stepExecutionStatus) {
            if (!status.getExitStatus().getExitCode().equals("FAILED")) continue;
            result.add(status);
            List<StepExecutionStatus> children = status.getChildren();
            if (children == null || children.size() <= 0) continue;
            result.addAll(JobExecutionStatus.getFailedStepExecutionStatus(status.getChildren()));
        }
        return result;
    }
}

