/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest.model;

import de.superx.common.Field;
import java.util.HashMap;
import java.util.Map;

public enum FieldType {
    Text(0),
    Select(1),
    MultiSelect(2),
    TreeSelect_Institution_Person(4),
    Label(8),
    Checkbox(10),
    Password(11),
    TreeSelect(12),
    DatePicker(14),
    TextArea(16),
    RadioButton(17),
    HLine(20),
    DateRange(21),
    Comment(5),
    TreeView(9),
    HiddenField(13),
    Anchor(18),
    FileUpload(19),
    Form(20),
    None(21),
    Unassigned(22),
    CurrentlyUnknown_999(999);

    private int value;
    private static final Map<Integer, FieldType> TYPES;

    private FieldType(int value) {
        this.value = value;
    }

    public static FieldType getCorrectedFieldType(Field field) {
        FieldType fieldType = FieldType.getByValue(field.getArt());
        if (FieldType.checkMultiSelectCriteria(fieldType, field)) {
            fieldType = MultiSelect;
        } else if (fieldType == Text && field.getTyp() == Field.Typ.typ_date) {
            fieldType = DatePicker;
        } else if (fieldType == Text && field.getZeilenanzahl() > 1) {
            fieldType = TextArea;
        } else if (fieldType == Label && field.getName().contains("##")) {
            fieldType = HLine;
        } else if (fieldType == TreeSelect_Institution_Person) {
            fieldType = TreeSelect;
        } else if (fieldType == HiddenField) {
            fieldType = "tablestylesheet".equals(field.getName()) ? Select : HiddenField;
        }
        return fieldType;
    }

    private static boolean checkMultiSelectCriteria(FieldType fieldType, Field field) {
        boolean result = true;
        result &= fieldType == Select;
        result &= !field.isObligatorisch();
        result &= field.getZeilenanzahl() > 1;
        Field.Typ typ = field.getTyp();
        return result &= typ == Field.Typ.typ_char || typ == Field.Typ.typ_integer || typ == Field.Typ.typ_decimal;
    }

    public static FieldType getByValue(Field.Art value) {
        if (value == Field.Art.id_6_Institutionsdialog_fuer_Lehreinheiten || value == Field.Art.id_7_Institutionsdialog_fuer_Lehreinheiten_ohne_Einschr_Userrechte) {
            return TYPES.get(4);
        }
        if (!TYPES.containsKey(value.getIntValue())) {
            throw new IllegalArgumentException("No FieldType implemented for value " + value);
        }
        return TYPES.get(value.getIntValue());
    }

    public int getValue() {
        return this.value;
    }

    static {
        TYPES = new HashMap<Integer, FieldType>();
        for (FieldType type : FieldType.values()) {
            TYPES.put(type.getValue(), type);
        }
    }
}

