/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest.model;

import de.superx.rest.model.format.CustomDateFormat;
import de.superx.rest.model.format.CustomFormat;
import de.superx.rest.model.format.DetailFormat;
import de.superx.rest.model.format.EditFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public enum ColumnType {
    DecimalColumn(3),
    IntegerColumn(4),
    BooleanColumn(7),
    DateColumn(6, new CustomDateFormat("dd.MM.yyyy")),
    TimestampColumn(8, new CustomDateFormat("dd.MM.yyyy HH:mm:ss.SSSSSX")),
    TimeColumn(9, new CustomDateFormat("HH:mm:ss")),
    StringColumn(1),
    DetailColumn(10, new DetailFormat()),
    EditColumn(11, new EditFormat()),
    DocumentationColumn(12),
    SortOrderColumn(13),
    HierarchyLevelColumn(14);

    private static Logger logger;
    private static final Map<Integer, ColumnType> TYPES;
    private int value;
    private CustomFormat format;

    private ColumnType(int value) {
        this.value = value;
    }

    private ColumnType(int value, CustomFormat format) {
        this.value = value;
        this.format = format;
    }

    public int getValue() {
        return this.value;
    }

    public Object formatValue(Object val) {
        Object result = val;
        if (val != null && this.format != null) {
            try {
                result = this.format.format(val);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)("Couldn't format value " + val + " as " + this.format), (Throwable)e);
            }
        }
        return result;
    }

    public static ColumnType[] getColumnTypes(int[] values, String[] columnNames) {
        ColumnType[] result = new ColumnType[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = ColumnType.getColumnType(values[i], columnNames[i]);
        }
        return result;
    }

    private static ColumnType getColumnType(int value, String name) {
        if (ColumnType.isDetailColumn(name)) {
            return DetailColumn;
        }
        if (ColumnType.isEditColumn(name)) {
            return EditColumn;
        }
        return TYPES.get(value);
    }

    private static boolean isDetailColumn(String name) {
        return name.startsWith(DetailType.nexttable.value) || name.startsWith(DetailType.nextwindowtable.value) || name.startsWith(DetailType.nextpage.value) || name.startsWith(DetailType.nextmask.value);
    }

    private static boolean isEditColumn(String name) {
        return name.startsWith(EditType.nextedit.value);
    }

    static {
        logger = Logger.getLogger(ColumnType.class);
        TYPES = new HashMap<Integer, ColumnType>();
        for (ColumnType type : ColumnType.values()) {
            TYPES.put(type.getValue(), type);
        }
    }

    private static enum DetailType {
        nexttable("nexttable"),
        nextwindowtable("nextwindowtable"),
        nextpage("nextpage"),
        nextmask("nextmask");

        public String value;

        private DetailType(String value) {
            this.value = value;
        }
    }

    private static enum EditType {
        nextedit("nextedit");

        public String value;

        private EditType(String value) {
            this.value = value;
        }
    }
}

