/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest.config;

import de.superx.common.UngueltigeEingabeException;
import de.superx.rest.config.ValueFormatTool;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WordListFormatTool
extends ValueFormatTool {
    private static String LETTER = "\\p{gc=L}";
    private static String DECIMAL = "\\p{gc=Nd}";
    private static String SEPARATOR = "\\p{gc=Z}";

    @Override
    public String escapeForFormular(String inputValue) throws UngueltigeEingabeException {
        if (!this.confirmFormat(inputValue)) {
            throw new UngueltigeEingabeException("expected word list format");
        }
        return WordListFormatTool.addQuotes(inputValue);
    }

    @Override
    public boolean confirmFormat(String input) {
        String[] values;
        if (input == null || input.isEmpty()) {
            return true;
        }
        Pattern word_format = Pattern.compile("\\A[" + LETTER + DECIMAL + SEPARATOR + "\\.:,\\-\\_/\\n\\r\\^()]+\\z");
        for (String value : values = input.split(",")) {
            Matcher matcher = word_format.matcher(value);
            if (value == "" || value.equals("?") || matcher.matches()) continue;
            return false;
        }
        return true;
    }
}

