/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest;

import de.memtext.util.FileUtils;
import de.superx.common.SxUser;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxSQL_Server;
import de.superx.util.PathAndFileUtils;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.net.URISyntaxException;
import javax.ws.rs.core.Context;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/logs"})
public class LogsProvider {
    @RequestMapping(path={"/{logtype}"}, method={RequestMethod.GET})
    public String printLogs(@PathVariable(value="logtype") String logtype, @RequestParam(value="loglines") Integer loglines, @Context HttpServletRequest httpRequest) {
        String mandantenid;
        String returntext = "";
        SxUser user = (SxUser)httpRequest.getSession().getAttribute("user");
        Object mandantobject = httpRequest.getSession().getAttribute("MandantenID");
        String string = mandantenid = mandantobject != null ? mandantobject.toString() : SxSQL_Server.DEFAULT_MANDANTEN_ID;
        returntext = user == null || !user.isAdmin() ? "Fehlende Rechte" : (logtype.equals("activity") || logtype.equals("fmsql") || logtype.equals("sql") || logtype.equals("xml") ? this.getMaskLogs(mandantenid, logtype) : this.getTomcatLogs(mandantenid, logtype, loglines));
        return returntext;
    }

    private String getMaskLogs(String mandantenid, String logtype) {
        Object logString;
        if (mandantenid.equalsIgnoreCase(SuperXManager.getLastMaskenSqlMandantid())) {
            switch (logtype) {
                case "activity": {
                    logString = SuperXManager.activityLog.toString().replace("<br>", "\n");
                    break;
                }
                case "fmsql": {
                    logString = SuperXManager.getLastFMMaskenSql();
                    break;
                }
                case "sql": {
                    logString = SuperXManager.getLastMaskenSql();
                    break;
                }
                case "xml": {
                    logString = SuperXManager.getLastXml();
                    break;
                }
                default: {
                    logString = "Protokoll " + logtype + " kann nicht gelesen werden";
                    break;
                }
            }
        } else {
            logString = "Bitte wiederholen Sie den Aufruf mit dem jew. Mandant";
        }
        return logString;
    }

    private String getTomcatLogs(String mandantenid, String logtype, Integer loglines) {
        Object logFilePath = "";
        if (loglines == null) {
            loglines = 100;
        }
        try {
            logFilePath = PathAndFileUtils.getWebinfDirectory();
        }
        catch (URISyntaxException e1) {
            logFilePath = System.getProperty("catalina.base");
        }
        switch (logtype) {
            case "serverlog": {
                logFilePath = (String)logFilePath + File.separator + "logs" + File.separator + "superx.log";
                break;
            }
            case "serverlogsql": {
                logFilePath = (String)logFilePath + File.separator + "logs" + File.separator + "superx_" + mandantenid + ".log";
                break;
            }
            case "serverlogxml": {
                logFilePath = (String)logFilePath + File.separator + "logs" + File.separator + "superx_" + mandantenid + "_xml.log";
                break;
            }
            default: {
                throw new RuntimeException("Logtype " + logtype + " not supported!");
            }
        }
        Object logString = "Protokoll " + (String)logFilePath + " kann nicht gelesen werden";
        File logfile = new File((String)logFilePath);
        if (logfile.exists()) {
            try {
                logString = FileUtils.tail(logfile, loglines);
            }
            catch (Exception e) {
                logString = (String)logString + ": " + e.toString();
            }
        }
        return logString;
    }
}

