/*
 * Decompiled with CFR 0.152.
 */
package de.superx.rest;

import de.superx.jdbc.entity.kenn.ReportStichtagsart;
import de.superx.jdbc.entity.kenn.Stichtag;
import de.superx.jdbc.entity.kennx.Lieferfreigabe;
import de.superx.jdbc.entity.kennx.LieferfreigabeFilter;
import de.superx.jdbc.entity.kennx.LieferfreigabeHs;
import de.superx.jdbc.entity.kennx.LieferfreigabeStichtagsart;
import de.superx.jdbc.entity.kennx.LieferfreigabeStichtagsartBezugszeit;
import de.superx.jdbc.repository.kenn.StichtagRepository;
import de.superx.jdbc.repository.kennx.LieferfreigabeFilterRepository;
import de.superx.jdbc.repository.kennx.LieferfreigabeRepository;
import de.superx.rest.InputValidationError;
import de.superx.rest.RestControllerBase;
import de.superx.rest.model.kenn.Report;
import de.superx.spring.service.UserService;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/kenn-config"})
public class KennConfigApi
extends RestControllerBase {
    static Logger logger = Logger.getLogger(KennConfigApi.class);
    @Autowired
    DataSource dataSource;
    @Autowired
    LieferfreigabeRepository kennxLieferfreigabeRepository;
    @Autowired
    StichtagRepository stichtagRepository;
    @Autowired
    LieferfreigabeFilterRepository kennxLieferfreigabeFilterRepository;
    @Autowired
    PlatformTransactionManager transactionManager;
    @Autowired
    UserService userService;

    @Override
    protected Logger getLogger() {
        return logger;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/stichtage"})
    public List<Stichtag> getStichtageConfig() {
        this.userService.checkStichtageRights();
        List<Stichtag> stichtage = this.stichtagRepository.findAllByOrderByStichtagsartAscBezugszeitAsc();
        return stichtage;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/stichtage"})
    public Boolean saveStichtageConfig(@RequestBody List<Stichtag> stichtage) {
        this.userService.checkStichtageRights();
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        TransactionStatus transaction = this.transactionManager.getTransaction(null);
        try {
            for (Stichtag stichtag : stichtage) {
                KennConfigApi.validateNoOverwriting(stichtag.tid);
                KennConfigApi.validateStichtagIntegrity(jt, stichtag);
                stichtag.tid = this.getStichtagId(stichtag);
                Stichtag n = (Stichtag)this.stichtagRepository.save(stichtag);
                if (n.tid != null) continue;
                throw new RuntimeException("Couldn't save");
            }
            this.transactionManager.commit(transaction);
        }
        catch (InputValidationError err) {
            this.transactionManager.rollback(transaction);
            logger.error((Object)"Could not save Stichtage", (Throwable)err);
            throw err;
        }
        catch (Exception e) {
            this.transactionManager.rollback(transaction);
            logger.error((Object)"Could not save Stichtage", (Throwable)e);
            throw new RuntimeException("Could not save Stichtage");
        }
        return Boolean.TRUE;
    }

    private Integer getStichtagId(Stichtag stichtag) {
        List<Stichtag> stichtage = this.getStichtageConfig();
        int stichtagsIndex = KennConfigApi.indexOfStichtag(stichtage, stichtag);
        if (stichtagsIndex != -1) {
            return stichtage.get((int)stichtagsIndex).tid;
        }
        return null;
    }

    public static int indexOfStichtag(List<Stichtag> stichtage, Stichtag stichtag) {
        for (int i = 0; i < stichtage.size(); ++i) {
            if (!stichtage.get((int)i).bezugszeit.equals(stichtag.bezugszeit) || !stichtage.get((int)i).stichtagsart_id.trim().equals(stichtag.stichtagsart_id.trim())) continue;
            return i;
        }
        return -1;
    }

    private static void validateStichtagIntegrity(JdbcTemplate jt, Stichtag stichtag) {
        Object[] args = new Object[]{stichtag.stichtagsart_id};
        int[] typesArg = new int[]{1};
        SqlRowSet bezugsartRs = jt.queryForRowSet("SELECT bezugsart, druck AS stichtagsart, datum_wird_ausgewertet FROM kenn_stichtagsart WHERE apnr = ? AND aktiv = '1';", args, typesArg);
        if (!bezugsartRs.last() || bezugsartRs.getRow() != 1) {
            throw new InputValidationError("Konnte keine (eindeutige) Bezugsart f\u00fcr Stichtagsart '" + stichtag.stichtagsart_id + "' finden");
        }
        int datumWirdAusgewertet = bezugsartRs.getInt("datum_wird_ausgewertet");
        if (datumWirdAusgewertet == 1 && stichtag.stichtag == null) {
            throw new InputValidationError("F\u00fcr die Stichtagsart '" + stichtag.stichtagsart_id + "' ist ein Datum zwingend erforderlich.");
        }
        String bezugsartLookup = bezugsartRs.getString("bezugsart");
        if (stichtag.bezugsart == null) {
            stichtag.bezugsart = bezugsartLookup;
        } else if (!bezugsartLookup.equals(stichtag.bezugsart)) {
            throw new InputValidationError("Bezugsart '" + stichtag.bezugsart + "' ist ung\u00fcltig f\u00fcr Stichtagsart '" + stichtag.stichtagsart_id + "'");
        }
        if (stichtag.bezugszeit != null && !stichtag.bezugszeit.toString().matches(KennConfigApi.bezugszeitPatternFunction(stichtag.bezugsart))) {
            throw new InputValidationError("Bezugszeit '" + stichtag.bezugszeit + "' passt nicht zur Bezugsart '" + bezugsartLookup + "' der Stichtagart '" + stichtag.stichtagsart_id);
        }
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/deleteStichtage"})
    public Boolean deleteStichtage(@RequestBody int[] stichtageIds) {
        this.userService.checkStichtageRights();
        TransactionStatus transaction = this.transactionManager.getTransaction(null);
        try {
            for (int stichtageId : stichtageIds) {
                this.stichtagRepository.deleteById(stichtageId);
            }
            this.transactionManager.commit(transaction);
        }
        catch (Exception e) {
            this.transactionManager.rollback(transaction);
            logger.error((Object)"Could not delete Stichtag", (Throwable)e);
            throw e;
        }
        return Boolean.TRUE;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/reportStichtagsartIds"})
    public List<ReportStichtagsart> getReportStichtage() {
        this.userService.checkStichtageRights();
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        SqlRowSet report_stichtagsart = jt.queryForRowSet("SELECT DISTINCT trim(krfs.druck) AS report_name, trim(krs.stichtagsart_id) AS stichtagsart_id\nFROM kenn_report_stichtagsart krs\nLEFT JOIN kenn_stichtag ks ON ks.stichtagsart_id = krs.stichtagsart_id\nLEFT JOIN kenn_report kr ON kr.apnr = krs.report_id\nLEFT JOIN kenn_report_fuer_stichtagsarten krfs on kr.gruppe=krfs.apnr\nWHERE ks.stichtagsart_id IS NOT NULL");
        report_stichtagsart.beforeFirst();
        HashMap<String, List> report_stichtagsarten = new HashMap<String, List>();
        while (report_stichtagsart.next()) {
            report_stichtagsarten.computeIfAbsent(report_stichtagsart.getString("report_name"), k -> new ArrayList()).add(report_stichtagsart.getString("stichtagsart_id"));
        }
        ArrayList<ReportStichtagsart> report_stichtagsart_ids = new ArrayList<ReportStichtagsart>();
        for (Map.Entry entry : report_stichtagsarten.entrySet()) {
            report_stichtagsart_ids.add(new ReportStichtagsart((String)entry.getKey(), (List)entry.getValue()));
        }
        return report_stichtagsart_ids;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/lieferfreigaben"})
    public List<Lieferfreigabe> getLieferfreigabenConfig() {
        this.userService.checkLieferfreigabeRights();
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        SqlRowSet report_lookup = jt.queryForRowSet("SELECT lfg.tid, trim(krfs.druck) AS report_name, trim(af.defaulttext) AS filter_name FROM kennx_lieferfreigabe lfg JOIN kenn_report_fuer_stichtagsarten krfs ON lfg.report_id = krfs.apnr JOIN kenn_report kr ON krfs.apnr = kr.gruppe LEFT JOIN kennx_lieferfreigabe_filter AS af ON lfg.additional_filter_id = af.tid");
        Iterable lfgn = this.kennxLieferfreigabeRepository.findAll();
        report_lookup.beforeFirst();
        while (report_lookup.next()) {
            int tid = report_lookup.getInt("tid");
            String report_name = report_lookup.getString("report_name");
            String filter_name = report_lookup.getString("filter_name");
            for (Lieferfreigabe target : lfgn) {
                if (target == null || target.tid != tid) continue;
                target.report_name = report_name;
                target.additional_filter_name = filter_name;
            }
        }
        SqlRowSet stichtagsart_lookup = jt.queryForRowSet("SELECT lfs.tid, lfs.lieferfreigabe_id, lfs.stichtagsart_id, sta.druck AS stichtagsart_name, sta.bezugsart\nFROM kennx_lieferfreigabe_stichtagsart lfs JOIN kenn_stichtagsart sta ON lfs.stichtagsart_id = sta.apnr");
        stichtagsart_lookup.beforeFirst();
        while (stichtagsart_lookup.next()) {
            int tid = stichtagsart_lookup.getInt("tid");
            int lieferfreigabe_id = stichtagsart_lookup.getInt("lieferfreigabe_id");
            String stichtagsart_name = stichtagsart_lookup.getString("stichtagsart_name");
            String stichtagsart_bezugsart = stichtagsart_lookup.getString("bezugsart");
            for (Lieferfreigabe report_target : lfgn) {
                if (report_target == null || report_target.tid != lieferfreigabe_id) continue;
                for (LieferfreigabeStichtagsart lieferfreigabeStichtagsart : report_target.lieferfreigabeStichtagsart) {
                    if (lieferfreigabeStichtagsart.tid == null || lieferfreigabeStichtagsart.tid != tid) continue;
                    lieferfreigabeStichtagsart.stichtagsart_name = stichtagsart_name;
                    for (LieferfreigabeStichtagsartBezugszeit target_bezugszeit : lieferfreigabeStichtagsart.kennxLieferfreigabeStichtagsartBezugszeit) {
                        if (target_bezugszeit.tid == null) continue;
                        target_bezugszeit.bezugsartId = stichtagsart_bezugsart;
                    }
                }
            }
        }
        SqlRowSet hochschule_lookup = jt.queryForRowSet("SELECT lfghs.tid, lfghs.lieferfreigabe_id, coalesce(o.drucktext, 'unbekannt') AS hochschule_name FROM kennx_lieferfreigabe_hs lfghs LEFT JOIN organigramm AS o ON '' || lfghs.hs_nr = o.key_apnr;");
        hochschule_lookup.beforeFirst();
        while (hochschule_lookup.next()) {
            int tid = hochschule_lookup.getInt("tid");
            int lieferfreigabe_id = hochschule_lookup.getInt("lieferfreigabe_id");
            String hochschule_name = hochschule_lookup.getString("hochschule_name");
            for (Lieferfreigabe report_target : lfgn) {
                if (report_target == null || report_target.tid != lieferfreigabe_id) continue;
                for (LieferfreigabeHs lieferfreigabeHs : report_target.lieferfreigabeHs) {
                    if (lieferfreigabeHs.tid == null || lieferfreigabeHs.tid != tid) continue;
                    lieferfreigabeHs.hochschule_name = hochschule_name;
                }
            }
        }
        Iterable lfgf = this.kennxLieferfreigabeFilterRepository.findAll();
        return lfgn;
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/lieferfreigaben"})
    public Boolean saveLieferfreigabe(@RequestBody Lieferfreigabe lieferfreigabe) {
        this.userService.checkLieferfreigabeRights();
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        try {
            KennConfigApi.validateNoOverwriting(lieferfreigabe.tid);
            KennConfigApi.validateDateValidation(lieferfreigabe.gueltig_von, lieferfreigabe.gueltig_bis);
            KennConfigApi.validateAdditionalFilterIntegrity(lieferfreigabe, jt);
            for (LieferfreigabeStichtagsart stichtagsart : lieferfreigabe.lieferfreigabeStichtagsart) {
                KennConfigApi.validateStichtagsartIntegrity(jt, stichtagsart);
            }
            Lieferfreigabe n = (Lieferfreigabe)this.kennxLieferfreigabeRepository.save(lieferfreigabe);
            if (n.tid == null) {
                throw new RuntimeException("Couldn't save");
            }
        }
        catch (InputValidationError err) {
            logger.error((Object)"Could not save Stichtage", (Throwable)err);
            throw err;
        }
        catch (Exception e) {
            logger.error((Object)"Could not save Lieferfreigabe", (Throwable)e);
            throw new RuntimeException("Could not save Lieferfreigabe");
        }
        return Boolean.TRUE;
    }

    private static void validateNoOverwriting(Integer tid) {
        if (tid != null) {
            throw new InputValidationError("Zum speichern darf keine tid angegeben werden. Ein Objekt k\u00f6nnte \u00fcberschrieben werden.");
        }
    }

    private static void validateDateValidation(LocalDate gueltigVon, LocalDate gueltigBis) {
        if (gueltigVon != null && gueltigBis != null && gueltigVon.isAfter(gueltigBis)) {
            throw new InputValidationError("'gueltig_von' darf nicht nach 'gueltig_bis' sein");
        }
    }

    private static void validateStichtagsartIntegrity(JdbcTemplate jt, LieferfreigabeStichtagsart stichtagsart) {
        Object[] args = new Object[]{stichtagsart.stichtagsartId};
        int[] typesArg = new int[]{1};
        SqlRowSet stichtagsartActiv = jt.queryForRowSet("SELECT apnr, bezugsart FROM kenn_stichtagsart WHERE apnr = ? AND aktiv = '1';", args, typesArg);
        if (!stichtagsartActiv.last() || stichtagsartActiv.getRow() != 1) {
            throw new InputValidationError("Konnte Stichtage nicht speichern, da f\u00fcr Stichtagsart-ID '" + stichtagsart.stichtagsartId + "' keine (eindeutige) Stichtagsart gefunden wurde");
        }
        String bezugsartLookup = stichtagsartActiv.getString("bezugsart");
        for (LieferfreigabeStichtagsartBezugszeit bezugszeit : stichtagsart.kennxLieferfreigabeStichtagsartBezugszeit) {
            if (bezugszeit.value.toString().matches(KennConfigApi.bezugszeitPatternFunction(bezugsartLookup))) continue;
            throw new InputValidationError("Bezugszeit '" + bezugszeit + "' passt nicht zur Bezugsart '" + bezugsartLookup + "' der Stichtagart '" + stichtagsart.stichtagsartId);
        }
    }

    private static void validateAdditionalFilterIntegrity(Lieferfreigabe lieferfreigabe, JdbcTemplate jt) {
        int[] typesArg;
        Object[] args;
        SqlRowSet additional_filter;
        if (!(lieferfreigabe.additional_filter_id == null || (additional_filter = jt.queryForRowSet("SELECT tid, report_id FROM kennx_lieferfreigabe_filter WHERE tid = ? AND report_id = ?;", args = new Object[]{lieferfreigabe.additional_filter_id, lieferfreigabe.report_id}, typesArg = new int[]{4, 1})).last() && additional_filter.getRow() == 1)) {
            throw new InputValidationError("Konnte keinen Unterbericht mit Id '" + lieferfreigabe.additional_filter_id + "' des Berichts '" + lieferfreigabe.report_name + "' finden");
        }
    }

    private static String bezugszeitPatternFunction(String bezugsartId) {
        switch (bezugsartId) {
            case "J": {
                return "^[0-9]{4}$";
            }
            case "S": {
                return "^[0-9]{4}[1-2]$";
            }
            case "Q": {
                return "^[0-9]{4}[1-4]$";
            }
        }
        logger.error((Object)("Unbekannte Bezugsart: " + bezugsartId));
        return "";
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/deleteLieferfreigaben"})
    public Boolean deleteLieferfreigaben(@RequestBody int[] lieferfreigabenIds) {
        this.userService.checkLieferfreigabeRights();
        TransactionStatus transaction = this.transactionManager.getTransaction(null);
        try {
            for (int lieferfreigabeId : lieferfreigabenIds) {
                this.kennxLieferfreigabeRepository.deleteById(lieferfreigabeId);
            }
            this.transactionManager.commit(transaction);
        }
        catch (Exception e) {
            this.transactionManager.rollback(transaction);
            logger.error((Object)"Could not delete Lieferfreigabe", (Throwable)e);
            throw e;
        }
        return Boolean.TRUE;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/reports"})
    public List<Report> getKennReports() {
        this.userService.checkReportDeliveryRights();
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        return jt.query("SELECT distinct trim(krfs.apnr) as report_id,\ntrim(krfs.druck) AS report_druck,\ntrim(krfs.bezugsart) AS report_bezugsart\nFROM kenn_report_fuer_stichtagsarten krfs\nWHERE  krfs.land_apnr='14' /* Sachsen */\nORDER BY report_druck;", (RowMapper)new RowMapper<Report>(){

            public Report mapRow(ResultSet rs, int rowNum) throws SQLException {
                Report report = new Report(rs.getString("report_id"), rs.getString("report_druck"), rs.getString("report_bezugsart"));
                return report;
            }
        });
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/stichtagsarten"})
    public List<LieferfreigabeStichtagsart> getStichtagsarten(@RequestParam(required=false, value="report_id") String report_id, @RequestParam(required=false, value="bezugszeit_rpt") Integer bezugszeit_rpt) {
        this.userService.checkReportDeliveryRights();
        Object[] args = new Object[]{report_id};
        int[] typesArg = new int[]{1};
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        ArrayList<LieferfreigabeStichtagsart> stichgtagsarten = new ArrayList<LieferfreigabeStichtagsart>();
        SqlRowSet result = jt.queryForRowSet("SELECT DISTINCT TRIM(krs.stichtagsart_id) AS stichtagsart_id, TRIM(ks.druck) AS stichtagsart_name, ks.datum_wird_ausgewertet FROM kenn_report kr, kenn_report_stichtagsart krs, kenn_stichtagsart ks WHERE ks.apnr=krs.stichtagsart_id and kr.apnr=krs.report_id and kr.gruppe= ? and ks.aktiv = '1' ORDER BY stichtagsart_name", args, typesArg);
        result.beforeFirst();
        while (result.next()) {
            String stichtagsart_id = result.getString("stichtagsart_id");
            String stichtagsart_name = result.getString("stichtagsart_name");
            String datumWirdAusgewertet = result.getString("datum_wird_ausgewertet");
            Object[] args2 = new Object[]{report_id, stichtagsart_id, bezugszeit_rpt};
            int[] typesArg2 = new int[]{1, 1, 4};
            HashSet<LieferfreigabeStichtagsartBezugszeit> bezugszeiten = new HashSet<LieferfreigabeStichtagsartBezugszeit>();
            bezugszeiten.addAll(jt.query("SELECT * FROM sp_get_rpt_sta_bezugszeit( ?, ?, ?) AS sp LEFT JOIN kenn_stichtagsart ks on ks.apnr=sp.stichtagsart_id;", args2, typesArg2, (RowMapper)new RowMapper<LieferfreigabeStichtagsartBezugszeit>(){

                public LieferfreigabeStichtagsartBezugszeit mapRow(ResultSet rs, int rowNum) throws SQLException {
                    LieferfreigabeStichtagsartBezugszeit bezugszeit = new LieferfreigabeStichtagsartBezugszeit((Integer)rs.getInt("bezugszeit"), rs.getString("bezugsart_stichtagsart"));
                    return bezugszeit;
                }
            }));
            LieferfreigabeStichtagsart kls = new LieferfreigabeStichtagsart(stichtagsart_id, stichtagsart_name, bezugszeiten, datumWirdAusgewertet);
            stichgtagsarten.add(kls);
        }
        return stichgtagsarten;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/lieferfreigabe_filter"})
    public List<LieferfreigabeFilter> getLieferfreigabeFilter() {
        this.userService.checkLieferfreigabeRights();
        ArrayList<LieferfreigabeFilter> result = new ArrayList<LieferfreigabeFilter>();
        Iterable it = this.kennxLieferfreigabeFilterRepository.findAll();
        it.forEach(result::add);
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, path={"/hochschulen"})
    public List<LieferfreigabeHs> getHochschulen() {
        this.userService.checkReportDeliveryRights();
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        return jt.query("SELECT CAST(key_apnr AS int) AS hs_nr, name FROM organigramm WHERE orgstruktur=10 OR (name = 'Muster-Hochschule' AND parent = 'Wurzel_Org' AND current_date BETWEEN gueltig_seit AND gueltig_bis AND sourcesystem=6) ORDER BY name", (RowMapper)new RowMapper<LieferfreigabeHs>(){

            public LieferfreigabeHs mapRow(ResultSet rs, int rowNum) throws SQLException {
                return new LieferfreigabeHs((Integer)rs.getInt("hs_nr"), rs.getString("name"));
            }
        });
    }
}

