/*
 * Decompiled with CFR 0.152.
 */
package de.superx.job;

import de.superx.job.ActionNode;
import java.io.File;

public class ExtractAction
extends ActionNode {
    public String unlFile;
    public String stagingSchema;
    public String sourceTable;
    public String stagingTable;
    public String extractionScript;
    public String extractionExclude;
    public String dataSource;

    public ExtractAction(String id, String table, String extractionScript, String extractionExclude, String stagingSchema, String unlFile, String dataSource, Integer systemInfoId, String mod) {
        super(ExtractAction.makeName(id, unlFile, dataSource), null, systemInfoId, true, ActionNode.ActionType.EXTRACT);
        this.sourceTable = table;
        this.extractionScript = extractionScript.isBlank() ? "1=1" : extractionScript;
        this.extractionExclude = extractionExclude;
        this.stagingSchema = stagingSchema.isBlank() ? "public" : stagingSchema;
        this.stagingTable = String.format("%s", table);
        this.unlFile = unlFile;
        this.dataSource = dataSource;
    }

    public ExtractAction() {
    }

    private static String makeName(String id, String unlFile, String dataSource) {
        String name = "Extract " + id + " " + unlFile.substring(unlFile.lastIndexOf(File.separatorChar) + 1);
        if (dataSource != null && !dataSource.isEmpty()) {
            name = name + " (" + dataSource + ")";
        }
        return name;
    }
}

