/*
 * Decompiled with CFR 0.152.
 */
package de.superx.job;

import de.superx.job.ActionNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ContainerNode
extends ActionNode {
    private List<ActionNode> actions = new ArrayList<ActionNode>();
    private JobType jobType = JobType.unknown;
    private Map<String, String> parameters = new HashMap<String, String>();
    private boolean ignoreErrors = false;
    private JobSource source = JobSource.FILE;

    public ContainerNode() {
    }

    public ContainerNode(String name, String id, Integer systemInfoId) {
        super(name, id, systemInfoId, true, ActionNode.ActionType.CONTAINER);
        this.jobType = JobType.getJobTypeForName(id);
    }

    public void add(ActionNode node) {
        this.actions.add(node);
    }

    public void add(int position, ActionNode node) {
        this.actions.add(position, node);
    }

    public void addAll(List<ActionNode> nodes) {
        this.actions.addAll(nodes);
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public boolean hasParameters() {
        return this.parameters.size() > 0;
    }

    public int size() {
        return this.actions.size();
    }

    public List<ActionNode> getActions() {
        return this.actions;
    }

    public int stepCount() {
        int stepCount = 0;
        for (ActionNode node : this.actions) {
            if (node instanceof ContainerNode) {
                stepCount += ((ContainerNode)node).stepCount();
                continue;
            }
            ++stepCount;
        }
        return stepCount;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public static ActionNode getActionById(ContainerNode root, String id) {
        for (ActionNode actionNode : root.actions) {
            ActionNode childAction;
            if (actionNode.id.equals(id)) {
                return actionNode;
            }
            if (!(actionNode instanceof ContainerNode) || (childAction = ContainerNode.getActionById((ContainerNode)actionNode, id)) == null) continue;
            return childAction;
        }
        return null;
    }

    public boolean isIgnoreErrors() {
        return this.ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
    }

    public void setJobSource(JobSource jobSource) {
        this.source = jobSource;
    }

    public JobSource getJobSource() {
        return this.source;
    }

    public void setCustom(int custom) {
        this.custom = custom;
        List<ActionNode> children = this.getActions();
        for (ActionNode child : children) {
            if (child instanceof ContainerNode) {
                ((ContainerNode)child).setCustom(custom);
                continue;
            }
            child.custom = custom;
        }
    }

    public void setIgnoreErrorsAllChildren(boolean ignoreErrors) {
        this.ignoreErrors = ignoreErrors;
        for (ActionNode node : this.actions) {
            if (!(node instanceof ContainerNode)) continue;
            ((ContainerNode)node).setIgnoreErrorsAllChildren(ignoreErrors);
        }
    }

    public static enum JobType {
        unload("_unload", 1),
        load_transform("_load_and_transform", 2),
        complete("_unload_load_transform", 3),
        special("_special", 4),
        install_upgrade("_install_upgrade", 5),
        uninstall("_uninstall", 6),
        unknown("_unknown", 0);

        private String namePattern;
        private int jobTypeId;

        private JobType(String namePattern, int jobTypeId) {
            this.namePattern = namePattern;
            this.jobTypeId = jobTypeId;
        }

        public String getNamePattern() {
            return this.namePattern;
        }

        public String createName(String componentAbbreviation) {
            return componentAbbreviation + this.namePattern;
        }

        public String createName(String componentAbbreviation, String additionalInfo) {
            return componentAbbreviation + "_" + additionalInfo + this.namePattern;
        }

        public int getJobTypeId() {
            return this.jobTypeId;
        }

        public static String getComponentAbbreviationFromJobName(String jobName) {
            if (jobName == null) {
                return "UNKNOWN";
            }
            if (jobName.contains("_")) {
                return jobName.substring(0, jobName.indexOf(95));
            }
            return jobName;
        }

        public static JobType getJobTypeForName(String name) {
            JobType result = unknown;
            for (JobType jobType : JobType.values()) {
                if (!name.endsWith(jobType.namePattern)) continue;
                return jobType;
            }
            return result;
        }

        public static boolean isIdJobType(String id, JobType type) {
            return Pattern.matches("[a-z_]*" + type.namePattern, id);
        }
    }

    public static enum JobSource {
        FILE,
        DB;

    }
}

