/*
 * Decompiled with CFR 0.152.
 */
package de.superx.job;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import de.superx.job.ContainerNode;
import de.superx.job.ExecuteDbtAction;
import de.superx.job.ExecuteSQLFluffAction;
import de.superx.job.ExtractAction;
import de.superx.job.KettleAction;
import de.superx.job.LoadAction;
import de.superx.job.LoadDbtSource;
import de.superx.job.LoadEtlRoutinesAction;
import de.superx.job.LoadMondrianSchemaAction;
import de.superx.job.RemoveSpringBatchHistoryAction;
import de.superx.job.SqlAction;
import de.superx.job.SqlScriptAction;
import de.superx.job.Timestamp;
import de.superx.job.TransferAction;
import de.superx.job.UnloadAction;
import de.superx.job.UnloadParams;
import de.superx.job.UpdateMetadataAction;
import de.superx.job.UpgradeDbFormsConfigAction;
import org.apache.commons.lang.StringUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=true)
public abstract class ActionNode {
    public ActionType type;
    public String name;
    public String id;
    public Integer tid;
    public Integer systemInfoId;
    public boolean active;
    public Integer custom;

    public ActionNode(String name, String id, Integer systemInfoId, boolean active, Integer custom, ActionType type) {
        if (name == null) {
            throw new IllegalArgumentException("Name must not be null");
        }
        this.name = StringUtils.abbreviate((String)name, (int)100);
        this.id = id == null || id.isEmpty() ? this.name.toLowerCase().replace(" ", "_") : id;
        this.type = type;
        this.systemInfoId = systemInfoId;
        this.active = active;
        this.custom = custom;
    }

    public ActionNode(String name, String id, Integer systemInfoId, boolean active, ActionType type) {
        this(name, id, systemInfoId, active, 0, type);
    }

    public ActionNode() {
    }

    public static enum ActionType {
        LOAD(LoadAction.class, 1),
        DOSQL(SqlScriptAction.class, 2),
        DOQUERY(SqlAction.class, 3),
        UNLOAD(UnloadAction.class, 4),
        MSG(null, 5),
        TRANSFER(TransferAction.class, 6),
        KETTLE(KettleAction.class, 7),
        CONTAINER(ContainerNode.class, 8),
        UNLOADPARAMS(UnloadParams.class, 9),
        TIMESTAMP(Timestamp.class, 10),
        LOAD_ETL_ROUTINES(LoadEtlRoutinesAction.class, 11),
        LOAD_MONDRIAN_SCHEMA(LoadMondrianSchemaAction.class, 12),
        UNKNOWN(null, 13),
        EXTRACT(ExtractAction.class, 14),
        LOAD_DBT_SOURCE(LoadDbtSource.class, 15),
        UPGRADE_DBFORMS_CONFIG(UpgradeDbFormsConfigAction.class, 16),
        EXECUTE_DBT(ExecuteDbtAction.class, 17),
        UPDATE_METADATA(UpdateMetadataAction.class, 18),
        EXECUTE_SQLFLUFF(ExecuteSQLFluffAction.class, 19),
        REMOVE_SPRING_BATCH_HISTORY(RemoveSpringBatchHistoryAction.class, 20);

        private Class<? extends ActionNode> clazz;
        private int stepTypeId;

        private ActionType(Class<? extends ActionNode> clazz, int stepTypeId) {
            this.clazz = clazz;
            this.stepTypeId = stepTypeId;
        }

        public int getStepTypeId() {
            return this.stepTypeId;
        }

        public Class<? extends ActionNode> getActionClass() {
            return this.clazz;
        }

        public static ActionType getActionTypeById(int stepTypeId) {
            for (ActionType actionType : ActionType.values()) {
                if (actionType.getStepTypeId() != stepTypeId) continue;
                return actionType;
            }
            return UNKNOWN;
        }
    }
}

