/*
 * Decompiled with CFR 0.152.
 */
package de.superx.jdbc.repository;

import de.memtext.util.DateUtils;
import de.superx.jdbc.entity.Entity;
import de.superx.jdbc.model.DynamicFieldType;
import de.superx.jdbc.model.TableRef;
import de.superx.rest.model.ColumnType;
import de.superx.rest.model.FieldType;
import de.superx.rest.model.HisDynamicFieldConfig;
import de.superx.rest.model.Item;
import de.superx.spring.service.BiaRepositoryService;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.NoRepositoryBean;

@NoRepositoryBean
public interface BiaAdminCrudRepository<T extends Entity>
extends CrudRepository<T, Object> {
    default public HisDynamicFieldConfig getEditConfig(Object id, BiaRepositoryService brs) throws IllegalArgumentException, IllegalAccessException, InstantiationException, SQLException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<Entity> entityClass = this.getEntityClass(brs);
        HisDynamicFieldConfig result = new HisDynamicFieldConfig("form", FieldType.Form);
        Field[] allFields = entityClass.getDeclaredFields();
        Entity entity = this.getEntity(id, brs);
        for (Field field : allFields) {
            HisDynamicFieldConfig config = this.createChildConfigForEdit(entity, field, brs);
            result.children.add(config);
        }
        return result;
    }

    default public HisDynamicFieldConfig getFilterConfig(BiaRepositoryService brs) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Field[] allFields;
        Entity entity = this.getNewEntity(brs);
        HisDynamicFieldConfig result = new HisDynamicFieldConfig("form", FieldType.Form);
        for (Field field : allFields = entity.getClass().getDeclaredFields()) {
            if (this.getFilterControlType(field) == FieldType.None) continue;
            HisDynamicFieldConfig config = this.createChildConfigForFilter(field, brs);
            result.children.add(config);
        }
        return result;
    }

    default public Entity getEntity(Object id, BiaRepositoryService brs) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Optional optionalEntity = this.findById(id);
        if (optionalEntity.isPresent()) {
            return (Entity)optionalEntity.get();
        }
        return this.getNewEntity(brs);
    }

    default public Entity getNewEntity(BiaRepositoryService brs) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<Entity> domainClass = brs.getDomainClassFor(this);
        return domainClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    default public Class<Entity> getEntityClass(BiaRepositoryService brs) {
        return brs.getDomainClassFor(this);
    }

    default public HisDynamicFieldConfig createChildConfigForEdit(Entity entity, Field field, BiaRepositoryService brs) throws IllegalArgumentException, IllegalAccessException, SQLException {
        HisDynamicFieldConfig config = new HisDynamicFieldConfig(field.getName(), field.getName(), field.get(entity));
        config.controlType = this.getEditControlType(field);
        config.label = this.getLabel(config.label, field);
        List<Item> items = this.getItems(field, brs);
        if (items.isEmpty()) {
            items = entity.getCellSpecificItems(field.getName(), brs.getDataSource());
        }
        if (!items.isEmpty() && config.controlType != FieldType.Select && config.controlType != FieldType.MultiSelect) {
            config.controlType = FieldType.Select;
        }
        config.defaultValue = this.formatDefaultValue(config.defaultValue, config.controlType, field);
        if (config.controlType.equals((Object)FieldType.TextArea)) {
            config.height = Integer.min(10, String.valueOf(config.defaultValue).length() / 30);
        }
        config.required = entity.isFieldRequired(field, brs.getDataSource());
        config.disabled = this.getDisabled(field);
        config.setItems(items);
        return config;
    }

    default public HisDynamicFieldConfig createChildConfigForFilter(Field field, BiaRepositoryService brs) throws IllegalArgumentException, IllegalAccessException {
        HisDynamicFieldConfig config = new HisDynamicFieldConfig(field.getName(), field.getName(), null);
        config.controlType = this.getFilterControlType(field);
        config.label = this.getLabel(config.label, field);
        config.visibleInSimplifiedForm = this.getVisibility(field);
        List<Item> items = this.getItems(field, brs);
        items.add(0, new Item("", ""));
        config.setItems(items);
        return config;
    }

    default public boolean getVisibility(Field field) {
        DynamicFieldType annotation = field.getAnnotation(DynamicFieldType.class);
        if (annotation != null) {
            return annotation.visibleInSimplifiedForm();
        }
        return true;
    }

    default public boolean getDisabled(Field field) {
        DynamicFieldType annotation = field.getAnnotation(DynamicFieldType.class);
        return annotation != null && annotation.readOnly();
    }

    default public FieldType getFilterControlType(Field field) {
        DynamicFieldType annotation = field.getAnnotation(DynamicFieldType.class);
        if (annotation != null) {
            if (annotation.filterControlType() != FieldType.Unassigned) {
                return annotation.filterControlType();
            }
            return annotation.editControlType();
        }
        return FieldType.Text;
    }

    default public FieldType getEditControlType(Field field) {
        DynamicFieldType annotation = field.getAnnotation(DynamicFieldType.class);
        if (annotation != null) {
            return annotation.editControlType();
        }
        return FieldType.Text;
    }

    default public String getLabel(String label, Field field) {
        DynamicFieldType annotation = field.getAnnotation(DynamicFieldType.class);
        if (annotation != null && !annotation.label().isEmpty()) {
            return annotation.label();
        }
        return label;
    }

    default public Object formatDefaultValue(Object defaultValue, FieldType controlType, Field field) {
        if (field.getType().equals(java.util.Date.class) && controlType == FieldType.DatePicker && defaultValue != null) {
            return DateUtils.formatUS(new Date(((java.util.Date)defaultValue).getTime()));
        }
        if (controlType == FieldType.Select && defaultValue != null) {
            return defaultValue.toString();
        }
        if (defaultValue instanceof String) {
            return defaultValue.toString().trim();
        }
        return defaultValue;
    }

    default public List<Item> getItems(Field field, BiaRepositoryService brs) throws IllegalArgumentException, IllegalAccessException {
        List<Item> items = new ArrayList<Item>();
        TableRef annotation = field.getAnnotation(TableRef.class);
        DynamicFieldType fieldType = field.getAnnotation(DynamicFieldType.class);
        if (fieldType != null && fieldType.columnType() == ColumnType.BooleanColumn) {
            items.add(new Item("Nein", "0"));
            items.add(new Item("Ja", "1"));
        } else if (annotation != null) {
            items = brs.getItemsFromKeytable(annotation.table(), annotation.labelField(), annotation.keyField());
        }
        return items;
    }
}

