/*
 * Decompiled with CFR 0.152.
 */
package de.superx.jdbc.entity;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Hochschulinfo {
    private static Logger logger = LoggerFactory.getLogger(Hochschulinfo.class);
    private static Pattern PLZ_PATTERN = Pattern.compile("\\d{5}");
    private String name = "";
    private int nr;
    private String strasse = "";
    private String strasseNr = "";
    private String plz = "";
    private String ort = "";
    private String melderName = "";
    private String melderVorname = "";

    public void setAdresse(String adresse) {
        Matcher plzMatcher;
        String[] addressParts = adresse.split(",");
        if (addressParts.length == 1 && (plzMatcher = PLZ_PATTERN.matcher(adresse)).find()) {
            int plzPos = plzMatcher.start();
            addressParts = new String[]{adresse.substring(0, plzPos - 1).trim(), adresse.substring(plzPos)};
        }
        if (addressParts.length != 2) {
            logger.warn("Problem parsing address: " + adresse);
        } else {
            this.parseStreet(addressParts[0].trim());
            this.parseCity(addressParts[1].trim());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.trim();
    }

    public String getStrasse() {
        return this.strasse;
    }

    public String getStrasseNr() {
        return this.strasseNr;
    }

    public String getPlz() {
        return this.plz;
    }

    public String getOrt() {
        return this.ort;
    }

    public int getNr() {
        return this.nr;
    }

    public void setNr(int nr) {
        this.nr = nr;
    }

    public String getMelderName() {
        return this.melderName;
    }

    public void setMelderName(String melderName) {
        this.melderName = melderName == null ? "" : melderName;
    }

    public String getMelderVorname() {
        return this.melderVorname;
    }

    public void setMelderVorname(String melderVorname) {
        this.melderVorname = melderVorname == null ? "" : melderVorname;
    }

    private void parseStreet(String street) {
        int posStreetNr = StringUtils.indexOfAny((CharSequence)street, (String)"1234567890");
        if (posStreetNr != -1) {
            this.strasse = street.substring(0, posStreetNr - 1).trim();
            this.strasseNr = street.substring(posStreetNr);
        } else {
            this.strasse = street;
            logger.warn("Problem parsing street: " + street);
        }
    }

    private void parseCity(String city) {
        if (city.isEmpty() || city.length() < 6) {
            logger.warn("Problem parsing city " + city);
            this.ort = city.length() > 0 ? city : "Unbekannter Ort";
            this.plz = "Unbekannte PLZ";
        } else {
            int cityNameIndex = StringUtils.indexOfAnyBut((CharSequence)city, (CharSequence)" 1234567890-.");
            if (cityNameIndex != -1) {
                this.plz = city.substring(0, cityNameIndex - 1).trim();
                this.ort = city.substring(cityNameIndex);
            } else {
                logger.warn("Problem parsing area code " + city);
                this.ort = city;
            }
        }
    }
}

