/*
 * Decompiled with CFR 0.152.
 */
package de.superx.etl.bin;

import de.memtext.util.GetOpts;
import de.memtext.util.StringUtils;
import de.superx.etl.EtlActionJob;
import de.superx.etl.EtlUtils;

public class EtlJobExecutor {
    public static void main(String[] args) {
        String usage = "usage: java de.superx.bin.EtlJobExecutor -dbproperties:$DB_PROPERTIES -job:abc -params:TID=16000 (optional) -outfile:Ausgabedatei (optional)";
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_dbprops, GetOpts.Options.opt_job});
        if (isdrin != null) {
            System.err.println(usage);
            System.exit(1);
        }
        int returnCode = 0;
        String dbpropfile = GetOpts.getValue(GetOpts.Options.opt_dbprops);
        String job = GetOpts.getValue(GetOpts.Options.opt_job);
        String params = null;
        if (GetOpts.isPresent(GetOpts.Options.opt_params)) {
            params = GetOpts.getValue(GetOpts.Options.opt_params);
        }
        if (params != null) {
            params = StringUtils.replace(params, ",", EtlUtils.NEWLINE);
        }
        String outfile = null;
        if (GetOpts.isPresent(GetOpts.Options.opt_outFile)) {
            outfile = GetOpts.getValue(GetOpts.Options.opt_outFile);
        }
        EtlActionJob myJob = new EtlActionJob(job, "", dbpropfile);
        try {
            myJob.initJob(null, job, params);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(myJob.getLogoutput());
            System.exit(1);
        }
        System.out.println("Job " + job + " initialized");
        try {
            returnCode = myJob.execute(outfile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(myJob.getLogoutput());
            System.exit(1);
        }
        System.out.println("Job " + job + " executed in " + myJob.getDuration() + " Sec.");
        System.exit(returnCode);
    }
}

