/*
 * Decompiled with CFR 0.152.
 */
package de.superx.etl.bin;

import de.memtext.util.ExceptionHandler;
import de.memtext.util.GetOpts;
import de.memtext.util.StringUtils;
import de.superx.bin.SxConnection;
import de.superx.etl.EtlUtils;
import de.superx.etl.SqlExecutor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class Dosql {
    private static Connection myDb;
    private static DatabaseMetaData dbmd;
    private static Statement st;
    private static boolean done;
    private static String delim;
    private static String header;
    private static String logfile;
    private static String tabelle;
    private static String dbpropfile;
    private static String outfile;
    private static String outFormat;
    private static String _dateiPfad;
    private static Logger logger;
    private static ExceptionHandler exceptionHandler;
    private static SxConnection myConnection;
    private static String usage;

    public static void instructions() {
        System.out.println("SuperX @version@\n");
        System.out.println("\nDieses Javaprogramm f\u00fchrt ein beliebiges sql-Script mit einer oder mehr sql-Anweisungen aus");
        System.out.println("Im Classpath muss superx@version@.jar sowie der zugeh\u00f6rige jdbc-Treiber sein.");
        System.out.println("Befehl:\n java dosql <Dateipfad sql-Script> <delimiter>(optional) <Ausgabe der Feld\u00fcberschriften (optional, true oder false).");
        System.out.println("Default:\n java dosql <Dateipfad sql-Script> <TAB> true");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            Dosql.execute(args);
        }
        catch (Exception e) {
            logger.severe("Fehler beim sql-Script: " + _dateiPfad + " " + e.toString());
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void execute(String[] args) throws Exception {
        String params = "";
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_dbprops, GetOpts.Options.opt_logger, GetOpts.Options.opt_sql});
        if (isdrin != null) {
            System.err.println("Folgende Optionen fehlen: " + isdrin);
            System.err.println(usage);
            System.exit(1);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_logger)) {
            logfile = GetOpts.getValue(GetOpts.Options.opt_logger);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_dbprops)) {
            dbpropfile = GetOpts.getValue(GetOpts.Options.opt_dbprops);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_sql)) {
            _dateiPfad = GetOpts.getValue(GetOpts.Options.opt_sql);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_outFormat)) {
            outFormat = GetOpts.getValue(GetOpts.Options.opt_outFormat);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_delim)) {
            delim = GetOpts.getValue(GetOpts.Options.opt_delim);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_header)) {
            header = GetOpts.getValue(GetOpts.Options.opt_header);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_outFile)) {
            outfile = GetOpts.getValue(GetOpts.Options.opt_outFile);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_params)) {
            params = GetOpts.getValue(GetOpts.Options.opt_params);
        }
        if (delim.equals("")) {
            delim = "^";
        }
        int returnCode = 0;
        File f = new File(logfile);
        if (!f.exists()) {
            throw new IOException("Datei nicht gefunden: " + logfile);
        }
        FileInputStream ins = new FileInputStream(logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        logfile = MyLogManager.getProperty(".level");
        logger.info("Using Loggging-Level " + logfile);
        File sqlScriptFile = new File(_dateiPfad);
        Dosql.getConnection(logger, dbpropfile);
        Properties paramProperties = null;
        if (!params.equals("")) {
            params = StringUtils.replace(params, "|", System.getProperty("line.separator"));
            paramProperties = EtlUtils.convertStringToProperty(params);
        }
        SqlExecutor mySqlExecutor = new SqlExecutor("default", myConnection, sqlScriptFile, paramProperties);
        if (!outfile.equals("")) {
            mySqlExecutor.setOutfile(outfile);
        }
        returnCode = mySqlExecutor.executeQueries();
        String output = mySqlExecutor.getOutString().toString();
        myConnection.close();
        System.out.println("Dosql hat das Script " + _dateiPfad + " erfolgreich durchgef\u00fchrt");
        System.out.println(output);
        logger.info("dosql erfolgreich beendet");
    }

    public static void getConnection(Logger logger, String propFile) throws SQLException {
        myConnection = new SxConnection();
        myConnection.setPropfile(propFile);
        logger.config("Starting Connection...");
        try {
            myDb = myConnection.getConnection();
            st = myDb.createStatement();
            dbmd = myDb.getMetaData();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.severe("Keine DB-Verbindung: " + e.toString());
            throw new SQLException("Keine DB-Verbindung: " + e.toString());
        }
    }

    static {
        done = false;
        delim = "^";
        header = "false";
        logfile = "../conf/logging.properties";
        tabelle = "";
        dbpropfile = "../conf/db.properties";
        outfile = "";
        outFormat = "txt";
        _dateiPfad = "";
        logger = Logger.getLogger(Dosql.class.toString());
        exceptionHandler = new ExceptionHandler(false);
        myConnection = null;
        usage = "-------------------------------------\nGebrauch: java de.superx.bin.Dosql -logger=<<Pfad zu logging.properties>> -dbproperties=<<Pfad zu db.properties>> -sqlfile:<Datei mit sql-Ausdr\u00fccken> -params:<Parameter, die in sql- oder Script-Dateien ersetzt werden; Syntax:param1=wert1|param2=wert2 etc> -outFormat:<Ausgabeformat (txt | html | xml)>(optional) -delim:<delimiter> -header:<mit Spalten\u00fcberschriften (true | false)>(optional) -outfile:<Ausgabedatei>(optional) \n---------------------------------------------------";
    }
}

