/*
 * Decompiled with CFR 0.152.
 */
package de.superx.etl.biad;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.superx.etl.biad.DBSource;
import de.superx.job.ExtractAction;
import de.superx.util.PathAndFileUtils;
import java.io.IOException;
import java.util.ArrayList;

public class DBSourceDeserializer
extends StdDeserializer<DBSource> {
    public DBSourceDeserializer() {
        this(null);
    }

    public DBSourceDeserializer(Class<?> vc) {
        super(vc);
    }

    public DBSource deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String name = node.get("name").asText();
        String database = node.get("database").asText();
        String schema = node.get("schema").asText();
        ArrayList<ExtractAction> tables = new ArrayList<ExtractAction>();
        for (JsonNode tableNode : node.get("tables")) {
            if (tableNode.has("custom")) continue;
            String tableName = tableNode.get("name").asText();
            String unlFile = PathAndFileUtils.buildUnlFile("biad", tableName);
            String extractionScript = "";
            if (tableNode.has("extraction-script")) {
                extractionScript = tableNode.get("extraction-script").asText();
            }
            String extractionExclude = "";
            if (tableNode.has("extraction-exclude")) {
                extractionExclude = tableNode.get("extraction-exclude").asText();
            }
            tables.add(new ExtractAction(tableName, tableName, extractionScript, extractionExclude, schema, unlFile, "hisinone", 440, null));
        }
        return new DBSource(name, database, schema, tables);
    }
}

