/*
 * Decompiled with CFR 0.152.
 */
package de.superx.etl;

import de.memtext.util.StringUtils;
import de.superx.bin.SxConnection;
import de.superx.bin.SxJdbcClient;
import de.superx.bin.XUpdater;
import de.superx.common.FieldContainer;
import de.superx.etl.QueryResultSerializer;
import de.superx.servlet.SxPools;
import de.superx.util.SqlStringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;

public class SqlExecutor {
    public final String NEWLINE = System.getProperty("line.separator");
    private SxConnection mySxConnection;
    private String sqlScript;
    private File sqlScriptFile;
    private Logger logger;
    private String mandantenId = "default";
    private Statement st;
    private Connection myConnection;
    private StringBuffer outString = new StringBuffer("");
    private int returnCode;
    private String outfile = "";
    private String CSVdelim = "^";
    private boolean printColNames = false;
    private String outFormat = "txt";
    private long numberOfRows;
    private Properties params;

    public SqlExecutor(String mandantenId, SxConnection mySxConnection, String sqlScript, Properties params) {
        this.mySxConnection = mySxConnection;
        this.sqlScript = sqlScript;
        this.mandantenId = mandantenId;
        this.logger = Logger.getLogger("superx_" + mandantenId);
        this.params = params;
    }

    public SqlExecutor(String mandantenId, SxConnection mySxConnection, File sqlScriptFile, Properties params) throws IOException {
        this.mySxConnection = mySxConnection;
        this.mandantenId = mandantenId;
        this.sqlScriptFile = sqlScriptFile;
        this.logger = Logger.getLogger("superx_" + mandantenId);
        this.params = params;
        if (!sqlScriptFile.exists()) {
            throw new IOException("Datei nicht gefunden: " + sqlScriptFile.getAbsolutePath());
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(sqlScriptFile)));
        Object sql = "";
        String text = "";
        while ((text = in.readLine()) != null) {
            sql = (String)sql + this.NEWLINE + text.trim();
        }
        in.close();
        this.sqlScript = sql;
    }

    public SxConnection getMySxConnection() {
        return this.mySxConnection;
    }

    public void setMyConnection(SxConnection mySxConnection) {
        this.mySxConnection = mySxConnection;
    }

    public String getSqlScript() {
        return this.sqlScript;
    }

    public void setSqlScript(String sqlScript) {
        this.sqlScript = sqlScript;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getMandantenId() {
        return this.mandantenId;
    }

    public void setMandantenId(String mandantenId) {
        this.mandantenId = mandantenId;
    }

    public String getOutfile() {
        return this.outfile;
    }

    public void setOutfile(String outfile) {
        this.outfile = outfile;
    }

    public String getCSVdelim() {
        return this.CSVdelim;
    }

    public void setCSVdelim(String cSVdelim) {
        this.CSVdelim = cSVdelim;
    }

    public boolean getPrintColNames() {
        return this.printColNames;
    }

    public void setPrintColNames(boolean printColNames) {
        this.printColNames = printColNames;
    }

    public String getOutFormat() {
        return this.outFormat;
    }

    public void setOutFormat(String outFormat) {
        this.outFormat = outFormat;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    public void setNumberOfRows(long numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    public Properties getParams() {
        return this.params;
    }

    public void setParams(Properties params) {
        this.params = params;
    }

    public StringBuffer getOutString() {
        return this.outString;
    }

    public void setOutString(StringBuffer outString) {
        this.outString = outString;
    }

    public int executeQueries() throws Exception {
        this.returnCode = 0;
        QueryResultSerializer myQueryResultSerializer = null;
        if (this.sqlScript.toLowerCase().indexOf("<xupdate>") > -1) {
            SxConnection myConnection = new SxConnection();
            myConnection.setPropfile(this.mySxConnection.getPropfile());
            Connection con = myConnection.getConnection();
            new XUpdater().execute(con, myConnection.getDatabaseAbbr(), this.sqlScript, this.logger);
        } else {
            if (this.sqlScript.toLowerCase().indexOf("--freemarker template") > -1) {
                HashMap map = new HashMap();
                FieldContainer individualFields = new FieldContainer();
                this.sqlScript = SxPools.get(this.mandantenId).getTemplateProcessor().process(map, -1, "SQL-Script", this.sqlScript, individualFields, SxPools.get(this.mandantenId).getRepository(), SxPools.get(this.mandantenId).getSqlDialect());
                String keepGenerated = System.getProperty("FreemarkerKeepGenerated");
                if (keepGenerated != null && keepGenerated.equalsIgnoreCase("true")) {
                    FileWriter sqlScriptTmp;
                    if (this.sqlScriptFile == null) {
                        File tempFile = File.createTempFile("fm_output", ".sql");
                        sqlScriptTmp = new FileWriter(tempFile);
                        this.logger.info("FM generated SQL: " + tempFile.getAbsolutePath());
                    } else {
                        sqlScriptTmp = new FileWriter(this.sqlScriptFile.getAbsolutePath() + ".tmp.sql");
                    }
                    sqlScriptTmp.write(this.sqlScript);
                    sqlScriptTmp.close();
                }
            }
            this.sqlScript = this.sqlScript.trim();
            this.sqlScript = SqlStringUtils.removeComment(this.sqlScript, "{", "}");
            if (this.sqlScript.startsWith("\"")) {
                this.sqlScript = this.sqlScript.substring(1, this.sqlScript.length());
            }
            if (this.sqlScript.endsWith("\"")) {
                this.sqlScript = this.sqlScript.substring(0, this.sqlScript.length() - 1);
            }
            if (this.params != null) {
                Enumeration<?> paramEnum = this.params.propertyNames();
                while (paramEnum.hasMoreElements()) {
                    String paramName = (String)paramEnum.nextElement();
                    String paramValue = this.params.getProperty(paramName);
                    this.sqlScript = StringUtils.replace(this.sqlScript, "$" + paramName, paramValue);
                }
            }
            this.logger.config("Inhalt der sql-Datei: " + this.NEWLINE + "--" + this.sqlScript + "--");
            SxJdbcClient myClient = new SxJdbcClient(this.logger, this.mySxConnection.getPropfile(), this.sqlScript);
            myClient.Rs_executeALL();
            ResultSet myrs = myClient.getRs();
            if (myrs != null) {
                if (!this.outfile.equals("")) {
                    try {
                        FileWriter fw = new FileWriter(this.outfile);
                        if (this.outFormat.equalsIgnoreCase("xml")) {
                            fw.write("<?xml version=\"1.0\"  encoding=\"" + SqlStringUtils.getEncoding() + "\" ?>");
                        }
                        myQueryResultSerializer = new QueryResultSerializer("default", this.mySxConnection, myrs, fw);
                        this.numberOfRows = myQueryResultSerializer.unloadQueryResults("DOQUERY", this.outFormat, this.CSVdelim, this.printColNames);
                        this.returnCode = myQueryResultSerializer.getReturnCode();
                    }
                    catch (IOException e) {
                        this.logger.severe("Fehler beim Erstellen der Datei " + this.outfile);
                        this.returnCode = 1;
                    }
                } else {
                    StringWriter sw = new StringWriter();
                    if (this.outFormat.equalsIgnoreCase("xml")) {
                        sw.write("<?xml version=\"1.0\"  encoding=\"UTF-8\" ?>");
                    }
                    myQueryResultSerializer = new QueryResultSerializer("default", this.mySxConnection, myrs, sw);
                    this.numberOfRows = myQueryResultSerializer.unloadQueryResults("DOQUERY", this.outFormat, this.CSVdelim, this.printColNames);
                    this.returnCode = myQueryResultSerializer.getReturnCode();
                    this.outString = myQueryResultSerializer.getOutputString().getBuffer();
                }
            } else {
                this.logger.info("Keine R\u00fcckgabewerte aus SQL-Script");
            }
        }
        return this.returnCode;
    }
}

