/*
 * Decompiled with CFR 0.152.
 */
package de.superx.etl;

import de.superx.bin.SxConnection;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxSqlHelper;
import de.superx.etl.EtlAction;
import de.superx.etl.EtlStep;
import de.superx.etl.EtlUtils;
import de.superx.etl.SqlExecutor;
import de.superx.servlet.SuperXManager;
import de.superx.util.FileUtils;
import de.superx.util.SqlStringUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

public class EtlActionJob
extends EtlAction {
    private String mandantenID;
    private String jobTid;
    private String jobUniquename;
    private String jobLogfile;
    private String jobCaption;
    private Properties runTimeParams;
    private StringWriter sw = new StringWriter();

    public EtlActionJob(String uniquename, String logfile, String propfile) {
        super(uniquename, logfile, propfile);
    }

    public EtlActionJob(String uniquename) {
        super(uniquename);
    }

    public StringWriter getSw() {
        return this.sw;
    }

    public void setSw(StringWriter sw) {
        this.sw = sw;
    }

    public void setRunTimeParams(String runTimeParamsArg) throws IOException {
        if (runTimeParamsArg != null) {
            this.runTimeParams = EtlUtils.convertStringToProperty(runTimeParamsArg);
        }
    }

    public void initJob(String component, String job, String runtimeParamsArg) throws Exception {
        long jetzt = new Date().getTime();
        EtlUtils.initJobEnvironment();
        String paramName = null;
        String paramDefault = "";
        Object paramProperties = "";
        String systeminfoId = "";
        this.setStarttime(jetzt);
        this.initConnectionIfNecessary();
        if (!SqlStringUtils.checkValidKeyEntry(job)) {
            throw new SQLException("Invalid job " + job);
        }
        if (!((String)paramProperties).equals("")) {
            this.setParams(EtlUtils.convertStringToProperty((String)paramProperties));
        }
        if (runtimeParamsArg == null) {
            runtimeParamsArg = this.buildRunTimeParamsArg(job, systeminfoId, component);
        }
        runtimeParamsArg = "SUPERX_DIR=" + EtlUtils.SUPERX_DIR + EtlUtils.NEWLINE + (String)runtimeParamsArg;
        this.setRunTimeParams((String)runtimeParamsArg);
        super.addActionLog("Runtime Params: " + (String)runtimeParamsArg);
        if (this.runTimeParams != null) {
            this.setParams(EtlUtils.mergeParamProperties(this.getParams(), this.runTimeParams));
        }
        String sql = "select J.tid,J.uniquename,J.caption,J.logfile, P.uniquename as param_name,P.name as param_caption, P.param_default,  J.systeminfo_id,D.his_system as modulname from etl_job J left outer join etl_job_param P on (J.tid=P.etl_job_id)  left outer join db_version D on (D.systeminfo_id=J.systeminfo_id)  where J.uniquename='" + job + "';";
        SuperX_el el = new SuperX_el();
        SxSqlHelper sh = new SxSqlHelper();
        sh.execute(sql, this.getDbconnection(), el);
        if (el.getError_String() != null && !el.getError_String().trim().equals("")) {
            throw new SQLException("\nProblem bei Job DETAILS:\n\n  Meldung:" + el.getError_String() + "\n  sql:" + sql);
        }
        SxResultSet result = el.getResultSet();
        int rownr = 0;
        Iterator it = result.iterator();
        while (it.hasNext()) {
            ++rownr;
            SxResultRow row = (SxResultRow)it.next();
            this.jobTid = row.get(0).toString().trim();
            this.jobUniquename = row.get(1).toString().trim();
            this.jobCaption = row.get(2).toString().trim();
            this.jobLogfile = row.get(3).toString().trim();
            if (row.get(4) != null) {
                paramName = row.get(4).toString().trim();
            }
            if (row.get(5) != null) {
                String string = row.get(5).toString().trim();
            }
            if (row.get(4) != null) {
                paramDefault = row.get(6).toString().trim();
            }
            if (paramName != null) {
                paramProperties = (String)paramProperties + paramName + "=" + paramDefault + EtlUtils.NEWLINE;
            }
            if (row.get(7) != null) {
                systeminfoId = row.get(7).toString();
            }
            if (row.get(8) == null) continue;
            component = row.get(8).toString();
        }
        if (rownr == 0) {
            throw new Exception("Job " + job + " unbekannt");
        }
        super.addActionLog("Job gefunden: " + this.jobCaption + EtlUtils.NEWLINE);
        super.addActionLog("Job " + this.jobCaption + " initialized");
    }

    public ArrayList<EtlStep> buildEtlStepList() {
        ArrayList<EtlStep> EtlStepList = new ArrayList<EtlStep>();
        int rownr = 0;
        boolean jobReturnCode = false;
        try {
            SxResultSet result = this.getJobSteps();
            rownr = 0;
            Iterator it = result.iterator();
            while (it.hasNext()) {
                boolean stepReturnCode = false;
                ++rownr;
                SxResultRow row = (SxResultRow)it.next();
                Integer stepTid = (Integer)row.get(0);
                String stepUniquename = row.get(1).toString().trim();
                String stepCaption = row.get(2).toString().trim();
                Integer stepSortnr = (Integer)row.get(4);
                Integer stepForceContinue = (Integer)row.get(5);
                Integer stepParentStepId = (Integer)row.get(6);
                String stepLogfile = row.get(7).toString().trim();
                String stepTypeUniquename = row.get(8).toString().trim();
                String stepTypeCaption = row.get(9).toString().trim();
                String stepTypeHandler = row.get(10).toString().trim();
                EtlStep myStep = new EtlStep(stepUniquename, this.jobLogfile, this.propfile);
                myStep.setDbconnection(this.getDbconnection());
                myStep.initStep(this.jobUniquename, this.getParams(), stepTid, stepUniquename, stepLogfile, stepCaption, stepSortnr, stepForceContinue, stepParentStepId, stepTypeUniquename, stepTypeCaption, stepTypeHandler);
                EtlStepList.add(myStep);
            }
            if (rownr == 0) {
                throw new Exception("Steps unbekannt");
            }
        }
        catch (Exception e1) {
            String error = "Fehler beim Laden der Steps: " + EtlUtils.NEWLINE + e1.toString().trim();
            super.addActionLog(error);
            throw new RuntimeException(error, e1);
        }
        return EtlStepList;
    }

    public int execute(String outfile) throws SQLException, Exception {
        boolean rownr = false;
        int jobReturnCode = 0;
        ArrayList<EtlStep> myEtlSteps = this.buildEtlStepList();
        rownr = false;
        super.addActionLog("Steps found: " + myEtlSteps.size());
        this.sw.write("<?xml version=\"1.0\"  encoding=\"" + SqlStringUtils.getEncoding() + "\" ?><etlAction name=\"" + this.jobUniquename + "\">\n");
        if (myEtlSteps.size() > 0) {
            for (EtlStep myStep : myEtlSteps) {
                int stepReturnCode = 0;
                try {
                    stepReturnCode = myStep.execute();
                }
                catch (Exception e) {
                    stepReturnCode = 0;
                    e.printStackTrace();
                }
                super.addActionLog(myStep.getActionLog().toString());
                this.sw = myStep.getOutputStringWriter();
                if (stepReturnCode == 0) continue;
                if (myStep.getStepForceContinue() == 0) {
                    jobReturnCode = 1;
                }
                break;
            }
        } else {
            throw new Exception("Steps unbekannt");
        }
        this.sw.write("\n</etlAction>\n");
        if (outfile == null || outfile.equals("")) {
            System.out.println(this.sw.toString());
        } else {
            try {
                EtlUtils.saveFileContentsWithEncoding(outfile, this.sw.toString(), null);
            }
            catch (Exception e) {
                e.printStackTrace();
                jobReturnCode = 1;
            }
        }
        long jetzt = new Date().getTime();
        this.setEndtime(jetzt);
        return jobReturnCode;
    }

    public SxResultSet getJobSteps() throws SQLException {
        Object sql = "select S.tid,S.uniquename,S.caption,S.systeminfo_id,R.sortnr,R.force_continue::integer as force_continue,R.parent_step_id,S.logfile,T.uniquename,T.caption,T.handler";
        sql = (String)sql + " FROM etl_step S, etl_step_type T, etl_step_relation R where T.tid=S.step_type_id and R.step_id=S.tid and  R.job_id=" + this.jobTid + " order by R.sortnr,R.tid;";
        SuperX_el el = new SuperX_el();
        SxSqlHelper sh = new SxSqlHelper();
        try {
            sh.execute((String)sql, this.getDbconnection(), el);
        }
        catch (Exception e1) {
            super.addActionLog("Fehler beim SQL: " + (String)sql + EtlUtils.NEWLINE + el.getError_String().trim());
            return null;
        }
        if (el.getError_String() != null && !el.getError_String().trim().equals("")) {
            throw new SQLException("\nProblem bei Steps DETAILS:\n\n  Meldung:" + el.getError_String() + "\n  sql:" + (String)sql);
        }
        SxResultSet myResult = el.getResultSet();
        super.addActionLog("Steps found: " + myResult.size());
        return myResult;
    }

    private String buildRunTimeParamsArg(String jobUniquename, String systeminfoId, String modulName) {
        String ps = EtlUtils.PATHSEP;
        Object rtArg = "";
        if (modulName != null) {
            String modulNameUpper = modulName.toUpperCase();
            String modulPfad = SuperXManager.getWEB_INFPfad() + ps + "conf" + ps + "edustore" + ps + "db" + ps + "module" + ps + modulName;
            rtArg = (String)rtArg + modulNameUpper + "_PFAD=" + modulPfad + EtlUtils.NEWLINE;
            rtArg = (String)rtArg + modulNameUpper + "_LOAD_PFAD=" + modulPfad + ps + "rohdaten" + EtlUtils.NEWLINE;
        }
        return rtArg;
    }

    private int readStepsforInstallUpgradeUnload(String jobUniquename, Properties paramProperties, String modulName) throws Exception {
        File f;
        int returnCode = 0;
        Object sqlScriptFile = "";
        String sqlScript = "";
        if (jobUniquename.endsWith("upgrade")) {
            sqlScriptFile = "$" + modulName.toUpperCase() + "_PFAD" + EtlUtils.PATHSEP + "upgrade" + EtlUtils.PATHSEP + "etl_steps_fuellen_upgrade.sql";
        }
        if (jobUniquename.endsWith("unload")) {
            sqlScriptFile = "$" + modulName.toUpperCase() + "_LOAD_PFAD" + EtlUtils.PATHSEP + "etl_steps_fuellen_unload.sql";
        }
        if ((f = new File((String)(sqlScriptFile = EtlUtils.parseStringAgainstParams((String)sqlScriptFile, paramProperties)))).exists()) {
            sqlScript = FileUtils.getFileContentsWithEncoding((String)sqlScriptFile, null);
            SxConnection myConnection = new SxConnection();
            String dbpropfile = SuperXManager.getWEB_INFPfad() + EtlUtils.PATHSEP + "db.properties";
            myConnection.setPropfile(dbpropfile);
            SqlExecutor mySqlExecutor = new SqlExecutor("default", myConnection, sqlScript, paramProperties);
            returnCode = mySqlExecutor.executeQueries();
            myConnection.close();
        }
        return returnCode;
    }
}

