/*
 * Decompiled with CFR 0.152.
 */
package de.superx.etl.ActionHandler;

import de.superx.bin.SxConnection;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtlActionHandler {
    public Logger logger = LoggerFactory.getLogger(EtlActionHandler.class);
    public Properties handlerSpecificProperties;
    public Properties runTimeParams;
    private String handlerType;
    protected String logOutput = "";
    protected long numberOfRows = 0L;
    protected int returnCode;
    protected SxConnection stepSxConnection;
    protected Connection stepConnection;
    public String propFile;
    public StringWriter outputStringWriter;
    public String outfile;

    public EtlActionHandler(String handlerType, Properties hsp) {
        this.handlerType = handlerType;
        this.handlerSpecificProperties = hsp;
    }

    public EtlActionHandler() {
    }

    public void setReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setNumberOfRows(long numberOfRows) {
        this.numberOfRows = numberOfRows;
    }

    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    public void setConnection(Connection con) {
        this.stepConnection = con;
    }

    public void setLogOutput(String log) {
        this.logOutput = log;
    }

    public String getLogOutput() {
        return this.logOutput;
    }

    public String getPropFile() {
        return this.propFile;
    }

    public void setPropFile(String propFile) {
        this.propFile = propFile;
    }

    public StringWriter getOutputStringWriter() {
        return this.outputStringWriter;
    }

    public void setOutputStringWriter(StringWriter sw) {
        this.outputStringWriter = sw;
    }

    public String getOutfile() {
        return this.outfile;
    }

    public void setOutfile(String outfile) {
        this.outfile = outfile;
    }

    public Properties getHandlerSpecificProperties() {
        return this.handlerSpecificProperties;
    }

    public void setHandlerSpecificProperties(Properties hsp) {
        this.handlerSpecificProperties = hsp;
    }

    public Properties getRunTimeParams() {
        return this.runTimeParams;
    }

    public void setRunTimeParams(Properties runTimeParams) {
        this.runTimeParams = runTimeParams;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected boolean initConnectionIfNecessary() throws SQLException {
        boolean inited = false;
        if (this.stepConnection == null) {
            this.logger.info("Init new connection.");
            this.stepSxConnection = new SxConnection();
            this.stepSxConnection.setPropfile(this.propFile);
            try {
                this.stepConnection = this.stepSxConnection.getConnection();
                inited = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.logger.error("Keine DB-Verbindung: " + e.toString());
                throw new SQLException("Keine DB-Verbindung: " + e.toString());
            }
        } else {
            this.logger.info("Connection already exists.");
        }
        return inited;
    }
}

