/*
 * Decompiled with CFR 0.152.
 */
package de.superx.dbt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zaxxer.hikari.HikariDataSource;
import de.superx.dbt.UnsupportedPythonVersionException;
import de.superx.rest.EtlJobApi;
import de.superx.rest.model.job.Component;
import de.superx.servlet.SuperXManager;
import de.superx.spring.HIS1Databases;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.lang3.SystemUtils;
import org.jfree.util.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;

public class DbtManager
implements Runnable {
    static Logger logger = LoggerFactory.getLogger(DbtManager.class);
    private final boolean isLinux = SystemUtils.IS_OS_LINUX;
    private final Path dbtInstallDirUser = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "dbt_" + (this.isLinux ? "linux" : "windows")).toAbsolutePath().normalize();
    private final Path dbtInstallDirEnv = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "dbt_env_" + (this.isLinux ? "linux" : "windows")).toAbsolutePath().normalize();
    private Path dbtInstallDir;
    private String pythonExecutable = "python";
    private String user = "postgres";
    private String password = "postgres";
    private String host = "localhost";
    private String port = "5432";
    private String db = "eduetl";
    private Process process;
    private int modelCount = 0;
    private String runtimeErrors = "";
    private String select;
    private boolean test;
    private Path projectPath;
    private List<JsonNode> dbtLog = new ArrayList<JsonNode>();
    private JsonNode stats;
    private EtlJobApi etlJobApi;

    public DbtManager(Path projectPath, String select) {
        this(projectPath, select, true, false);
    }

    public DbtManager(Path projectPath, String select, boolean test) {
        this(projectPath, select, true, test);
    }

    public DbtManager(Path projectPath, String select, boolean readDBProperties, boolean test) {
        if (!projectPath.toFile().isDirectory()) {
            throw new RuntimeException(projectPath.toAbsolutePath() + " is no directory!");
        }
        File projectFile = Path.of(projectPath.toString(), "dbt_project.yml").toFile();
        if (!projectFile.exists()) {
            throw new RuntimeException(projectPath + " is no dbt project directory (no dbt_project.yml found)!");
        }
        File profilesFile = Path.of(projectPath.toString(), "profiles.yml").toFile();
        if (!profilesFile.exists()) {
            throw new RuntimeException(projectPath + " is no dbt project directory (no profiles.yml found)!");
        }
        this.projectPath = projectPath.toAbsolutePath().normalize();
        this.pythonExecutable = DbtManager.getPython3ExecutableName();
        this.select = select;
        this.test = test;
        if (readDBProperties) {
            try {
                Map<String, String> eduetl = HIS1Databases.getConnection("eduetl");
                this.user = eduetl.get("user");
                this.password = eduetl.get("password");
                this.host = eduetl.get("host");
                this.port = eduetl.get("dbserverport");
                this.db = eduetl.get("database");
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't get connection info for eduetl", e);
            }
        }
        this.dbtInstallDir = this.dbtInstallDirEnv.toFile().isDirectory() ? this.dbtInstallDirEnv : this.dbtInstallDirUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Path dbt = this.getDbtPath();
        ArrayList<String> pbCommand = new ArrayList<String>(Arrays.asList(this.pythonExecutable, dbt.toString(), "--log-format", "json", "--no-use-colors"));
        if (!this.isLinux && this.dbtInstallDirEnv.toFile().isDirectory()) {
            pbCommand.remove(0);
        }
        if (this.test) {
            pbCommand.add("test");
        } else {
            pbCommand.addAll(Arrays.asList("build", "--resource-types", "snapshot", "seed", "model"));
        }
        if (this.select != null && !this.select.isBlank()) {
            pbCommand.add("--select");
            pbCommand.add(this.select);
        }
        logger.info("Project path: " + this.projectPath.toString());
        logger.info("dbt_bin: " + dbt.toString());
        logger.info(Arrays.toString(pbCommand.toArray()));
        ProcessBuilder p = new ProcessBuilder(pbCommand).directory(this.projectPath.toFile());
        Map<String, String> env = this.getComponentStatus();
        env.putAll(this.getDbtEnvironment());
        env.putAll(DbtManager.getUnloadParams());
        p.environment().putAll(env);
        p.redirectErrorStream(false);
        this.dbtLog = new ArrayList<JsonNode>();
        try {
            this.modelCount = 0;
            this.process = p.start();
            logger.info("ProcessBuilder start");
            logger.info("PYTHONUSERBASE: " + p.environment().get("PYTHONUSERBASE"));
            String pathVar = "PATH";
            if (!this.isLinux) {
                pathVar = "Path";
            }
            logger.info("PATH: " + p.environment().get(pathVar));
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            CompletableFuture<String> errFuture = DbtManager.readOutStream(this.process.getErrorStream());
            errFuture.thenAccept(error -> this.checkStdError((String)error));
            String line = "";
            ObjectMapper objectMapper = new ObjectMapper();
            while ((line = reader.readLine()) != null) {
                logger.info(line);
                JsonNode node = objectMapper.readTree(line.getBytes());
                JsonNode data = node.get("data");
                if (data.get("stats") != null) {
                    this.stats = node;
                    continue;
                }
                if (data.has("index")) {
                    this.modelCount = data.get("index").asInt();
                }
                this.dbtLog.add(node);
            }
        }
        catch (Exception e) {
            logger.error("Couldn't start dbt run!", (Throwable)e);
            this.runtimeErrors = "Couldn't start dbt run!\n" + e.getMessage();
        }
        finally {
            if (!this.test) {
                this.generateDocs(env);
            }
        }
    }

    public String getPythonExecutableName() {
        return this.pythonExecutable;
    }

    public Path getDbtBinDir() {
        return Path.of(this.dbtInstallDir.toString(), "bin");
    }

    private Map<String, String> getComponentStatus() {
        HashMap<String, String> result = new HashMap<String, String>();
        EtlJobApi api = this.etlJobApi == null ? SuperXManager.getBean(null, EtlJobApi.class) : this.etlJobApi;
        List<Component> components = api.getInstallJobs();
        for (Component comp : components) {
            result.put("COMP_" + comp.getAbbreviation().toUpperCase() + "_INSTALLED", comp.isInstalled() ? "TRUE" : "FALSE");
        }
        return result;
    }

    public int getModelCount() {
        return this.modelCount;
    }

    public List<String> getErrorMessages() {
        ArrayList<String> result = new ArrayList<String>();
        if (!this.runtimeErrors.isEmpty()) {
            result.add(this.runtimeErrors);
        } else {
            for (JsonNode node : this.dbtLog) {
                Optional<JsonNode> level = DbtManager.findFirstOccurence("level", node);
                if (level.isPresent() && "error".equals(level.get().asText())) {
                    Optional<JsonNode> msg = DbtManager.findFirstOccurence("msg", node);
                    if (msg.isPresent()) {
                        result.add(msg.get().asText());
                        continue;
                    }
                    logger.warn("No msg property found in dbt log " + node);
                    continue;
                }
                logger.warn("No level property found in dbt log " + node);
            }
        }
        return result;
    }

    public Process getProcess() {
        return this.process;
    }

    public Optional<Boolean> isSuccess() {
        Optional<Boolean> success = Optional.empty();
        if (this.stats != null) {
            success = Optional.of(this.stats.get("data").get("stats").get("error").asInt() == 0);
        }
        return success;
    }

    public String getPythonVersion() {
        return DbtManager.getPythonVersion(this.pythonExecutable);
    }

    public void generateDocs(Map<String, String> env) {
        try {
            Path dbt = this.getDbtPath();
            ArrayList<String> pbCommand = new ArrayList<String>(Arrays.asList(this.pythonExecutable, dbt.toString(), "--no-use-colors", "docs", "generate"));
            if (this.select != null && !this.select.isBlank()) {
                pbCommand.add("--select");
                pbCommand.add(this.select);
            }
            ProcessBuilder pb = new ProcessBuilder(pbCommand).directory(this.projectPath.toFile());
            pb.environment().putAll(env);
            pb.redirectErrorStream(true);
            Process p = pb.start();
            InputStream stdoutInputStream = p.getInputStream();
            BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(stdoutInputStream));
            String line = null;
            while ((line = stdoutReader.readLine()) != null) {
                logger.info(line);
            }
        }
        catch (Exception iox) {
            throw new RuntimeException("Couldn't run dbt generate docs ", iox);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getPythonVersion(String executable) {
        try {
            ProcessBuilder p = new ProcessBuilder(executable, "--version");
            p.redirectErrorStream(true);
            Process process = p.start();
            try (InputStreamReader input = new InputStreamReader(process.getInputStream());){
                String string;
                try (BufferedReader br = new BufferedReader(input);){
                    String output = br.lines().collect(Collectors.joining("\n"));
                    string = output.substring(output.indexOf(32) + 1);
                }
                return string;
            }
        }
        catch (Exception iox) {
            throw new RuntimeException("Couldn't execute " + executable + ". Is Python 3 installed and in PATH?", iox);
        }
    }

    public static String getPython3ExecutableName() {
        String[] executables = new String[]{"python", "python3", "python.bat"};
        String version = "";
        for (String executable : executables) {
            try {
                version = DbtManager.getPythonVersion(executable);
                if (!version.startsWith("3")) continue;
                return executable;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new RuntimeException("No Python 3 found in PATH!");
    }

    public Map<String, String> getDbtEnvironment() {
        Map<String, String> env = Map.ofEntries(Map.entry("PYTHONUSERBASE", this.dbtInstallDir.toString()), Map.entry("DBT_HOST", this.host), Map.entry("DBT_PORT", this.port.toString()), Map.entry("DBT_USER", this.user), Map.entry("DBT_ENV_SECRET_PW", this.password), Map.entry("DBT_DB", this.db));
        return env;
    }

    public List<JsonNode> getDbtLog() {
        return List.copyOf(this.dbtLog);
    }

    private Path getDbtPath() {
        Path dbt = Path.of(this.getDbtBinDir().toString(), "dbt");
        if (!this.isLinux && !this.dbtInstallDirEnv.toFile().isDirectory()) {
            String[] majorMinor = this.getPythonVersion().split("\\.");
            dbt = Path.of(this.dbtInstallDir.toString(), "Python" + majorMinor[0] + majorMinor[1], "Scripts", "dbt.exe").toAbsolutePath();
        } else if (!this.isLinux) {
            dbt = Path.of(this.dbtInstallDir.toString(), "Scripts", "dbt.exe").toAbsolutePath();
        }
        return dbt;
    }

    private static Optional<JsonNode> findFirstOccurence(String name, JsonNode searchNode) {
        JsonNode parent = searchNode.findParent(name);
        JsonNode result = parent != null ? parent.get(name) : null;
        return Optional.of(result);
    }

    private boolean checkStdError(String errorString) {
        boolean error = false;
        if (errorString.length() > 0) {
            this.runtimeErrors = "Error starting dbt: \n" + errorString;
            logger.error(this.runtimeErrors);
            error = true;
        }
        return error;
    }

    private static CompletableFuture<String> readOutStream(InputStream is) {
        return CompletableFuture.supplyAsync(() -> {
            try (InputStreamReader isr = new InputStreamReader(is);){
                String string;
                try (BufferedReader br = new BufferedReader(isr);){
                    String inputLine;
                    StringBuilder res = new StringBuilder();
                    while ((inputLine = br.readLine()) != null) {
                        res.append(inputLine).append(System.lineSeparator());
                    }
                    string = res.toString();
                }
                return string;
            }
            catch (Throwable e) {
                throw new RuntimeException("problem with executing program", e);
            }
        });
    }

    private static Map<String, String> getUnloadParams() {
        DataSource ds = (DataSource)SuperXManager.getBean("dataSource", HikariDataSource.class);
        Map<String, String> result = new HashMap<String, String>();
        if (ds != null) {
            JdbcTemplate jt = new JdbcTemplate(ds);
            result = (Map)jt.query("SELECT param_id, param_val FROM unload_params", (ResultSetExtractor)new ResultSetExtractor<Map<String, String>>(){

                public Map<String, String> extractData(ResultSet rs) throws SQLException, DataAccessException {
                    HashMap<String, String> params = new HashMap<String, String>();
                    while (rs.next()) {
                        String key = rs.getString("param_id");
                        String value = rs.getString("param_val");
                        String string = value = value == null ? "" : value;
                        if (key != null) {
                            params.put(key, value);
                            continue;
                        }
                        Log.warn((Object)("Null key " + key + " -> " + value));
                    }
                    return params;
                }
            });
        }
        return result;
    }

    private static Path getDbtInstallDir() {
        boolean isLinux = SystemUtils.IS_OS_LINUX;
        Path dbtInstallDir = null;
        Path dbtInstallDirUser = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "dbt_" + (isLinux ? "linux" : "windows")).toAbsolutePath().normalize();
        Path dbtInstallDirEnv = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "dbt_env_" + (isLinux ? "linux" : "windows")).toAbsolutePath().normalize();
        dbtInstallDir = dbtInstallDirEnv.toFile().isDirectory() ? dbtInstallDirEnv : dbtInstallDirUser;
        return dbtInstallDir;
    }

    public static String getBinInDbtDir(String bin) {
        boolean isLinux = SystemUtils.IS_OS_LINUX;
        String pythonExecutable = DbtManager.getPython3ExecutableName();
        String version = DbtManager.getPythonVersion(pythonExecutable);
        Path dbtInstallDir = DbtManager.getDbtInstallDir();
        Path sl = Path.of(dbtInstallDir.toString(), "bin", bin);
        if (!isLinux) {
            String[] majorMinor = version.split("\\.");
            sl = Path.of(dbtInstallDir.toString(), "Python" + majorMinor[0] + majorMinor[1], "Scripts", bin + ".exe").toAbsolutePath();
        }
        return sl.toString();
    }

    public static List<String> getStagingTables(String select) {
        try {
            Path dbtProjectDir = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "projects", "hisinone", "transform");
            ProcessBuilder builder = new ProcessBuilder(DbtManager.getPython3ExecutableName(), DbtManager.getBinInDbtDir("dbt"), "ls", "--select", select, "--output", "name").directory(dbtProjectDir.toFile());
            Map<String, String> env = builder.environment();
            env.put("COMP_RES_INSTALLED", "true");
            env.put("DBT_DB", "eduetl");
            env.put("PYTHONUSERBASE", DbtManager.getDbtInstallDir().toString());
            Process process = builder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            CompletableFuture<String> errFuture = DbtManager.readOutStream(process.getErrorStream());
            errFuture.thenAccept(error -> {
                if (error.length() > 0) {
                    logger.warn("WARNING: could not get staging tables for select: " + select);
                    logger.warn(error);
                }
            });
            List results = reader.lines().collect(Collectors.toList());
            ArrayList<String> tables = new ArrayList<String>();
            for (String model : results) {
                if (!model.startsWith("staging.")) continue;
                tables.add(model.split("staging.")[1]);
            }
            return tables;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void checkPythonCompatability(String pythonVersion) throws UnsupportedPythonVersionException {
        try {
            Path dbtInstallLib = Path.of(SuperXManager.getWEB_INFPfad(), "..", "dbt", "dbt_linux", "lib").toAbsolutePath().normalize();
            List files = Files.list(dbtInstallLib).collect(Collectors.toList());
            ArrayList<String> supportedVersions = new ArrayList<String>();
            for (Path path : files) {
                String version = path.toString().split("python")[1];
                supportedVersions.add(version);
            }
            String[] splitVersion = pythonVersion.split("\\.");
            String userVersion = splitVersion[0] + "." + splitVersion[1];
            if (!supportedVersions.contains(userVersion)) {
                String errorMessage = "Unsupported version of Python: " + userVersion + ".Supported Versions: ";
                StringJoiner joiner = new StringJoiner(", ");
                for (String version : supportedVersions) {
                    joiner.add(version);
                }
                errorMessage = errorMessage + joiner.toString();
                throw new UnsupportedPythonVersionException(errorMessage);
            }
        }
        catch (UnsupportedPythonVersionException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setEtlJobApi(EtlJobApi etlJobApi) {
        this.etlJobApi = etlJobApi;
    }
}

