/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.util.XMLUtils;
import de.superx.common.AbstractSicht;
import freemarker.template.TemplateModelException;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLModifier {
    private String name;

    public XMLModifier(String name) {
        this.name = name;
    }

    public void modify(File f, AbstractSicht s) throws TemplateModelException {
        try {
            DocumentBuilderFactory docFactory = XMLUtils.createSecureDocumentBuilderFactory();
            docFactory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(f);
            System.out.println("**** Modifying Mondrian Schema for " + s.getName());
            NodeList nl = doc.getElementsByTagName("Dimension");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node node = nl.item(i);
                if (!this.getAttribValue(node, "name").equals(this.name)) continue;
                System.out.println("found dimension " + this.name + " " + i);
                this.checkHierarchy(doc, node, s);
            }
            this.writeFile(f, doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TemplateModelException("xml \u00c4nderung fehlgeschlagen:", e);
        }
    }

    private void checkHierarchy(Document doc, Node node, AbstractSicht s) {
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node hnode = nl.item(i);
            if (!"Hierarchy".equals(hnode.getNodeName())) continue;
            this.removeIfAlreadyExists(hnode, node, s.getName_intern());
        }
        Element hier = doc.createElement("Hierarchy");
        hier.setAttribute("primaryKey", "apnr");
        hier.setAttribute("hasAll", "true");
        hier.setAttribute("allMemberCaption", "Alle " + s.getName());
        hier.setAttribute("caption", s.getName());
        hier.setAttribute("name", s.getName().replace('/', '-'));
        Element annotations = doc.createElement("Annotations");
        Element annotation = doc.createElement("Annotation");
        annotation.setAttribute("name", "name_intern");
        annotation.appendChild(doc.createTextNode(s.getName_intern()));
        annotations.appendChild(annotation);
        hier.appendChild(annotations);
        Element table = doc.createElement("Table");
        table.setAttribute("name", "dim_bp_altsicht_apnr");
        table.setAttribute("alias", "dim_bp_altsicht_apnr_" + s.getName_intern());
        Element sql = doc.createElement("SQL");
        sql.appendChild(doc.createTextNode("\"dim_bp_altsicht_apnr_" + s.getName_intern() + "\".\"hierarchie_id\"='" + s.getName_intern() + "'"));
        table.appendChild(sql);
        hier.appendChild(table);
        Element level = doc.createElement("Level");
        level.setAttribute("caption", s.getName());
        level.setAttribute("name", s.getName().replace('/', '-'));
        level.setAttribute("type", "Numeric");
        level.setAttribute("nameColumn", "druck");
        level.setAttribute("column", "apnr");
        level.setAttribute("uniqueMembers", "true");
        level.setAttribute("parentColumn", "parent");
        level.setAttribute("nullParentValue", "null");
        Element closure = doc.createElement("Closure");
        closure.setAttribute("parentColumn", "parent");
        closure.setAttribute("childColumn", "key");
        Element table2 = doc.createElement("Table");
        table2.setAttribute("name", "dim_closure");
        Element sql2 = doc.createElement("SQL");
        sql2.appendChild(doc.createTextNode("\"dim_closure\".\"hierarchie_id\"='" + s.getName_intern() + "'"));
        table2.appendChild(sql2);
        closure.appendChild(table2);
        level.appendChild(closure);
        hier.appendChild(level);
        node.appendChild(hier);
        System.out.println("Added Hierarchy: " + hier.getTextContent());
    }

    private void removeIfAlreadyExists(Node hierarchyNode, Node dimensionNode, String name_intern) {
        NodeList children = hierarchyNode.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            System.out.println("Child of hierarchy: " + child.getNodeName());
            if (!"Annotations".equals(child.getNodeName())) continue;
            NodeList annotations = child.getChildNodes();
            System.out.println("Found Annotations... Count: " + annotations.getLength());
            for (int ii = 0; ii < annotations.getLength(); ++ii) {
                if (!"name_intern".equals(this.getAttribValue(annotations.item(ii), "name"))) continue;
                String content = annotations.item(ii).getTextContent();
                System.out.println("Content: " + content);
                if (!name_intern.equals(content)) continue;
                System.out.println("Removing annotated hierarchy " + this.name);
                dimensionNode.removeChild(hierarchyNode);
            }
        }
    }

    private String getAttribValue(Node node, String attrib) {
        NamedNodeMap attribs = node.getAttributes();
        if (attribs == null) {
            return "";
        }
        System.out.println("Attributes of node " + node.getNodeName() + ": ");
        int count = attribs.getLength();
        for (int i = 0; i < count; ++i) {
            System.out.println("Attribute Name: " + attribs.item(i).getNodeName() + " Value: " + attribs.item(i).getNodeValue());
        }
        String result = "";
        Node node2 = attribs.getNamedItem(attrib);
        String string = result = node2 != null ? node2.getNodeValue() : "";
        if (result == null) {
            result = "";
        }
        return result;
    }

    private void writeFile(File f, Document doc) throws TransformerException {
        this.removeEmptyTextNodes(doc);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(f);
        transformer.transform(source, result);
    }

    private void removeEmptyTextNodes(Document doc) {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        try {
            XPathExpression xpathExp = xpathFactory.newXPath().compile("//text()[normalize-space(.) = '']");
            NodeList emptyTextNodes = (NodeList)xpathExp.evaluate(doc, XPathConstants.NODESET);
            for (int i = 0; i < emptyTextNodes.getLength(); ++i) {
                Node emptyTextNode = emptyTextNodes.item(i);
                emptyTextNode.getParentNode().removeChild(emptyTextNode);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }
}

