/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.baseobjects.coll.NamedObjectSet;
import de.memtext.util.StringUtils;
import de.memtext.util.TransletUtils;
import de.memtext.util.TransletWrapper;
import de.superx.common.DBServletException;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SxPools;
import de.superx.util.SqlStringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class TransletCache {
    private static final String SCHEME_PREFIX = "file:";
    private static final String _PDF = "_pdf";
    private static NamedObjectSet transletPool = new NamedObjectSet();
    private static Map<String, String> merkmale = new HashMap<String, String>();
    private static Date lastClear;

    private TransletCache() {
    }

    public static boolean isFullXMLRequired(String filename) {
        return merkmale.containsKey(filename) && merkmale.get(filename).equals("fullXML");
    }

    public static Transformer getTransformer(String mandantenID, String filename) throws TransformerConfigurationException, DBServletException {
        TransletWrapper tr = null;
        Object transletname = filename;
        if (mandantenID != null && SxPools.get(mandantenID).hasCustomPDFFile() && filename.toLowerCase().contains(_PDF)) {
            transletname = (String)transletname + mandantenID;
        }
        if (transletPool.containsItemWithName((String)transletname)) {
            tr = (TransletWrapper)transletPool.getByName((String)transletname);
            if (mandantenID != null) {
                Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.DEBUG, (Object)("   using prepared translet: " + filename));
            }
        } else {
            try {
                tr = TransletCache.prepareTranslet(filename, mandantenID);
                if (filename.toLowerCase().indexOf("maske") > -1) {
                    URI u = new URI(filename.replace('\\', '/').replace(" ", "%20"));
                    String content = StringUtils.readFile(new File(u));
                    if (content.indexOf("dojo") == -1 || content.indexOf("isFullXMLRequired=true") > -1) {
                        merkmale.put(filename, "fullXML");
                    }
                } else {
                    merkmale.remove(filename);
                }
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
                throw new DBServletException("Konnte XSL-Datei " + filename + " nicht kompilieren evtl. Datei nicht gefunden. DETAILS: Genauere Infos in  tomcat-logs (catalina.out)");
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new DBServletException("Konnte XSL-Datei " + filename + " nicht pr\u00fcfen. DETAILS: Genauere Infos in  tomcat-logs (catalina.out)");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
                throw new DBServletException("Konnte XSL-Datei " + filename + " nicht pr\u00fcfen. DETAIS: Genauere Infos in  tomcat-logs (catalina.out)");
            }
            transletPool.add(tr);
            if (mandantenID != null) {
                Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.DEBUG, (Object)("   using freshly compiled translet: " + filename));
            }
        }
        Transformer t = tr.newTransformer();
        t.setOutputProperty("encoding", SqlStringUtils.getEncoding());
        return t;
    }

    private static TransletWrapper prepareTranslet(String fileuri_par, String mandantenID) throws TransformerConfigurationException {
        Object fileuri;
        TransletWrapper tr = null;
        Object transletname = fileuri = fileuri_par;
        if (((String)fileuri).toLowerCase().contains(_PDF) && mandantenID != null && SxPools.get(mandantenID).hasCustomPDFFile()) {
            File fRead = null;
            URI uRead = null;
            File fWrite = null;
            URI uWrite = null;
            try {
                String xsl;
                fileuri = ((String)fileuri).replace('\\', '/');
                if (!((String)fileuri).startsWith(SCHEME_PREFIX)) {
                    fileuri = SCHEME_PREFIX + (String)fileuri;
                }
                if ((xsl = StringUtils.readFile(fRead = new File(uRead = new URI((String)fileuri)))).indexOf("<!--<xsl:import href=\"../custom/MANDANTENID/custom_pdf.xsl\"/>-->") > -1) {
                    String tmp_xsl = StringUtils.replace(xsl, "<!--<xsl:import href=\"../custom/MANDANTENID/custom_pdf.xsl\"/>-->", "<xsl:import href=\"../" + mandantenID + "/custom/custom_pdf.xsl\"/>");
                    fileuri = ((String)fileuri).replace(".xsl", "") + "_" + mandantenID + "_tmp.xsl";
                    uWrite = new URI((String)fileuri);
                    fWrite = new File(uWrite);
                    FileUtils.writeStringToFile((File)fWrite, (String)tmp_xsl);
                    transletname = (String)transletname + mandantenID;
                }
            }
            catch (Exception e) {
                throw new TransformerConfigurationException("Datei uri " + (String)fileuri + " kann nicht gelesen oder verarbeitet werden");
            }
        }
        tr = new TransletWrapper((String)transletname, TransletUtils.createTemplate((String)fileuri));
        return tr;
    }

    @Deprecated
    public static void initStandardTranslets() throws TransformerConfigurationException, DBServletException {
        TransletCache.getTransformer("file:///" + ServletUtils.getPath() + "/menue_html.xsl", "");
        TransletCache.getTransformer("file:///" + ServletUtils.getPath() + "/maske_html.xsl", "");
        TransletCache.getTransformer("file:///" + ServletUtils.getPath() + "/tabelle_html.xsl", "");
    }

    public static void clear() {
        transletPool.clear();
        lastClear = new Date();
    }

    public static Date getLastClear() {
        return lastClear;
    }

    public static int getTransletPoolSize() {
        return transletPool.size();
    }

    public static int getMerkmaleSize() {
        return merkmale.size();
    }
}

