/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import de.memtext.baseobjects.User;
import de.memtext.db.NichtAngemeldetException;
import de.memtext.rights.Rights;
import de.memtext.util.CryptUtils;
import de.memtext.util.DateUtils;
import de.superx.common.DBServletException;
import de.superx.common.DatenblattFields;
import de.superx.common.DatenblattTables;
import de.superx.common.IsUserInAtLeastOneGroup;
import de.superx.common.IsUserInGroup;
import de.superx.common.IsUserInGroupWithName;
import de.superx.common.OrgUnit;
import de.superx.common.SelectionBuffer;
import de.superx.common.Sichten;
import de.superx.common.SxFinRechte;
import de.superx.common.SxKontierungsrechte;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.TableFieldExists;
import de.superx.common.UserHasMaskRight;
import de.superx.common.UserHasSachgebRight;
import de.superx.servlet.ServletUtils;
import de.superx.servlet.SxSQL_Server;
import de.superx.servlet.Themenbaum;
import freemarker.template.TemplateBooleanModel;
import java.io.Serializable;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import javax.xml.transform.TransformerException;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.GrantedAuthoritiesContainer;
import org.springframework.security.core.userdetails.UserDetails;

public class SxUser
extends User
implements Serializable,
UserDetails,
GrantedAuthoritiesContainer {
    public static final String USER_ROLE_PLACEHOLDER = "UserRole";
    public static final String USER_ROLE_ID_PLACEHOLDER = "UserRoleId";
    public static final String USER_HISINONE_ORGUNIT_LID_PLACEHOLDER = "UserHISinOneOrgunitLid";
    private final UUID uuid = UUID.randomUUID();
    private Themenbaum themenbaum = new Themenbaum();
    private String mandantenID = SxSQL_Server.DEFAULT_MANDANTEN_ID;
    private Sichten sichten = new Sichten();
    private List<Integer> erlaubteMaskenTids = new ArrayList<Integer>();
    private Collection groups = new LinkedList();
    private Collection groupnames = new LinkedList();
    private Collection sachgebiete = new LinkedList();
    private String[] oldShas = new String[7];
    private String currentSha = "";
    private SxFinRechte finRechte = new SxFinRechte();
    private HashMap basicMap = new HashMap();
    private SelectionBuffer sb = new SelectionBuffer();
    private boolean hasMaskenEditRights = false;
    private Collection hiddenFields = new LinkedList();
    private Map<String, Map<String, String>> rightsMap = new HashMap<String, Map<String, String>>();
    private String role = "";
    private Integer roleId;
    private Integer hisInOneOrgUnitLidOfRole;
    private Set<OrgUnit> allowedOrgUnits = new TreeSet<OrgUnit>();
    private Set<OrgUnit> implicitlyAllowedOrgUnits = new TreeSet<OrgUnit>();
    private SxKontierungsrechte sxKontierungsrechte = new SxKontierungsrechte();
    private static final long serialVersionUID = 7L;

    public SxUser() {
        this.init();
    }

    public SxUser(String username, Integer userid) throws SQLException, DBServletException, TransformerException {
        super(username, userid);
        this.init();
    }

    public SxUser(String username, Integer userid, String mandantenId) throws SQLException, DBServletException, TransformerException {
        super(username, userid);
        this.mandantenID = mandantenId;
        this.init();
    }

    public SxUser(String username) {
        super(username);
    }

    public void init() {
        this.sichten.setUser(this);
        this.basicMap.put("SxFinRechte", this.finRechte);
        this.basicMap.put("SxKontierungsrechte", this.sxKontierungsrechte);
        this.basicMap.put("Username", this.getName());
        this.basicMap.put("today", DateUtils.getTodayString());
        this.basicMap.put("yeartoday", DateUtils.getYear(new Date(new java.util.Date().getTime())));
        this.basicMap.put("databaseMajorVersion", 0);
        this.basicMap.put("databaseMinorVersion", 0);
        this.basicMap.put("DatenblattTables", new DatenblattTables(this.getMandantenID()));
        this.basicMap.put("DatenblattFields", new DatenblattFields());
        this.basicMap.put("TableFieldExists", new TableFieldExists(this.getMandantenID()));
    }

    public void addImplicitlyAllowedOrgUnit(OrgUnit ou) {
        this.implicitlyAllowedOrgUnits.add(ou);
    }

    public Set<OrgUnit> getImplicitlyAllowedOrgUnits() {
        return this.implicitlyAllowedOrgUnits;
    }

    public int getUserIdAsInt() {
        return (Integer)this.getId();
    }

    public SelectionBuffer getSelectionBuffer() {
        return this.sb;
    }

    @Override
    public void setAdmin(boolean isAdmin) {
        super.setAdmin(isAdmin);
        this.basicMap.put("UserIsAdmin", this.isAdmin() ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE);
        this.finRechte.setHasAllRights(isAdmin);
        this.sxKontierungsrechte.setHasAllRights(true);
    }

    public HashMap getBasicMap() {
        return this.basicMap;
    }

    public Themenbaum getThemenbaum() {
        return this.themenbaum;
    }

    public Sichten getSichten() {
        return this.sichten;
    }

    public void setUserid(Integer id) {
        super.setId(id);
    }

    public void setRoleId(Integer id) {
        this.roleId = id;
        this.basicMap.put(USER_ROLE_ID_PLACEHOLDER, this.roleId);
    }

    public String getRole() {
        return this.role != null ? this.role : "";
    }

    public Integer getRoleId() {
        return this.roleId != null ? this.roleId : Integer.valueOf(-1);
    }

    public void clearCache() {
        this.sichten.clear();
    }

    public void initErlaubteMasken(List<Integer> maskenTids) {
        this.erlaubteMaskenTids.addAll(maskenTids);
        this.basicMap.put("UserMaskRights", this.getMaskRights());
        this.basicMap.put("UserHasMaskRight", new UserHasMaskRight(this));
    }

    public String getMaskRights() {
        StringBuffer result = new StringBuffer(",");
        Iterator<Integer> it = this.erlaubteMaskenTids.iterator();
        while (it.hasNext()) {
            result.append(it.next() + ",");
        }
        return result.toString();
    }

    public void checkAuthentificationForMask(String tidStr) {
        if (tidStr == null) {
            throw new IllegalStateException("Kann Maske nicht \u00f6ffnen DETAILS:tid parameter war null");
        }
        if (!this.isMaskAllowed(tidStr)) {
            throw new IllegalArgumentException("Sie haben keine Berechtigung f\u00fcr Maske mit ID-Nummer " + tidStr);
        }
    }

    boolean isMaskAllowed(String tidStr) {
        boolean result = false;
        if (this.isAdmin()) {
            result = true;
        } else {
            try {
                result = this.erlaubteMaskenTids.contains(Integer.valueOf(tidStr));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean hasRightsOnReport(int tid) {
        return this.erlaubteMaskenTids.contains(tid);
    }

    public boolean isPWUsedBefore(String check) {
        boolean result = false;
        String sha1 = CryptUtils.encodeSHA(check);
        String sha2 = CryptUtils.encodeSHA(check + CryptUtils.geheimnis1);
        for (int i = 0; i < 7; ++i) {
            if (this.oldShas[i] == null || !sha1.equals(this.oldShas[i]) && !sha2.equals(this.oldShas[i])) continue;
            result = true;
        }
        return result;
    }

    public boolean isPWSHAUsedBefore(String sha) {
        boolean result = false;
        for (int i = 0; i < 7; ++i) {
            if (this.oldShas[i] == null || !sha.equals(this.oldShas[i])) continue;
            result = true;
        }
        return result;
    }

    public void setOldSha(int pos, String oldsha) {
        this.oldShas[pos] = oldsha;
    }

    public String getMandantenID() {
        return this.mandantenID;
    }

    public void setMandantenID(String mandantenID) {
        this.mandantenID = mandantenID;
    }

    public void rememberOldSHA(String oldsha) {
        for (int i = 6; i > 0; --i) {
            this.oldShas[i] = this.oldShas[i - 1];
        }
        this.oldShas[0] = oldsha;
    }

    public String getUser_PW_Command(int gueltigkeit) {
        Object gueltig = "'1.1.3000'";
        if (gueltigkeit > 0) {
            gueltig = "'" + DateUtils.formatGerman(DateUtils.makeFutureDate(new Date(new java.util.Date().getTime()), gueltigkeit)) + "'";
        }
        String result = "delete from user_pw where userinfo_id='" + this.getId() + "'; insert into user_pw (userinfo_id,pw_gueltig_bis,old_sha1,old_sha2,old_sha3,old_sha4,old_sha5,old_sha6,old_sha7) values ('" + this.getId() + "',date_val(" + (String)gueltig + ")";
        for (int i = 0; i < 7; ++i) {
            result = this.oldShas[i] == null ? result + ",null" : result + ",'" + this.oldShas[i] + "'";
        }
        result = result + ")";
        return result;
    }

    public String getCurrentSha() {
        return this.currentSha;
    }

    public void setCurrentSha(String sha) {
        this.currentSha = sha;
    }

    public void initFinRechte(SxResultSet rs, int finRightVariant, SxResultSet rsProjToInst, boolean is0FINJoker, HashMap repository) {
        this.finRechte.setVariant(finRightVariant);
        this.finRechte.setRepository(repository);
        this.finRechte.set0FINJoker(is0FINJoker);
        if (this.isAdmin()) {
            this.finRechte.setHasAllRights(true);
        }
        for (SxResultRow row : rs) {
            this.finRechte.createAndAddEntry(row);
        }
        for (SxResultRow row : rsProjToInst) {
            this.finRechte.addProj((String)row.get(0));
        }
    }

    public void addGruppe(String groupid, String groupname) {
        this.groups.add(groupid);
        this.groupnames.add(groupname);
        this.updateFreemarkerBasicMap();
    }

    public void updateFreemarkerBasicMap() {
        this.basicMap.put("UserIsAdmin", this.isAdmin() ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE);
        this.basicMap.put("UserGroups", this.getGroups());
        this.basicMap.put("UserSachgebiete", this.getSachgebiete());
        this.basicMap.put("UserGroupnames", this.getGroupnames());
        this.basicMap.put("IsUserInGroup", new IsUserInGroup(this));
        this.basicMap.put("IsUserInGroupWithName", new IsUserInGroupWithName(this));
        this.basicMap.put("IsUserInAtLeastOneGroup", new IsUserInAtLeastOneGroup(this));
    }

    public String getSachgebiete() {
        StringBuffer result = new StringBuffer(",");
        Iterator it = this.sachgebiete.iterator();
        while (it.hasNext()) {
            result.append(it.next() + ",");
        }
        return result.toString();
    }

    public String getSachgebieteIn() {
        StringBuffer result = new StringBuffer();
        Iterator it = this.sachgebiete.iterator();
        while (it.hasNext()) {
            result.append(it.next());
            if (!it.hasNext()) continue;
            result.append(',');
        }
        return result.toString();
    }

    public String getGroups() {
        StringBuffer result = new StringBuffer(",");
        Iterator it = this.groups.iterator();
        while (it.hasNext()) {
            result.append(it.next() + ",");
        }
        return result.toString();
    }

    public String getGroupnames() {
        StringBuffer result = new StringBuffer(",");
        Iterator it = this.groupnames.iterator();
        while (it.hasNext()) {
            result.append(it.next() + ",");
        }
        return result.toString();
    }

    public boolean isInGroup(String group) {
        return this.groups.contains(group);
    }

    public boolean isInGroupWithName(String group) {
        return this.groupnames.contains(group);
    }

    public void setDBVersion(int databaseMajorVersion, int databaseMinorVersion) {
        this.basicMap.put("databaseMajorVersion", databaseMajorVersion);
        this.basicMap.put("databaseMinorVersion", databaseMinorVersion);
    }

    public void setHiddenFields(SxResultSet rs) {
        for (SxResultRow row : rs) {
            this.hiddenFields.add(row.get(0));
        }
    }

    public void setMaskenEditRights(SxResultSet rs) {
        Iterator it = rs.iterator();
        if (it.hasNext()) {
            SxResultRow row = (SxResultRow)it.next();
            Object o = row.get(0);
            this.hasMaskenEditRights = ((Number)o).intValue() > 0;
        }
    }

    public boolean isFieldHidingWanted(Object id) {
        return this.hiddenFields.contains(id);
    }

    public void setSachgebiete(SxResultSet rs) {
        for (SxResultRow row : rs) {
            this.sachgebiete.add(row.get(0).toString());
            this.basicMap.put("UserHasSachgebRight", new UserHasSachgebRight(this.sachgebiete));
        }
    }

    public Map<String, Map<String, String>> getRightsMap() {
        return this.rightsMap;
    }

    public void setRights(Map<String, Map<String, String>> rightsMap, String role) {
        if (role != null) {
            this.role = role;
            this.basicMap.put(USER_ROLE_PLACEHOLDER, role);
        }
        if (rightsMap != null) {
            this.rightsMap = rightsMap;
        }
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.getGrantedAuthorities();
    }

    public String getPassword() {
        return "not_important";
    }

    public String getUsername() {
        return this.getName();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return true;
    }

    public Set<String> getHis1Rights() {
        Set<String> all = this.rightsMap.keySet();
        return Sets.filter(all, (Predicate)new Predicate<String>(){

            public boolean apply(String arg0) {
                return arg0.startsWith("RIGHT_");
            }
        });
    }

    public List<GrantedAuthority> getGrantedAuthorities() {
        List authorities = AuthorityUtils.createAuthorityList((String[])this.getRoles().toArray(new String[0]));
        authorities.add(new GrantedAuthority(){

            public String getAuthority() {
                return SxUser.this.role;
            }
        });
        return authorities;
    }

    private Set<String> getRoles() {
        Set<String> all = this.rightsMap.keySet();
        return Sets.filter(all, (Predicate)new Predicate<String>(){

            public boolean apply(String arg0) {
                return arg0.startsWith("ROLE_");
            }
        });
    }

    private String getRoleString() {
        String rolle = "standard";
        if (this.getRoles().size() > 0) {
            rolle = StringUtils.join(this.getRoles(), (String)", ");
        }
        return rolle;
    }

    public void initKontierungsrechte() throws SQLException, DBServletException {
        if (this.isAdmin()) {
            this.sxKontierungsrechte.setHasAllRights(true);
        } else {
            this.sxKontierungsrechte.clearAll();
            SxResultSet rs = ServletUtils.executeALL_el(null, null, "Einlesen von Kontierungsrechten  f\u00fcr Benutzer " + this.getId(), SxKontierungsrechte.readingSQL + this.getId(), this.getMandantenID(), true).getResultSet();
            for (SxResultRow row : rs) {
                this.sxKontierungsrechte.createAndAddEntry(row);
            }
        }
    }

    public Integer getHisInOneOrgUnitLidOfRole() {
        return this.hisInOneOrgUnitLidOfRole != null ? this.hisInOneOrgUnitLidOfRole : Integer.valueOf(-1);
    }

    public void setHisInOneOrgUnitLidOfRole(Integer lid) {
        this.hisInOneOrgUnitLidOfRole = lid;
        this.basicMap.remove(USER_HISINONE_ORGUNIT_LID_PLACEHOLDER);
        if (lid != null) {
            this.basicMap.put(USER_HISINONE_ORGUNIT_LID_PLACEHOLDER, lid.toString());
        }
    }

    public void addStandardOrgUnitRight(OrgUnit eineOrgUnit) {
        this.allowedOrgUnits.add(eineOrgUnit);
    }

    public Set<String> getAllAllowedOrgUnitsForSaiku() {
        Rights orgUnitRights = new Rights();
        StringBuffer optionalLogMessages = new StringBuffer();
        orgUnitRights.add(this.getAllowedOrgUnitApnrs());
        orgUnitRights.addOrgUnitRights(optionalLogMessages, this.getImplicitlyAllowedOrgUnits());
        orgUnitRights.addLiveMappingRights(optionalLogMessages, this.mandantenID);
        if (this.hasAllOrgUnitRights()) {
            orgUnitRights.add("Unbekannt");
            orgUnitRights.add("-999990");
        }
        return orgUnitRights.getAllRightKeys();
    }

    public String getUUID() {
        return this.uuid.toString();
    }

    @Override
    public int hashCode() {
        return this.uuid.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return this.hashCode() == o.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + " (" + this.getRoleString() + ")";
    }

    public Set<String> getAllowedOrgUnitApnrs() {
        TreeSet<String> orgUnitApnrs = new TreeSet<String>();
        for (OrgUnit ou : this.allowedOrgUnits) {
            orgUnitApnrs.add(ou.getApnr());
        }
        return orgUnitApnrs;
    }

    public String getAllowedOrgUnitApnrsString() {
        StringBuffer liste = new StringBuffer();
        for (OrgUnit ou : this.allowedOrgUnits) {
            liste.append(ou.getApnr() + ",");
        }
        return liste.toString();
    }

    public Set<OrgUnit> getAllowedOrgUnits() {
        return this.allowedOrgUnits;
    }

    public boolean hasAllOrgUnitRights() {
        boolean result = false;
        if (this.isAdmin()) {
            result = true;
        } else {
            for (OrgUnit ou : this.allowedOrgUnits) {
                if (!ou.getApnr().contentEquals("0")) continue;
                result = true;
            }
        }
        return result;
    }

    public boolean hasDbFormRight(String dbFormName) {
        if (!this.isAdmin()) {
            return this.hasMaskenEditRights;
        }
        return true;
    }

    public void initThemenbaum() throws SQLException, DBServletException, TransformerException, NichtAngemeldetException {
        this.themenbaum.init((Integer)this.getId(), this.getName(), this.isAdmin(), this.getMandantenID());
    }
}

