/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.servlet.SxSQL_Server;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SxSqlHelper {
    private String mandantenID = SxSQL_Server.DEFAULT_MANDANTEN_ID;

    public synchronized void execute(String query, Connection connection, SuperX_el gesamt) throws SQLException {
        SxResultSet rows = new SxResultSet();
        Statement statement = connection.createStatement();
        StringTokenizer st = new StringTokenizer(query, ";");
        int numberOfColumns = -1;
        int updateCount = -1;
        int n = 0;
        while (st.hasMoreTokens()) {
            ++n;
            String sqlstmt = st.nextToken().trim();
            if (sqlstmt.length() < 5) continue;
            try {
                if (statement.execute(sqlstmt)) {
                    int column;
                    ResultSet resultSet = statement.getResultSet();
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    numberOfColumns = metaData.getColumnCount();
                    String[] columnNames = new String[numberOfColumns];
                    String[] columnLabel = new String[numberOfColumns];
                    int[] columnDisplaySize = new int[numberOfColumns];
                    int[] columnType = new int[numberOfColumns];
                    int[] Scale = new int[numberOfColumns];
                    boolean[] isWritable = new boolean[numberOfColumns];
                    for (column = 0; column < numberOfColumns; ++column) {
                        columnNames[column] = metaData.getColumnName(column + 1);
                    }
                    for (column = 0; column < numberOfColumns; ++column) {
                        columnLabel[column] = metaData.getColumnLabel(column + 1);
                    }
                    for (column = 0; column < numberOfColumns; ++column) {
                        columnDisplaySize[column] = metaData.getColumnDisplaySize(column + 1);
                    }
                    for (column = 0; column < numberOfColumns; ++column) {
                        columnType[column] = this.adaptColumType(metaData.getColumnType(column + 1));
                    }
                    for (column = 0; column < numberOfColumns; ++column) {
                        Scale[column] = metaData.getScale(column + 1);
                    }
                    for (column = 0; column < numberOfColumns; ++column) {
                        isWritable[column] = metaData.isWritable(column + 1);
                    }
                    int naturalOrderNo = 1;
                    while (resultSet.next()) {
                        SxResultRow newRow = this.addRow(metaData, numberOfColumns, naturalOrderNo++, resultSet, columnNames);
                        rows.add(newRow);
                    }
                    gesamt.setColumnCount(numberOfColumns);
                    gesamt.setAndAdaptColumnNames(columnNames);
                    gesamt.setColumnLabels(columnLabel);
                    gesamt.setColumnDisplaySizes(columnDisplaySize);
                    gesamt.setColumnTypes(columnType);
                    gesamt.setScales(Scale);
                    gesamt.setisWritable(isWritable);
                    gesamt.setRows(rows);
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    updateCount = -1;
                } else {
                    updateCount = statement.getUpdateCount();
                }
            }
            catch (SQLException e) {
                Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.INFO, (Object)e.toString());
                gesamt.setError_String(e.toString());
            }
            catch (Exception e) {
                Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.INFO, (Object)("Allgemeiner Fehler beim DB-Zugriff:" + e.toString()));
                gesamt.setError_String(e.toString());
            }
            gesamt.setUpdateCount(updateCount);
        }
        if (statement != null) {
            statement.close();
        }
    }

    private SxResultRow addRow(ResultSetMetaData metaData, int numberOfColumns, int naturalOrderNo, ResultSet resultSet, String[] columnName) throws SQLException {
        SxResultRow newRow = SxResultRow.createInstance(metaData, numberOfColumns, naturalOrderNo, resultSet, columnName, this.mandantenID);
        return newRow;
    }

    public int adaptColumType(int rsColType) {
        return switch (rsColType) {
            case -6, -5, 4, 5 -> 4;
            case 16 -> -7;
            case 2, 3, 6, 7, 8 -> 3;
            case 91 -> 6;
            case 93 -> 8;
            case 92 -> 9;
            default -> 1;
        };
    }
}

