/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.superx.util.SqlStringUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SxResultRow
extends ArrayList {
    private static final long serialVersionUID = 1L;
    private int naturalOrderNo;

    public SxResultRow(int numberOfCols, int naturalOrderNo) {
        super(numberOfCols);
        this.naturalOrderNo = naturalOrderNo;
    }

    public int getNaturalOrderNo() {
        return this.naturalOrderNo;
    }

    @Override
    public boolean equals(Object o) {
        if (this != o && o instanceof SxResultRow && ((SxResultRow)o).getNaturalOrderNo() == this.getNaturalOrderNo()) {
            throw new IllegalStateException("zwei ResultRows mit indentischer naturalOrderNo");
        }
        return this == o;
    }

    public static SxResultRow createInstance(ResultSetMetaData metaData, int numberOfColumns, int naturalOrderNo, ResultSet resultSet, String[] columnName, String mandantenID) throws SQLException {
        SxResultRow newRow = new SxResultRow(numberOfColumns, naturalOrderNo);
        block22: for (int i = 0; i < numberOfColumns; ++i) {
            switch (metaData.getColumnType(i + 1)) {
                case 1: 
                case 12: {
                    Object value;
                    try {
                        value = resultSet.getString(i + 1);
                    }
                    catch (Exception e) {
                        value = "";
                        Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.WARN, (Object)("Textfeld " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString()));
                    }
                    if (value == null || ((String)value).equals("null")) {
                        newRow.add(new String(""));
                        continue block22;
                    }
                    newRow.add(((String)value).trim());
                    continue block22;
                }
                case -1: {
                    Object value;
                    try {
                        value = resultSet.getString(i + 1);
                    }
                    catch (Exception e) {
                        value = "";
                        Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.WARN, (Object)("Blob " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString()));
                    }
                    if (value == null || ((String)value).equals("null")) {
                        newRow.add(new String(""));
                        continue block22;
                    }
                    newRow.add(((String)value).trim());
                    continue block22;
                }
                case 4: {
                    try {
                        newRow.add(resultSet.getObject(i + 1));
                    }
                    catch (Exception e) {
                        Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.WARN, (Object)("Integer " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString()));
                        newRow.add(null);
                    }
                    continue block22;
                }
                case 2: {
                    try {
                        BigDecimal myNum = resultSet.getBigDecimal(i + 1);
                        newRow.add(myNum);
                    }
                    catch (Exception e) {
                        Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.WARN, (Object)("Numeric " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString()));
                        newRow.add(null);
                    }
                    continue block22;
                }
                case 93: {
                    Object myObj;
                    try {
                        myObj = resultSet.getObject(i + 1);
                        Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.INFO, (Object)("Objekt: " + myObj.toString()));
                        newRow.add(myObj);
                    }
                    catch (Exception e) {
                        Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.WARN, (Object)("Timestamp " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString()));
                        newRow.add("");
                    }
                    continue block22;
                }
                case 91: {
                    Object myObj = null;
                    try {
                        myObj = resultSet.getDate(i + 1);
                        newRow.add(myObj);
                    }
                    catch (Exception e) {
                        System.out.println("myObj " + myObj + " i:" + i + " columncount:" + resultSet.getMetaData().getColumnCount());
                        for (int ix = 0; ix < resultSet.getMetaData().getColumnCount(); ++ix) {
                            System.out.println(resultSet.getMetaData().getColumnName(ix + 1) + " " + resultSet.getMetaData().getColumnTypeName(ix + 1));
                        }
                        Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.WARN, (Object)("Datum " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString()));
                        newRow.add("Fehler beim Datum einlesen");
                    }
                    continue block22;
                }
                default: {
                    try {
                        newRow.add(SqlStringUtils.convertClobToString(resultSet.getObject(i + 1)));
                        continue block22;
                    }
                    catch (Exception e) {
                        Logger.getLogger((String)("superx_" + mandantenID)).log((Priority)Level.WARN, (Object)("Unbekanntes Objekt " + columnName[i] + " konnte nicht ausgewertet werden:" + e.toString()));
                        newRow.add(null);
                    }
                }
            }
        }
        return newRow;
    }
}

