/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.db.RestrictionCollector;
import de.memtext.util.StringUtils;
import de.superx.common.Field;
import de.superx.common.RightsApplicator;
import de.superx.common.SxResultRow;
import freemarker.template.TemplateModelException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class SxKontierungsrecht
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String finanzstelle;
    private String hhprog;
    private String fonds;
    private String fipos;
    private List arglist = new LinkedList();

    SxKontierungsrecht(SxResultRow row) {
        this.finanzstelle = (String)row.get(0);
        this.hhprog = (String)row.get(1);
        this.fonds = (String)row.get(2);
        this.fipos = (String)row.get(3);
        this.arglist.add("getSubkeys");
        this.arglist.add("dummy");
    }

    public String getHHprog() {
        return this.hhprog;
    }

    public String getFonds() {
        return this.fonds;
    }

    public String getSQL(Field finanzstelleField, Field hhprogField, Field fondsField, Field fiposField) throws TemplateModelException {
        RestrictionCollector rc = new RestrictionCollector();
        String r = null;
        if (!this.finanzstelle.equals("0") && (r = this.getSingle(finanzstelleField, "kst_nr", this.finanzstelle)).length() > 0) {
            rc.addAndRestriction(r);
        }
        if (!this.hhprog.equals("0") && (r = this.getSingle(hhprogField, "ktr_nr", this.hhprog)).length() > 0) {
            rc.addAndRestriction(r);
        }
        if (!this.fonds.equals("0") && (r = this.getSingle(fondsField, "ggnr", this.fonds)).length() > 0) {
            rc.addAndRestriction(r);
        }
        if (!this.fipos.equals("0") && (r = this.getSingle(fiposField, "sachkonto", this.fipos)).length() > 0) {
            rc.addAndRestriction(r);
        }
        Object result = "";
        if (rc.isSomethingAdded()) {
            result = "( " + rc.toString() + "   )\n ";
        }
        return result;
    }

    public String getAuswahl(int field, String dbfieldname) throws TemplateModelException {
        String value = "";
        if (field == 1) {
            value = this.hhprog;
        }
        if (field == 2) {
            value = this.fonds;
        }
        RestrictionCollector rc = new RestrictionCollector();
        if (value.indexOf(",") > -1) {
            RightsApplicator.checkOnlyPosOrNeg(value);
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreElements()) {
            String einWert = st.nextToken();
            boolean isNegative = einWert.indexOf("-") > -1;
            if ((einWert = StringUtils.replace(einWert, "-", "")).indexOf("*") > -1) {
                if (isNegative) {
                    rc.addAndRestriction(" " + dbfieldname + " not like '" + einWert.replace('*', '%') + "' ");
                    continue;
                }
                rc.addOrRestriction(" " + dbfieldname + "  like '" + einWert.replace('*', '%') + "' ");
                continue;
            }
            if (isNegative) {
                rc.addAndRestriction(" " + dbfieldname + " !='" + einWert + "' ");
                continue;
            }
            rc.addOrRestriction(" " + dbfieldname + " ='" + einWert + "'");
        }
        return "(" + rc.toString() + ") ";
    }

    private String getSingle(Field field, String dbfieldname, String value) throws TemplateModelException {
        RestrictionCollector rc = new RestrictionCollector();
        if (value.indexOf(",") > -1) {
            RightsApplicator.checkOnlyPosOrNeg(value);
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        while (st.hasMoreElements()) {
            boolean isNegative;
            String einWert = st.nextToken();
            boolean bl = isNegative = einWert.indexOf("-") > -1;
            if (einWert.indexOf("*") > -1) {
                if (isNegative) {
                    String adapted = StringUtils.replace(einWert, "-", "");
                    rc.addAndRestriction(" " + dbfieldname + " not like '" + adapted.replace('*', '%') + "' ");
                    continue;
                }
                rc.addOrRestriction(" " + dbfieldname + "  like '" + einWert.replace('*', '%') + "' ");
                continue;
            }
            this.arglist.set(1, StringUtils.replace(einWert, "-", ""));
            if (isNegative) {
                rc.addAndRestriction(" " + dbfieldname + " not in " + field.exec(this.arglist));
                continue;
            }
            rc.addOrRestriction(" " + dbfieldname + "  in " + field.exec(this.arglist));
        }
        Object result = "";
        if (rc.isSomethingAdded()) {
            result = "(" + rc.toString() + ") ";
        }
        return result;
    }

    public boolean hasAllRights() {
        return this.finanzstelle.equals("0") && this.hhprog.equals("0") && this.fonds.equals("0") && this.fipos.equals("0");
    }
}

