/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class SxComparator
implements Comparator,
Serializable {
    private static final long serialVersionUID = 1L;
    private LinkedList sortcols = new LinkedList();
    private String colsort;

    public SxComparator() {
    }

    public SxComparator(String colsort) {
        this.setColsort(colsort);
    }

    private void setColsort(String colsort) {
        this.colsort = colsort;
        this.sortcols.clear();
        if (this.colsort != null) {
            this.colsort = this.colsort.toUpperCase();
            StringTokenizer st = new StringTokenizer(this.colsort, "|");
            while (st.hasMoreTokens()) {
                this.sortcols.add(new SortCol(st.nextToken()));
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    public int compare(Object o, Object o2) {
        if (!(o instanceof SxResultRow) || !(o2 instanceof SxResultRow)) {
            throw new IllegalArgumentException("kann nur ResultRow-Objekte vergleichen");
        }
        int result = 0;
        SxResultRow r1 = (SxResultRow)o;
        SxResultRow r2 = (SxResultRow)o2;
        if (r1 == r2 || r1.equals(r2)) {
            result = 0;
        } else if (this.colsort == null) {
            result = Integer.valueOf(r1.getNaturalOrderNo()).compareTo(r2.getNaturalOrderNo());
        } else {
            for (SortCol aSortCol : this.sortcols) {
                Comparable c1 = (Comparable)r1.get(aSortCol.getCol());
                Comparable c2 = (Comparable)r2.get(aSortCol.getCol());
                result = c1 == null ? -1 : (c2 == null ? 1 : c1.compareTo(c2));
                if (aSortCol.isDesc()) {
                    result *= -1;
                }
                if (result == 0) continue;
                break;
            }
            if (result == 0) {
                result = Integer.valueOf(r1.getNaturalOrderNo()).compareTo(r2.getNaturalOrderNo());
            }
        }
        return result;
    }

    public static void main(String[] args) {
        SxResultRow r1 = new SxResultRow(10, 1);
        SxResultRow r2 = new SxResultRow(10, 2);
        SxResultRow r3 = new SxResultRow(10, 3);
        SxResultRow r4 = new SxResultRow(10, 4);
        SxResultRow r5 = new SxResultRow(10, 5);
        SxResultRow r6 = new SxResultRow(10, 6);
        r1.add(10);
        r1.add(5);
        r1.add(100);
        r1.add(1);
        r2.add(10);
        r2.add(6);
        r2.add(100);
        r2.add(2);
        r3.add(20);
        r3.add(4);
        r3.add(120);
        r3.add(3);
        r4.add(30);
        r4.add(3);
        r4.add(110);
        r4.add(4);
        r5.add(25);
        r5.add(9);
        r5.add(150);
        r5.add(5);
        r6.add(25);
        r6.add(9);
        r6.add(100);
        r6.add(6);
        SxResultSet test = new SxResultSet();
        test.add(r1);
        test.add(r2);
        test.add(r3);
        test.add(r4);
        test.add(r5);
        test.add(r6);
        System.out.println("natural ");
        SxComparator.print(test);
        SxResultSet test2 = new SxResultSet("0-a");
        test2.addAll(test);
        test = test2;
        System.out.println("Spalte 0");
        SxComparator.print(test);
        test2 = new SxResultSet("0-d");
        test2.addAll(test);
        test = test2;
        System.out.println("Spalte 0 desc");
        SxComparator.print(test);
        test2 = new SxResultSet("1-a");
        test2.addAll(test);
        test = test2;
        System.out.println("Spalte 1");
        SxComparator.print(test);
        System.out.println("Spalte 1-d");
        test2 = new SxResultSet("1-d");
        test2.addAll(test);
        test = test2;
        SxComparator.print(test);
        System.out.println("Spalte 0-a|1-D");
        test2 = new SxResultSet("0-a|1-d");
        test2.addAll(test);
        test = test2;
        SxComparator.print(test);
        System.out.println("Spalte 0-a|1-D|2-a");
        test2 = new SxResultSet("0-a|1-d|2-a");
        test2.addAll(test);
        test = test2;
        SxComparator.print(test);
        System.out.println("Spalte 0-a|1-D|2-d");
        test2 = new SxResultSet("0-a|1-d|2-d");
        test2.addAll(test);
        test = test2;
        SxComparator.print(test);
        System.out.println("Spalte 2-a|1-a");
        test2 = new SxResultSet("2-a|1-a");
        test2.addAll(test);
        test = test2;
        SxComparator.print(test);
        System.out.println("Spalte 2-a|1-d");
        test2 = new SxResultSet("2-a|1-d");
        test2.addAll(test);
        test = test2;
        SxComparator.print(test);
    }

    private static void print(SxResultSet test) {
        for (SxResultRow r : test) {
            for (int i = 0; i < r.size(); ++i) {
                System.out.print(r.get(i) + " - ");
            }
            System.out.println();
        }
    }

    private class SortCol {
        private int col;
        private boolean isDesc;

        SortCol(String acolsort) {
            if (acolsort.endsWith("-A")) {
                this.isDesc = false;
            } else if (acolsort.endsWith("-D")) {
                this.isDesc = true;
            } else {
                throw new IllegalArgumentException("SortCol muss mit -A oder -D enden, nicht: " + acolsort);
            }
            String colstr = acolsort.substring(0, acolsort.length() - 2);
            try {
                this.col = Integer.parseInt(colstr);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("interne Spaltenangabe muss Integer sein, nicht: " + colstr);
            }
        }

        public int getCol() {
            return this.col;
        }

        public void setCol(int col) {
            this.col = col;
        }

        public boolean isDesc() {
            return this.isDesc;
        }

        public void setDesc(boolean isDesc) {
            this.isDesc = isDesc;
        }
    }
}

