/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.superx.common.SxResultRow;
import java.io.Serializable;

public class Stylesheet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String filename = "";
    private String caption;
    private String description;
    private String contenttype;
    private String stylesheetType;
    private String toolbarIconFilepath;
    private String usageResultsetData;
    private String jrDatasource;
    private int ord;
    private int isGeneric;

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getContenttype() {
        return this.contenttype;
    }

    public void setContenttype(String contenttype) {
        this.contenttype = contenttype;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getOrd() {
        return this.ord;
    }

    public void setOrd(int ord) {
        this.ord = ord;
    }

    public int getIsGeneric() {
        return this.isGeneric;
    }

    public void setIsGeneric(int isGeneric) {
        this.isGeneric = isGeneric;
    }

    public String getStylesheetType() {
        if (this.stylesheetType == null) {
            switch (this.filename) {
                case "tabelle_xml.xsl": {
                    this.stylesheetType = "XML";
                    break;
                }
                case "tabelle_fo_pdf.xsl": {
                    this.stylesheetType = "XSL_FO";
                    break;
                }
                case "tabelle_xls.xsl": {
                    this.stylesheetType = "XSL_XLSX";
                    break;
                }
                default: {
                    if (this.filename.endsWith(".jrxml")) {
                        return "JRXML";
                    }
                    if (this.filename.endsWith(".xsl")) {
                        return "XSL";
                    }
                    this.stylesheetType = "";
                }
            }
        }
        return this.stylesheetType;
    }

    public void setStylesheetType(String stylesheetType) {
        this.stylesheetType = stylesheetType == null ? "" : stylesheetType.trim();
    }

    public String getToolbarIconFilepath() {
        return this.toolbarIconFilepath;
    }

    public void setToolbarIconFilepath(String toolbarIconFilepath) {
        this.toolbarIconFilepath = toolbarIconFilepath == null ? "" : toolbarIconFilepath.trim();
    }

    public String getUsageResultsetData() {
        if (this.jrDatasource == null) {
            return "T";
        }
        return this.usageResultsetData;
    }

    public void setUsageResultsetData(String usageResultsetData) {
        this.usageResultsetData = usageResultsetData == null ? "" : usageResultsetData.trim();
    }

    public String getJrDatasource() {
        if (this.jrDatasource == null || this.jrDatasource.equals("")) {
            if (this.filename.endsWith("_xmlsource.jrxml")) {
                return "XML";
            }
            if (this.filename.endsWith(".jrxml")) {
                return "RS";
            }
        }
        return this.jrDatasource;
    }

    public void setJrDatasource(String jrDatasource) {
        this.jrDatasource = jrDatasource == null ? "" : jrDatasource.trim();
    }

    public Stylesheet(String file) {
        if (file == null) {
            file = "";
        }
        this.filename = file.trim();
    }

    public Stylesheet(SxResultRow stylesheetRow) {
        this.setOrd(Integer.parseInt(stylesheetRow.get(4).toString()));
        this.setFilename(stylesheetRow.get(0).toString());
        this.setCaption(stylesheetRow.get(1).toString());
        this.setDescription(stylesheetRow.get(2).toString());
        this.setContenttype(stylesheetRow.get(3).toString());
        this.setIsGeneric(Integer.parseInt(stylesheetRow.get(5).toString()));
        this.setToolbarIconFilepath(stylesheetRow.get(6).toString());
        this.setJrDatasource(stylesheetRow.get(7).toString());
        this.setUsageResultsetData(stylesheetRow.get(8).toString());
        this.setStylesheetType(stylesheetRow.get(9).toString());
    }

    public String toString() {
        return this.filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String file) {
        this.filename = file;
    }

    public String toXml() {
        StringBuffer result = new StringBuffer("<stylesheet ord='" + this.getOrd() + "'>");
        result.append(" <filename>" + this.getFilename() + "</filename>\n");
        result.append(" <caption>" + this.getCaption() + "</caption>\n");
        result.append(" <description>" + this.getDescription() + "</description>\n");
        result.append("<contenttype>" + this.getContenttype() + "</contenttype>\n");
        result.append("<is_generic>" + this.getIsGeneric() + "</is_generic>\n");
        result.append("<stylesheet_type>" + this.getStylesheetType() + "</stylesheet_type>\n");
        result.append("<toolbar_icon_filepath>" + this.getToolbarIconFilepath() + "</toolbar_icon_filepath>\n");
        result.append("<jr_datasource>" + this.getJrDatasource() + "</jr_datasource>\n");
        result.append("<usage_resultset_data>" + this.getUsageResultsetData() + "</usage_resultset_data>\n");
        result.append(" </stylesheet>\n");
        return result.toString();
    }
}

