/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import de.memtext.util.StringUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OrgUnitMapping
implements Cloneable {
    private String id;
    private String uniquename;
    private Set<String> mappedIds = new HashSet<String>();

    public OrgUnitMapping(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getUniquename() {
        return this.uniquename;
    }

    public void setUniquename(String uniquename) {
        if (this.uniquename != null && !this.uniquename.contentEquals(uniquename)) {
            throw new IllegalArgumentException("F\u00fcr OrgUnit apnr " + this.id + " wurde zun\u00e4chst " + this.uniquename + " eingetragen, \u00c4nderung auf " + uniquename + " nicht erlaubt");
        }
        this.uniquename = uniquename;
    }

    public Set<String> getMappedIds() {
        return this.mappedIds;
    }

    public void addMappedId(String mappedId) {
        if (!mappedId.contentEquals(this.id) && !mappedId.contentEquals(this.uniquename)) {
            this.mappedIds.add(mappedId);
        }
    }

    public String getKeysInclLiveMapping() {
        StringBuffer result = new StringBuffer();
        result.append("'" + this.uniquename + "',");
        if (!this.id.contentEquals(this.uniquename)) {
            result.append("'" + this.id + "',");
        }
        Iterator<String> it = this.mappedIds.iterator();
        while (it.hasNext()) {
            result.append("'" + it.next() + "',");
        }
        if (result.length() > 0) {
            StringUtils.deleteLastChar(result);
        }
        return result.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        OrgUnitMapping clone = (OrgUnitMapping)super.clone();
        clone.setId(this.id);
        clone.setUniquename(this.uniquename);
        Iterator<String> it = this.mappedIds.iterator();
        while (it.hasNext()) {
            clone.addMappedId(it.next());
        }
        return clone;
    }
}

