/*
 * Decompiled with CFR 0.152.
 */
package de.superx.common;

import com.google.common.io.Files;
import de.memtext.baseobjects.IdObject;
import de.memtext.baseobjects.IdObjectI;
import de.memtext.baseobjects.NamedIdObjectI;
import de.memtext.baseobjects.NamedIdObjectWithParent;
import de.memtext.baseobjects.coll.IdObjectCollection;
import de.memtext.baseobjects.coll.IdObjectList;
import de.memtext.baseobjects.coll.NamedIdObjectWithParentCollection;
import de.memtext.baseobjects.coll.NamedIdObjectWithParentList;
import de.memtext.baseobjects.coll.NamedIdObjectWithParentSet;
import de.memtext.db.DB;
import de.memtext.db.ProcedureSql;
import de.memtext.rights.Allowable;
import de.memtext.rights.Rights;
import de.memtext.time.EphemeralI;
import de.memtext.time.Period;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.tree.TreeBuilder;
import de.memtext.util.DateUtils;
import de.memtext.util.EqualsUtil;
import de.memtext.util.StringUtils;
import de.memtext.util.TreeUtils;
import de.superx.common.DBServletException;
import de.superx.common.FieldContainer;
import de.superx.common.RightsApplicator;
import de.superx.common.SelectableItem;
import de.superx.common.SelectableItemNode;
import de.superx.common.SelectableItemTree;
import de.superx.common.SichtartRechte;
import de.superx.common.Sichten;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxUser;
import de.superx.common.XMLModifier;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import de.superx.util.SqlStringUtils;
import freemarker.template.SimpleNumber;
import freemarker.template.SimpleScalar;
import freemarker.template.SimpleSequence;
import freemarker.template.TemplateBooleanModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractSicht
extends SelectableItemTree
implements NamedIdObjectI,
EphemeralI,
Allowable,
TemplateHashModel,
TemplateMethodModel {
    private static boolean isNewTreeBuildWanted = true;
    private SichtartRechte sichtartRechte = new SichtartRechte();
    protected static ImageIcon leaf = null;
    private boolean isFirstInGroup = false;
    protected Sichten sichten;
    private String attribut1 = "";
    private String attribut2 = "";
    private Integer attribut3;
    private boolean isSubelementsinForEach = true;
    private boolean isDynamic = false;
    private boolean isTreeCfgRead = false;
    private HashMap childrensMap = new HashMap();
    private static final long serialVersionUID = 1L;
    private Object id;
    private String name;
    protected String mandantenID = SxSQL_Server.DEFAULT_MANDANTEN_ID;
    public NamedIdObjectWithParentCollection selectableItemCollection = new NamedIdObjectWithParentSet();
    protected int label;
    protected String art;
    protected String name_intern;
    protected String beschreibung;
    protected String quelle;
    protected String stand;
    protected boolean isStandbuttonWanted;
    protected boolean isPerfectlyRegular;
    protected boolean hasCachedVersion;
    protected boolean isAllowed = false;
    protected Period validityPeriod = new Period(Date.valueOf("1900-01-01"), Date.valueOf("3000-01-01"));
    protected Integer systeminfoid;
    protected SxUser user;
    protected String treeCfgTable;
    protected String altHierId;
    protected String treeCfgId;
    protected AbstractSicht hauptSicht;
    protected NamedIdObjectWithParentList altHierItems = new NamedIdObjectWithParentList();
    protected IdObjectCollection closedTreeNodes = new IdObjectList();
    protected Integer type;
    protected Integer xmlMaxEntries;
    protected Rights rights = new Rights(true, true);
    private boolean isNoSelectionPossible = false;

    public String getAttribut1() {
        return this.attribut1;
    }

    public void setAttribut1(String attribut1) {
        this.attribut1 = attribut1;
    }

    public String getAttribut2() {
        return this.attribut2;
    }

    public void setAttribut2(String attribut2) {
        this.attribut2 = attribut2;
    }

    public AbstractSicht(Sichten sichten, Object id, String name) {
        this.sichten = sichten;
        this.setId(id);
        this.setName(name);
        this.configTree();
    }

    protected AbstractSicht(Sichten sichten, Object id, String name, DefaultTreeModel model) {
        this.sichten = sichten;
        this.setId(id);
        this.setName(name);
        this.setModel(model);
        this.configTree();
    }

    public SxUser getUser() {
        return this.user;
    }

    public int getLabel() {
        return this.label;
    }

    private boolean isKostenstellenSichtOrFallBack() {
        return this.getArt().indexOf("Kostenstellen-Sicht") > -1 && this.getType() != 20 && !this.sichtartRechte.isActive() || this.sichtartRechte.isActive() && this.sichtartRechte.isFallback_user_inst_wanted();
    }

    private boolean isOrganigrammSicht() {
        return this.getArt().indexOf("Organigramm-Sicht") > -1;
    }

    private void readRights() throws SQLException, DBServletException, TemplateException, IOException {
        this.rights.clear();
        if (this.isKostenstellenSichtOrFallBack()) {
            if (this.sichtartRechte.isActive() && this.sichtartRechte.isFallback_user_inst_wanted()) {
                Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.DEBUG, (Object)("Nutze Rechte-Fallback auf user_institution f\u00fcr User " + this.user.getName() + " (" + this.user.getId() + ") Sicht:" + this.getName() + " (" + this.getName_intern() + ")"));
            }
            if (this.user.isAdmin()) {
                this.rights.setAdmin(true);
                this.rights.setHasAllRights(true);
                this.user.getBasicMap().put("UserHasAllKostenstellenRights", TemplateBooleanModel.TRUE);
            } else {
                this.readNichtAdminUserRights();
            }
        }
        if (this.sichtartRechte.isActive() && !this.sichtartRechte.isFallback_user_inst_wanted()) {
            this.readSpecificNonStandardSichtRechte();
        }
        this.user.getBasicMap().put("UserHasAll" + this.getArt() + "Rights", this.rights.hasAllRights() ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE);
        this.user.getBasicMap().put("UserHasNo" + this.getArt() + "Rights", this.rights.hasNoRights() ? TemplateBooleanModel.TRUE : TemplateBooleanModel.FALSE);
    }

    private void readSpecificNonStandardSichtRechte() {
        this.rights.setAdmin(this.user.isAdmin());
        this.rights.setHasAllRights(this.user.isAdmin());
        if (!this.user.isAdmin()) {
            this.rights.clear();
            StringBuffer msg = new StringBuffer(this.user.getName() + " (" + this.user.getId() + ") erh\u00e4lt Rechte f\u00fcr Sicht " + this.getName_intern() + " (" + this.getId() + ")");
            for (String key : this.sichtartRechte.getKeys()) {
                if (key.equals("0")) {
                    this.rights.setHasAllRights(true);
                    msg.append(" Schl\u00fcssel 0-> Alle Rechte");
                    break;
                }
                this.rights.add(key);
                msg.append(key + " ");
            }
            Logger.getLogger((String)("superx_" + this.mandantenID)).debug((Object)msg.toString());
        }
    }

    private void readNichtAdminUserRights() {
        if (this.user.hasAllOrgUnitRights()) {
            this.rights.setHasAllRights(true);
            this.user.getBasicMap().put("UserHasAllKostenstellenRights", TemplateBooleanModel.TRUE);
        } else {
            this.rights.setHasAllRights(false);
            this.user.getBasicMap().put("UserHasAllKostenstellenRights", TemplateBooleanModel.FALSE);
        }
        StringBuffer msg = new StringBuffer("Rechte f\u00fcr User " + this.user.getName() + " Sicht:" + this.getName() + "(" + this.getName_intern() + ") Direkte Rechte: " + this.user.getAllowedOrgUnitApnrsString());
        this.rights.add(this.user.getAllowedOrgUnitApnrs());
        if (this.isImplicitOrgUnitRightsWanted()) {
            msg.append(" via implicitRights: ");
            this.rights.addOrgUnitRights(msg, this.user.getImplicitlyAllowedOrgUnits());
        }
        if (this.isLiveMappingWanted()) {
            this.rights.addLiveMappingRights(msg, this.mandantenID);
        }
        Logger.getLogger((String)("superx_" + this.mandantenID)).info((Object)("Rechte f\u00fcr User " + this.user.getName() + " " + msg));
    }

    public String getBeschreibung() {
        return this.beschreibung;
    }

    @Override
    public java.util.Date getValidSince() {
        return this.validityPeriod.getFrom();
    }

    @Override
    public java.util.Date getValidTill() {
        return this.validityPeriod.getTill();
    }

    @Override
    public boolean isValidAt(java.util.Date date) {
        return this.validityPeriod.isInPeriod(date);
    }

    @Override
    public void setValidSince(java.util.Date date) {
        this.validityPeriod.setFrom(date);
    }

    @Override
    public void setValidTill(java.util.Date date) {
        this.validityPeriod.setTill(date);
    }

    public String getName_intern() {
        return this.name_intern;
    }

    public void setBeschreibung(String string) {
        this.beschreibung = string;
    }

    public void setLabel(int i) {
        this.label = i;
    }

    public void setName_intern(String string) {
        this.name_intern = string;
    }

    public String getQuelle() {
        return this.quelle;
    }

    public void setQuelle(String q) {
        this.quelle = q;
        String test = q.replaceAll("<<UserID>>", "");
        test = test.replaceAll("<<Stand>>", "");
        if (AbstractSicht.getStrippedSQL(test = test.replaceAll("<<Sicht>>", "")).indexOf("<<") > -1) {
            this.isDynamic = true;
        }
    }

    public static String getStrippedSQL(String sql) {
        int startpos = 0;
        if (SqlStringUtils.hasSQLProcessingMarker(sql.trim().toUpperCase())) {
            startpos = 7;
        }
        return sql.substring(startpos);
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public boolean isStandbuttonWanted() {
        return this.isStandbuttonWanted;
    }

    public String getStand() {
        return this.stand;
    }

    public void setStandbuttonWanted(boolean b) {
        this.isStandbuttonWanted = b;
    }

    public Set<String> getAllKeysSet() throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        TreeSet<String> s = new TreeSet<String>();
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            if (node.getId() == null || node.getId().equals("") || node.getId().toString().equals("xxxxxx-xxxxxx@") || !node.isAllowed()) continue;
            s.add(node.getId().toString());
        }
        return s;
    }

    public void setStand(Hashtable formular, HashMap map, FieldContainer individualFields, String gewuenschterStand) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        if (gewuenschterStand == null) {
            throw new IllegalArgumentException("Der Stand kann nicht auf null gesetzt werden f\u00fcr Sicht " + this.getId());
        }
        if (!DateUtils.isValidDate(gewuenschterStand)) {
            throw new IllegalArgumentException("Konnte neuen Stand f\u00fcr Sicht " + this.getName_intern() + " (" + this.getId() + ") nicht setzen.  " + gewuenschterStand + " ist kein g\u00fcltiges dd.mm.yyyy-Datum");
        }
        if (this.stand == null || this.isDynamic() || !gewuenschterStand.equals(this.stand)) {
            Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.DEBUG, (Object)(DateUtils.getNowString() + " Start aktualisieren Sicht:  " + this.getName_intern() + " (" + this.getId() + ") f\u00fcr Stand " + this.stand));
            this.stand = gewuenschterStand;
            this.update(formular, map, individualFields);
        }
    }

    public boolean isAltHier() {
        return this.hauptSicht != null;
    }

    public boolean isCachedVersionInPool() {
        return false;
    }

    protected synchronized void update(Hashtable formular, HashMap map, FieldContainer individualFields) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        this.readRights();
        if (this.getTreeCfgTable() != null && !this.isTreeCfgRead) {
            this.readTreeCfg();
        }
        if (this.isAltHier()) {
            this.updateChildrensMapForAltHier(formular, map, individualFields);
        } else if (!this.isCachedVersionInPool() || this.isDynamic()) {
            this.updateChildrensMapForRegular(formular, map, individualFields);
        }
        SelectableItemNode root = (SelectableItemNode)this.getModel().getRoot();
        root.removeAllChildren();
        this.isNoSelectionPossible = false;
        if (!this.isCachedVersionInPool() && this.selectableItemCollection.size() == 0) {
            this.setNoSelectionPossible();
        } else {
            if (this.isAltHier()) {
                this.updateAltHier(root);
            } else {
                this.updateRegular(root);
            }
            this.childrensMap.clear();
            Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.DEBUG, (Object)("Tree f\u00fcr Sicht:  " + this.getName_intern() + " (" + this.getId() + ") nach urspr\u00fcngl. Aufbau:" + TreeUtils.countDescendents(root) + " Eintr\u00e4ge "));
            Logger.getLogger((String)("superx_" + this.mandantenID)).trace((Object)("Tree f\u00fcr Sicht:  " + this.getName_intern() + " (" + this.getId() + ") nach urspr\u00fcngl. Aufbau:" + TreeUtils.toString(root)));
            if (this.isAltHier()) {
                RightsApplicator.apply(this, this.hauptSicht.rights);
            } else {
                RightsApplicator.apply(this, this.rights);
            }
            Logger.getLogger((String)("superx_" + this.mandantenID)).debug((Object)("Tree f\u00fcr Sicht:  " + this.getName_intern() + " (" + this.getId() + ") nach Rechteanwendung:" + TreeUtils.countDescendents(root) + " Eintr\u00e4ge "));
            Logger.getLogger((String)("superx_" + this.mandantenID)).trace((Object)("Tree Sicht:  " + this.getName_intern() + " (" + this.getId() + ") nach Rechteanwendung:" + TreeUtils.toString(root)));
            if (this.isLiveMappingWanted()) {
                this.updateLiveMappingInfoInNodes();
            }
            this.isNoSelectionPossible = false;
            if (root.getChildCount() == 0) {
                this.setNoSelectionPossible();
            }
            ((DefaultTreeModel)this.getModel()).reload();
            this.applyTreeCfg();
        }
        this.updateSubordinateKeyLists(root);
        this.refreshGui();
        Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.DEBUG, (Object)("Aktualisieren der Sicht:  " + this.getName_intern() + " (" + this.getId() + ") f\u00fcr Stand " + this.stand + " beendet"));
        try {
            if (DateUtils.formatGerman(DateUtils.parse(this.stand)).equals(DateUtils.getTodayString())) {
                if (this.sichten.containsItemWithId(this.getId())) {
                    this.sichten.remove(this.sichten.getById(this.getId()));
                }
                this.sichten.add(this);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void updateRegular(SelectableItemNode root) throws NoMainEntryException, KeyParentEqualException {
        if (isNewTreeBuildWanted) {
            if (this.isCachedVersionInPool()) {
                this.addCachedNodes(root);
            } else {
                this.childrensMap.clear();
                for (SelectableItem item : this.selectableItemCollection) {
                    SelectableItemNode n = new SelectableItemNode(item);
                    if (this.isLidSicht()) {
                        TreeBuilder.add(this.childrensMap, n, n.getParent_lid() == null ? "" : n.getParent_lid());
                        continue;
                    }
                    TreeBuilder.add(this.childrensMap, n, n.getParentKey() == null ? "" : n.getParentKey());
                }
                if (this.isLidSicht()) {
                    TreeBuilder.addNodesToRootFromMapByLid(root, "", this.childrensMap, null);
                } else {
                    TreeBuilder.addNodesToRootFromMap(root, "", this.childrensMap, null);
                }
            }
        } else {
            this.insertnodes("", root);
            if (root.getChildCount() == 0) {
                this.insertnodes(null, root);
            }
        }
    }

    private void updateAltHier(SelectableItemNode root) {
        try {
            TreeBuilder.addNodesToRootFromMap(root, "", this.childrensMap, null);
        }
        catch (NoMainEntryException noMainEntryException) {
        }
        catch (KeyParentEqualException e) {
            e.printStackTrace();
        }
        try {
            if (root.getChildCount() == 0) {
                TreeBuilder.addNodesToRootFromMap(root, null, this.childrensMap, null);
            }
        }
        catch (NoMainEntryException e) {
            e.printStackTrace();
        }
        catch (KeyParentEqualException e) {
            e.printStackTrace();
        }
    }

    private boolean isLiveMappingWanted() {
        return (this.isKostenstellenSichtOrFallBack() || this.isOrganigrammSicht()) && (this.getAttribut2() == null || this.getAttribut2().toLowerCase().indexOf("nolivemapping") == -1) || this.getAttribut2() != null && this.getAttribut2().toLowerCase().indexOf("uselivemapping") > -1;
    }

    private void updateLiveMappingInfoInNodes() {
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).depthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            node.setOrgUnitMapping(SxPools.get(this.mandantenID).getOrgUnitMappings().get(node.getId()));
        }
    }

    private boolean isLidSicht() {
        return this.quelle.indexOf("parent_lid") > -1;
    }

    public void addCachedNodes(SelectableItemNode root) {
        throw new UnsupportedOperationException("hier nicht definiert");
    }

    private synchronized void updateChildrensMapForRegular(Hashtable formular, HashMap map, FieldContainer individualFields) throws SQLException, DBServletException, TemplateException, IOException {
        String sql = "";
        boolean isOrganigramm = false;
        if (this.getArt().equals("Organigramm-Sicht")) {
            isOrganigramm = true;
        }
        sql = this.prepareGeneralReadingSql();
        if (this.isDynamic()) {
            sql = this.dynamicSichtGenerateSql(formular, sql);
        }
        sql = this.dynmicSichtFMParsing(map, individualFields, sql);
        SxResultSet rohform = this.readFromDb(sql);
        Logger.getLogger((String)("superx_" + this.mandantenID)).log((Priority)Level.DEBUG, (Object)(" Datenbank lieferte f\u00fcr Sicht:  " + this.getName_intern() + " (" + this.getId() + ") " + rohform.size() + " Eintr\u00e4ge " + DateUtils.getNowString()));
        this.selectableItemCollection.clear();
        if (rohform.size() > 0) {
            try {
                this.selectableItemCollection.addAll(SelectableItem.toSelectableItemCollection(rohform, isOrganigramm));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SQLException("Sicht " + this.getName() + "(" + this.getId() + ") konnte nicht aufgebaut werden. DETAILS:" + e);
            }
            Logger.getLogger((String)("superx_" + this.mandantenID)).trace((Object)this.selectableItemCollection.toString());
        }
    }

    public abstract String dynmicSichtFMParsing(HashMap var1, FieldContainer var2, String var3) throws TemplateException, IOException, SQLException;

    public abstract String dynamicSichtGenerateSql(Hashtable var1, String var2);

    private synchronized void updateChildrensMapForAltHier(Hashtable formular, HashMap map, FieldContainer individualFields) throws SQLException, DBServletException, KeyParentEqualException, CloneNotSupportedException, NoMainEntryException, TemplateException, IOException {
        SelectableItem copiedElement2;
        this.hauptSicht.setStand(formular, map, individualFields, this.stand);
        if (this.altHierItems.isEmpty()) {
            this.readAltHierItems();
        }
        this.selectableItemCollection.clear();
        this.childrensMap.clear();
        int sortnr = 1;
        for (NamedIdObjectWithParent altHierItem : this.altHierItems) {
            SelectableItem hauptItem = null;
            try {
                hauptItem = (SelectableItem)this.hauptSicht.getSelectableItemCollection().getById(altHierItem.getId());
                copiedElement2 = (SelectableItem)hauptItem.clone();
                copiedElement2.setParentKey(altHierItem.getParentKey());
                copiedElement2.setSortNr(sortnr++);
                this.selectableItemCollection.add(copiedElement2);
                TreeBuilder.add(this.childrensMap, new SelectableItemNode(copiedElement2), copiedElement2.getParentKey());
            }
            catch (IllegalArgumentException copiedElement2) {}
        }
        if (!this.selectableItemCollection.containsItemWithId("") && this.selectableItemCollection.containsItemWithId(null) && this.hauptSicht.getSelectableItemCollection().containsItemWithParent("")) {
            NamedIdObjectWithParentCollection c = this.hauptSicht.getSelectableItemCollection().getByParent("");
            for (SelectableItem item : c) {
                copiedElement2 = (SelectableItem)item.clone();
                copiedElement2.setSortNr(sortnr++);
                this.selectableItemCollection.add(copiedElement2);
                TreeBuilder.add(this.childrensMap, copiedElement2, copiedElement2.getParentKey());
            }
        }
    }

    public void updateKlappstatus() {
        Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).depthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode node = (SelectableItemNode)en.nextElement();
            node.setClosedInTree(this.isCollapsed(new TreePath(node.getPath())));
        }
    }

    private void applyTreeCfg() {
        if (this.isAltHier()) {
            TreeUtils.expandAll(this);
            Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).depthFirstEnumeration();
            block0: while (en.hasMoreElements()) {
                SelectableItemNode node = (SelectableItemNode)en.nextElement();
                node.setClosedInAltHier(false);
                for (IdObject closedItem : this.closedTreeNodes) {
                    if (!EqualsUtil.areEqual(node.getId(), closedItem.getId())) continue;
                    node.setClosedInAltHier(false);
                    TreePath tp = new TreePath(node.getPath());
                    this.collapsePath(tp);
                    continue block0;
                }
            }
        } else {
            Enumeration<TreeNode> en = ((SelectableItemNode)this.getModel().getRoot()).depthFirstEnumeration();
            while (en.hasMoreElements()) {
                SelectableItemNode node = (SelectableItemNode)en.nextElement();
                node.setClosedInAltHier(false);
            }
        }
    }

    private void setNoSelectionPossible() {
        this.isNoSelectionPossible = true;
        ((SelectableItemNode)this.getModel().getRoot()).removeAllChildren();
        ((SelectableItemNode)this.getModel().getRoot()).add(new SelectableItemNode(new SelectableItem("keine Auswahl m\u00f6glich", "Keine Auswahl m\u00f6glich")));
        ((DefaultTreeModel)this.getModel()).reload();
    }

    public boolean isNoSelectionPossible() {
        return this.isNoSelectionPossible;
    }

    private void updateSubordinateKeyLists(DefaultMutableTreeNode root) {
        Enumeration<TreeNode> en = root.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            TreeNode node = en.nextElement();
            if (!(node instanceof SelectableItemNode)) continue;
            ((SelectableItemNode)node).updateSubordinateKeyList();
        }
    }

    private void littleGenerateSql(StringBuffer sql) {
        String art;
        StringUtils.replace(sql, "<<UserID>>", "" + this.user.getId());
        if (this.getStand().equals("1.1.1970")) {
            int pos = sql.indexOf("<<Stand>>");
            if (pos > -1) {
                sql.replace(pos, pos + 9, "date_val('1.1.3000')");
            }
            if ((pos = sql.lastIndexOf("<<Stand>>")) > -1) {
                sql.replace(pos, pos + 9, "date_val('1.1.1900')");
            }
            if (!this.getSqlDialect().equals("Postgres")) {
                StringUtils.replace(sql, "date_val", "date");
            }
        }
        if ((art = this.getArt()).endsWith("-Sicht")) {
            art = art.substring(0, art.length() - 6);
        }
        if (this.getSqlDialect().equals("Postgres")) {
            StringUtils.replace(sql, "<<" + art + "-Stand>>", "date_val('" + this.getStand() + "')");
            StringUtils.replace(sql, "<<Stand>>", "date_val('" + this.getStand() + "')");
        } else {
            StringUtils.replace(sql, "<<Stand>>", "date('" + this.getStand() + "')");
            StringUtils.replace(sql, "<<" + art + "-Stand>>", "date('" + this.getStand() + "')");
        }
        StringUtils.replace(sql, "<<Sicht>>", "'" + this.getId().toString() + "'");
    }

    private String prepareGeneralReadingSql() {
        StringBuffer result = new StringBuffer(this.getQuelle());
        if (result.length() > 7 && result.substring(0, 7).equals("<<SQL>>")) {
            result = new StringBuffer(result.substring(7));
        }
        this.littleGenerateSql(result);
        if (result.toString().startsWith("sp_")) {
            if (this.getSqlDialect().equals("Postgres")) {
                result.insert(0, "select ");
            } else {
                result.insert(0, "execute procedure ");
            }
        }
        return result.toString();
    }

    @Deprecated
    protected String prepareOrgaReadingSql() {
        ProcedureSql procSql = new ProcedureSql(this.getSqlDialect().equals("Postgres") ? DB.POSTGRES : DB.INFORMIX);
        procSql.setName(this.getQuelle());
        procSql.addParam(this.user.getId());
        procSql.addDateParam(this.getStand());
        procSql.addParam(this.getId());
        procSql.setFinalSelect("select name,key_apnr,parent,lehre,erlaubt from tmp_organigramm; drop table tmp_organigramm;");
        return procSql.getFinishedCall();
    }

    protected abstract String getSqlDialect();

    protected abstract SxResultSet readFromDb(String var1) throws SQLException, DBServletException, TemplateException, IOException;

    @Deprecated
    private void insertnodes(String theParent, DefaultMutableTreeNode aktNode) {
        Collection result = new TreeSet();
        result = this.mySelect(theParent);
        for (SelectableItem einEintrag : result) {
            SelectableItemNode neuNode = new SelectableItemNode(einEintrag);
            aktNode.add(neuNode);
            String eintrag_key = (String)einEintrag.getId();
            if (eintrag_key != null & theParent == null) {
                this.insertnodes((String)einEintrag.getId(), neuNode);
            }
            if (eintrag_key == null & theParent == null) {
                System.out.println("Achtung! Element hat f\u00e4lschlicherweise sich selbst als parent:" + einEintrag.getName());
            }
            if (eintrag_key == null || theParent == null) continue;
            if (!theParent.equals(eintrag_key)) {
                if (eintrag_key.trim().equals("")) {
                    throw new IllegalArgumentException("Ung\u00fcltiger Schl\u00fcssel Leerstring bei Sicht " + this.getId());
                }
                this.insertnodes((String)einEintrag.getId(), neuNode);
                continue;
            }
            System.out.println("Achtung! Element hat f\u00e4lschlicherweise sich selbst als parent:" + einEintrag.getName() + " key_apnr:" + einEintrag.getId());
        }
    }

    @Deprecated
    private Collection mySelect(String pruefparent) {
        TreeSet<SelectableItem> result = new TreeSet<SelectableItem>();
        for (SelectableItem einEintrag : this.selectableItemCollection) {
            String eintrag_parent = (String)einEintrag.getParentKey();
            if (eintrag_parent == null && pruefparent == null) {
                result.add(einEintrag);
            }
            if (eintrag_parent == null || pruefparent == null || !eintrag_parent.equals(pruefparent)) continue;
            result.add(einEintrag);
        }
        return result;
    }

    public String getArt() {
        return this.art;
    }

    public void setArt(String string) {
        this.art = string;
    }

    public boolean isPerfectlyRegular() {
        return this.isPerfectlyRegular;
    }

    public void setPerfectlyRegular(boolean b) {
        this.isPerfectlyRegular = b;
    }

    public void setUser(SxUser user) {
        if (user == null) {
            throw new IllegalArgumentException("User objekt darf nicht null sein");
        }
        this.user = user;
        this.rights.setAdmin(user.isAdmin());
    }

    Integer getSysteminfoid() {
        return this.systeminfoid;
    }

    void setSysteminfoid(Integer systeminfoid) {
        this.systeminfoid = systeminfoid;
    }

    String getTreeCfgId() {
        return this.treeCfgId;
    }

    public void setTreeCfgId(String treeviewid) {
        this.treeCfgId = treeviewid;
    }

    String getTreeCfgTable() {
        return this.treeCfgTable;
    }

    public void setTreeCfgTable(String treeCfgTable) {
        this.treeCfgTable = treeCfgTable;
    }

    String getAltHierId() {
        return this.altHierId;
    }

    public void setAltHierId(String alt_hier_id) {
        this.altHierId = alt_hier_id;
    }

    public NamedIdObjectWithParentCollection getSelectableItemCollection() {
        return this.selectableItemCollection;
    }

    public void setHauptSicht(AbstractSicht hauptSicht) {
        this.hauptSicht = hauptSicht;
    }

    public void readAltHierItems() throws SQLException, DBServletException, KeyParentEqualException, TemplateException, IOException {
        String sql = "select key,parent from " + this.getQuelle() + " where hierarchie_id='" + this.getAltHierId() + "' order by key";
        SxResultSet rohform = this.readFromDb(sql);
        this.altHierItems.clear();
        for (SxResultRow einEintrag : rohform) {
            NamedIdObjectWithParent item = new NamedIdObjectWithParent();
            item.setId(einEintrag.get(0));
            try {
                item.setParentKey(einEintrag.get(1));
            }
            catch (KeyParentEqualException e) {
                e.printStackTrace();
                throw new RuntimeException("Konne Sicht " + this.getName() + " (" + this.getId() + ") nicht aufbauen. DETAILS:" + e);
            }
            this.altHierItems.add(item);
        }
    }

    public Object exec(List l) throws TemplateModelException {
        Object result = "";
        if (l.get(0).toString().equalsIgnoreCase("getSubkeys")) {
            String key = l.get(1).toString();
            if (!this.containsItemWithId(key)) {
                throw new IllegalArgumentException("In der Sicht " + this.getName() + "(" + this.getName_intern() + ") ist kein Schl\u00fcssel " + key + " enhalten");
            }
            SelectableItemNode node = this.getById(key);
            result = "(" + TreeUtils.getSubordinateKeyList(node, true, true) + ")";
        }
        if (l.get(0).toString().equalsIgnoreCase("dim_bp_apnr_update_parents")) {
            dimension_bp_id = l.get(1).toString();
            result = this.dimbpapnrUpdateParent(dimension_bp_id);
        } else if (l.get(0).toString().equalsIgnoreCase("dim_closure")) {
            dimension_bp_id = l.get(1).toString();
            result = this.dimclosure(dimension_bp_id);
        } else if (l.get(0).toString().equalsIgnoreCase("dim_closure_alt_sicht")) {
            result = this.dim_closure_alt_sicht(this.getName_intern());
        } else if (l.get(0).toString().equalsIgnoreCase("dim_bp_altsicht_fuellen")) {
            result = this.dim_bp_altsicht_fuellen();
        } else if (l.get(0).toString().equalsIgnoreCase("update_edustore_xml")) {
            String webinfdir = l.get(1).toString();
            String name = l.get(2).toString();
            XMLModifier xm = new XMLModifier(name);
            File f = new File(webinfdir + File.separator + "classes" + File.separator + "edustore" + File.separator + "tmp_edustore.xml");
            if (!f.exists()) {
                File origSchema = new File(webinfdir + File.separator + "classes" + File.separator + "edustore" + File.separator + "edustore.xml");
                if (origSchema.exists()) {
                    try {
                        Files.copy((File)origSchema, (File)f);
                    }
                    catch (IOException e) {
                        throw new TemplateModelException((Exception)e);
                    }
                } else {
                    throw new TemplateModelException("Couldn't find Mondrian schema file " + origSchema);
                }
            }
            if (f.exists()) {
                System.out.println("Edustore.xml update modifying " + f + " name:" + name);
                xm.modify(f, this);
            }
            if ((f = new File(webinfdir + File.separator + "src" + File.separator + "edustore" + File.separator + "edustore.xml")).exists()) {
                System.out.println("Edustore.xml update modifying " + f + " name:" + name);
                xm.modify(f, this);
            }
            result = "";
        }
        return result;
    }

    private String dim_closure_alt_sicht(String hierarchie_id) {
        LinkedList<Object> usedDimKeys = new LinkedList<Object>();
        StringBuffer result = new StringBuffer("delete from dim_closure where hierarchie_id='" + hierarchie_id + "';\n");
        DefaultMutableTreeNode startNode = (DefaultMutableTreeNode)((DefaultTreeModel)this.getModel()).getRoot();
        Enumeration<TreeNode> en = startNode.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode n = (SelectableItemNode)en.nextElement();
            if (n.getOwnKey().equals("xxxxxx-xxxxxx@") || usedDimKeys.contains(n.getOwnKey())) continue;
            result.append("insert into dim_closure(hierarchie_id,key,parent,distance) values ('" + hierarchie_id + "',(select distinct apnr from dim_bp_altsicht_apnr where apnrchar='" + n.getOwnKey() + "' and hierarchie_id='" + hierarchie_id + "'),(select distinct apnr from dim_bp_altsicht_apnr where apnrchar='" + n.getOwnKey() + "' and hierarchie_id='" + hierarchie_id + "'),0 );\n");
            this.dimclosurerecaltsicht(hierarchie_id, n.getOwnKey().toString(), (SelectableItemNode)n.getParent(), result, 1);
            usedDimKeys.add(n.getOwnKey());
        }
        return result.toString();
    }

    private void dimclosurerecaltsicht(String hierarchie_id, String key, SelectableItemNode parentNode, StringBuffer result, int distance) {
        if (parentNode != null && !parentNode.getOwnKey().equals("xxxxxx-xxxxxx@")) {
            result.append("insert into dim_closure(hierarchie_id,key,parent,distance) values ('" + hierarchie_id + "',(select distinct apnr from dim_bp_altsicht_apnr where apnrchar='" + key + "' and hierarchie_id='" + hierarchie_id + "'),(select distinct apnr from dim_bp_altsicht_apnr where apnrchar='" + parentNode.getOwnKey() + "' and hierarchie_id='" + hierarchie_id + "')," + distance + " );\n");
            this.dimclosurerecaltsicht(hierarchie_id, key, (SelectableItemNode)parentNode.getParent(), result, ++distance);
        }
    }

    private String dim_bp_altsicht_fuellen() {
        LinkedList<Object> usedDimKeys = new LinkedList<Object>();
        StringBuffer result = new StringBuffer("delete from dim_bp_altsicht_apnr where hierarchie_id='" + this.getName_intern() + "';\n");
        DefaultMutableTreeNode startNode = (DefaultMutableTreeNode)((DefaultTreeModel)this.getModel()).getRoot();
        Enumeration<TreeNode> en = startNode.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode n = (SelectableItemNode)en.nextElement();
            if (n.getOwnKey().equals("xxxxxx-xxxxxx@") || usedDimKeys.contains(n.getOwnKey())) continue;
            Object parent = n.getParentKey();
            if (parent == null) {
                parent = "null";
            }
            result.append("insert into dim_bp_altsicht_apnr (hierarchie_id,apnrchar,parentchar,druck) values ('" + this.getName_intern() + "','" + n.getOwnKey() + "','" + parent + "','" + n.getName() + "');\n");
            usedDimKeys.add(n.getOwnKey());
        }
        return result.toString();
    }

    private String dimclosure(String dimension_bp_id) {
        StringBuffer result = new StringBuffer("delete from dim_closure where dimension_bp_id=" + dimension_bp_id + ";\n");
        DefaultMutableTreeNode startNode = (DefaultMutableTreeNode)((DefaultTreeModel)this.getModel()).getRoot();
        Enumeration<TreeNode> en = startNode.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode n = (SelectableItemNode)en.nextElement();
            if (n.getOwnKey().equals("xxxxxx-xxxxxx@")) continue;
            result.append("insert into dim_closure(dimension_bp_id,key,parent) values (" + dimension_bp_id + ",(select distinct apnr from trans_dim_bp_apnr where sourcesystem_id='" + n.getOwnKey() + "' and dimension_bp_id=" + dimension_bp_id + "),(select distinct apnr from trans_dim_bp_apnr where sourcesystem_id='" + n.getOwnKey() + "' and dimension_bp_id=" + dimension_bp_id + ") );\n");
            this.dimclosurerec(dimension_bp_id, n.getOwnKey().toString(), (SelectableItemNode)n.getParent(), result);
        }
        return result.toString();
    }

    private void dimclosurerec(String dimension_bp_id, String key, SelectableItemNode parentNode, StringBuffer result) {
        if (parentNode != null && !parentNode.getOwnKey().equals("xxxxxx-xxxxxx@")) {
            result.append("insert into dim_closure(dimension_bp_id,key,parent) values (" + dimension_bp_id + ",(select distinct apnr from trans_dim_bp_apnr where sourcesystem_id='" + key + "' and dimension_bp_id=" + dimension_bp_id + "),(select distinct apnr from trans_dim_bp_apnr where sourcesystem_id='" + parentNode.getOwnKey() + "' and dimension_bp_id=" + dimension_bp_id + ") );\n");
            this.dimclosurerec(dimension_bp_id, key, (SelectableItemNode)parentNode.getParent(), result);
        }
    }

    private String dimbpapnrUpdateParent(String dimension_bp_id) {
        StringBuffer result = new StringBuffer();
        DefaultMutableTreeNode startNode = (DefaultMutableTreeNode)((DefaultTreeModel)this.getModel()).getRoot();
        Enumeration<TreeNode> en = startNode.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            SelectableItemNode n = (SelectableItemNode)en.nextElement();
            if (n.getParentKey() == null || n.getParentKey().equals("")) continue;
            result.append("update dim_bp_apnr set parent=(select distinct apnr from trans_dim_bp_apnr where sourcesystem_id='" + n.getParentKey() + "' and dimension_bp_id=" + dimension_bp_id + ") where dimension_bp_id=" + dimension_bp_id + " and apnr in (select apnr from trans_dim_bp_apnr where sourcesystem_id='" + n.getOwnKey() + "' and dimension_bp_id=" + dimension_bp_id + ");\n");
        }
        return result.toString();
    }

    public String getOwnAndParentsKeyList() {
        DefaultMutableTreeNode startNode = (DefaultMutableTreeNode)((DefaultTreeModel)this.getModel()).getRoot();
        if (this.getSelectionCount() > 0) {
            startNode = (SelectableItemNode)this.getSelectionPath().getLastPathComponent();
        }
        return TreeUtils.getOwnAndParentsKeyList(startNode, false, true).replaceAll(",'xxxxxx-xxxxxx@'", "");
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public void setId(Object id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return (this.isAltHier() ? "Alt.Hier:" : "") + this.name + " Anzahl Eintr\u00e4ge:" + ((DefaultMutableTreeNode)this.getModel().getRoot()).getChildCount();
    }

    protected void refreshGui() {
        SelectableItemNode root = (SelectableItemNode)this.getModel().getRoot();
        if (!this.isAltHier() && root.getChildCount() > 0) {
            DefaultMutableTreeNode ebene1 = (DefaultMutableTreeNode)root.getChildAt(0);
            this.expandPath(new TreePath(ebene1.getPath()));
        }
        this.setRootVisible(false);
        this.validate();
    }

    private void configTree() {
        this.setRootVisible(false);
        if (leaf == null) {
            ClassLoader cl = this.getClass().getClassLoader();
            try {
                leaf = new ImageIcon(cl.getResource("images/leaf.gif"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setBorderSelectionColor(Color.darkGray);
        if (leaf != null) {
            renderer.setLeafIcon(leaf);
        }
        this.setCellRenderer(renderer);
        this.setSelectionModel(new SxSelectionModel());
        this.getSelectionModel().setSelectionMode(1);
        this.refreshGui();
    }

    protected void setMultiSelection(boolean isMulti) {
        if (isMulti) {
            this.getSelectionModel().setSelectionMode(4);
        } else {
            this.getSelectionModel().setSelectionMode(1);
        }
    }

    protected void reset() {
        this.setNoSelectionPossible();
    }

    private void readTreeCfg() throws SQLException, DBServletException, TemplateException, IOException {
        this.closedTreeNodes.clear();
        String sql = "select node_id from " + this.getTreeCfgTable() + " where tree_id='" + this.getTreeCfgId() + "'";
        SxResultSet rohform = this.readFromDb(sql);
        for (SxResultRow einEintrag : rohform) {
            IdObject item = new IdObject();
            item.setId(einEintrag.get(0));
            this.closedTreeNodes.add(item);
        }
        this.isTreeCfgRead = true;
    }

    public Collection getElements(int enumType, boolean isHiddenWanted) {
        LinkedList<SelectableItemNode> result = new LinkedList<SelectableItemNode>();
        SelectableItemNode startNode = (SelectableItemNode)this.getModel().getRoot();
        for (int i = 0; i < Math.max(1, this.getSelectionCount()); ++i) {
            if (this.getSelectionCount() > 0) {
                startNode = (SelectableItemNode)this.getSelectionPaths()[i].getLastPathComponent();
            }
            Enumeration<TreeNode> en = null;
            if (enumType < 1 || enumType > 3) {
                throw new IllegalArgumentException("Ung\u00fcltiger Enumtype");
            }
            if (enumType == 1) {
                en = startNode.preorderEnumeration();
            }
            if (enumType == 2) {
                en = startNode.breadthFirstEnumeration();
            }
            if (enumType == 3) {
                en = startNode.depthFirstEnumeration();
            }
            if (this.isSubelementsinForEach()) {
                while (en.hasMoreElements()) {
                    SelectableItemNode node = (SelectableItemNode)en.nextElement();
                    if (!isHiddenWanted && node.isHidden() || node.isRoot()) continue;
                    result.add(node);
                }
                continue;
            }
            if (!isHiddenWanted && startNode.isHidden() || startNode.isRoot() || this.isAltHier() && !this.isVisible(new TreePath(startNode.getPath()))) continue;
            result.add(startNode);
        }
        return result;
    }

    public boolean isExpanded(SelectableItemNode n) {
        return this.isCollapsed(new TreePath(n.getPath()));
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (key == null) {
            return null;
        }
        SimpleScalar result = null;
        if (key.equalsIgnoreCase("sichtart")) {
            result = new SimpleScalar(this.getArt());
        }
        if (key.equalsIgnoreCase("sichtname_intern")) {
            result = new SimpleScalar(this.getName_intern());
        }
        if (key.equalsIgnoreCase("sichtname")) {
            result = new SimpleScalar(this.getName());
        }
        if (key.equalsIgnoreCase("id") || key.equalsIgnoreCase("key")) {
            result = this.getId() == null ? new SimpleScalar(null) : new SimpleScalar(this.getId().toString());
        }
        if (key.equalsIgnoreCase("allNeededKeys") || key.equalsIgnoreCase("allNeededKeysList")) {
            result = new SimpleScalar(this.getAllNeededKeysList());
        }
        if (key.equalsIgnoreCase("keysToRoot")) {
            result = new SimpleScalar(this.getOwnAndParentsKeyList());
        }
        if (key.equalsIgnoreCase("elementsMinEbene")) {
            result = new SimpleNumber(this.getElementsMinEbene(1));
        }
        if (key.equalsIgnoreCase("elementsMaxEbene")) {
            result = new SimpleNumber(this.getElementsMaxEbene(1));
        }
        if (key.equalsIgnoreCase("allElements")) {
            result = new SimpleSequence(this.getAllElements());
        }
        if (key.equalsIgnoreCase("breadthFirstElements")) {
            result = new SimpleSequence(this.getElements(2, false));
        }
        if (key.equalsIgnoreCase("depthFirstElements")) {
            result = new SimpleSequence(this.getElements(3, false));
        }
        if (key.equalsIgnoreCase("elements_incl_hidden")) {
            result = new SimpleSequence(this.getElements(1, true));
        }
        if (key.equalsIgnoreCase("breadthFirstElements_incl_hidden")) {
            result = new SimpleSequence(this.getElements(2, true));
        }
        if (key.equalsIgnoreCase("depthFirstElements_incl_hidden")) {
            result = new SimpleSequence(this.getElements(3, true));
        }
        if (key.equalsIgnoreCase("selectedElementsOnly")) {
            LinkedList<Object> list = new LinkedList<Object>();
            for (int i = 0; i < this.getSelectionCount(); ++i) {
                list.add(this.getSelectionPaths()[i].getLastPathComponent());
            }
            result = new SimpleSequence(list);
        }
        if (key.equalsIgnoreCase("hasValue")) {
            result = this.getSelectionCount() == 0 ? TemplateBooleanModel.FALSE : TemplateBooleanModel.TRUE;
        }
        if (key.equalsIgnoreCase("selectionCount")) {
            result = new SimpleNumber((Number)this.getSelectionCount());
        }
        return result;
    }

    public boolean isEmpty() throws TemplateModelException {
        return false;
    }

    @Override
    public boolean isAllowed() {
        return this.isAllowed;
    }

    @Override
    public void setAllowed(boolean isAllowed) {
        this.isAllowed = isAllowed;
    }

    public String getMandantenID() {
        return this.mandantenID;
    }

    public void setMandantenID(String mandantenID) {
        this.mandantenID = mandantenID;
    }

    public static void main(String[] args) {
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getXmlMaxEntries() {
        return this.xmlMaxEntries;
    }

    public void setXmlMaxEntries(Integer xmlMaxEntries) {
        this.xmlMaxEntries = xmlMaxEntries;
    }

    protected void finishClone(AbstractSicht cl) throws CloneNotSupportedException {
        cl.sichten = this.sichten;
        cl.mandantenID = this.mandantenID;
        cl.label = this.label;
        cl.art = this.art;
        cl.name_intern = this.name_intern;
        cl.beschreibung = this.beschreibung;
        cl.quelle = this.quelle;
        cl.stand = this.stand;
        cl.isStandbuttonWanted = this.isStandbuttonWanted;
        cl.isPerfectlyRegular = this.isPerfectlyRegular;
        cl.hasCachedVersion = this.hasCachedVersion;
        cl.isAllowed = this.isAllowed;
        cl.systeminfoid = this.systeminfoid;
        cl.treeCfgId = this.treeCfgId;
        cl.treeCfgTable = this.treeCfgTable;
        cl.sichtartRechte = this.sichtartRechte;
        cl.isDynamic = this.isDynamic;
        cl.selectableItemCollection.clear();
        for (IdObjectI item : this.selectableItemCollection) {
            cl.selectableItemCollection.add(((SelectableItem)item).clone());
        }
        cl.altHierItems.clear();
        for (IdObjectI item : this.altHierItems) {
            cl.altHierItems.add(((NamedIdObjectWithParent)item).clone());
        }
        cl.closedTreeNodes.clear();
        for (IdObjectI item : this.closedTreeNodes) {
            cl.closedTreeNodes.add(((IdObject)item).clone());
        }
        cl.validityPeriod = (Period)this.validityPeriod.clone();
        cl.user = this.user;
        cl.altHierId = this.altHierId;
        if (this.hauptSicht != null) {
            cl.hauptSicht = (AbstractSicht)this.hauptSicht.clone();
        }
        cl.type = this.type;
        cl.xmlMaxEntries = this.xmlMaxEntries;
        cl.attribut2 = this.attribut2;
        cl.attribut1 = this.attribut1;
        cl.attribut3 = this.attribut3;
        cl.rights = (Rights)this.rights.clone();
        cl.applyTreeCfg();
    }

    public String getJSONInfo() {
        return "{name:\"" + StringUtils.jsonAdapt(this.getName(), true) + "\",name_intern:\"" + StringUtils.jsonAdapt(this.getName_intern(), true) + "\",stand:" + (this.isStandbuttonWanted() ? "true" : "false") + "}";
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof AbstractSicht) {
            result = this.getId().equals(((AbstractSicht)o).getId());
        }
        return result;
    }

    public boolean isSubelementsinForEach() {
        return this.isSubelementsinForEach;
    }

    public void setSubelementsinForEach(boolean isSubelementsinForEach) {
        this.isSubelementsinForEach = isSubelementsinForEach;
    }

    public boolean isFirstInGroup() {
        return this.isFirstInGroup;
    }

    public void setFirstInGroup(boolean isFristInGroup) {
        this.isFirstInGroup = isFristInGroup;
    }

    public Integer getAttribut3() {
        return this.attribut3;
    }

    public void setAttribut3(Integer attribut3) {
        this.attribut3 = attribut3;
    }

    public int getElementsMinEbene(int type) {
        Collection c = this.getElements(type, true);
        int minEbene = 99999;
        for (DefaultMutableTreeNode n : c) {
            if (n.getLevel() >= minEbene) continue;
            minEbene = n.getLevel();
        }
        return minEbene;
    }

    public int getElementsMaxEbene(int type) {
        Collection c = this.getElements(type, true);
        int maxEbene = -1;
        for (DefaultMutableTreeNode n : c) {
            if (n.getLevel() <= maxEbene) continue;
            maxEbene = n.getLevel();
        }
        return maxEbene;
    }

    public SichtartRechte getSichtartRechte() {
        return this.sichtartRechte;
    }

    public void setSichtartRechte(SichtartRechte sichtartRechte) {
        this.sichtartRechte = sichtartRechte;
    }

    public boolean isImplicitOrgUnitRightsWanted() {
        return this.attribut2 != null && this.attribut2.toLowerCase().indexOf("implicitorgunitrights") > -1;
    }

    private class SxSelectionModel
    extends DefaultTreeSelectionModel {
        private static final long serialVersionUID = 1L;

        private SxSelectionModel() {
        }

        @Override
        protected boolean canPathsBeAdded(TreePath[] paths) {
            boolean result = true;
            for (int i = 0; i < paths.length; ++i) {
                if (!(paths[i].getLastPathComponent() instanceof SelectableItemNode) || ((SelectableItemNode)paths[i].getLastPathComponent()).isSelectable()) continue;
                result = false;
                break;
            }
            return result;
        }

        @Override
        public void addSelectionPath(TreePath path) {
            TreePath[] tp = new TreePath[]{path};
            if (this.canPathsBeAdded(tp)) {
                super.addSelectionPath(path);
            }
        }

        @Override
        public void addSelectionPaths(TreePath[] paths) {
            if (this.canPathsBeAdded(paths)) {
                super.addSelectionPaths(paths);
            }
        }

        @Override
        public void setSelectionPath(TreePath path) {
            TreePath[] tp = new TreePath[]{path};
            if (this.canPathsBeAdded(tp)) {
                super.setSelectionPath(path);
            }
        }

        @Override
        public void setSelectionPaths(TreePath[] paths) {
            if (this.canPathsBeAdded(paths)) {
                super.setSelectionPaths(paths);
            }
        }
    }
}

