/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin.fm;

import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import de.superx.spring.batch.His1DataSources;
import freemarker.template.SimpleScalar;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateTransformModel;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.KettleLoggingEvent;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryListener;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.metastore.DatabaseMetaStoreUtil;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.stores.memory.MemoryMetaStore;

public class EtlStarter
implements TemplateTransformModel {
    public static final String PARAM_KEY_COMP = "component";
    public static final String PARAM_KEY_STEP = "etl_step";
    public static final String PARAM_LOGLEVEL = "log_level";
    static Logger logger = Logger.getLogger(EtlStarter.class);
    private LogLevel logLevel = LogLevel.MINIMAL;
    private String mandantenId = SxSQL_Server.DEFAULT_MANDANTEN_ID;

    public EtlStarter(String mandantenId) {
        this.mandantenId = mandantenId;
    }

    public Writer getWriter(Writer paramWriter, Map paramMap) throws TemplateModelException, IOException {
        logger.info((Object)("**EtlStarter** for mandantenID " + this.mandantenId));
        SimpleScalar componentSc = (SimpleScalar)paramMap.get(PARAM_KEY_COMP);
        SimpleScalar etl_stepSc = (SimpleScalar)paramMap.get(PARAM_KEY_STEP);
        SimpleScalar log_levelSc = (SimpleScalar)paramMap.get(PARAM_LOGLEVEL);
        String component = componentSc.getAsString();
        String etl_step = etl_stepSc.getAsString();
        if (component == null || component.isEmpty()) {
            throw new TemplateModelException("Missing parameter component");
        }
        if (etl_step == null || etl_step.isEmpty()) {
            throw new TemplateModelException("Missing parameter etl_step");
        }
        paramMap.remove(PARAM_KEY_COMP);
        paramMap.remove(PARAM_KEY_STEP);
        paramMap.remove(PARAM_LOGLEVEL);
        if (log_levelSc != null) {
            this.logLevel = LogLevel.valueOf((String)log_levelSc.getAsString());
        }
        HashMap<String, String> params = new HashMap<String, String>();
        for (Object key : paramMap.keySet()) {
            SimpleScalar value = (SimpleScalar)paramMap.get(key);
            params.put((String)key, value.getAsString());
            logger.info((Object)("PARAM: " + key + " -> " + value.getAsString()));
        }
        String moduleDir = SuperXManager.getModuleDir();
        if (moduleDir == null || moduleDir.equals("")) {
            if (System.getProperty("MODULE_PFAD") != null && !System.getProperty("MODULE_PFAD").toString().equals("")) {
                moduleDir = System.getProperty("MODULE_PFAD").toString();
            } else {
                throw new IOException("Module-Pfad kann nicht ermittelt werden, bitte setzen Sie den JVM Parameter -DMODULE_PFAD=...");
            }
        }
        String jobFilePath = null;
        jobFilePath = component.contentEquals("manual") ? this.getFilePathFromDatabase(etl_step, moduleDir) : this.getFilePathFromModule(component, etl_step, moduleDir);
        logger.info((Object)("Kettle job: " + jobFilePath));
        this.kettleCallEmbedded(jobFilePath, params, true);
        return null;
    }

    private String getFilePathFromDatabase(String etl_step, String moduleDir) throws IOException {
        String jobFilePath = null;
        try (Connection con = SxPools.get(this.mandantenId).getConnection();
             PreparedStatement pst = con.prepareStatement("select filepath from sx_jobs where uniquename=?");){
            pst.setString(1, etl_step);
            ResultSet rs = pst.executeQuery();
            while (rs.next()) {
                jobFilePath = rs.getString(1);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new IOException("Fehler beim Auslesen von sx_jobs mit uniquename " + etl_step + " " + e);
        }
        if (jobFilePath == null) {
            throw new IOException("Fehler beim Auslesen von sx_jobs mit uniquename " + etl_step + " Kein Eintrag gefunden");
        }
        return moduleDir + File.separator + jobFilePath;
    }

    private String getFilePathFromModule(String component, String etl_step, String moduleDir) throws TemplateModelException {
        Element etl;
        if (!new File((String)(moduleDir = (String)moduleDir + File.separator + component + File.separator)).exists()) {
            throw new TemplateModelException("Component not found: " + component);
        }
        File componentXml = new File((String)moduleDir + File.separator + "conf" + File.separator + component + ".xml");
        if (!componentXml.canRead()) {
            throw new TemplateModelException("Cannot read component xml for " + component);
        }
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read(componentXml);
            etl = (Element)document.selectSingleNode("//module/etl/etl-step[@id='" + etl_step + "']/action/kettle-job-embedded");
        }
        catch (DocumentException e) {
            throw new TemplateModelException((Exception)((Object)e));
        }
        if (etl == null) {
            throw new TemplateModelException("Didn't find kettle-job-embedded in etl-step with id " + etl_step + " for component " + component);
        }
        String fileAttr = etl.attributeValue("file");
        String jobFilePath = (String)moduleDir + fileAttr.substring(fileAttr.indexOf(47) + 1);
        return jobFilePath;
    }

    public final StringBuffer kettleCallEmbedded(String jobfile, Map<String, String> jobParams, boolean isPostgres) {
        return this.kettleCallEmbedded(this.mandantenId, jobfile, jobParams, isPostgres);
    }

    private final StringBuffer kettleCallEmbedded(String mandantenID, String jobfile, Map<String, String> jobParams, boolean isPostgres) {
        StringWriter writer = new StringWriter();
        WriterAppender appender = new WriterAppender((Layout)new SimpleLayout(), (Writer)writer);
        Level oldLevel = logger.getLevel();
        logger.setLevel(Level.DEBUG);
        logger.addAppender((Appender)appender);
        try {
            MemoryMetaStore metastore = new MemoryMetaStore();
            His1DataSources dataSources = SuperXManager.getBean("dataSources", His1DataSources.class);
            Set<String> dbNames = dataSources != null ? dataSources.getKeys() : Set.of("eduetl");
            for (String dbName : dbNames) {
                DatabaseMeta dbmeta = new DatabaseMeta(dbName, isPostgres ? "POSTGRESQL" : "INFORMIX", "JNDI", null, dbName, "1521", null, null);
                DatabaseMetaStoreUtil.createDatabaseElement((IMetaStore)metastore, (DatabaseMeta)dbmeta);
                logger.info((Object)("Init pdi database connection " + dbName));
            }
            JobMeta jobMeta = new JobMeta(null, jobfile, null, (IMetaStore)metastore, null);
            jobMeta.setSafeModeEnabled(true);
            Job job = new Job(null, jobMeta);
            job.setLogLevel(this.logLevel);
            String[] params = jobMeta.listParameters();
            for (String param : params) {
                logger.info((Object)("Job-Param: " + param));
                logger.info((Object)("  -> defaults to " + jobMeta.getParameterDefault(param)));
            }
            job.copyParametersFrom((NamedParams)jobMeta);
            job.setInteractive(true);
            if (jobParams != null) {
                for (String param : jobParams.keySet()) {
                    String value = jobParams.get(param);
                    if (param.equals(PARAM_LOGLEVEL)) {
                        job.setLogLevel(LogLevel.valueOf((String)value));
                        logger.info((Object)("Set kettle LogLevel to " + value));
                        continue;
                    }
                    logger.info((Object)("PARAM " + param + " = " + value));
                    jobMeta.setParameterValue(param, value);
                }
            }
            KettleLogStore.discardLines((String)job.getLogChannelId(), (boolean)true);
            int logStartLine = KettleLogStore.getLastBufferLineNr();
            job.addJobEntryListener(new JobEntryListener(){
                private Map<String, Integer> jobEntryCounts = new HashMap<String, Integer>();

                public void beforeExecution(Job ajob, JobEntryCopy jobEntryCopy, JobEntryInterface jobEntryInterface) {
                    if (jobEntryCopy.isStart()) {
                        return;
                    }
                    String name = jobEntryCopy.getName();
                    int count = this.jobEntryCounts.containsKey(name) ? this.jobEntryCounts.get(name) + 1 : 1;
                    this.jobEntryCounts.put(name, count);
                    if (this.jobEntryCounts.get(name) > 10) {
                        throw new RuntimeException("Job creating too many job entries of " + name);
                    }
                    logger.debug((Object)("JobEntry: " + name + " Count: " + this.jobEntryCounts.get(name)));
                }

                public void afterExecution(Job job, JobEntryCopy jobEntryCopy, JobEntryInterface jobEntryInterface, Result result) {
                }
            });
            job.activateParameters();
            job.start();
            job.waitUntilFinished();
            List logEvents = KettleLogStore.getLogBufferFromTo((String)job.getLogChannelId(), (boolean)true, (int)logStartLine, (int)KettleLogStore.getLastBufferLineNr());
            StringBuffer errors = new StringBuffer();
            for (KettleLoggingEvent event : logEvents) {
                logger.debug((Object)event.getMessage().toString());
                if (event.getLevel() != LogLevel.ERROR) continue;
                errors.append(event.getMessage());
            }
            if (errors.length() > 0) {
                logger.info((Object)(job.getErrors() + " Errors executing Kettle job " + jobfile));
                throw new RuntimeException("Errors in Kettle job " + jobfile + ": " + errors);
            }
            logger.info((Object)"Job erfolgreich durchgef\u00fchrt");
        }
        catch (Exception ex) {
            logger.error((Object)("Error executing Kettle job " + jobfile), (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            logger.removeAppender((Appender)appender);
            logger.setLevel(oldLevel);
        }
        return writer.getBuffer();
    }

    public static void main(String[] args) {
        String jobfile = "file:///home/superx/data-integration/exceltest.kjb";
        HashMap<String, String> jobParams = new HashMap<String, String>();
        jobParams.put("PATH_TO_EXCELFILE", "/home/superx/tmp/testexcel2.xlsx");
        EtlStarter es = new EtlStarter("default");
        es.kettleCallEmbedded(jobfile, jobParams, false);
    }
}

