/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.LogUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.AbstractWebserviceClient;
import de.superx.bin.SxConnection;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.logging.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WebserviceClientHier
extends AbstractWebserviceClient {
    private String dbpropfile;
    private String hsnr;
    private String xmlConfig;
    private String wsurl;
    private String hierSOAP;
    private PreparedStatement pst_insert;
    private Connection con;

    public static void main(String[] args) {
        System.out.println("SuperX-WebserviceClientHier Version 1.4 (2021-12-20)");
        WebserviceClientHier tc = new WebserviceClientHier();
        tc.run(args);
    }

    public void run(String[] args) {
        try {
            this.initLogging();
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_dbprops, GetOpts.Options.opt_xmlconfig, GetOpts.Options.opt_hsnr});
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.exit(1);
            }
            this.readConfig();
            this.prepareDbAndPreparedStatement();
            this.readKostenstellen(this.hsnr, null);
            this.con.close();
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            System.out.println("Error " + e.getMessage());
            e.printStackTrace();
            LogUtils.close("wc");
            System.exit(1);
        }
        finally {
            LogUtils.close("wc");
        }
    }

    private void prepareDbAndPreparedStatement() throws Exception {
        SxConnection myConnection = new SxConnection();
        myConnection.setPropfile(this.dbpropfile);
        this.con = myConnection.getConnection();
        Statement st = this.con.createStatement();
        st.execute("delete from gxstage_inst_hier");
        st.close();
        this.pst_insert = this.con.prepareStatement("insert into gxstage_inst_hier (inst_nr, uebinst_nr,lname1,orgstruktur) values (?,?,?,-1)");
    }

    private void readKostenstellen(String kostenstelle, String parent) throws Exception {
        String soap = this.hierSOAP.replaceAll("XXKOSTLXX", kostenstelle);
        StringBuffer result = this.readSOAP(soap, this.wsurl);
        Document document = XMLUtils.buildDocumentFromString(WebserviceClientHier.purge(result.toString(), false), false);
        if (this.isReplyOk(result)) {
            Node headert = XMLUtils.getFirstNode(document, "EX_SETHEADERT");
            Node headertitem = XMLUtils.getChildNode(headert, "item");
            String id = XMLUtils.getChildNodeValue(headertitem, "SETNAME");
            String name = XMLUtils.getChildNodeValue(headertitem, "DESCRIPT");
            String msg = "  Kostenstelle " + id + " " + name + " gefunden";
            System.out.println(msg);
            logger.log(Level.FINEST, msg);
            this.updateDatabase(id, parent, name);
            Node kids = XMLUtils.getFirstNode(document, "EX_SETNODE");
            Iterator<Node> it = XMLUtils.getChildNodeIterator(kids);
            while (it.hasNext()) {
                Node item = it.next();
                String unterkostenstelle = XMLUtils.getChildNodeValue(item, "SUBSETNAME");
                this.readKostenstellen(unterkostenstelle, kostenstelle);
            }
        } else {
            String msg = "Error: Aufruf von Webservice f\u00fcr " + this.xmlConfig + " fehlgeschlagen:\n" + result;
            System.out.println(msg);
            logger.severe(msg);
            LogUtils.close("wc");
            System.exit(-1);
        }
    }

    private void updateDatabase(String id, String parent, String name) throws SQLException {
        this.pst_insert.clearParameters();
        this.pst_insert.setString(1, id);
        this.pst_insert.setString(2, parent);
        this.pst_insert.setString(3, name);
        this.pst_insert.execute();
    }

    private void readConfig() throws IOException, SAXException {
        this.dbpropfile = GetOpts.getValue(GetOpts.Options.opt_dbprops);
        this.hsnr = GetOpts.getValue(GetOpts.Options.opt_hsnr);
        System.out.println("\n" + DateUtils.getTodayString() + " " + DateUtils.getNowString() + "\nHochschulnummer " + this.hsnr);
        logger.info("\nHochschulnummer " + this.hsnr);
        this.xmlConfig = GetOpts.getValue(GetOpts.Options.opt_xmlconfig);
        if (GetOpts.isPresent(GetOpts.Options.opt_noDelete)) {
            this.isDeleteTmpXmlFileWanted = false;
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_pause)) {
            String p = GetOpts.getValue(GetOpts.Options.opt_pause);
            this.pause = Integer.parseInt(p);
            System.out.println("Pause between soap calls " + this.pause);
        }
        logger.log(Level.INFO, "Verarbeite " + this.xmlConfig);
        System.out.println("Verarbeite " + this.xmlConfig);
        Document dconf = XMLUtils.buildDocument(new File(this.xmlConfig));
        Node n = XMLUtils.getFirstNode(dconf, "webservice");
        n = XMLUtils.getFirstNode(dconf, "wsurl");
        this.wsurl = XMLUtils.getTheValue(n);
        this.wsurl = this.adaptURL(this.wsurl);
        logger.fine("URL:" + this.wsurl);
        System.out.println("URL:" + this.wsurl);
        n = XMLUtils.getFirstNode(dconf, "hiersoap");
        this.hierSOAP = XMLUtils.getTheValue(n);
        this.hierSOAP = this.hierSOAP.replaceAll("XXHSNRXX", this.hsnr);
    }
}

