/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.LogUtils;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.AbstractWebserviceClient;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.logging.Level;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WebserviceClientFiposGroupsHoh
extends AbstractWebserviceClient {
    private boolean isDebug = false;
    private Document configDocument;
    private XMLInputFactory factory = XMLInputFactory.newInstance();
    private String xmlConfig;
    private String url;
    private String soap;
    private String outfilename;
    private String setname;
    private boolean isDeleteTmpXmlFileWanted = true;
    private File tmpFile;
    private PrintWriter fwLeafs;
    private BufferedWriter bfwLeafs;
    private StringBuilder leafs = new StringBuilder();

    public static void main(String[] args) {
        System.out.println("SuperX-WebserviceClientFiposGroupsHoh Version 1.0.2");
        WebserviceClientFiposGroupsHoh tc = new WebserviceClientFiposGroupsHoh();
        tc.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        try {
            this.initLogging();
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_xmlconfig, GetOpts.Options.opt_setname, GetOpts.Options.opt_out});
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.exit(1);
            }
            this.readConfig();
            this.perform();
            String msg = "    fertig: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
            logger.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            System.out.println("Error " + e.getMessage());
            e.printStackTrace();
            LogUtils.close("wc");
            System.exit(1);
        }
        finally {
            LogUtils.close("wc");
        }
    }

    private void perform() throws Exception {
        Node n = XMLUtils.getFirstNode(this.configDocument, "url");
        this.url = XMLUtils.getTheValue(n);
        this.url = this.adaptURL(this.url);
        logger.fine("URL:" + this.url);
        System.out.println("URL:" + this.url);
        n = XMLUtils.getFirstNode(this.configDocument, "soap");
        this.soap = XMLUtils.getTheValue(n);
        this.soap = this.soap.replace("XXSETNAMEXX", this.setname);
        System.out.println(this.soap);
        logger.fine("SOAP Aufruf:\n" + this.soap);
        this.tmpFile = this.createSoapFile(this.soap, this.url);
        Object msg = " - empfangen ";
        if (!this.isDeleteTmpXmlFileWanted) {
            msg = (String)msg + " (" + this.tmpFile + ")";
        }
        msg = (String)msg + " " + DateUtils.getNowString();
        System.out.println((String)msg);
        if (this.isReplyOk(this.tmpFile)) {
            this.initOutFile();
            this.readData();
            if (this.leafs.length() > 0) {
                this.bfwLeafs.write(this.leafs.toString());
                this.bfwLeafs.flush();
            }
            if (this.isDeleteTmpXmlFileWanted) {
                this.tmpFile.delete();
            }
        } else {
            msg = "Error: Aufruf von Webservice f\u00fcr Beseg  (" + this.xmlConfig + ") fehlgeschlagen";
            System.out.println((String)msg);
            System.out.println(StringUtils.readFile(this.tmpFile));
            logger.severe((String)msg);
            LogUtils.close("wc");
            System.exit(-1);
        }
        this.closeFile();
    }

    private void readData() throws XMLStreamException, IOException {
        FileInputStream in = null;
        in = this.isDebug ? new FileInputStream("/home/superx/svn/repos/Projekte/hohenheim_uni/webservices/finanzposgruppen/sxbmbf.txt") : new FileInputStream(this.tmpFile);
        XMLStreamReader parser = this.factory.createXMLStreamReader(in);
        this.leafs.setLength(0);
        boolean getDataLeafs = false;
        boolean isLeafs = false;
        while (parser.hasNext()) {
            switch (parser.getEventType()) {
                case 1: {
                    String name = parser.getLocalName();
                    if (name.equals("EX_SETLEAF")) {
                        isLeafs = true;
                    }
                    if (!isLeafs || !this.isRelevantNodeName(name)) break;
                    getDataLeafs = true;
                    break;
                }
                case 4: {
                    if (!isLeafs || !getDataLeafs || parser.isWhiteSpace()) break;
                    this.leafs.append(WebserviceClientFiposGroupsHoh.purge(parser.getText(), true));
                    break;
                }
                case 2: {
                    String name = parser.getLocalName();
                    if (name.equals("EX_SETLEAF")) {
                        isLeafs = false;
                    }
                    if (isLeafs && getDataLeafs && this.isRelevantNodeName(name)) {
                        getDataLeafs = false;
                        this.leafs.append("^");
                    }
                    if (!isLeafs || !name.equals("item")) break;
                    this.leafs.append(this.setname + "^\n");
                    break;
                }
                case 8: {
                    parser.close();
                }
            }
            parser.next();
        }
        ((InputStream)in).close();
    }

    private void readConfig() throws IOException, SAXException {
        this.xmlConfig = GetOpts.getValue(GetOpts.Options.opt_xmlconfig);
        this.setname = GetOpts.getValue(GetOpts.Options.opt_setname);
        this.outfilename = GetOpts.getValue(GetOpts.Options.opt_out);
        System.out.println("\n" + DateUtils.getTodayString() + " " + DateUtils.getNowString());
        if (GetOpts.isPresent(GetOpts.Options.opt_noDelete)) {
            this.isDeleteTmpXmlFileWanted = false;
        }
        logger.log(Level.INFO, "Verarbeite " + this.xmlConfig);
        System.out.println("Verarbeite " + this.xmlConfig);
        this.configDocument = XMLUtils.buildDocument(new File(this.xmlConfig));
    }

    private void initOutFile() throws Exception {
        File outFile = new File(this.outfilename);
        if (outFile.exists()) {
            outFile.delete();
        }
        this.fwLeafs = new PrintWriter(outFile);
        this.bfwLeafs = new BufferedWriter(this.fwLeafs);
    }

    private boolean isRelevantNodeName(String name) {
        return name.equals("SETNAME") || name.equals("VALSIGN") || name.equals("VALOPTION") || name.equals("VALFROM") || name.equals("VALTO");
    }

    private void closeFile() throws Exception {
        this.bfwLeafs.close();
        this.fwLeafs.close();
        if (this.isDeleteTmpXmlFileWanted && this.tmpFile.exists()) {
            this.tmpFile.delete();
        }
    }
}

