/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.LogUtils;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.AbstractWebserviceClient;
import de.superx.bin.SxTransformer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Deprecated
public class WebserviceClientBewegungsdatenAlt
extends AbstractWebserviceClient {
    private Document resultDocument;
    private Document configDocument;
    private String hsnr;
    private final Calendar calendar = Calendar.getInstance();
    private String xmlConfig;
    private String datentyp;
    private String url;
    private String data;
    private String soap;
    private String replaceNodeName;
    private String xslpfad;
    private String outfile;
    private File tempFile;
    private String jahr;
    private PrintWriter fw;
    private BufferedWriter bfw;
    private static final Logger log = Logger.getLogger("wc");

    public static void main(String[] args) {
        System.out.println("SuperX-WebserviceClientBewegungsdaten Version 0.9.3");
        WebserviceClientBewegungsdatenAlt tc = new WebserviceClientBewegungsdatenAlt();
        tc.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        try {
            LogUtils.initRawFileDateTime("wc", "WebserviceClient.log", 100000, 1, true, false);
            log.setLevel(Level.FINEST);
            log.getHandlers()[0].setLevel(Level.FINEST);
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_xmlconfig, GetOpts.Options.opt_xslPfad, GetOpts.Options.opt_hsnr, GetOpts.Options.opt_jahr, GetOpts.Options.opt_out, GetOpts.Options.opt_datentyp});
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.exit(1);
            }
            this.readConfig();
            this.perform();
            String msg = "    fertig: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
            log.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            log.severe(e.getMessage());
            System.out.println("Error " + e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            LogUtils.close("wc");
        }
    }

    private void perform() throws Exception {
        Node n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "detailurl");
        this.url = XMLUtils.getTheValue(n);
        this.url = this.adaptURL(this.url);
        n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "detailsoap");
        this.soap = XMLUtils.getTheValue(n);
        this.soap = this.soap.replace("XXHSNRXX", this.hsnr);
        this.soap = this.soap.replace("XXJAHRXX", this.jahr);
        System.out.println(this.datentyp + "\n14x " + this.soap);
        n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "detailreplacenode");
        this.replaceNodeName = XMLUtils.getAttribValue(n, "from");
        this.initTempFile();
        for (int monat = 0; monat <= 4; ++monat) {
            String monatssoap = this.getMonatsoap(monat);
            log.fine(this.datentyp + "\nSOAP Aufruf:\n" + monatssoap);
            System.out.print("starte Aufruf " + (monat + 1));
            this.data = this.readSOAP(monatssoap, this.url).toString();
            System.gc();
            System.out.println("  -  empfangen ");
            this.data = this.data.replaceAll("<\\?xml.*\\?>", "");
            System.gc();
            this.data = XMLUtils.removeTroublesomeCharacters(this.data);
            System.gc();
            this.data = this.data.replaceAll("\u20ac", "EUR");
            System.gc();
            this.data = this.data.replaceAll("\u2013", "-");
            System.gc();
            this.data = this.data.replaceAll("\u2026", "...");
            System.gc();
            this.data = StringUtils.replace(this.data, this.replaceNodeName, "response");
            System.gc();
            this.resultDocument = XMLUtils.buildDocumentFromString(this.data, false);
            if (this.isReplyOk()) {
                if (this.data.indexOf("<EX_FMIFIIT/>") > -1 || this.data.indexOf("<EX_FMBDP/>") > -1 || this.data.indexOf("<EX_FMIOI/>") > -1) continue;
                this.appendData();
            } else {
                String msg = "Error: Aufruf von Webservice f\u00fcr Bewegungsdaten " + this.datentyp + " (" + this.xmlConfig + ") fehlgeschlagen";
                System.out.println(msg);
                log.severe(msg);
                LogUtils.close("wc");
                System.exit(-1);
            }
            System.gc();
        }
        this.closeFileAndTransform();
    }

    private String getMonatsoap(int monat) {
        String tempsoap = this.soap;
        if (monat == 0) {
            int vorjahr = Integer.parseInt(this.jahr);
            tempsoap = tempsoap.replaceAll("XXSTARTXX", --vorjahr + "-01-01");
            tempsoap = tempsoap.replaceAll("XXENDEXX", vorjahr + "-12-31");
        }
        if (monat >= 1 && monat <= 12) {
            int jahrint = Integer.parseInt(this.jahr);
            this.calendar.set(1, jahrint);
            this.calendar.set(2, monat - 1);
            String monatstr = monat < 10 ? "0" + monat : "" + monat;
            tempsoap = tempsoap.replaceAll("XXSTARTXX", this.jahr + "-" + monatstr + "-01");
            int maxDay = this.calendar.getActualMaximum(5);
            tempsoap = tempsoap.replaceAll("XXENDEXX", this.jahr + "-" + monatstr + "-" + maxDay);
        }
        if (monat == 13) {
            int folgejahr = Integer.parseInt(this.jahr);
            tempsoap = tempsoap.replaceAll("XXSTARTXX", ++folgejahr + "-01-01");
            tempsoap = tempsoap.replaceAll("XXENDEXX", folgejahr + "-12-31");
        }
        return tempsoap;
    }

    private void readConfig() throws IOException, SAXException {
        this.xmlConfig = GetOpts.getValue(GetOpts.Options.opt_xmlconfig);
        this.outfile = GetOpts.getValue(GetOpts.Options.opt_out);
        this.xslpfad = GetOpts.getValue(GetOpts.Options.opt_xslPfad);
        this.hsnr = GetOpts.getValue(GetOpts.Options.opt_hsnr);
        this.jahr = GetOpts.getValue(GetOpts.Options.opt_jahr);
        this.datentyp = GetOpts.getValue(GetOpts.Options.opt_datentyp);
        System.out.println("\n" + DateUtils.getTodayString() + " " + DateUtils.getNowString() + "\nHochschulnummer " + this.hsnr);
        log.info("\nHochschulnummer " + this.hsnr);
        if (GetOpts.isPresent(GetOpts.Options.opt_noDelete)) {
            this.isDeleteTmpXmlFileWanted = false;
        }
        log.log(Level.INFO, "Geschaeftsjahr " + this.jahr);
        System.out.println("Geschaeftsjahr " + this.jahr);
        log.log(Level.INFO, "Verarbeite " + this.xmlConfig);
        System.out.println("Verarbeite " + this.xmlConfig);
        this.configDocument = XMLUtils.buildDocument(new File(this.xmlConfig));
    }

    private void appendData() throws Exception {
        this.bfw.write(this.data);
        this.bfw.flush();
    }

    private void initTempFile() throws Exception {
        this.tempFile = File.createTempFile("webservicedata", ".xml");
        if (!this.isDeleteTmpXmlFileWanted) {
            System.out.println("Temp Datei: " + this.tempFile.getAbsolutePath());
            log.info("Temp Datei: " + this.tempFile.getAbsolutePath());
        }
        if (this.tempFile.exists()) {
            this.tempFile.delete();
        }
        this.fw = new PrintWriter(this.tempFile, "UTF-8");
        this.bfw = new BufferedWriter(this.fw);
        this.bfw.write("<newdata>\n");
    }

    private void closeFileAndTransform() throws Exception {
        this.bfw.write("\n</newdata>\n");
        this.bfw.close();
        this.fw.close();
        SxTransformer sxTrans = new SxTransformer(log, this.outfile);
        sxTrans.quellstring = this.tempFile.getAbsolutePath();
        sxTrans.stylesheet = this.xslpfad + File.separator + "soap_to_csv_" + this.datentyp + ".xsl";
        sxTrans.params = "ignoreElements=EX_JEST";
        sxTrans.transformFile("text");
        if (this.datentyp.equals("fmifiit")) {
            sxTrans.outfile = StringUtils.replace(this.outfile, ".", "hd.");
            sxTrans.stylesheet = StringUtils.replace(sxTrans.stylesheet, "soap_to_csv_fmifiit.xsl", "soap_to_csv_fmifihd.xsl");
            String msg = "Erzeuge zusaetzliche Header_Datei " + sxTrans.outfile;
            log.log(Level.INFO, msg);
            System.out.println(msg);
            sxTrans.transformFile("text");
        }
        if (this.isDeleteTmpXmlFileWanted) {
            this.tempFile.delete();
        }
    }

    private boolean isReplyOk() {
        boolean result = false;
        if (!XMLUtils.hasANodeWithName(this.resultDocument, "TYPE")) {
            System.out.println(this.data);
            log.severe(this.data);
        } else {
            Node type = XMLUtils.getFirstNode(this.resultDocument, "TYPE");
            if (XMLUtils.getTheValue(type).equals("I")) {
                result = true;
            }
        }
        return result;
    }
}

