/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.LogUtils;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.AbstractWebserviceClient;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.logging.Level;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WebserviceClientBewegungsdaten
extends AbstractWebserviceClient {
    private Document configDocument;
    private XMLInputFactory factory = XMLInputFactory.newInstance();
    private String hsnr;
    private String xmlConfig;
    private String datentyp;
    private String url;
    private String soap;
    private String outfilename;
    private boolean columnNamesWritten = false;
    private boolean columnNamesHdWritten = false;
    private File tmpFile;
    private File outFile;
    private File outFileHd;
    private String jahr;
    private PrintWriter fw;
    private PrintWriter fwhd;
    private BufferedWriter bfw;
    private BufferedWriter bfwhd;
    private Calendar cal = Calendar.getInstance();

    public static void main(String[] args) {
        System.out.println("SuperX-WebserviceClientBewegungsdaten Version 1.4 (2.2.2023)");
        WebserviceClientBewegungsdaten tc = new WebserviceClientBewegungsdaten();
        tc.run(args);
    }

    private boolean isWorkaroundNeeded() {
        return this.hsnr.contentEquals("3001") && this.jahr.contentEquals("2021") && this.datentyp.equals("fmifiit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        try {
            this.initLogging();
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_xmlconfig, GetOpts.Options.opt_hsnr, GetOpts.Options.opt_jahr, GetOpts.Options.opt_out, GetOpts.Options.opt_datentyp});
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.exit(1);
            }
            this.readConfig();
            this.perform();
            String msg = "    fertig: " + DateUtils.getTodayString() + " " + DateUtils.getNowString();
            logger.info(msg);
            System.out.println(msg);
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            System.out.println("Error " + e.getMessage());
            e.printStackTrace();
            LogUtils.close("wc");
            System.exit(1);
        }
        finally {
            LogUtils.close("wc");
        }
    }

    private void perform() throws Exception {
        Node n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "detailurl");
        this.url = XMLUtils.getTheValue(n);
        this.url = this.adaptURL(this.url);
        logger.fine("URL:" + this.url);
        System.out.println("URL:" + this.url);
        n = XMLUtils.getFirstNode(this.configDocument, this.datentyp + "detailsoap");
        this.soap = XMLUtils.getTheValue(n);
        this.soap = this.soap.replace("XXHSNRXX", this.hsnr);
        this.soap = this.soap.replace("XXJAHRXX", this.jahr);
        System.out.println(this.datentyp + "\nVorlage " + this.soap);
        this.initOutFile();
        int vorjahr = Integer.parseInt(this.jahr) - 1;
        this.runAbruf("1970-01-01", vorjahr + "-01-01");
        this.runAbruf(vorjahr + "-01-02", vorjahr + "-01-31");
        this.runAbruf(vorjahr + "-02-01", vorjahr + "-03-01");
        this.runAbruf(vorjahr + "-03-02", vorjahr + "-03-31");
        this.runAbruf(vorjahr + "-04-01", vorjahr + "-04-30");
        this.runAbruf(vorjahr + "-05-01", vorjahr + "-05-31");
        this.runAbruf(vorjahr + "-06-01", vorjahr + "-06-30");
        this.runAbruf(vorjahr + "-07-01", vorjahr + "-07-31");
        this.runAbruf(vorjahr + "-08-01", vorjahr + "-08-31");
        this.runAbruf(vorjahr + "-09-01", vorjahr + "-09-30");
        this.runAbruf(vorjahr + "-10-01", vorjahr + "-10-31");
        this.runAbruf(vorjahr + "-11-01", vorjahr + "-11-30");
        this.runAbruf(vorjahr + "-12-01", vorjahr + "-12-31");
        int jahrint = Integer.parseInt(this.jahr);
        this.cal.set(jahrint, 0, 1);
        while (this.cal.get(1) == jahrint) {
            String datum = this.getDateString();
            this.runAbruf(datum, datum);
            this.cal.add(6, 1);
        }
        int folgejahr = Integer.parseInt(this.jahr) + 1;
        this.runAbruf(folgejahr + "-01-01", folgejahr + "-01-31");
        this.runAbruf(folgejahr + "-02-01", folgejahr + "-03-01");
        this.runAbruf(folgejahr + "-03-02", folgejahr + "-03-31");
        this.runAbruf(folgejahr + "-04-01", folgejahr + "-04-30");
        this.runAbruf(folgejahr + "-05-01", folgejahr + "-05-31");
        this.runAbruf(folgejahr + "-06-01", folgejahr + "-06-30");
        this.runAbruf(folgejahr + "-07-01", folgejahr + "-07-31");
        this.runAbruf(folgejahr + "-08-01", folgejahr + "-08-31");
        this.runAbruf(folgejahr + "-09-01", folgejahr + "-09-30");
        this.runAbruf(folgejahr + "-10-01", folgejahr + "-10-31");
        this.runAbruf(folgejahr + "-11-01", folgejahr + "-11-30");
        this.runAbruf(folgejahr + "-12-01", folgejahr + "-12-31");
        int folgejahr2 = Integer.parseInt(this.jahr) + 2;
        this.runAbruf(folgejahr2 + "-01-01", "2100-12-31");
        this.closeFile();
    }

    private String getDateString() {
        int month = this.cal.get(2) + 1;
        String monthstr = "" + month;
        if (month < 10) {
            monthstr = "0" + month;
        }
        int day = this.cal.get(5);
        String daystring = "" + day;
        if (day < 10) {
            daystring = "0" + day;
        }
        String result = this.cal.get(1) + "-" + monthstr + "-" + daystring;
        return result;
    }

    protected void runAbruf(String datevon, String datebis) throws Exception, XMLStreamException, IOException {
        String soap = this.getSoap(datevon, datebis);
        logger.fine(this.datentyp + "\nSOAP Aufruf:\n" + soap);
        Object msg = "starte Aufruf fuer " + datevon + " bis " + datebis;
        System.out.println((String)msg);
        this.tmpFile = this.createSoapFile(soap, this.url);
        msg = " - empfangen ";
        if (!this.isDeleteTmpXmlFileWanted) {
            msg = (String)msg + " (" + this.tmpFile + ")";
        }
        msg = (String)msg + " " + DateUtils.getNowString();
        System.out.println((String)msg);
        String nodeName = "EX_" + this.datentyp.toUpperCase();
        if (this.isReplyOk(this.tmpFile)) {
            String data;
            String columnNames = this.getColumnNames(nodeName).toString();
            if (!this.columnNamesWritten && !columnNames.equals("")) {
                this.bfw.write(columnNames);
                this.columnNamesWritten = true;
            }
            if (!(data = this.getData(nodeName).toString()).equals("")) {
                this.bfw.write(data);
            }
            this.bfw.flush();
            if (this.datentyp.equals("fmifiit")) {
                columnNames = this.getColumnNames("EX_FMIFIHD").toString();
                if (!this.columnNamesHdWritten && !columnNames.equals("")) {
                    this.bfwhd.write(columnNames);
                    this.columnNamesHdWritten = true;
                }
                if (!(data = this.getData("EX_FMIFIHD").toString()).equals("")) {
                    this.bfwhd.write(data);
                }
                this.bfwhd.flush();
            }
            if (this.isDeleteTmpXmlFileWanted) {
                this.tmpFile.delete();
            }
        } else {
            msg = "Error: Aufruf von Webservice f\u00fcr Bewegungsdaten " + this.datentyp + " (" + this.xmlConfig + ") fehlgeschlagen";
            System.out.println((String)msg);
            System.out.println(StringUtils.readFile(this.tmpFile));
            logger.severe((String)msg);
            LogUtils.close("wc");
            System.exit(-1);
        }
    }

    private String getSoap(String datevon, String datebis) {
        String tempsoap = this.soap;
        tempsoap = tempsoap.replaceAll("XXSTARTXX", datevon);
        tempsoap = tempsoap.replaceAll("XXENDEXX", datebis);
        return tempsoap;
    }

    private void readConfig() throws IOException, SAXException {
        this.xmlConfig = GetOpts.getValue(GetOpts.Options.opt_xmlconfig);
        this.outfilename = GetOpts.getValue(GetOpts.Options.opt_out);
        this.hsnr = GetOpts.getValue(GetOpts.Options.opt_hsnr);
        this.jahr = GetOpts.getValue(GetOpts.Options.opt_jahr);
        this.datentyp = GetOpts.getValue(GetOpts.Options.opt_datentyp);
        System.out.println("\n" + DateUtils.getTodayString() + " " + DateUtils.getNowString() + "\nHochschulnummer " + this.hsnr);
        logger.info("\nHochschulnummer " + this.hsnr);
        if (GetOpts.isPresent(GetOpts.Options.opt_noDelete)) {
            this.isDeleteTmpXmlFileWanted = false;
        }
        logger.log(Level.INFO, "Geschaeftsjahr " + this.jahr);
        System.out.println("Geschaeftsjahr " + this.jahr);
        logger.log(Level.INFO, "Verarbeite " + this.xmlConfig);
        System.out.println("Verarbeite " + this.xmlConfig);
        this.configDocument = XMLUtils.buildDocument(new File(this.xmlConfig));
    }

    private void initOutFile() throws Exception {
        this.outFile = new File(this.outfilename);
        if (this.outFile.exists()) {
            this.outFile.delete();
        }
        this.fw = new PrintWriter(this.outFile);
        this.bfw = new BufferedWriter(this.fw);
        if (this.datentyp.equals("fmifiit")) {
            String hdfilename = StringUtils.replace(this.outfilename, ".", "hd.");
            this.outFileHd = new File(hdfilename);
            String msg = "Erzeuge zusaetzliche Header_Datei " + hdfilename;
            logger.log(Level.INFO, msg);
            System.out.println(msg);
            this.fwhd = new PrintWriter(this.outFileHd);
            this.bfwhd = new BufferedWriter(this.fwhd);
        }
    }

    private void closeFile() throws Exception {
        this.bfw.close();
        this.fw.close();
        if (this.datentyp.equals("fmifiit")) {
            this.bfwhd.close();
            this.fwhd.close();
        }
        if (this.isDeleteTmpXmlFileWanted && this.tmpFile.exists()) {
            this.tmpFile.delete();
        }
    }

    private StringBuilder getData(String topnode) throws XMLStreamException, IOException {
        FileInputStream in = new FileInputStream(this.tmpFile);
        XMLStreamReader parser = this.factory.createXMLStreamReader(in);
        StringBuilder result = new StringBuilder();
        boolean getData = false;
        while (parser.hasNext()) {
            switch (parser.getEventType()) {
                case 1: {
                    String name = parser.getLocalName();
                    if (!name.equals(topnode)) break;
                    getData = true;
                    break;
                }
                case 4: {
                    if (!getData || parser.isWhiteSpace()) break;
                    String data = parser.getText();
                    data = data.matches("(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)") ? WebserviceClientBewegungsdaten.adaptDatePattern(data) : WebserviceClientBewegungsdaten.purge(data, true);
                    result.append(data);
                    break;
                }
                case 2: {
                    if (parser.getLocalName().equals(topnode)) {
                        getData = false;
                        break;
                    }
                    if (getData && parser.getLocalName().equals("item")) {
                        result.append("\n");
                        break;
                    }
                    if (!getData) break;
                    result.append("^");
                    break;
                }
                case 8: {
                    parser.close();
                }
            }
            parser.next();
        }
        ((InputStream)in).close();
        return result;
    }

    private String getColumnNames(String topnode) throws XMLStreamException, IOException {
        FileInputStream in = new FileInputStream(this.tmpFile);
        XMLStreamReader parser = this.factory.createXMLStreamReader(in);
        String prefix = topnode.replaceAll("EX_", "");
        StringBuilder result = new StringBuilder();
        boolean getNames = false;
        while (parser.hasNext()) {
            switch (parser.getEventType()) {
                case 1: {
                    String name = parser.getLocalName();
                    if (parser.getLocalName().equals(topnode)) {
                        getNames = true;
                        break;
                    }
                    if (!getNames || name.equals("item")) break;
                    result.append(prefix + "_" + parser.getLocalName() + "^");
                    break;
                }
                case 2: {
                    if (!parser.getLocalName().equals(topnode) && !parser.getLocalName().equals("item")) break;
                    getNames = false;
                    break;
                }
                case 8: {
                    parser.close();
                }
            }
            parser.next();
        }
        ((InputStream)in).close();
        if (result.length() > 0) {
            result.setLength(result.length() - 1);
        }
        if (result.length() > 0) {
            result.append("\n");
        }
        return result.toString().toLowerCase();
    }
}

