/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.LogUtils;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import de.superx.bin.AbstractWebserviceClient;
import de.superx.bin.SxConnection;
import de.superx.bin.SxTransformer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WebserviceClient
extends AbstractWebserviceClient {
    private boolean isDebug = false;
    private boolean isDBConnectionPossible = true;
    private Document document;
    private Set<String> newOrUpdatedObjects = new HashSet<String>();
    private Set<String> deletedObjects = new HashSet<String>();
    private String dbpropfile;
    private String objectClass;
    private String hsnr;
    private String changesURL;
    private String changesSOAP;
    private String xmlConfig;
    private String detailURL;
    private String detailSOAP;
    private String replaceNodeName;
    private String xsl;
    private String outfile;
    private String stammdatenstart = null;
    private boolean isDeleteTmpXmlFileWanted = true;
    private static final String FISTL_HIERARCHIE_INFO = "<EX_FMHISV> \n            <item> \n               <MANDT></MANDT> \n               <FIKRS></FIKRS> \n               <HIVARNT>000</HIVARNT> \n               <FISTL></FISTL> \n               <HIROOT_ST></HIROOT_ST> \n               <PARENT_ST/> \n               <NEXT_ST/> \n               <CHILD_ST/> \n               <HILEVEL>0001</HILEVEL> \n            </item> \n         </EX_FMHISV>";

    public static void main(String[] args) {
        System.out.println("SuperX-WebserviceClient Version 1.4 (2025-02-25)");
        WebserviceClient tc = new WebserviceClient();
        tc.run(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        try {
            this.initLogging();
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_dbprops, GetOpts.Options.opt_xmlconfig, GetOpts.Options.opt_xsl, GetOpts.Options.opt_hsnr, GetOpts.Options.opt_out});
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.exit(1);
            }
            this.readConfig();
            this.readChanges();
            if (this.isReplyOk()) {
                this.readObjectIdSets();
                if (this.isDBConnectionPossible) {
                    this.toDeletedObjectsTable();
                }
                this.writeChangeXml();
            } else {
                String msg = "Error: Aufruf von Webservice f\u00fcr " + this.xmlConfig + " fehlgeschlagen";
                System.out.println(msg);
                logger.severe(msg);
                LogUtils.close("wc");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            logger.severe(e.getMessage());
            System.out.println("Error " + e.getMessage());
            e.printStackTrace();
            LogUtils.close("wc");
            System.exit(1);
        }
        finally {
            LogUtils.close("wc");
        }
    }

    private void readChanges() throws Exception {
        String soapString = StringUtils.replace(this.changesSOAP, "XXOBJECT_CLASSXX", this.objectClass);
        String startDatum = this.getStartDatum();
        logger.log(Level.INFO, "Startdatum " + startDatum);
        System.out.println("Startdatum " + startDatum);
        soapString = StringUtils.replace(soapString, "XXSTARTDATEXX", startDatum);
        soapString = StringUtils.replace(soapString, "XXTODAYXX", new Date(new java.util.Date().getTime()).toString());
        logger.fine("SOAP Aufruf:\n" + soapString);
        String result = this.readSOAP(soapString, this.changesURL).toString();
        this.document = XMLUtils.buildDocumentFromString(result, false);
        logger.finest("Geaenderte Objekte Klasse " + this.objectClass);
    }

    private void readConfig() throws IOException, SAXException {
        this.dbpropfile = GetOpts.getValue(GetOpts.Options.opt_dbprops);
        this.xmlConfig = GetOpts.getValue(GetOpts.Options.opt_xmlconfig);
        this.outfile = GetOpts.getValue(GetOpts.Options.opt_out);
        this.xsl = GetOpts.getValue(GetOpts.Options.opt_xsl);
        this.hsnr = GetOpts.getValue(GetOpts.Options.opt_hsnr);
        System.out.println("\n" + DateUtils.getTodayString() + " " + DateUtils.getNowString() + "\nHochschulnummer " + this.hsnr);
        logger.info("\nHochschulnummer " + this.hsnr);
        if (GetOpts.isPresent(GetOpts.Options.opt_noDelete)) {
            this.isDeleteTmpXmlFileWanted = false;
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_pause)) {
            String p = GetOpts.getValue(GetOpts.Options.opt_pause);
            this.pause = Integer.parseInt(p);
            System.out.println("Pause between soap calls " + this.pause);
        }
        logger.log(Level.INFO, "Verarbeite " + this.xmlConfig);
        System.out.println("Verarbeite " + this.xmlConfig);
        Document dconf = XMLUtils.buildDocument(new File(this.xmlConfig));
        Node n = XMLUtils.getFirstNode(dconf, "webservice");
        this.objectClass = XMLUtils.getAttribValue(n, "object_class");
        n = XMLUtils.getFirstNode(dconf, "changesurl");
        this.changesURL = XMLUtils.getTheValue(n);
        this.changesURL = this.adaptURL(this.changesURL);
        n = XMLUtils.getFirstNode(dconf, "changessoap");
        this.changesSOAP = XMLUtils.getTheValue(n);
        this.changesSOAP = StringUtils.replace(this.changesSOAP, "XXOBJECTICLASSXX", this.objectClass);
        n = XMLUtils.getFirstNode(dconf, "detailurl");
        this.detailURL = XMLUtils.getTheValue(n);
        this.detailURL = this.adaptURL(this.detailURL);
        n = XMLUtils.getFirstNode(dconf, "detailsoap");
        this.detailSOAP = XMLUtils.getTheValue(n);
        n = XMLUtils.getFirstNode(dconf, "replacenode");
        this.replaceNodeName = XMLUtils.getAttribValue(n, "from");
    }

    private void readObjectIdSets() {
        Node changehead = XMLUtils.getFirstNode(this.document, "CHANGEHEAD");
        Iterator<Node> it = XMLUtils.getChildNodeIterator(changehead);
        int i = 1;
        while (it.hasNext()) {
            Node item = it.next();
            String objectid = XMLUtils.getChildNodeValue(item, "OBJECTID");
            String change_ind = XMLUtils.getChildNodeValue(item, "CHANGE_IND");
            if (change_ind != null && change_ind.equals("D")) {
                this.deletedObjects.add(objectid);
            } else {
                this.newOrUpdatedObjects.add(objectid);
            }
            ++i;
        }
        System.out.println("Zu loeschen " + this.deletedObjects.size() + " neu/geaendert " + this.newOrUpdatedObjects.size());
        logger.info("Anzahl zu loeschender Objekte " + this.deletedObjects.size());
        logger.info("Anzahl zu neuer/geaenderter Objekte " + this.newOrUpdatedObjects.size());
    }

    private boolean isJestWanted() {
        return this.objectClass.equals("PRPS");
    }

    private void writeChangeXml() throws Exception {
        File f = File.createTempFile("webservicedata", ".xml");
        File fjest = null;
        if (this.isJestWanted()) {
            fjest = File.createTempFile("webservicedatajest", ".xml");
        }
        if (!this.isDeleteTmpXmlFileWanted) {
            System.out.println("Temp Datei: " + f.getAbsolutePath());
            logger.info("Temp Datei: " + f.getAbsolutePath());
            if (this.isJestWanted()) {
                System.out.println("Temp Datei: " + fjest.getAbsolutePath());
                logger.info("Temp Datei: " + fjest.getAbsolutePath());
            }
        }
        if (f.exists()) {
            f.delete();
        }
        if (fjest != null && fjest.exists()) {
            fjest.delete();
        }
        BufferedWriter bfw = Files.newBufferedWriter(f.toPath(), new OpenOption[0]);
        bfw.write("<newdata>\n");
        BufferedWriter bfwjest = null;
        if (this.isJestWanted()) {
            bfwjest = Files.newBufferedWriter(fjest.toPath(), new OpenOption[0]);
            bfwjest.write("<newdata>\n");
        }
        int i = 0;
        int rownr = 0;
        System.out.println(DateUtils.getTodayString() + " " + DateUtils.getNowString());
        String reply = null;
        String replyjest = null;
        for (String objectId : this.newOrUpdatedObjects) {
            reply = this.getSoapDetailRequest(objectId, i);
            if (++i % 10 == 0) {
                System.out.print(i + " ");
            }
            if (this.objectClass.equals("KSTAR") && reply.indexOf("<EX_CSKB/>") > -1 || reply.indexOf("<MESSAGE>Es wurden 0000") > -1) continue;
            if (this.objectClass.equals("FMFCTR")) {
                reply = this.patchMissingFistlHierarchieInfo(reply);
            }
            if (this.isJestWanted()) {
                replyjest = this.adaptJestData(reply, objectId);
            }
            ++rownr;
            if (!this.isDebug && reply.indexOf("<TYPE>I</TYPE>") == -1) {
                System.out.println("Fehler bei Lesen von Object " + objectId);
                System.out.println(reply);
                bfw.close();
                if (f.exists()) {
                    f.delete();
                }
                if (this.isJestWanted()) {
                    bfwjest.close();
                    if (fjest.exists()) {
                        fjest.delete();
                    }
                }
                System.exit(-1);
            }
            reply = StringUtils.replace(reply, "<Envelope", "<Envelope rownr=\"" + rownr + "\" ");
            reply = this.nachbearbeiten(reply);
            bfw.write(reply);
            if (!this.isJestWanted()) continue;
            replyjest = WebserviceClient.purge(replyjest, "RETURN");
            replyjest = this.nachbearbeiten(replyjest);
            bfwjest.write(replyjest);
        }
        System.out.println("");
        bfw.write("\n</newdata>\n");
        bfw.close();
        if (this.isJestWanted()) {
            bfwjest.write("\n</newdata>\n");
            bfwjest.close();
        }
        this.transformXmlToCSV(f, fjest);
        if (this.isDeleteTmpXmlFileWanted) {
            f.delete();
            if (this.isJestWanted()) {
                fjest.delete();
            }
        }
        System.out.println("    fertig: " + DateUtils.getTodayString() + " " + DateUtils.getNowString());
    }

    private void transformXmlToCSV(File f, File fjest) throws TransformerException, Exception {
        SxTransformer sxTrans = new SxTransformer(logger, this.outfile);
        sxTrans.quellstring = f.getAbsolutePath();
        sxTrans.stylesheet = this.xsl;
        sxTrans.params = "ignoreElements=EX_JEST";
        sxTrans.transformFile("text");
        if (this.isJestWanted()) {
            sxTrans = new SxTransformer(logger, StringUtils.replace(this.outfile, ".", "jest."));
            sxTrans.quellstring = fjest.getAbsolutePath();
            String xsljest = "";
            if (this.objectClass.equals("PRPS")) {
                xsljest = StringUtils.replace(this.xsl, "soap_to_csv.xsl", "psp_jest.xsl");
            }
            sxTrans.stylesheet = xsljest;
            sxTrans.params = "";
            sxTrans.transformFile("text");
        }
    }

    private String adaptJestData(String reply, String objectId) {
        String replyjest = WebserviceClient.purge(reply, false);
        replyjest = replyjest.replaceAll("<Envelope>", "");
        replyjest = replyjest.replaceAll("<Header>", "");
        replyjest = replyjest.replaceAll("</Header>", "");
        replyjest = StringUtils.replace(replyjest, "<Header/>", "");
        replyjest = replyjest.replaceAll("</Envelope>", "");
        replyjest = replyjest.replaceAll("<SOAP:Body>", "");
        replyjest = replyjest.replaceAll("</SOAP:Body>", "");
        replyjest = replyjest.replaceAll("<response>", "");
        replyjest = replyjest.replaceAll("</response>", "");
        replyjest = WebserviceClient.purge(replyjest, "EX_PROJ");
        replyjest = WebserviceClient.purge(replyjest, "EX_PRPS");
        replyjest = WebserviceClient.purge(replyjest, "EX_PRHI");
        replyjest = StringUtils.replace(replyjest, "<EX_JEST>", "");
        replyjest = StringUtils.replace(replyjest, "<EX_JEST/>", "");
        replyjest = StringUtils.replace(replyjest, "</EX_JEST>", "");
        replyjest = replyjest.replaceAll("<item>", "<item>\n<POSID>" + objectId + "</POSID>\n");
        return replyjest;
    }

    private String nachbearbeiten(String reply) {
        reply = WebserviceClient.purge(reply, true);
        reply = WebserviceClient.adaptDatePattern(reply);
        reply = this.removeXmlHeader(reply);
        reply = this.format(reply);
        return reply;
    }

    private String patchMissingFistlHierarchieInfo(String input) {
        return StringUtils.replace(input, "<EX_FMHISV/>", FISTL_HIERARCHIE_INFO);
    }

    private String getStartDatum() throws Exception {
        String result = "2000-01-01";
        if (this.isDBConnectionPossible) {
            SxConnection myConnection = new SxConnection();
            myConnection.setPropfile(this.dbpropfile);
            Connection con = myConnection.getConnection();
            Statement stm = con.createStatement();
            ResultSet rs = stm.executeQuery("select datum from systeminfo where tid=170");
            while (rs.next()) {
                Date o = rs.getDate(1);
                if (o == null) continue;
                result = ((Object)o).toString();
            }
            rs.close();
            stm.close();
            con.close();
        }
        if (System.getProperty("stammdatenstart") != null) {
            result = System.getProperty("stammdatenstart");
        }
        return result;
    }

    private void toDeletedObjectsTable() throws Exception {
        SxConnection myConnection = new SxConnection();
        myConnection.setPropfile(this.dbpropfile);
        Connection con = myConnection.getConnection();
        PreparedStatement pst = con.prepareStatement("insert into gxstage_delete_object (object_class,object_id) values (?,?)");
        for (String objectId : this.deletedObjects) {
            pst.clearParameters();
            pst.setString(1, this.objectClass);
            pst.setString(2, objectId);
            pst.execute();
        }
        pst.close();
        con.close();
    }

    private String getSoapDetailRequest(String objectid, int i) throws Exception {
        String idpart1 = "";
        if (objectid.length() >= 4) {
            idpart1 = objectid.substring(0, 4);
        }
        String idpart2 = "";
        if (objectid.length() >= 5) {
            idpart2 = objectid.substring(4);
        }
        String idpart3 = "";
        if (objectid.length() > 8) {
            idpart3 = objectid.substring(8);
        }
        String soapxml = StringUtils.replace(this.detailSOAP, "IDPART1", idpart1);
        soapxml = StringUtils.replace(soapxml, "IDPART2", idpart2);
        soapxml = StringUtils.replace(soapxml, "IDPART3", idpart3);
        soapxml = StringUtils.replace(soapxml, "XXOBJECTIDXX", objectid);
        soapxml = StringUtils.replace(soapxml, "XXHSNRXX", this.hsnr);
        if (i == 0) {
            logger.finest("1. SOAP Detailaufruf:\n" + soapxml);
        }
        String res = this.readSOAP(soapxml, this.detailURL).toString();
        String result = StringUtils.replace(res, this.replaceNodeName, "response");
        return result;
    }

    private boolean isReplyOk() {
        boolean result = false;
        try {
            Node type = XMLUtils.getFirstNode(this.document, "TYPE");
            if (XMLUtils.getTheValue(type).equals("I")) {
                result = true;
            }
        }
        catch (Exception e) {
            logger.severe("Kein Konten TYPE gefunden mit Value I - Result:\n");
            try {
                logger.severe(XMLUtils.documentToString(this.document, null));
            }
            catch (Exception ex) {
                logger.severe("Fehler bei XML Ausgabe " + ex);
            }
        }
        return result;
    }
}

